/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.state.migration.to_8_4;

import io.camunda.zeebe.db.TransactionContext;
import io.camunda.zeebe.db.ZeebeDb;
import io.camunda.zeebe.engine.state.migration.to_8_4.MultiTenancySignalSubscriptionStateMigration;
import io.camunda.zeebe.engine.state.migration.to_8_4.legacy.LegacySignalSubscriptionState;
import io.camunda.zeebe.engine.state.mutable.MutableProcessingState;
import io.camunda.zeebe.engine.state.signal.DbSignalSubscriptionState;
import io.camunda.zeebe.engine.util.ProcessingStateExtension;
import io.camunda.zeebe.protocol.ZbColumnFamilies;
import io.camunda.zeebe.protocol.impl.record.value.signal.SignalSubscriptionRecord;
import io.camunda.zeebe.protocol.record.value.SignalSubscriptionRecordValue;
import io.camunda.zeebe.util.buffer.BufferUtil;
import java.util.concurrent.atomic.AtomicInteger;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

public class MultiTenancyMigrationTest {

    @Nested
    @ExtendWith(value={ProcessingStateExtension.class})
    class MigrateSignalSubscriptionStateForMultiTenancyTest {
        final MultiTenancySignalSubscriptionStateMigration sut = new MultiTenancySignalSubscriptionStateMigration();
        private ZeebeDb<ZbColumnFamilies> zeebeDb;
        private MutableProcessingState processingState;
        private TransactionContext transactionContext;
        private LegacySignalSubscriptionState legacyState;
        private DbSignalSubscriptionState signalSubscriptionState;

        MigrateSignalSubscriptionStateForMultiTenancyTest(MultiTenancyMigrationTest this$0) {
        }

        @BeforeEach
        void setup() {
            this.legacyState = new LegacySignalSubscriptionState(this.zeebeDb, this.transactionContext);
            this.signalSubscriptionState = new DbSignalSubscriptionState(this.zeebeDb, this.transactionContext);
        }

        @Test
        void shouldMigrateSignalNameAndSubscriptionKeyColumnFamily() {
            String signalName = "test";
            String processId = "testProcess";
            String catchEventId = "catchEvent";
            long processDefinitionKey = 1L;
            long signalSubscriptionKey = 2L;
            long catchEventInstanceKey = 3L;
            String tenantId = "<default>";
            SignalSubscriptionRecord signalSubscription = new SignalSubscriptionRecord().setSignalName(BufferUtil.wrapString((String)"test")).setBpmnProcessId(BufferUtil.wrapString((String)"testProcess")).setCatchEventId(BufferUtil.wrapString((String)"catchEvent")).setProcessDefinitionKey(1L).setCatchEventInstanceKey(3L);
            this.legacyState.put(2L, signalSubscription);
            this.sut.runMigration(this.processingState);
            AtomicInteger subscriptionCounter = new AtomicInteger(0);
            this.signalSubscriptionState.visitBySignalName(BufferUtil.wrapString((String)"test"), "<default>", subscription -> {
                io.camunda.zeebe.protocol.record.Assertions.assertThat((SignalSubscriptionRecordValue)signalSubscription).hasSignalName("test").hasBpmnProcessId("testProcess").hasCatchEventId("catchEvent").hasProcessDefinitionKey(1L).hasCatchEventInstanceKey(3L).hasTenantId("<default>");
                subscriptionCounter.incrementAndGet();
            });
            Assertions.assertThat((AtomicInteger)subscriptionCounter).hasValue(1);
            Assertions.assertThat((boolean)this.legacyState.getSignalNameAndSubscriptionKeyColumnFamily().isEmpty()).isTrue();
        }

        @Test
        void shouldMigrateSubscriptionKeyAndSignalNameColumnFamilyForProcessDefinitionKey() {
            String signalName = "test";
            String processId = "testProcess";
            String catchEventId = "catchEvent";
            long processDefinitionKey = 1L;
            long signalSubscriptionKey = 2L;
            String tenantId = "<default>";
            SignalSubscriptionRecord signalSubscription = new SignalSubscriptionRecord().setSignalName(BufferUtil.wrapString((String)"test")).setBpmnProcessId(BufferUtil.wrapString((String)"testProcess")).setCatchEventId(BufferUtil.wrapString((String)"catchEvent")).setProcessDefinitionKey(1L);
            this.legacyState.put(2L, signalSubscription);
            this.sut.runMigration(this.processingState);
            AtomicInteger subscriptionCounter = new AtomicInteger(0);
            this.signalSubscriptionState.visitStartEventSubscriptionsByProcessDefinitionKey(1L, subscription -> {
                io.camunda.zeebe.protocol.record.Assertions.assertThat((SignalSubscriptionRecordValue)signalSubscription).hasSignalName("test").hasBpmnProcessId("testProcess").hasCatchEventId("catchEvent").hasProcessDefinitionKey(1L).hasCatchEventInstanceKey(-1L).hasTenantId("<default>");
                subscriptionCounter.incrementAndGet();
            });
            Assertions.assertThat((AtomicInteger)subscriptionCounter).hasValue(1);
            Assertions.assertThat((boolean)this.legacyState.getSubscriptionKeyAndSignalNameColumnFamily().isEmpty()).isTrue();
        }

        @Test
        void shouldMigrateSubscriptionKeyAndSignalNameColumnFamilyForCatchKey() {
            String signalName = "test";
            String processId = "testProcess";
            String catchEventId = "catchEvent";
            long signalSubscriptionKey = 2L;
            long catchEventInstanceKey = 3L;
            String tenantId = "<default>";
            SignalSubscriptionRecord signalSubscription = new SignalSubscriptionRecord().setSignalName(BufferUtil.wrapString((String)"test")).setBpmnProcessId(BufferUtil.wrapString((String)"testProcess")).setCatchEventId(BufferUtil.wrapString((String)"catchEvent")).setCatchEventInstanceKey(3L);
            this.legacyState.put(2L, signalSubscription);
            this.sut.runMigration(this.processingState);
            AtomicInteger subscriptionCounter = new AtomicInteger(0);
            this.signalSubscriptionState.visitStartEventSubscriptionsByProcessDefinitionKey(3L, subscription -> {
                io.camunda.zeebe.protocol.record.Assertions.assertThat((SignalSubscriptionRecordValue)signalSubscription).hasSignalName("test").hasBpmnProcessId("testProcess").hasCatchEventId("catchEvent").hasProcessDefinitionKey(-1L).hasCatchEventInstanceKey(3L).hasTenantId("<default>");
                subscriptionCounter.incrementAndGet();
            });
            Assertions.assertThat((AtomicInteger)subscriptionCounter).hasValue(1);
            Assertions.assertThat((boolean)this.legacyState.getSubscriptionKeyAndSignalNameColumnFamily().isEmpty()).isTrue();
        }
    }
}

