/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.util;

import io.camunda.zeebe.engine.processing.streamprocessor.writers.TypedEventWriter;
import io.camunda.zeebe.engine.util.Records;
import io.camunda.zeebe.protocol.record.RecordValue;
import io.camunda.zeebe.protocol.record.intent.Intent;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public final class RecordingTypedEventWriter
implements TypedEventWriter {
    private final List<RecordedEvent<?>> events = new CopyOnWriteArrayList();

    public List<RecordedEvent<?>> getEvents() {
        return this.events;
    }

    public void appendFollowUpEvent(long key, Intent intent, RecordValue value) {
        this.appendFollowUpEvent(key, intent, value, 1);
    }

    public void appendFollowUpEvent(long key, Intent intent, RecordValue value, int recordVersion) {
        this.events.add(new RecordedEvent<RecordValue>(key, intent, value, recordVersion));
    }

    public boolean canWriteEventOfLength(int eventLength) {
        return true;
    }

    public static final class RecordedEvent<T extends RecordValue> {
        public final long key;
        public final Intent intent;
        public final T value;
        private final int recordVersion;

        public RecordedEvent(long key, Intent intent, T value, int recordVersion) {
            this.key = key;
            this.intent = intent;
            this.value = (RecordValue)Records.cloneValue(value);
            this.recordVersion = recordVersion;
        }

        public String toString() {
            return "RecordedEvent{key=" + this.key + ", intent=" + String.valueOf(this.intent) + ", value=" + String.valueOf(this.value) + ", recordVersion=" + this.recordVersion + "}";
        }
    }
}

