/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.util;

import io.camunda.zeebe.logstreams.log.LogAppendEntry;
import io.camunda.zeebe.logstreams.log.LogStreamWriter;
import io.camunda.zeebe.protocol.impl.record.RecordMetadata;
import io.camunda.zeebe.protocol.impl.record.UnifiedRecordValue;
import io.camunda.zeebe.protocol.record.RecordType;
import io.camunda.zeebe.protocol.record.ValueType;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.stream.api.InterPartitionCommandSender;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;

public class TestInterPartitionCommandSender
implements InterPartitionCommandSender {
    private final Map<Integer, LogStreamWriter> writers = new HashMap<Integer, LogStreamWriter>();
    private final Function<Integer, LogStreamWriter> writerFactory;
    private CommandInterceptor interceptor = CommandInterceptor.SEND_ALL;

    public TestInterPartitionCommandSender(Function<Integer, LogStreamWriter> writerFactory) {
        this.writerFactory = writerFactory;
    }

    public void sendCommand(int receiverPartitionId, ValueType valueType, Intent intent, UnifiedRecordValue command) {
        this.sendCommand(receiverPartitionId, valueType, intent, null, command);
    }

    public void sendCommand(int receiverPartitionId, ValueType valueType, Intent intent, Long recordKey, UnifiedRecordValue command) {
        if (!this.interceptor.shouldSend(receiverPartitionId, valueType, intent, recordKey, command)) {
            return;
        }
        RecordMetadata metadata = new RecordMetadata().recordType(RecordType.COMMAND).intent(intent).valueType(valueType);
        LogStreamWriter writer = this.writers.get(receiverPartitionId);
        LogAppendEntry entry = recordKey != null ? LogAppendEntry.of((long)recordKey, (RecordMetadata)metadata, (UnifiedRecordValue)command) : LogAppendEntry.of((RecordMetadata)metadata, (UnifiedRecordValue)command);
        writer.tryWrite(entry);
    }

    public void initializeWriters(int partitionCount) {
        for (int i = 1; i < 1 + partitionCount; ++i) {
            this.writers.put(i, this.writerFactory.apply(i));
        }
    }

    public void intercept(CommandInterceptor interceptor) {
        this.interceptor = interceptor;
    }

    @FunctionalInterface
    public static interface CommandInterceptor {
        public static final CommandInterceptor SEND_ALL = (receiverPartitionId, valueType, intent, recordKey, command) -> true;
        public static final CommandInterceptor DROP_ALL = (receiverPartitionId, valueType, intent, recordKey, command) -> false;

        public boolean shouldSend(int var1, ValueType var2, Intent var3, Long var4, UnifiedRecordValue var5);
    }
}

