/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.util.client;

import io.camunda.zeebe.engine.util.client.CommandWriter;
import io.camunda.zeebe.protocol.impl.record.UnifiedRecordValue;
import io.camunda.zeebe.protocol.impl.record.value.decision.DecisionEvaluationRecord;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.intent.DecisionEvaluationIntent;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.value.DecisionEvaluationRecordValue;
import io.camunda.zeebe.test.util.MsgPackUtil;
import io.camunda.zeebe.test.util.record.DecisionEvaluationRecordStream;
import io.camunda.zeebe.test.util.record.RecordingExporter;
import java.util.Map;
import java.util.function.Function;

public class DecisionEvaluationClient {
    private static final Function<Long, Record<DecisionEvaluationRecordValue>> SUCCESS_EXPECTATION = position -> (Record)((DecisionEvaluationRecordStream)((DecisionEvaluationRecordStream)RecordingExporter.decisionEvaluationRecords().withIntent((Intent)DecisionEvaluationIntent.EVALUATED)).withSourceRecordPosition(position.longValue())).getFirst();
    private static final Function<Long, Record<DecisionEvaluationRecordValue>> FAILURE_EXPECTATION = position -> (Record)((DecisionEvaluationRecordStream)((DecisionEvaluationRecordStream)RecordingExporter.decisionEvaluationRecords().withIntent((Intent)DecisionEvaluationIntent.FAILED)).withSourceRecordPosition(position.longValue())).getFirst();
    private static final Function<Long, Record<DecisionEvaluationRecordValue>> REJECTION_EXPECTATION = position -> (Record)((DecisionEvaluationRecordStream)((DecisionEvaluationRecordStream)((DecisionEvaluationRecordStream)RecordingExporter.decisionEvaluationRecords().onlyCommandRejections()).withIntent((Intent)DecisionEvaluationIntent.EVALUATE)).withSourceRecordPosition(position.longValue())).getFirst();
    private final CommandWriter writer;
    private final DecisionEvaluationRecord decisionEvaluationRecord = new DecisionEvaluationRecord();
    private Function<Long, Record<DecisionEvaluationRecordValue>> expectation = SUCCESS_EXPECTATION;

    public DecisionEvaluationClient(CommandWriter writer) {
        this.writer = writer;
    }

    public DecisionEvaluationClient ofDecisionId(String decisionId) {
        this.decisionEvaluationRecord.setDecisionId(decisionId);
        return this;
    }

    public DecisionEvaluationClient ofDecisionKey(long decisionKey) {
        this.decisionEvaluationRecord.setDecisionKey(decisionKey);
        return this;
    }

    public DecisionEvaluationClient withVariables(Map<String, Object> variables) {
        this.decisionEvaluationRecord.setVariables(MsgPackUtil.asMsgPack(variables));
        return this;
    }

    public DecisionEvaluationClient withVariables(String variables) {
        this.decisionEvaluationRecord.setVariables(MsgPackUtil.asMsgPack((String)variables));
        return this;
    }

    public DecisionEvaluationClient withVariable(String key, Object value) {
        this.decisionEvaluationRecord.setVariables(MsgPackUtil.asMsgPack((String)key, (Object)value));
        return this;
    }

    public DecisionEvaluationClient withTenant(String tenantId) {
        this.decisionEvaluationRecord.setTenantId(tenantId);
        return this;
    }

    public Record<DecisionEvaluationRecordValue> evaluate() {
        long position = this.writer.writeCommand((Intent)DecisionEvaluationIntent.EVALUATE, (UnifiedRecordValue)this.decisionEvaluationRecord);
        return this.expectation.apply(position);
    }

    public DecisionEvaluationClient expectFailure() {
        this.expectation = FAILURE_EXPECTATION;
        return this;
    }

    public DecisionEvaluationClient expectRejection() {
        this.expectation = REJECTION_EXPECTATION;
        return this;
    }
}

