/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.util.client;

import io.camunda.zeebe.engine.util.client.CommandWriter;
import io.camunda.zeebe.protocol.impl.SubscriptionUtil;
import io.camunda.zeebe.protocol.impl.encoding.MsgPackConverter;
import io.camunda.zeebe.protocol.impl.record.UnifiedRecordValue;
import io.camunda.zeebe.protocol.impl.record.value.message.MessageRecord;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.MessageIntent;
import io.camunda.zeebe.protocol.record.value.MessageRecordValue;
import io.camunda.zeebe.test.util.MsgPackUtil;
import io.camunda.zeebe.test.util.record.MessageRecordStream;
import io.camunda.zeebe.test.util.record.RecordingExporter;
import java.time.Duration;
import java.util.Map;
import java.util.function.Function;
import org.agrona.DirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

public final class PublishMessageClient {
    private static final int DEFAULT_VALUE = -1;
    private static final Duration DEFAULT_MSG_TTL = Duration.ofHours(1L);
    private static final Function<Message, Record<MessageRecordValue>> SUCCESSFUL_EXPECTATION_SUPPLIER = message -> (Record)((MessageRecordStream)((MessageRecordStream)RecordingExporter.messageRecords((MessageIntent)MessageIntent.PUBLISHED).withPartitionId(message.partitionId)).withCorrelationKey(message.correlationKey).withSourceRecordPosition(message.position)).getFirst();
    private static final Function<Message, Record<MessageRecordValue>> REJECTION_EXPECTATION_SUPPLIER = message -> (Record)((MessageRecordStream)((MessageRecordStream)RecordingExporter.messageRecords((MessageIntent)MessageIntent.PUBLISH).onlyCommandRejections()).withPartitionId(message.partitionId)).withCorrelationKey(message.correlationKey).getFirst();
    private final MessageRecord messageRecord;
    private final CommandWriter writer;
    private final int partitionCount;
    private Function<Message, Record<MessageRecordValue>> expectation = SUCCESSFUL_EXPECTATION_SUPPLIER;
    private int partitionId = -1;

    public PublishMessageClient(CommandWriter environmentRule, int partitionCount) {
        this.writer = environmentRule;
        this.partitionCount = partitionCount;
        this.messageRecord = new MessageRecord();
        this.messageRecord.setTimeToLive(DEFAULT_MSG_TTL.toMillis());
    }

    public PublishMessageClient withCorrelationKey(String correlationKey) {
        this.messageRecord.setCorrelationKey(correlationKey);
        return this;
    }

    public PublishMessageClient withName(String name) {
        this.messageRecord.setName(name);
        return this;
    }

    public PublishMessageClient withId(String id) {
        this.messageRecord.setMessageId(id);
        return this;
    }

    public PublishMessageClient withTimeToLive(Duration timeToLive) {
        return this.withTimeToLive(timeToLive.toMillis());
    }

    public PublishMessageClient withTimeToLive(long timeToLive) {
        this.messageRecord.setTimeToLive(timeToLive);
        return this;
    }

    public PublishMessageClient withVariables(Map<String, Object> variables) {
        return this.withVariables(MsgPackUtil.asMsgPack(variables));
    }

    public PublishMessageClient withVariables(DirectBuffer variables) {
        this.messageRecord.setVariables(variables);
        return this;
    }

    public PublishMessageClient withVariables(String variables) {
        this.messageRecord.setVariables((DirectBuffer)new UnsafeBuffer(MsgPackConverter.convertToMsgPack((String)variables)));
        return this;
    }

    public PublishMessageClient withTenantId(String tenantId) {
        this.messageRecord.setTenantId(tenantId);
        return this;
    }

    public PublishMessageClient onPartition(int partitionId) {
        this.partitionId = partitionId;
        return this;
    }

    public PublishMessageClient expectRejection() {
        this.expectation = REJECTION_EXPECTATION_SUPPLIER;
        return this;
    }

    public Record<MessageRecordValue> publish() {
        if (this.partitionId == -1) {
            this.partitionId = SubscriptionUtil.getSubscriptionPartitionId((DirectBuffer)this.messageRecord.getCorrelationKeyBuffer(), (int)this.partitionCount);
        }
        long position = this.writer.writeCommandOnPartition(this.partitionId, (Intent)MessageIntent.PUBLISH, (UnifiedRecordValue)this.messageRecord);
        return this.expectation.apply(new Message(this, this.partitionId, this.messageRecord.getCorrelationKey(), position));
    }

    private class Message {
        final int partitionId;
        final String correlationKey;
        final long position;

        Message(PublishMessageClient publishMessageClient, int partitionId, String correlationKey, long position) {
            this.partitionId = partitionId;
            this.correlationKey = correlationKey;
            this.position = position;
        }
    }
}

