/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.bpmn.activity;

import io.camunda.zeebe.engine.util.EngineRule;
import io.camunda.zeebe.engine.util.JobWorkerElementBuilder;
import io.camunda.zeebe.engine.util.JobWorkerElementBuilderProvider;
import io.camunda.zeebe.model.bpmn.Bpmn;
import io.camunda.zeebe.model.bpmn.BpmnModelInstance;
import io.camunda.zeebe.model.bpmn.builder.AbstractFlowNodeBuilder;
import io.camunda.zeebe.model.bpmn.builder.StartEventBuilder;
import io.camunda.zeebe.model.bpmn.builder.ZeebeJobWorkerElementBuilder;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.RecordType;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.JobIntent;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceIntent;
import io.camunda.zeebe.protocol.record.intent.VariableIntent;
import io.camunda.zeebe.protocol.record.value.BpmnElementType;
import io.camunda.zeebe.protocol.record.value.JobBatchRecordValue;
import io.camunda.zeebe.protocol.record.value.JobRecordValue;
import io.camunda.zeebe.protocol.record.value.ProcessInstanceRecordValue;
import io.camunda.zeebe.protocol.record.value.VariableRecordValue;
import io.camunda.zeebe.test.util.record.ProcessInstanceRecordStream;
import io.camunda.zeebe.test.util.record.RecordingExporter;
import io.camunda.zeebe.test.util.record.RecordingExporterTestWatcher;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.MapAssert;
import org.assertj.core.groups.Tuple;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public final class JobWorkerElementTest {
    @ClassRule
    public static final EngineRule ENGINE = EngineRule.singlePartition();
    private static final String PROCESS_ID = "process";
    @Rule
    public final RecordingExporterTestWatcher recordingExporterTestWatcher = new RecordingExporterTestWatcher();
    @Parameterized.Parameter
    public JobWorkerElementBuilder elementBuilder;

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> parameters() {
        return JobWorkerElementBuilderProvider.buildersAsParameters();
    }

    private BpmnModelInstance process(Consumer<ZeebeJobWorkerElementBuilder<?>> elementModifier) {
        StartEventBuilder processBuilder = Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent();
        AbstractFlowNodeBuilder<?, ?> jobWorkerElementBuilder = this.elementBuilder.build((AbstractFlowNodeBuilder<?, ?>)processBuilder, elementModifier);
        return ((AbstractFlowNodeBuilder)jobWorkerElementBuilder.id("task")).done();
    }

    @Test
    public void shouldActivateTask() {
        ENGINE.deployment().withXmlResource(this.process(t -> t.zeebeJobType("test"))).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        Assertions.assertThat((Stream)RecordingExporter.processInstanceRecords().withProcessInstanceKey(processInstanceKey).withElementType(this.elementBuilder.getElementType()).limit(3L)).extracting(new Function[]{Record::getRecordType, Record::getIntent}).containsSequence((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{RecordType.COMMAND, ProcessInstanceIntent.ACTIVATE_ELEMENT}), Assertions.tuple((Object[])new Object[]{RecordType.EVENT, ProcessInstanceIntent.ELEMENT_ACTIVATING}), Assertions.tuple((Object[])new Object[]{RecordType.EVENT, ProcessInstanceIntent.ELEMENT_ACTIVATED})});
        Record taskActivating = (Record)((ProcessInstanceRecordStream)RecordingExporter.processInstanceRecords().withProcessInstanceKey(processInstanceKey).withIntent((Intent)ProcessInstanceIntent.ELEMENT_ACTIVATING)).withElementType(this.elementBuilder.getElementType()).getFirst();
        io.camunda.zeebe.protocol.record.Assertions.assertThat((ProcessInstanceRecordValue)((ProcessInstanceRecordValue)taskActivating.getValue())).hasElementId("task").hasBpmnElementType(this.elementBuilder.getElementType()).hasFlowScopeKey(processInstanceKey).hasBpmnProcessId(PROCESS_ID).hasProcessInstanceKey(processInstanceKey);
    }

    @Test
    public void shouldActivateTaskWithCustomTenant() {
        String tenantId = "foo";
        ENGINE.deployment().withXmlResource(this.process(t -> t.zeebeJobType("test"))).withTenantId("foo").deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).withTenantId("foo").create();
        Record taskActivating = (Record)((ProcessInstanceRecordStream)RecordingExporter.processInstanceRecords().withProcessInstanceKey(processInstanceKey).withTenantId("foo").withIntent((Intent)ProcessInstanceIntent.ELEMENT_ACTIVATING)).withElementType(this.elementBuilder.getElementType()).getFirst();
        io.camunda.zeebe.protocol.record.Assertions.assertThat((ProcessInstanceRecordValue)((ProcessInstanceRecordValue)taskActivating.getValue())).hasElementId("task").hasBpmnElementType(this.elementBuilder.getElementType()).hasFlowScopeKey(processInstanceKey).hasBpmnProcessId(PROCESS_ID).hasProcessInstanceKey(processInstanceKey).hasTenantId("foo");
    }

    @Test
    public void shouldCreateJob() {
        ENGINE.deployment().withXmlResource(this.process(t -> ((ZeebeJobWorkerElementBuilder)t.zeebeJobType("test")).zeebeJobRetries("5"))).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        Record taskActivated = (Record)((ProcessInstanceRecordStream)RecordingExporter.processInstanceRecords().withProcessInstanceKey(processInstanceKey).withIntent((Intent)ProcessInstanceIntent.ELEMENT_ACTIVATED)).withElementType(this.elementBuilder.getElementType()).getFirst();
        Record jobCreated = (Record)RecordingExporter.jobRecords((JobIntent)JobIntent.CREATED).withProcessInstanceKey(processInstanceKey).getFirst();
        io.camunda.zeebe.protocol.record.Assertions.assertThat((JobRecordValue)((JobRecordValue)jobCreated.getValue())).hasType("test").hasRetries(5).hasElementInstanceKey(taskActivated.getKey()).hasElementId(((ProcessInstanceRecordValue)taskActivated.getValue()).getElementId()).hasProcessDefinitionKey(((ProcessInstanceRecordValue)taskActivated.getValue()).getProcessDefinitionKey()).hasBpmnProcessId(((ProcessInstanceRecordValue)taskActivated.getValue()).getBpmnProcessId()).hasProcessDefinitionVersion(((ProcessInstanceRecordValue)taskActivated.getValue()).getVersion());
    }

    @Test
    public void shouldCreateJobWithCustomHeaders() {
        ENGINE.deployment().withXmlResource(this.process(t -> ((ZeebeJobWorkerElementBuilder)((ZeebeJobWorkerElementBuilder)t.zeebeJobType("test")).zeebeTaskHeader("a", "b")).zeebeTaskHeader("c", "d"))).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        Record jobCreated = (Record)RecordingExporter.jobRecords((JobIntent)JobIntent.CREATED).withProcessInstanceKey(processInstanceKey).getFirst();
        Map customHeaders = ((JobRecordValue)jobCreated.getValue()).getCustomHeaders();
        ((MapAssert)((MapAssert)Assertions.assertThat((Map)customHeaders).hasSize(2)).containsEntry((Object)"a", (Object)"b")).containsEntry((Object)"c", (Object)"d");
    }

    @Test
    public void shouldCreateJobWithVariables() {
        ENGINE.deployment().withXmlResource(this.process(t -> ((ZeebeJobWorkerElementBuilder)t.zeebeInputExpression("x", "y")).zeebeJobType("taskWithVariables"))).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).withVariable("x", 1).create();
        Record variableCreated = (Record)RecordingExporter.variableRecords((VariableIntent)VariableIntent.CREATED).withProcessInstanceKey(processInstanceKey).withName("y").getFirst();
        io.camunda.zeebe.protocol.record.Assertions.assertThat((VariableRecordValue)((VariableRecordValue)variableCreated.getValue())).hasValue("1");
        RecordingExporter.jobRecords((JobIntent)JobIntent.CREATED).withProcessInstanceKey(processInstanceKey).await();
        List activatedJobs = ((JobBatchRecordValue)ENGINE.jobs().withType("taskWithVariables").activate().getValue()).getJobs();
        ((ListAssert)Assertions.assertThat((List)activatedJobs).hasSize(1)).allSatisfy(job -> ((MapAssert)Assertions.assertThat((Map)job.getVariables()).containsEntry((Object)"x", (Object)1)).containsEntry((Object)"y", (Object)1));
    }

    @Test
    public void shouldCompleteTask() {
        ENGINE.deployment().withXmlResource(this.process(t -> t.zeebeJobType("test"))).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        ENGINE.job().ofInstance(processInstanceKey).withType("test").complete();
        Assertions.assertThat((Stream)RecordingExporter.processInstanceRecords().withProcessInstanceKey(processInstanceKey).limitToProcessInstanceCompleted()).extracting(new Function[]{r -> ((ProcessInstanceRecordValue)r.getValue()).getBpmnElementType(), Record::getIntent}).containsSubsequence((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{this.elementBuilder.getElementType(), ProcessInstanceIntent.ELEMENT_COMPLETING}), Assertions.tuple((Object[])new Object[]{this.elementBuilder.getElementType(), ProcessInstanceIntent.ELEMENT_COMPLETED}), Assertions.tuple((Object[])new Object[]{BpmnElementType.PROCESS, ProcessInstanceIntent.ELEMENT_COMPLETED})});
    }

    @Test
    public void shouldCompleteTaskWithCustomTenant() {
        String tenantId = "foo";
        ENGINE.deployment().withXmlResource(this.process(t -> t.zeebeJobType("test"))).withTenantId("foo").deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).withTenantId("foo").create();
        ENGINE.job().ofInstance(processInstanceKey).withType("test").withAuthorizedTenantIds("foo").complete();
        Assertions.assertThat((Stream)RecordingExporter.processInstanceRecords().withProcessInstanceKey(processInstanceKey).withTenantId("foo").limitToProcessInstanceCompleted()).extracting(new Function[]{r -> ((ProcessInstanceRecordValue)r.getValue()).getBpmnElementType(), Record::getIntent}).containsSubsequence((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{this.elementBuilder.getElementType(), ProcessInstanceIntent.ELEMENT_COMPLETING}), Assertions.tuple((Object[])new Object[]{this.elementBuilder.getElementType(), ProcessInstanceIntent.ELEMENT_COMPLETED}), Assertions.tuple((Object[])new Object[]{BpmnElementType.PROCESS, ProcessInstanceIntent.ELEMENT_COMPLETED})});
    }

    @Test
    public void shouldCreateJobWithJobTypeExpression() {
        ENGINE.deployment().withXmlResource(this.process(t -> t.zeebeJobTypeExpression("type"))).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).withVariable("type", "test").create();
        Record jobCreated = (Record)RecordingExporter.jobRecords((JobIntent)JobIntent.CREATED).withProcessInstanceKey(processInstanceKey).getFirst();
        io.camunda.zeebe.protocol.record.Assertions.assertThat((JobRecordValue)((JobRecordValue)jobCreated.getValue())).hasType("test");
    }

    @Test
    public void shouldCreateJobWithJobRetriesExpression() {
        ENGINE.deployment().withXmlResource(this.process(t -> ((ZeebeJobWorkerElementBuilder)t.zeebeJobType("test")).zeebeJobRetriesExpression("retries"))).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).withVariable("retries", 8).create();
        Record jobCreated = (Record)RecordingExporter.jobRecords((JobIntent)JobIntent.CREATED).withProcessInstanceKey(processInstanceKey).getFirst();
        io.camunda.zeebe.protocol.record.Assertions.assertThat((JobRecordValue)((JobRecordValue)jobCreated.getValue())).hasRetries(8);
    }
}

