/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.bpmn.activity;

import io.camunda.zeebe.engine.util.EngineRule;
import io.camunda.zeebe.model.bpmn.Bpmn;
import io.camunda.zeebe.model.bpmn.BpmnModelInstance;
import io.camunda.zeebe.model.bpmn.builder.ServiceTaskBuilder;
import io.camunda.zeebe.model.bpmn.builder.UserTaskBuilder;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceIntent;
import io.camunda.zeebe.test.util.record.ProcessInstanceRecordStream;
import io.camunda.zeebe.test.util.record.ProcessInstances;
import io.camunda.zeebe.test.util.record.RecordingExporter;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.function.Consumer;
import org.assertj.core.api.Assertions;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class OutputMappingTest {
    @ClassRule
    public static final EngineRule ENGINE = EngineRule.singlePartition();
    private static final String PROCESS_ID = "processId";
    private final BpmnModelInstance bpmnModelInstance;
    private final String elementId;
    private final Consumer<Long> completionHandler;

    public OutputMappingTest(BpmnModelInstance bpmnModelInstance, String elementId, Consumer<Long> completionHandler) {
        this.bpmnModelInstance = bpmnModelInstance;
        this.elementId = elementId;
        this.completionHandler = completionHandler;
    }

    @Parameterized.Parameters(name="{index}: {1}")
    public static Collection<Object[]> parameters() {
        return Arrays.asList({Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().serviceTask("serviceTaskId", b -> ((ServiceTaskBuilder)b.zeebeJobType("type")).zeebeOutputExpression("foo", "bar")).endEvent().done(), "serviceTaskId", OutputMappingTest.handler(key -> ENGINE.job().withType("type").ofInstance((long)key).complete())}, {Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().intermediateThrowEvent("intermediateThrowEventId", b -> b.zeebeOutputExpression("foo", "bar")).endEvent().done(), "intermediateThrowEventId", OutputMappingTest.handler(key -> {})}, {Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().userTask("userTaskId", b -> b.zeebeOutputExpression("foo", "bar")).endEvent().done(), "userTaskId", OutputMappingTest.handler(key -> ENGINE.job().withType("io.camunda.zeebe:userTask").ofInstance((long)key).complete())}, {((UserTaskBuilder)Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().userTask("nativeUserTaskId", b -> b.zeebeOutputExpression("foo", "bar")).zeebeUserTask()).endEvent().done(), "nativeUserTaskId", OutputMappingTest.handler(key -> ENGINE.userTask().ofInstance((long)key).complete())});
    }

    @Test
    public void shouldApplyOutputMapping() {
        ENGINE.deployment().withXmlResource(this.bpmnModelInstance).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).withVariables("{ \"foo\": 1 }").create();
        this.completionHandler.accept(processInstanceKey);
        Record record = (Record)((ProcessInstanceRecordStream)RecordingExporter.processInstanceRecords().withElementId(this.elementId).withIntent((Intent)ProcessInstanceIntent.ELEMENT_COMPLETED)).withProcessInstanceKey(processInstanceKey).getFirst();
        Map variables = ProcessInstances.getCurrentVariables((long)processInstanceKey, (long)record.getPosition());
        Assertions.assertThat((Map)variables).contains(new Map.Entry[]{Assertions.entry((Object)"bar", (Object)"1")});
    }

    private static Consumer<Long> handler(Consumer<Long> handler) {
        return handler;
    }
}

