/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.deployment.model.validation;

import io.camunda.zeebe.el.ExpressionLanguage;
import io.camunda.zeebe.el.ExpressionLanguageFactory;
import io.camunda.zeebe.engine.processing.bpmn.clock.ZeebeFeelEngineClock;
import io.camunda.zeebe.engine.processing.common.ExpressionProcessor;
import io.camunda.zeebe.engine.processing.deployment.model.validation.ExpectedValidationResult;
import io.camunda.zeebe.engine.processing.deployment.model.validation.ZeebeRuntimeValidators;
import io.camunda.zeebe.model.bpmn.Bpmn;
import io.camunda.zeebe.model.bpmn.BpmnModelInstance;
import io.camunda.zeebe.model.bpmn.traversal.ModelElementVisitor;
import io.camunda.zeebe.model.bpmn.traversal.ModelWalker;
import io.camunda.zeebe.model.bpmn.validation.ValidationVisitor;
import io.camunda.zeebe.model.bpmn.validation.zeebe.ZeebeDesignTimeValidators;
import io.camunda.zeebe.scheduler.clock.ActorClock;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.camunda.bpm.model.xml.validation.ValidationResults;
import org.camunda.feel.FeelEngineClock;

public class ProcessValidationUtil {
    public static void validateProcess(BpmnModelInstance process, ExpectedValidationResult expectation) {
        Bpmn.validateModel((BpmnModelInstance)process);
        List validationResults = ProcessValidationUtil.validate(process).getResults().values().stream().flatMap(Collection::stream).collect(Collectors.toList());
        String validationResultsAsString = validationResults.stream().map(ExpectedValidationResult::toString).collect(Collectors.joining(",\n"));
        ((ListAssert)Assertions.assertThat(validationResults).describedAs("Expected validation failure%n<%s>%n but actual validation validationResults was%n<%s>", new Object[]{expectation, validationResultsAsString})).anyMatch(expectation::matches);
    }

    public static void validateProcess(BpmnModelInstance process) {
        Bpmn.validateModel((BpmnModelInstance)process);
        Assertions.assertThat(ProcessValidationUtil.validate(process).getResults().values().stream().flatMap(Collection::stream).toList()).isEmpty();
    }

    private static ValidationResults validate(BpmnModelInstance model) {
        ModelWalker walker = new ModelWalker(model);
        ExpressionLanguage expressionLanguage = ExpressionLanguageFactory.createExpressionLanguage((FeelEngineClock)new ZeebeFeelEngineClock(ActorClock.current()));
        ExpressionProcessor.EvaluationContextLookup emptyLookup = scopeKey -> name -> null;
        ExpressionProcessor expressionProcessor = new ExpressionProcessor(expressionLanguage, emptyLookup);
        ValidationVisitor visitor = new ValidationVisitor((Collection)Stream.of(ZeebeRuntimeValidators.getValidators((ExpressionLanguage)expressionLanguage, (ExpressionProcessor)expressionProcessor), ZeebeDesignTimeValidators.VALIDATORS).flatMap(Collection::stream).collect(Collectors.toList()));
        walker.walk((ModelElementVisitor)visitor);
        return visitor.getValidationResult();
    }
}

