/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.incident;

import io.camunda.zeebe.engine.util.EngineRule;
import io.camunda.zeebe.model.bpmn.Bpmn;
import io.camunda.zeebe.model.bpmn.BpmnModelInstance;
import io.camunda.zeebe.model.bpmn.builder.BusinessRuleTaskBuilder;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.intent.DecisionIntent;
import io.camunda.zeebe.protocol.record.intent.IncidentIntent;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceIntent;
import io.camunda.zeebe.protocol.record.value.BpmnElementType;
import io.camunda.zeebe.protocol.record.value.ErrorType;
import io.camunda.zeebe.protocol.record.value.IncidentRecordValue;
import io.camunda.zeebe.protocol.record.value.IncidentRecordValueAssert;
import io.camunda.zeebe.test.util.collection.Maps;
import io.camunda.zeebe.test.util.record.DecisionRecordStream;
import io.camunda.zeebe.test.util.record.IncidentRecordStream;
import io.camunda.zeebe.test.util.record.RecordingExporter;
import io.camunda.zeebe.test.util.record.RecordingExporterTestWatcher;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.groups.Tuple;
import org.junit.Rule;
import org.junit.Test;

public class BusinessRuleTaskIncidentTest {
    private static final String PROCESS_ID = "process";
    private static final String TASK_ELEMENT_ID = "business-rule-task";
    private static final String DMN_RESOURCE = "/dmn/drg-force-user-with-assertions.dmn";
    private static final String DECISION_ID = "jedi_or_sith";
    private static final String DECISION_ID_VARIABLE = "decisionIdVariable";
    private static final String RESULT_VARIABLE = "result";
    @Rule
    public final EngineRule engine = EngineRule.singlePartition();
    @Rule
    public final RecordingExporterTestWatcher watcher = new RecordingExporterTestWatcher();

    private BpmnModelInstance processWithBusinessRuleTask(Consumer<BusinessRuleTaskBuilder> modifier) {
        return Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().businessRuleTask(TASK_ELEMENT_ID, modifier).endEvent().done();
    }

    private IncidentRecordValueAssert assertIncidentCreated(long processInstanceKey, long elementInstanceKey) {
        return this.assertIncidentCreated(processInstanceKey, elementInstanceKey, "<default>");
    }

    private IncidentRecordValueAssert assertIncidentCreated(long processInstanceKey, long elementInstanceKey, String tenantId) {
        Record incidentRecord = (Record)RecordingExporter.incidentRecords((IncidentIntent)IncidentIntent.CREATED).withProcessInstanceKey(processInstanceKey).getFirst();
        return io.camunda.zeebe.protocol.record.Assertions.assertThat((IncidentRecordValue)((IncidentRecordValue)incidentRecord.getValue())).hasElementId(TASK_ELEMENT_ID).hasElementInstanceKey(elementInstanceKey).hasTenantId(tenantId).hasJobKey(-1L).hasVariableScopeKey(elementInstanceKey);
    }

    @Test
    public void shouldCreateIncidentIfDecisionNotDeployed() {
        this.engine.deployment().withXmlResource(this.processWithBusinessRuleTask(b -> ((BusinessRuleTaskBuilder)b.zeebeCalledDecisionId("unknown_decision_id")).zeebeResultVariable(RESULT_VARIABLE))).deploy();
        long processInstanceKey = this.engine.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        Record taskActivating = (Record)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATING).withProcessInstanceKey(processInstanceKey).withElementId(TASK_ELEMENT_ID).withElementType(BpmnElementType.BUSINESS_RULE_TASK).getFirst();
        this.assertIncidentCreated(processInstanceKey, taskActivating.getKey()).hasErrorType(ErrorType.CALLED_DECISION_ERROR).hasErrorMessage("Expected to evaluate decision 'unknown_decision_id', but no decision found for id 'unknown_decision_id'");
    }

    @Test
    public void shouldCreateIncidentIfDecisionEvaluationFailed() {
        this.engine.deployment().withXmlClasspathResource(DMN_RESOURCE).withXmlResource(this.processWithBusinessRuleTask(b -> ((BusinessRuleTaskBuilder)b.zeebeCalledDecisionId(DECISION_ID)).zeebeResultVariable(RESULT_VARIABLE))).deploy();
        long processInstanceKey = this.engine.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        Record taskActivating = (Record)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATING).withProcessInstanceKey(processInstanceKey).withElementId(TASK_ELEMENT_ID).withElementType(BpmnElementType.BUSINESS_RULE_TASK).getFirst();
        this.assertIncidentCreated(processInstanceKey, taskActivating.getKey()).hasErrorType(ErrorType.DECISION_EVALUATION_ERROR).hasErrorMessage("Expected to evaluate decision 'jedi_or_sith', but Assertion failure on evaluate the expression 'assert(lightsaberColor, lightsaberColor != null)': The condition is not fulfilled");
    }

    @Test
    public void shouldCreateIncidentIfDecisionIdExpressionEvaluationFailed() {
        this.engine.deployment().withXmlClasspathResource(DMN_RESOURCE).withXmlResource(this.processWithBusinessRuleTask(b -> ((BusinessRuleTaskBuilder)b.zeebeCalledDecisionIdExpression(DECISION_ID_VARIABLE)).zeebeResultVariable(RESULT_VARIABLE))).deploy();
        long processInstanceKey = this.engine.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        Record taskActivating = (Record)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATING).withProcessInstanceKey(processInstanceKey).withElementId(TASK_ELEMENT_ID).withElementType(BpmnElementType.BUSINESS_RULE_TASK).getFirst();
        this.assertIncidentCreated(processInstanceKey, taskActivating.getKey()).hasErrorType(ErrorType.EXTRACT_VALUE_ERROR).hasErrorMessage("Expected result of the expression 'decisionIdVariable' to be 'STRING', but was 'NULL'. The evaluation reported the following warnings:\n[NO_VARIABLE_FOUND] No variable found with name 'decisionIdVariable'");
    }

    @Test
    public void shouldResolveIncidentAndCreateNewIncidentWhenContinuationFails() {
        this.engine.deployment().withXmlClasspathResource(DMN_RESOURCE).withXmlResource(this.processWithBusinessRuleTask(b -> ((BusinessRuleTaskBuilder)b.zeebeCalledDecisionId(DECISION_ID)).zeebeResultVariable(RESULT_VARIABLE))).deploy();
        long processInstanceKey = this.engine.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        Record incidentCreated = (Record)RecordingExporter.incidentRecords((IncidentIntent)IncidentIntent.CREATED).withProcessInstanceKey(processInstanceKey).getFirst();
        this.engine.incident().ofInstance(processInstanceKey).withKey(incidentCreated.getKey()).resolve();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((IncidentRecordStream)RecordingExporter.incidentRecords((IncidentIntent)IncidentIntent.RESOLVED).withProcessInstanceKey(processInstanceKey).withRecordKey(incidentCreated.getKey())).exists()).describedAs("original incident is resolved", new Object[0])).isTrue();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((IncidentRecordStream)RecordingExporter.incidentRecords((IncidentIntent)IncidentIntent.CREATED).withProcessInstanceKey(processInstanceKey).filter(i -> i.getKey() != incidentCreated.getKey())).exists()).describedAs("a new incident is created", new Object[0])).isTrue();
    }

    @Test
    public void shouldResolveIncidentAfterDecisionNotDeployed() {
        this.engine.deployment().withXmlResource(this.processWithBusinessRuleTask(b -> ((BusinessRuleTaskBuilder)b.zeebeCalledDecisionId(DECISION_ID)).zeebeResultVariable(RESULT_VARIABLE))).deploy();
        long processInstanceKey = this.engine.processInstance().ofBpmnProcessId(PROCESS_ID).withVariables(Maps.of((Map.Entry[])new Map.Entry[]{Assertions.entry((Object)"lightsaberColor", (Object)"blue")})).create();
        Record incidentCreated = (Record)RecordingExporter.incidentRecords((IncidentIntent)IncidentIntent.CREATED).withProcessInstanceKey(processInstanceKey).getFirst();
        this.engine.deployment().withXmlClasspathResource(DMN_RESOURCE).deploy();
        this.engine.incident().ofInstance(processInstanceKey).withKey(incidentCreated.getKey()).resolve();
        Assertions.assertThat((Stream)RecordingExporter.records().betweenProcessInstance(processInstanceKey).incidentRecords().onlyEvents()).extracting(new Function[]{Record::getKey, Record::getIntent}).describedAs("created incident is resolved and no new incident is created", new Object[0]).containsExactly((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{incidentCreated.getKey(), IncidentIntent.CREATED}), Assertions.tuple((Object[])new Object[]{incidentCreated.getKey(), IncidentIntent.RESOLVED})});
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_COMPLETED).withProcessInstanceKey(processInstanceKey).withElementId(TASK_ELEMENT_ID).exists()).describedAs("business rule task is successfully completed", new Object[0])).isTrue();
    }

    @Test
    public void shouldResolveIncidentAfterDecisionEvaluationFailed() {
        this.engine.deployment().withXmlClasspathResource(DMN_RESOURCE).withXmlResource(this.processWithBusinessRuleTask(b -> ((BusinessRuleTaskBuilder)b.zeebeCalledDecisionId(DECISION_ID)).zeebeResultVariable(RESULT_VARIABLE))).deploy();
        long processInstanceKey = this.engine.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        Record incidentCreated = (Record)RecordingExporter.incidentRecords((IncidentIntent)IncidentIntent.CREATED).withProcessInstanceKey(processInstanceKey).getFirst();
        this.engine.variables().ofScope(((IncidentRecordValue)incidentCreated.getValue()).getElementInstanceKey()).withDocument(Maps.of((Map.Entry[])new Map.Entry[]{Assertions.entry((Object)"lightsaberColor", (Object)"blue")})).update();
        this.engine.incident().ofInstance(processInstanceKey).withKey(incidentCreated.getKey()).resolve();
        Assertions.assertThat((Stream)RecordingExporter.records().betweenProcessInstance(processInstanceKey).incidentRecords().onlyEvents()).extracting(new Function[]{Record::getKey, Record::getIntent}).describedAs("created incident is resolved and no new incident is created", new Object[0]).containsExactly((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{incidentCreated.getKey(), IncidentIntent.CREATED}), Assertions.tuple((Object[])new Object[]{incidentCreated.getKey(), IncidentIntent.RESOLVED})});
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_COMPLETED).withProcessInstanceKey(processInstanceKey).withElementId(TASK_ELEMENT_ID).exists()).describedAs("business rule task is successfully completed", new Object[0])).isTrue();
    }

    @Test
    public void shouldResolveIncidentAfterDecisionIdExpressionEvaluationFailed() {
        this.engine.deployment().withXmlClasspathResource(DMN_RESOURCE).withXmlResource(this.processWithBusinessRuleTask(b -> ((BusinessRuleTaskBuilder)b.zeebeCalledDecisionIdExpression(DECISION_ID_VARIABLE)).zeebeResultVariable(RESULT_VARIABLE))).deploy();
        long processInstanceKey = this.engine.processInstance().ofBpmnProcessId(PROCESS_ID).withVariables(Maps.of((Map.Entry[])new Map.Entry[]{Assertions.entry((Object)"lightsaberColor", (Object)"blue")})).create();
        Record incidentCreated = (Record)RecordingExporter.incidentRecords((IncidentIntent)IncidentIntent.CREATED).withProcessInstanceKey(processInstanceKey).getFirst();
        this.engine.variables().ofScope(((IncidentRecordValue)incidentCreated.getValue()).getElementInstanceKey()).withDocument(Maps.of((Map.Entry[])new Map.Entry[]{Assertions.entry((Object)DECISION_ID_VARIABLE, (Object)DECISION_ID)})).update();
        this.engine.incident().ofInstance(processInstanceKey).withKey(incidentCreated.getKey()).resolve();
        Assertions.assertThat((Stream)RecordingExporter.records().betweenProcessInstance(processInstanceKey).incidentRecords().onlyEvents()).extracting(new Function[]{Record::getKey, Record::getIntent}).describedAs("created incident is resolved and no new incident is created", new Object[0]).containsExactly((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{incidentCreated.getKey(), IncidentIntent.CREATED}), Assertions.tuple((Object[])new Object[]{incidentCreated.getKey(), IncidentIntent.RESOLVED})});
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_COMPLETED).withProcessInstanceKey(processInstanceKey).withElementId(TASK_ELEMENT_ID).exists()).describedAs("business rule task is successfully completed", new Object[0])).isTrue();
    }

    @Test
    public void shouldCreateIncidentOnBusinessRuleTaskForCustomTenant() {
        String tenantId = "acme";
        this.engine.deployment().withXmlResource(this.processWithBusinessRuleTask(b -> ((BusinessRuleTaskBuilder)b.zeebeCalledDecisionId("unknown_decision_id")).zeebeResultVariable(RESULT_VARIABLE))).withTenantId("acme").deploy();
        long processInstanceKey = this.engine.processInstance().ofBpmnProcessId(PROCESS_ID).withTenantId("acme").create();
        Record taskActivating = (Record)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATING).withProcessInstanceKey(processInstanceKey).withElementId(TASK_ELEMENT_ID).withElementType(BpmnElementType.BUSINESS_RULE_TASK).withTenantId("acme").getFirst();
        this.assertIncidentCreated(processInstanceKey, taskActivating.getKey(), "acme");
    }

    @Test
    public void shouldCreateIncidentOnBusinessRuleTaskForDifferentTenant() {
        String tenantId = "acme";
        String otherTenantId = "emca";
        this.engine.deployment().withXmlResource(this.processWithBusinessRuleTask(b -> ((BusinessRuleTaskBuilder)b.zeebeCalledDecisionId(DECISION_ID)).zeebeResultVariable(RESULT_VARIABLE))).withTenantId("acme").deploy();
        this.engine.deployment().withXmlClasspathResource(DMN_RESOURCE).withXmlResource(this.processWithBusinessRuleTask(b -> ((BusinessRuleTaskBuilder)b.zeebeCalledDecisionId(DECISION_ID)).zeebeResultVariable(RESULT_VARIABLE))).withTenantId("emca").deploy();
        long processInstanceKey = this.engine.processInstance().ofBpmnProcessId(PROCESS_ID).withTenantId("acme").create();
        Record taskActivating = (Record)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATING).withProcessInstanceKey(processInstanceKey).withElementId(TASK_ELEMENT_ID).withElementType(BpmnElementType.BUSINESS_RULE_TASK).withTenantId("acme").getFirst();
        Assertions.assertThat((boolean)((DecisionRecordStream)RecordingExporter.decisionRecords().withIntent((Intent)DecisionIntent.CREATED)).withDecisionId(DECISION_ID).withTenantId("emca").exists()).isTrue();
        this.assertIncidentCreated(processInstanceKey, taskActivating.getKey(), "acme");
    }
}

