/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.incident;

import io.camunda.zeebe.engine.processing.incident.IncidentHelper;
import io.camunda.zeebe.engine.util.EngineRule;
import io.camunda.zeebe.model.bpmn.Bpmn;
import io.camunda.zeebe.model.bpmn.BpmnModelInstance;
import io.camunda.zeebe.model.bpmn.builder.BoundaryEventBuilder;
import io.camunda.zeebe.model.bpmn.builder.StartEventBuilder;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.intent.IncidentIntent;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceIntent;
import io.camunda.zeebe.protocol.record.value.BpmnElementType;
import io.camunda.zeebe.protocol.record.value.ErrorType;
import io.camunda.zeebe.protocol.record.value.IncidentRecordValue;
import io.camunda.zeebe.protocol.record.value.ProcessInstanceRecordValue;
import io.camunda.zeebe.test.util.Strings;
import io.camunda.zeebe.test.util.record.ProcessInstanceRecordStream;
import io.camunda.zeebe.test.util.record.RecordingExporter;
import io.camunda.zeebe.test.util.record.RecordingExporterTestWatcher;
import java.util.function.Function;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

public final class CallActivityIncidentTest {
    @ClassRule
    public static final EngineRule ENGINE = EngineRule.singlePartition();
    private static final String PROCESS_ID_VARIABLE = "wfChild";
    private static final Function<String, BpmnModelInstance> PROCESS_PARENT_PROCESS_ID_EXPRESSION_SUPPLIER = parentProcessId -> Bpmn.createExecutableProcess((String)parentProcessId).startEvent().callActivity("call", c -> c.zeebeProcessIdExpression(PROCESS_ID_VARIABLE)).done();
    @Rule
    public final RecordingExporterTestWatcher recordingExporterTestWatcher = new RecordingExporterTestWatcher();
    private String parentProcessId;
    private String childProcessId;

    @Before
    public void init() {
        this.parentProcessId = Strings.newRandomValidBpmnId();
        this.childProcessId = Strings.newRandomValidBpmnId();
        ENGINE.deployment().withXmlResource("wf-parent.bpmn", Bpmn.createExecutableProcess((String)this.parentProcessId).startEvent().callActivity("call", c -> c.zeebeProcessId(this.childProcessId)).done()).deploy();
    }

    @Test
    public void shouldCreateIncidentIfProcessIsNotDeployed() {
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(this.parentProcessId).create();
        Record<IncidentRecordValue> incident = this.getIncident(processInstanceKey);
        Record<ProcessInstanceRecordValue> elementInstance = this.getCallActivityInstance(processInstanceKey);
        IncidentHelper.assertIncidentCreated(incident, elementInstance).hasErrorType(ErrorType.CALLED_ELEMENT_ERROR).hasErrorMessage("Expected process with BPMN process id '" + this.childProcessId + "' to be deployed, but not found.");
    }

    @Test
    public void shouldCreateIncidentIfProcessHasNoNoneStartEvent() {
        ENGINE.deployment().withXmlResource(((StartEventBuilder)Bpmn.createExecutableProcess((String)this.childProcessId).startEvent().message("start")).endEvent().done()).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(this.parentProcessId).create();
        Record<IncidentRecordValue> incident = this.getIncident(processInstanceKey);
        Record<ProcessInstanceRecordValue> elementInstance = this.getCallActivityInstance(processInstanceKey);
        IncidentHelper.assertIncidentCreated(incident, elementInstance).hasErrorType(ErrorType.CALLED_ELEMENT_ERROR).hasErrorMessage("Expected process with BPMN process id '" + this.childProcessId + "' to have a none start event, but not found.");
    }

    @Test
    public void shouldCreateIncidentIfProcessIdVariableNotExists() {
        ENGINE.deployment().withXmlResource(PROCESS_PARENT_PROCESS_ID_EXPRESSION_SUPPLIER.apply(this.parentProcessId)).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(this.parentProcessId).create();
        Record<IncidentRecordValue> incident = this.getIncident(processInstanceKey);
        Record<ProcessInstanceRecordValue> elementInstance = this.getCallActivityInstance(processInstanceKey);
        IncidentHelper.assertIncidentCreated(incident, elementInstance).hasErrorType(ErrorType.EXTRACT_VALUE_ERROR).hasErrorMessage("Expected result of the expression 'wfChild' to be 'STRING', but was 'NULL'. The evaluation reported the following warnings:\n[NO_VARIABLE_FOUND] No variable found with name 'wfChild'");
    }

    @Test
    public void shouldCreateIncidentIfProcessIdVariableIsNaString() {
        ENGINE.deployment().withXmlResource(PROCESS_PARENT_PROCESS_ID_EXPRESSION_SUPPLIER.apply(this.parentProcessId)).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(this.parentProcessId).withVariable(PROCESS_ID_VARIABLE, 123).create();
        Record<IncidentRecordValue> incident = this.getIncident(processInstanceKey);
        Record<ProcessInstanceRecordValue> elementInstance = this.getCallActivityInstance(processInstanceKey);
        IncidentHelper.assertIncidentCreated(incident, elementInstance).hasErrorType(ErrorType.EXTRACT_VALUE_ERROR).hasErrorMessage("Expected result of the expression 'wfChild' to be 'STRING', but was 'NUMBER'.");
    }

    @Test
    public void shouldCreateIncidentOnCallActivityForCustomTenant() {
        String tenantId = "acme";
        ENGINE.deployment().withXmlResource(PROCESS_PARENT_PROCESS_ID_EXPRESSION_SUPPLIER.apply(this.parentProcessId)).withTenantId("acme").deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(this.parentProcessId).withTenantId("acme").create();
        Record<IncidentRecordValue> incident = this.getIncident(processInstanceKey);
        Record<ProcessInstanceRecordValue> elementInstance = this.getCallActivityInstance(processInstanceKey);
        IncidentHelper.assertIncidentCreated(incident, elementInstance, "acme").hasErrorType(ErrorType.EXTRACT_VALUE_ERROR).hasErrorMessage("Expected result of the expression 'wfChild' to be 'STRING', but was 'NULL'. The evaluation reported the following warnings:\n[NO_VARIABLE_FOUND] No variable found with name 'wfChild'");
    }

    @Test
    public void shouldResolveIncident() {
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(this.parentProcessId).create();
        Record<IncidentRecordValue> incident = this.getIncident(processInstanceKey);
        ENGINE.deployment().withXmlResource(Bpmn.createExecutableProcess((String)this.childProcessId).startEvent().endEvent().done()).deploy();
        ENGINE.incident().ofInstance(processInstanceKey).withKey(incident.getKey()).resolve();
        Assertions.assertThat((Stream)((ProcessInstanceRecordStream)((ProcessInstanceRecordStream)RecordingExporter.processInstanceRecords().onlyEvents()).withRecordKey(((IncidentRecordValue)incident.getValue()).getElementInstanceKey())).limit(2L)).extracting(Record::getIntent).contains((Object[])new Intent[]{ProcessInstanceIntent.ELEMENT_ACTIVATED});
    }

    @Test
    public void shouldResolveIncidentWithMessageBoundaryEvent() {
        ENGINE.deployment().withXmlResource(((BoundaryEventBuilder)Bpmn.createExecutableProcess((String)this.parentProcessId).startEvent().callActivity("call", c -> c.zeebeProcessId(this.childProcessId)).boundaryEvent("boundary").message(m -> m.name("message").zeebeCorrelationKeyExpression("123"))).endEvent().done()).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(this.parentProcessId).create();
        Record<IncidentRecordValue> incident = this.getIncident(processInstanceKey);
        ENGINE.deployment().withXmlResource(Bpmn.createExecutableProcess((String)this.childProcessId).startEvent().endEvent().done()).deploy();
        ENGINE.incident().ofInstance(processInstanceKey).withKey(incident.getKey()).resolve();
        Assertions.assertThat((Stream)((ProcessInstanceRecordStream)((ProcessInstanceRecordStream)RecordingExporter.processInstanceRecords().onlyEvents()).withRecordKey(((IncidentRecordValue)incident.getValue()).getElementInstanceKey())).limit(2L)).extracting(Record::getIntent).contains((Object[])new Intent[]{ProcessInstanceIntent.ELEMENT_ACTIVATED});
    }

    private Record<ProcessInstanceRecordValue> getCallActivityInstance(long processInstanceKey) {
        return (Record)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATING).withProcessInstanceKey(processInstanceKey).withElementType(BpmnElementType.CALL_ACTIVITY).getFirst();
    }

    private Record<IncidentRecordValue> getIncident(long processInstanceKey) {
        return (Record)RecordingExporter.incidentRecords((IncidentIntent)IncidentIntent.CREATED).withProcessInstanceKey(processInstanceKey).getFirst();
    }
}

