/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.job;

import io.camunda.zeebe.engine.util.EngineRule;
import io.camunda.zeebe.msgpack.spec.MsgPackHelper;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.RecordType;
import io.camunda.zeebe.protocol.record.RejectionType;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.JobIntent;
import io.camunda.zeebe.protocol.record.value.JobBatchRecordValue;
import io.camunda.zeebe.protocol.record.value.JobRecordValue;
import io.camunda.zeebe.test.util.Strings;
import io.camunda.zeebe.test.util.record.RecordingExporterTestWatcher;
import java.util.Collections;
import java.util.Map;
import org.agrona.DirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ThrowableAssert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

public final class CompleteJobTest {
    @ClassRule
    public static final EngineRule ENGINE = EngineRule.singlePartition();
    private static final String PROCESS_ID = "process";
    private static String jobType;
    @Rule
    public final RecordingExporterTestWatcher recordingExporterTestWatcher = new RecordingExporterTestWatcher();

    @Before
    public void setup() {
        jobType = Strings.newRandomValidBpmnId();
    }

    @Test
    public void shouldCompleteJob() {
        ENGINE.createJob(jobType, PROCESS_ID);
        Record<JobBatchRecordValue> batchRecord = ENGINE.jobs().withType(jobType).activate();
        JobRecordValue job = (JobRecordValue)((JobBatchRecordValue)batchRecord.getValue()).getJobs().get(0);
        Record<JobRecordValue> jobCompletedRecord = ENGINE.job().withKey((Long)((JobBatchRecordValue)batchRecord.getValue()).getJobKeys().get(0)).complete();
        JobRecordValue recordValue = (JobRecordValue)jobCompletedRecord.getValue();
        io.camunda.zeebe.protocol.record.Assertions.assertThat(jobCompletedRecord).hasRecordType(RecordType.EVENT).hasIntent((Intent)JobIntent.COMPLETED);
        io.camunda.zeebe.protocol.record.Assertions.assertThat((JobRecordValue)recordValue).hasWorker(((JobBatchRecordValue)batchRecord.getValue()).getWorker()).hasType(job.getType()).hasRetries(job.getRetries()).hasDeadline(job.getDeadline()).hasTenantId("<default>");
    }

    @Test
    public void shouldRejectCompletionIfJobNotFound() {
        int key = 123;
        Record<JobRecordValue> jobRecord = ENGINE.job().withKey(123L).expectRejection().complete();
        io.camunda.zeebe.protocol.record.Assertions.assertThat(jobRecord).hasRejectionType(RejectionType.NOT_FOUND);
    }

    @Test
    public void shouldCompleteJobWithVariables() {
        ENGINE.createJob(jobType, PROCESS_ID);
        Record<JobBatchRecordValue> batchRecord = ENGINE.jobs().withType(jobType).activate();
        Record<JobRecordValue> completedRecord = ENGINE.job().withKey((Long)((JobBatchRecordValue)batchRecord.getValue()).getJobKeys().get(0)).withVariables("{'foo':'bar'}").complete();
        io.camunda.zeebe.protocol.record.Assertions.assertThat(completedRecord).hasRecordType(RecordType.EVENT).hasIntent((Intent)JobIntent.COMPLETED);
        Assertions.assertThat((Map)((JobRecordValue)completedRecord.getValue()).getVariables()).containsExactly(new Map.Entry[]{Assertions.entry((Object)"foo", (Object)"bar")});
    }

    @Test
    public void shouldCompleteJobWithNilVariables() {
        ENGINE.createJob(jobType, PROCESS_ID);
        Record<JobBatchRecordValue> batchRecord = ENGINE.jobs().withType(jobType).activate();
        Record<JobRecordValue> completedRecord = ENGINE.job().withKey((Long)((JobBatchRecordValue)batchRecord.getValue()).getJobKeys().get(0)).withVariables((DirectBuffer)new UnsafeBuffer(MsgPackHelper.NIL)).complete();
        io.camunda.zeebe.protocol.record.Assertions.assertThat(completedRecord).hasRecordType(RecordType.EVENT).hasIntent((Intent)JobIntent.COMPLETED);
        Assertions.assertThat((Map)((JobRecordValue)completedRecord.getValue()).getVariables()).isEmpty();
    }

    @Test
    public void shouldCompleteJobWithZeroLengthVariables() {
        ENGINE.createJob(jobType, PROCESS_ID);
        Record<JobBatchRecordValue> batchRecord = ENGINE.jobs().withType(jobType).activate();
        Record<JobRecordValue> completedRecord = ENGINE.job().withKey((Long)((JobBatchRecordValue)batchRecord.getValue()).getJobKeys().get(0)).withVariables((DirectBuffer)new UnsafeBuffer(new byte[0])).complete();
        io.camunda.zeebe.protocol.record.Assertions.assertThat(completedRecord).hasRecordType(RecordType.EVENT).hasIntent((Intent)JobIntent.COMPLETED);
        Assertions.assertThat((Map)((JobRecordValue)completedRecord.getValue()).getVariables()).isEmpty();
    }

    @Test
    public void shouldThrowExceptionOnCompletionIfVariablesAreInvalid() {
        ENGINE.createJob(jobType, PROCESS_ID);
        Record<JobBatchRecordValue> batchRecord = ENGINE.jobs().withType(jobType).activate();
        byte[] invalidVariables = new byte[]{1};
        Throwable throwable = ThrowableAssert.catchThrowable(() -> ENGINE.job().withKey((Long)((JobBatchRecordValue)batchRecord.getValue()).getJobKeys().get(0)).withVariables((DirectBuffer)new UnsafeBuffer(invalidVariables)).expectRejection().complete());
        Assertions.assertThat((Throwable)throwable).isInstanceOf(RuntimeException.class);
        Assertions.assertThat((String)throwable.getMessage()).contains(new CharSequence[]{"Property 'variables' is invalid"});
        Assertions.assertThat((String)throwable.getMessage()).contains(new CharSequence[]{"Expected document to be a root level object, but was 'INTEGER'"});
    }

    @Test
    public void shouldRejectCompletionIfJobIsCompleted() {
        ENGINE.createJob(jobType, PROCESS_ID);
        Record<JobBatchRecordValue> batchRecord = ENGINE.jobs().withType(jobType).activate();
        Long jobKey = (Long)((JobBatchRecordValue)batchRecord.getValue()).getJobKeys().get(0);
        ENGINE.job().withKey(jobKey).complete();
        Record<JobRecordValue> jobRecord = ENGINE.job().withKey(jobKey).expectRejection().complete();
        io.camunda.zeebe.protocol.record.Assertions.assertThat(jobRecord).hasRejectionType(RejectionType.NOT_FOUND);
    }

    @Test
    public void shouldRejectCompletionIfJobIsFailed() {
        ENGINE.createJob(jobType, PROCESS_ID);
        Record<JobBatchRecordValue> batchRecord = ENGINE.jobs().withType(jobType).activate();
        Long jobKey = (Long)((JobBatchRecordValue)batchRecord.getValue()).getJobKeys().get(0);
        ENGINE.job().withKey(jobKey).fail();
        Record<JobRecordValue> jobRecord = ENGINE.job().withKey(jobKey).expectRejection().complete();
        io.camunda.zeebe.protocol.record.Assertions.assertThat(jobRecord).hasRejectionType(RejectionType.INVALID_STATE);
    }

    @Test
    public void shouldCompleteJobForCustomTenant() {
        String tenantId = "acme";
        ENGINE.createJob(jobType, PROCESS_ID, Collections.emptyMap(), "acme");
        Record<JobBatchRecordValue> batchRecord = ENGINE.jobs().withType(jobType).withTenantId("acme").activate();
        Record<JobRecordValue> jobCompletedRecord = ENGINE.job().withKey((Long)((JobBatchRecordValue)batchRecord.getValue()).getJobKeys().get(0)).withAuthorizedTenantIds("acme").complete();
        JobRecordValue recordValue = (JobRecordValue)jobCompletedRecord.getValue();
        io.camunda.zeebe.protocol.record.Assertions.assertThat(jobCompletedRecord).hasRecordType(RecordType.EVENT).hasIntent((Intent)JobIntent.COMPLETED);
        io.camunda.zeebe.protocol.record.Assertions.assertThat((JobRecordValue)recordValue).hasTenantId("acme");
    }

    @Test
    public void shouldRejectCompletionIfTenantIsUnauthorized() {
        String tenantId = "acme";
        String falseTenantId = "foo";
        ENGINE.createJob(jobType, PROCESS_ID, Collections.emptyMap(), "acme");
        Record<JobBatchRecordValue> batchRecord = ENGINE.jobs().withType(jobType).withTenantId("acme").activate();
        Record<JobRecordValue> jobRecord = ENGINE.job().withKey((Long)((JobBatchRecordValue)batchRecord.getValue()).getJobKeys().get(0)).withAuthorizedTenantIds("foo").expectRejection().complete();
        io.camunda.zeebe.protocol.record.Assertions.assertThat(jobRecord).hasRejectionType(RejectionType.NOT_FOUND);
    }
}

