/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.message.command;

import io.camunda.zeebe.engine.processing.message.command.SubscriptionCommandSender;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.Writers;
import io.camunda.zeebe.engine.state.EventApplier;
import io.camunda.zeebe.engine.state.appliers.EventAppliers;
import io.camunda.zeebe.protocol.Protocol;
import io.camunda.zeebe.protocol.impl.record.RecordMetadata;
import io.camunda.zeebe.protocol.impl.record.UnifiedRecordValue;
import io.camunda.zeebe.protocol.record.RecordValue;
import io.camunda.zeebe.protocol.record.ValueType;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.MessageSubscriptionIntent;
import io.camunda.zeebe.protocol.record.intent.ProcessMessageSubscriptionIntent;
import io.camunda.zeebe.stream.api.InterPartitionCommandSender;
import io.camunda.zeebe.stream.api.PostCommitTask;
import io.camunda.zeebe.stream.api.ProcessingResultBuilder;
import io.camunda.zeebe.util.buffer.BufferUtil;
import org.agrona.DirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class SubscriptionCommandSenderTest {
    public static final DirectBuffer DEFAULT_PROCESS_ID = BufferUtil.wrapString((String)"process");
    public static final int DEFAULT_MESSAGE_KEY = 123;
    public static final UnsafeBuffer DEFAULT_VARIABLES = new UnsafeBuffer();
    public static final DirectBuffer DEFAULT_CORRELATION_KEY = BufferUtil.wrapString((String)"correlationKey");
    private static final int SAME_PARTITION = 1;
    private static final int DIFFERENT_PARTITION = 2;
    private static final long DIFFERENT_RECEIVER_PARTITION_KEY = Protocol.encodePartitionId((int)2, (long)1L);
    private static final long SAME_RECEIVER_PARTITION_KEY = Protocol.encodePartitionId((int)1, (long)1L);
    private static final long DEFAULT_ELEMENT_INSTANCE_KEY = 111L;
    private static final DirectBuffer DEFAULT_MESSAGE_NAME = BufferUtil.wrapString((String)"msg");
    private static final String DEFAULT_TENANT = "<default>";
    private InterPartitionCommandSender mockInterPartitionCommandSender;
    private SubscriptionCommandSender subscriptionCommandSender;
    private ProcessingResultBuilder mockProcessingResultBuilder;

    @BeforeEach
    public void setup() {
        this.mockInterPartitionCommandSender = (InterPartitionCommandSender)Mockito.mock(InterPartitionCommandSender.class);
        this.subscriptionCommandSender = new SubscriptionCommandSender(1, this.mockInterPartitionCommandSender);
        this.mockProcessingResultBuilder = (ProcessingResultBuilder)Mockito.mock(ProcessingResultBuilder.class);
        EventAppliers mockEventAppliers = (EventAppliers)Mockito.mock(EventAppliers.class);
        Writers writers = new Writers(() -> this.mockProcessingResultBuilder, (EventApplier)mockEventAppliers);
        this.subscriptionCommandSender.setWriters(writers);
    }

    @Test
    public void shouldSentFollowUpCommandForCloseProcessMessageSubscription() {
        this.subscriptionCommandSender.closeProcessMessageSubscription(DIFFERENT_RECEIVER_PARTITION_KEY, 111L, DEFAULT_MESSAGE_NAME, DEFAULT_TENANT);
        ((ProcessingResultBuilder)Mockito.verify((Object)this.mockProcessingResultBuilder)).appendPostCommitTask((PostCommitTask)ArgumentMatchers.any());
        ((ProcessingResultBuilder)Mockito.verify((Object)this.mockProcessingResultBuilder, (VerificationMode)Mockito.never())).appendRecord(ArgumentMatchers.anyLong(), (RecordValue)ArgumentMatchers.any(), (RecordMetadata)ArgumentMatchers.any());
    }

    @Test
    public void shouldWriteFollowUpCommandForCloseProcessMessageSubscription() {
        this.subscriptionCommandSender.closeProcessMessageSubscription(SAME_RECEIVER_PARTITION_KEY, 111L, DEFAULT_MESSAGE_NAME, DEFAULT_TENANT);
        ((ProcessingResultBuilder)Mockito.verify((Object)this.mockProcessingResultBuilder, (VerificationMode)Mockito.never())).appendPostCommitTask((PostCommitTask)ArgumentMatchers.any());
        ((ProcessingResultBuilder)Mockito.verify((Object)this.mockProcessingResultBuilder)).appendRecord(ArgumentMatchers.anyLong(), (RecordValue)ArgumentMatchers.any(), (RecordMetadata)ArgumentMatchers.any());
    }

    @Test
    public void shouldSentFollowUpCommandForCorrelateProcessMessageSubscription() {
        this.subscriptionCommandSender.correlateProcessMessageSubscription(DIFFERENT_RECEIVER_PARTITION_KEY, 111L, DEFAULT_PROCESS_ID, DEFAULT_MESSAGE_NAME, 123L, (DirectBuffer)DEFAULT_VARIABLES, DEFAULT_CORRELATION_KEY, DEFAULT_TENANT);
        ((ProcessingResultBuilder)Mockito.verify((Object)this.mockProcessingResultBuilder)).appendPostCommitTask((PostCommitTask)ArgumentMatchers.any());
        ((ProcessingResultBuilder)Mockito.verify((Object)this.mockProcessingResultBuilder, (VerificationMode)Mockito.never())).appendRecord(ArgumentMatchers.anyLong(), (RecordValue)ArgumentMatchers.any(), (RecordMetadata)ArgumentMatchers.any());
    }

    @Test
    public void shouldWriteFollowUpCommandForCorrelateProcessMessageSubscription() {
        this.subscriptionCommandSender.correlateProcessMessageSubscription(SAME_RECEIVER_PARTITION_KEY, 111L, DEFAULT_PROCESS_ID, DEFAULT_MESSAGE_NAME, 123L, (DirectBuffer)DEFAULT_VARIABLES, DEFAULT_CORRELATION_KEY, DEFAULT_TENANT);
        ((ProcessingResultBuilder)Mockito.verify((Object)this.mockProcessingResultBuilder, (VerificationMode)Mockito.never())).appendPostCommitTask((PostCommitTask)ArgumentMatchers.any());
        ((ProcessingResultBuilder)Mockito.verify((Object)this.mockProcessingResultBuilder)).appendRecord(ArgumentMatchers.anyLong(), (RecordValue)ArgumentMatchers.any(), (RecordMetadata)ArgumentMatchers.any());
    }

    @Test
    public void shouldSendDirectCorrelateProcessMessageSubscription() {
        this.subscriptionCommandSender.sendDirectCorrelateProcessMessageSubscription(DIFFERENT_RECEIVER_PARTITION_KEY, 111L, DEFAULT_PROCESS_ID, DEFAULT_MESSAGE_NAME, 123L, (DirectBuffer)DEFAULT_VARIABLES, DEFAULT_CORRELATION_KEY, DEFAULT_TENANT);
        ((InterPartitionCommandSender)Mockito.verify((Object)this.mockInterPartitionCommandSender)).sendCommand(ArgumentMatchers.eq((int)2), (ValueType)ArgumentMatchers.eq((Object)ValueType.PROCESS_MESSAGE_SUBSCRIPTION), (Intent)ArgumentMatchers.eq((Object)ProcessMessageSubscriptionIntent.CORRELATE), (UnifiedRecordValue)ArgumentMatchers.any());
        ((ProcessingResultBuilder)Mockito.verify((Object)this.mockProcessingResultBuilder, (VerificationMode)Mockito.never())).appendPostCommitTask((PostCommitTask)ArgumentMatchers.any());
        ((ProcessingResultBuilder)Mockito.verify((Object)this.mockProcessingResultBuilder, (VerificationMode)Mockito.never())).appendRecord(ArgumentMatchers.anyLong(), (RecordValue)ArgumentMatchers.any(), (RecordMetadata)ArgumentMatchers.any());
    }

    @Test
    public void shouldSentFollowUpCommandForCloseMessageSubscription() {
        this.subscriptionCommandSender.closeMessageSubscription(2, DIFFERENT_RECEIVER_PARTITION_KEY, 111L, DEFAULT_MESSAGE_NAME, DEFAULT_TENANT);
        ((ProcessingResultBuilder)Mockito.verify((Object)this.mockProcessingResultBuilder)).appendPostCommitTask((PostCommitTask)ArgumentMatchers.any());
        ((ProcessingResultBuilder)Mockito.verify((Object)this.mockProcessingResultBuilder, (VerificationMode)Mockito.never())).appendRecord(ArgumentMatchers.anyLong(), (RecordValue)ArgumentMatchers.any(), (RecordMetadata)ArgumentMatchers.any());
    }

    @Test
    public void shouldWriteFollowUpCommandForCloseMessageSubscription() {
        this.subscriptionCommandSender.closeMessageSubscription(1, DIFFERENT_RECEIVER_PARTITION_KEY, 111L, DEFAULT_MESSAGE_NAME, DEFAULT_TENANT);
        ((ProcessingResultBuilder)Mockito.verify((Object)this.mockProcessingResultBuilder, (VerificationMode)Mockito.never())).appendPostCommitTask((PostCommitTask)ArgumentMatchers.any());
        ((ProcessingResultBuilder)Mockito.verify((Object)this.mockProcessingResultBuilder)).appendRecord(ArgumentMatchers.anyLong(), (RecordValue)ArgumentMatchers.any(), (RecordMetadata)ArgumentMatchers.any());
    }

    @Test
    public void shouldSendDirectCloseMessageSubscription() {
        this.subscriptionCommandSender.sendDirectCloseMessageSubscription(2, DIFFERENT_RECEIVER_PARTITION_KEY, 111L, DEFAULT_MESSAGE_NAME, DEFAULT_TENANT);
        ((InterPartitionCommandSender)Mockito.verify((Object)this.mockInterPartitionCommandSender)).sendCommand(ArgumentMatchers.eq((int)2), (ValueType)ArgumentMatchers.eq((Object)ValueType.MESSAGE_SUBSCRIPTION), (Intent)ArgumentMatchers.eq((Object)MessageSubscriptionIntent.DELETE), (UnifiedRecordValue)ArgumentMatchers.any());
        ((ProcessingResultBuilder)Mockito.verify((Object)this.mockProcessingResultBuilder, (VerificationMode)Mockito.never())).appendPostCommitTask((PostCommitTask)ArgumentMatchers.any());
        ((ProcessingResultBuilder)Mockito.verify((Object)this.mockProcessingResultBuilder, (VerificationMode)Mockito.never())).appendRecord(ArgumentMatchers.anyLong(), (RecordValue)ArgumentMatchers.any(), (RecordMetadata)ArgumentMatchers.any());
    }

    @Test
    public void shouldSentFollowUpCommandForOpenMessageSubscription() {
        this.subscriptionCommandSender.openMessageSubscription(2, DIFFERENT_RECEIVER_PARTITION_KEY, 111L, DEFAULT_PROCESS_ID, DEFAULT_MESSAGE_NAME, DEFAULT_CORRELATION_KEY, true, DEFAULT_TENANT);
        ((ProcessingResultBuilder)Mockito.verify((Object)this.mockProcessingResultBuilder)).appendPostCommitTask((PostCommitTask)ArgumentMatchers.any());
        ((ProcessingResultBuilder)Mockito.verify((Object)this.mockProcessingResultBuilder, (VerificationMode)Mockito.never())).appendRecord(ArgumentMatchers.anyLong(), (RecordValue)ArgumentMatchers.any(), (RecordMetadata)ArgumentMatchers.any());
    }

    @Test
    public void shouldWriteFollowUpCommandForOpenMessageSubscription() {
        this.subscriptionCommandSender.openMessageSubscription(1, DIFFERENT_RECEIVER_PARTITION_KEY, 111L, DEFAULT_PROCESS_ID, DEFAULT_MESSAGE_NAME, DEFAULT_CORRELATION_KEY, true, DEFAULT_TENANT);
        ((ProcessingResultBuilder)Mockito.verify((Object)this.mockProcessingResultBuilder, (VerificationMode)Mockito.never())).appendPostCommitTask((PostCommitTask)ArgumentMatchers.any());
        ((ProcessingResultBuilder)Mockito.verify((Object)this.mockProcessingResultBuilder)).appendRecord(ArgumentMatchers.anyLong(), (RecordValue)ArgumentMatchers.any(), (RecordMetadata)ArgumentMatchers.any());
    }

    @Test
    public void shouldSendDirectOpenMessageSubscription() {
        this.subscriptionCommandSender.sendDirectOpenMessageSubscription(2, DIFFERENT_RECEIVER_PARTITION_KEY, 111L, DEFAULT_PROCESS_ID, DEFAULT_MESSAGE_NAME, DEFAULT_CORRELATION_KEY, true, DEFAULT_TENANT);
        ((InterPartitionCommandSender)Mockito.verify((Object)this.mockInterPartitionCommandSender)).sendCommand(ArgumentMatchers.eq((int)2), (ValueType)ArgumentMatchers.eq((Object)ValueType.MESSAGE_SUBSCRIPTION), (Intent)ArgumentMatchers.eq((Object)MessageSubscriptionIntent.CREATE), (UnifiedRecordValue)ArgumentMatchers.any());
        ((ProcessingResultBuilder)Mockito.verify((Object)this.mockProcessingResultBuilder, (VerificationMode)Mockito.never())).appendPostCommitTask((PostCommitTask)ArgumentMatchers.any());
        ((ProcessingResultBuilder)Mockito.verify((Object)this.mockProcessingResultBuilder, (VerificationMode)Mockito.never())).appendRecord(ArgumentMatchers.anyLong(), (RecordValue)ArgumentMatchers.any(), (RecordMetadata)ArgumentMatchers.any());
    }

    @Test
    public void shouldSentFollowUpCommandForOpenProcessMessageSubscription() {
        this.subscriptionCommandSender.openProcessMessageSubscription(2L, DIFFERENT_RECEIVER_PARTITION_KEY, DEFAULT_MESSAGE_NAME, true, DEFAULT_TENANT);
        ((ProcessingResultBuilder)Mockito.verify((Object)this.mockProcessingResultBuilder)).appendPostCommitTask((PostCommitTask)ArgumentMatchers.any());
        ((ProcessingResultBuilder)Mockito.verify((Object)this.mockProcessingResultBuilder, (VerificationMode)Mockito.never())).appendRecord(ArgumentMatchers.anyLong(), (RecordValue)ArgumentMatchers.any(), (RecordMetadata)ArgumentMatchers.any());
    }

    @Test
    public void shouldWriteFollowUpCommandForOpenProcessMessageSubscription() {
        this.subscriptionCommandSender.openProcessMessageSubscription(SAME_RECEIVER_PARTITION_KEY, DIFFERENT_RECEIVER_PARTITION_KEY, DEFAULT_MESSAGE_NAME, true, DEFAULT_TENANT);
        ((ProcessingResultBuilder)Mockito.verify((Object)this.mockProcessingResultBuilder, (VerificationMode)Mockito.never())).appendPostCommitTask((PostCommitTask)ArgumentMatchers.any());
        ((ProcessingResultBuilder)Mockito.verify((Object)this.mockProcessingResultBuilder)).appendRecord(ArgumentMatchers.anyLong(), (RecordValue)ArgumentMatchers.any(), (RecordMetadata)ArgumentMatchers.any());
    }

    @Test
    public void shouldSentFollowUpCommandForRejectCorrelateMessageSubscription() {
        this.subscriptionCommandSender.rejectCorrelateMessageSubscription(2, DIFFERENT_RECEIVER_PARTITION_KEY, 111L, DEFAULT_PROCESS_ID, 123L, DEFAULT_MESSAGE_NAME, DEFAULT_CORRELATION_KEY, DEFAULT_TENANT);
        ((ProcessingResultBuilder)Mockito.verify((Object)this.mockProcessingResultBuilder)).appendPostCommitTask((PostCommitTask)ArgumentMatchers.any());
        ((ProcessingResultBuilder)Mockito.verify((Object)this.mockProcessingResultBuilder, (VerificationMode)Mockito.never())).appendRecord(ArgumentMatchers.anyLong(), (RecordValue)ArgumentMatchers.any(), (RecordMetadata)ArgumentMatchers.any());
    }

    @Test
    public void shouldWriteFollowUpCommandForRejectCorrelateMessageSubscription() {
        this.subscriptionCommandSender.rejectCorrelateMessageSubscription((int)SAME_RECEIVER_PARTITION_KEY, SAME_RECEIVER_PARTITION_KEY, 111L, DEFAULT_PROCESS_ID, 123L, DEFAULT_MESSAGE_NAME, DEFAULT_CORRELATION_KEY, DEFAULT_TENANT);
        ((ProcessingResultBuilder)Mockito.verify((Object)this.mockProcessingResultBuilder, (VerificationMode)Mockito.never())).appendPostCommitTask((PostCommitTask)ArgumentMatchers.any());
        ((ProcessingResultBuilder)Mockito.verify((Object)this.mockProcessingResultBuilder)).appendRecord(ArgumentMatchers.anyLong(), (RecordValue)ArgumentMatchers.any(), (RecordMetadata)ArgumentMatchers.any());
    }

    @Test
    public void shouldSentFollowUpCommandForCorrelateMessageSubscription() {
        this.subscriptionCommandSender.correlateMessageSubscription(2, DIFFERENT_RECEIVER_PARTITION_KEY, 111L, DEFAULT_PROCESS_ID, DEFAULT_MESSAGE_NAME, DEFAULT_TENANT);
        ((ProcessingResultBuilder)Mockito.verify((Object)this.mockProcessingResultBuilder)).appendPostCommitTask((PostCommitTask)ArgumentMatchers.any());
        ((ProcessingResultBuilder)Mockito.verify((Object)this.mockProcessingResultBuilder, (VerificationMode)Mockito.never())).appendRecord(ArgumentMatchers.anyLong(), (RecordValue)ArgumentMatchers.any(), (RecordMetadata)ArgumentMatchers.any());
    }

    @Test
    public void shouldWriteFollowUpCommandForCorrelateMessageSubscription() {
        this.subscriptionCommandSender.correlateMessageSubscription(1, DIFFERENT_RECEIVER_PARTITION_KEY, 111L, DEFAULT_PROCESS_ID, DEFAULT_MESSAGE_NAME, DEFAULT_TENANT);
        ((ProcessingResultBuilder)Mockito.verify((Object)this.mockProcessingResultBuilder, (VerificationMode)Mockito.never())).appendPostCommitTask((PostCommitTask)ArgumentMatchers.any());
        ((ProcessingResultBuilder)Mockito.verify((Object)this.mockProcessingResultBuilder)).appendRecord(ArgumentMatchers.anyLong(), (RecordValue)ArgumentMatchers.any(), (RecordMetadata)ArgumentMatchers.any());
    }
}

