/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.multitenancy;

import io.camunda.zeebe.engine.util.EngineRule;
import io.camunda.zeebe.model.bpmn.Bpmn;
import io.camunda.zeebe.protocol.record.Assertions;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.RecordAssert;
import io.camunda.zeebe.protocol.record.RejectionType;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceIntent;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceModificationIntent;
import io.camunda.zeebe.protocol.record.value.ProcessInstanceModificationRecordValue;
import io.camunda.zeebe.test.util.record.RecordingExporter;
import io.camunda.zeebe.test.util.record.RecordingExporterTestWatcher;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestWatcher;

public class TenantAwareModifyProcessInstanceTest {
    @ClassRule
    public static final EngineRule ENGINE = EngineRule.singlePartition();
    @Rule
    public final TestWatcher watcher = new RecordingExporterTestWatcher();

    @Test
    public void shouldModifyInstanceForDefaultTenant() {
        ENGINE.deployment().withXmlResource(Bpmn.createExecutableProcess((String)"process").startEvent().serviceTask("task", t -> t.zeebeJobType("test")).endEvent().done()).withTenantId("<default>").deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId("process").withTenantId("<default>").create();
        Record task = (Record)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATED).withProcessInstanceKey(processInstanceKey).withElementId("task").getFirst();
        Record<ProcessInstanceModificationRecordValue> modified = ENGINE.processInstance().withInstanceKey(processInstanceKey).forAuthorizedTenants("<default>").modification().activateElement("task").terminateElement(task.getKey()).modify();
        ((RecordAssert)Assertions.assertThat(modified).describedAs("Expect that modification was successful", new Object[0])).hasIntent((Intent)ProcessInstanceModificationIntent.MODIFIED);
    }

    @Test
    public void shouldRejectModifyInstanceForUnauthorizedTenant() {
        ENGINE.deployment().withXmlResource(Bpmn.createExecutableProcess((String)"process").startEvent().serviceTask("task", t -> t.zeebeJobType("test")).endEvent().done()).withTenantId("custom-tenant").deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId("process").withTenantId("custom-tenant").create();
        Record task = (Record)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATED).withProcessInstanceKey(processInstanceKey).withElementId("task").getFirst();
        Record<ProcessInstanceModificationRecordValue> rejection = ENGINE.processInstance().withInstanceKey(processInstanceKey).forAuthorizedTenants("another-tenant").modification().activateElement("task").terminateElement(task.getKey()).expectRejection().modify();
        Assertions.assertThat(rejection).hasRejectionType(RejectionType.NOT_FOUND).hasRejectionReason("Expected to modify process instance but no process instance found with key '%s'".formatted(processInstanceKey));
    }

    @Test
    public void shouldModifyInstanceForSpecificTenant() {
        ENGINE.deployment().withXmlResource(Bpmn.createExecutableProcess((String)"process").startEvent().serviceTask("task", t -> t.zeebeJobType("test")).endEvent().done()).withTenantId("custom-tenant").deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId("process").withTenantId("custom-tenant").create();
        Record task = (Record)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATED).withProcessInstanceKey(processInstanceKey).withElementId("task").getFirst();
        Record<ProcessInstanceModificationRecordValue> modified = ENGINE.processInstance().withInstanceKey(processInstanceKey).forAuthorizedTenants("custom-tenant").modification().activateElement("task").terminateElement(task.getKey()).modify();
        ((RecordAssert)Assertions.assertThat(modified).describedAs("Expect that modification was successful", new Object[0])).hasIntent((Intent)ProcessInstanceModificationIntent.MODIFIED);
    }
}

