/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.processinstance;

import io.camunda.zeebe.engine.util.EngineRule;
import io.camunda.zeebe.model.bpmn.Bpmn;
import io.camunda.zeebe.model.bpmn.builder.BoundaryEventBuilder;
import io.camunda.zeebe.model.bpmn.builder.SubProcessBuilder;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.RecordType;
import io.camunda.zeebe.protocol.record.RejectionType;
import io.camunda.zeebe.protocol.record.ValueType;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceCreationIntent;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceIntent;
import io.camunda.zeebe.test.util.record.ProcessInstanceCreationRecordStream;
import io.camunda.zeebe.test.util.record.RecordingExporter;
import io.camunda.zeebe.test.util.record.RecordingExporterTestWatcher;
import io.camunda.zeebe.util.ByteValue;
import java.util.function.Function;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.assertj.core.groups.Tuple;
import org.junit.Rule;
import org.junit.Test;

public class CreateProcessInstanceRejectionTest {
    private static final long MAX_MESSAGE_SIZE = ByteValue.ofMegabytes((long)4L);
    private static final String PROCESS_ID = "process-id";
    @Rule
    public final EngineRule engine = EngineRule.singlePartition();
    @Rule
    public final RecordingExporterTestWatcher recordingExporterTestWatcher = new RecordingExporterTestWatcher();

    @Test
    public void shouldRejectCommandIfElementIdIsUnknown() {
        this.engine.deployment().withXmlResource(Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().manualTask("task").endEvent().done()).deploy();
        this.engine.processInstance().ofBpmnProcessId(PROCESS_ID).withStartInstruction("task").withStartInstruction("unknown-element").withVariable("x", 1).expectRejection().create();
        Record rejectionRecord = (Record)((ProcessInstanceCreationRecordStream)RecordingExporter.processInstanceCreationRecords().onlyCommandRejections()).getFirst();
        io.camunda.zeebe.protocol.record.Assertions.assertThat((Record)rejectionRecord).hasIntent((Intent)ProcessInstanceCreationIntent.CREATE).hasRejectionType(RejectionType.INVALID_ARGUMENT).hasRejectionReason("Expected to create instance of process with start instructions but no element found with id 'unknown-element'.");
    }

    @Test
    public void shouldRejectCommandIfElementIsInsideMultiInstance() {
        this.engine.deployment().withXmlResource(((SubProcessBuilder)Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().subProcess("subprocess", s -> s.embeddedSubProcess().startEvent().manualTask("task-in-multi-instance").done()).multiInstance(m -> m.zeebeInputCollectionExpression("[1,2,3]"))).manualTask("task").endEvent().done()).deploy();
        this.engine.processInstance().ofBpmnProcessId(PROCESS_ID).withStartInstruction("task").withStartInstruction("task-in-multi-instance").withVariable("x", 1).expectRejection().create();
        Record rejectionRecord = (Record)((ProcessInstanceCreationRecordStream)RecordingExporter.processInstanceCreationRecords().onlyCommandRejections()).getFirst();
        io.camunda.zeebe.protocol.record.Assertions.assertThat((Record)rejectionRecord).hasIntent((Intent)ProcessInstanceCreationIntent.CREATE).hasRejectionType(RejectionType.INVALID_ARGUMENT).hasRejectionReason("Expected to create instance of process with start instructions but the element with id 'task-in-multi-instance' is inside a multi-instance subprocess. The creation of elements inside a multi-instance subprocess is not supported.");
    }

    @Test
    public void shouldRejectCommandIfEventBelongsToEventBasedGateway() {
        this.engine.deployment().withXmlResource(Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent("start").eventBasedGateway().intermediateCatchEvent("timer1", c -> c.timerWithDuration("PT0.1S")).endEvent().moveToLastGateway().intermediateCatchEvent("timer2", c -> c.timerWithDuration("PT0.1S")).endEvent().done()).deploy();
        this.engine.processInstance().ofBpmnProcessId(PROCESS_ID).withStartInstruction("timer1").expectRejection().create();
        Record rejectionRecord = (Record)((ProcessInstanceCreationRecordStream)RecordingExporter.processInstanceCreationRecords().onlyCommandRejections()).getFirst();
        io.camunda.zeebe.protocol.record.Assertions.assertThat((Record)rejectionRecord).hasIntent((Intent)ProcessInstanceCreationIntent.CREATE).hasRejectionType(RejectionType.INVALID_ARGUMENT).hasRejectionReason("Expected to create instance of process with start instructions but the element with id 'timer1' belongs to an event-based gateway. The creation of elements belonging to an event-based gateway is not supported.");
    }

    @Test
    public void shouldRejectCommandIfUnableToSubscribeToEvents() {
        this.engine.deployment().withXmlResource(Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().subProcess("subprocess", subprocess -> {
            subprocess.embeddedSubProcess().startEvent().serviceTask("task", t -> t.zeebeJobType("task")).endEvent();
            ((BoundaryEventBuilder)((BoundaryEventBuilder)subprocess.boundaryEvent("message-boundary-event").cancelActivity(Boolean.valueOf(false))).message(m -> m.name("msg").zeebeCorrelationKeyExpression("unknown_var"))).endEvent();
        }).endEvent().done()).deploy();
        this.engine.processInstance().ofBpmnProcessId(PROCESS_ID).withStartInstruction("task").expectRejection().create();
        io.camunda.zeebe.protocol.record.Assertions.assertThat((Record)((Record)((ProcessInstanceCreationRecordStream)RecordingExporter.processInstanceCreationRecords().withBpmnProcessId(PROCESS_ID).withStartInstruction("task").onlyCommandRejections()).getFirst())).hasIntent((Intent)ProcessInstanceCreationIntent.CREATE).hasRejectionType(RejectionType.INVALID_ARGUMENT).hasRejectionReason("Expected to subscribe to catch event(s) of 'subprocess' but Failed to extract the correlation key for 'unknown_var': The value must be either a string or a number, but was 'NULL'. The evaluation reported the following warnings:\n[NO_VARIABLE_FOUND] No variable found with name 'unknown_var'");
        Assertions.assertThat((Stream)RecordingExporter.records().limit(r -> r.getRecordType() == RecordType.COMMAND_REJECTION && r.getIntent() == ProcessInstanceCreationIntent.CREATE)).extracting(new Function[]{Record::getValueType, Record::getIntent}).describedAs("Expect that no process instance is activated", new Object[0]).doesNotContain((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{ValueType.PROCESS_INSTANCE, ProcessInstanceIntent.ELEMENT_ACTIVATING}), Assertions.tuple((Object[])new Object[]{ValueType.PROCESS_INSTANCE, ProcessInstanceIntent.ELEMENT_ACTIVATED})});
    }

    @Test
    public void shouldRejectCommandIfTooLarge() {
        this.engine.deployment().withXmlResource(Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().endEvent().done()).deploy();
        this.engine.processInstance().ofBpmnProcessId(PROCESS_ID).withVariable("variable", "x".repeat((int)(MAX_MESSAGE_SIZE - ByteValue.ofKilobytes((long)1L)))).expectRejection().create();
        io.camunda.zeebe.protocol.record.Assertions.assertThat((Record)((Record)((ProcessInstanceCreationRecordStream)RecordingExporter.processInstanceCreationRecords().withBpmnProcessId(PROCESS_ID).onlyCommandRejections()).getFirst())).hasIntent((Intent)ProcessInstanceCreationIntent.CREATE).hasRejectionType(RejectionType.EXCEEDED_BATCH_RECORD_SIZE);
    }

    @Test
    public void shouldRejectCommandIfNoProcessDefinitionForTenant() {
        String processId = "process";
        String tenantId = "foo";
        String fakeTenantId = "bar";
        this.engine.deployment().withXmlResource(Bpmn.createExecutableProcess((String)"process").startEvent().endEvent().done()).withTenantId("foo").deploy();
        this.engine.processInstance().ofBpmnProcessId("process").withTenantId("bar").expectRejection().create();
        Record rejectionRecord = (Record)((ProcessInstanceCreationRecordStream)RecordingExporter.processInstanceCreationRecords().onlyCommandRejections()).getFirst();
        io.camunda.zeebe.protocol.record.Assertions.assertThat((Record)rejectionRecord).hasIntent((Intent)ProcessInstanceCreationIntent.CREATE).hasRejectionType(RejectionType.NOT_FOUND).hasRejectionReason(String.format("Expected to find process definition with process ID '%s', but none found", "process", "bar"));
    }
}

