/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.timer;

import io.camunda.zeebe.engine.processing.scheduled.DueDateChecker;
import io.camunda.zeebe.stream.api.ReadonlyStreamProcessorContext;
import io.camunda.zeebe.stream.api.scheduling.ProcessingScheduleService;
import io.camunda.zeebe.stream.api.scheduling.Task;
import java.time.Duration;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class DueDateCheckerTest {
    @Test
    public void shouldNotScheduleTwoTasks() {
        DueDateChecker dueDateChecker = new DueDateChecker(100L, false, builder -> 0L);
        ReadonlyStreamProcessorContext mockContext = (ReadonlyStreamProcessorContext)Mockito.mock(ReadonlyStreamProcessorContext.class);
        ProcessingScheduleService mockScheduleService = (ProcessingScheduleService)Mockito.mock(ProcessingScheduleService.class);
        Mockito.when((Object)mockContext.getScheduleService()).thenReturn((Object)mockScheduleService);
        dueDateChecker.onRecovered(mockContext);
        ((ProcessingScheduleService)Mockito.verify((Object)mockScheduleService, (VerificationMode)Mockito.timeout((long)1000L))).runDelayed((Duration)ArgumentMatchers.eq((Object)Duration.ZERO), (Task)ArgumentMatchers.any(Task.class));
        Mockito.clearInvocations((Object[])new ProcessingScheduleService[]{mockScheduleService});
        long currentTimeMillis = System.currentTimeMillis();
        dueDateChecker.schedule(currentTimeMillis + 1000L);
        dueDateChecker.schedule(currentTimeMillis + 1000L);
        ((ProcessingScheduleService)Mockito.verify((Object)mockScheduleService, (VerificationMode)Mockito.timeout((long)1000L))).runDelayed((Duration)ArgumentMatchers.any(), (Task)ArgumentMatchers.any(Task.class));
    }

    @Test
    public void shouldScheduleForAnEarlierTasks() {
        DueDateChecker dueDateChecker = new DueDateChecker(100L, false, builder -> 0L);
        ReadonlyStreamProcessorContext mockContext = (ReadonlyStreamProcessorContext)Mockito.mock(ReadonlyStreamProcessorContext.class);
        ProcessingScheduleService mockScheduleService = (ProcessingScheduleService)Mockito.mock(ProcessingScheduleService.class);
        Mockito.when((Object)mockContext.getScheduleService()).thenReturn((Object)mockScheduleService);
        dueDateChecker.onRecovered(mockContext);
        ((ProcessingScheduleService)Mockito.verify((Object)mockScheduleService, (VerificationMode)Mockito.timeout((long)1000L))).runDelayed((Duration)ArgumentMatchers.eq((Object)Duration.ZERO), (Task)ArgumentMatchers.any(Task.class));
        Mockito.clearInvocations((Object[])new ProcessingScheduleService[]{mockScheduleService});
        long currentTimeMillis = System.currentTimeMillis();
        dueDateChecker.schedule(currentTimeMillis + 1000L);
        dueDateChecker.schedule(currentTimeMillis + 100L);
        ((ProcessingScheduleService)Mockito.verify((Object)mockScheduleService, (VerificationMode)Mockito.timeout((long)1000L).times(2))).runDelayed((Duration)ArgumentMatchers.any(), (Task)ArgumentMatchers.any(Task.class));
    }
}

