/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.state.appliers;

import io.camunda.zeebe.engine.state.appliers.FormCreatedApplier;
import io.camunda.zeebe.engine.state.appliers.FormDeletedApplier;
import io.camunda.zeebe.engine.state.deployment.PersistedForm;
import io.camunda.zeebe.engine.state.mutable.MutableFormState;
import io.camunda.zeebe.engine.state.mutable.MutableProcessingState;
import io.camunda.zeebe.engine.util.ProcessingStateExtension;
import io.camunda.zeebe.protocol.impl.record.value.deployment.FormRecord;
import io.camunda.zeebe.stream.api.state.KeyGenerator;
import io.camunda.zeebe.test.util.Strings;
import io.camunda.zeebe.util.buffer.BufferUtil;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ProcessingStateExtension.class})
public class FormDeletedApplierTest {
    private static final String TENANT_1 = "tenant1";
    private static final String TENANT_2 = "tenant2";
    private final String tenantId = "<default>";
    private MutableProcessingState processingState;
    private MutableFormState formState;
    private FormCreatedApplier formCreatedApplier;
    private FormDeletedApplier formDeletedApplier;
    private KeyGenerator keyGenerator;

    @BeforeEach
    public void setup() {
        this.formState = this.processingState.getFormState();
        this.formCreatedApplier = new FormCreatedApplier(this.formState);
        this.formDeletedApplier = new FormDeletedApplier(this.formState);
        this.keyGenerator = this.processingState.getKeyGenerator();
    }

    @Test
    void shouldNotFindVersion2AsLatestFormAfterDeletion() {
        FormRecord formV1 = this.sampleFormRecord();
        FormRecord formV2 = this.sampleFormRecord(2L, "form-id", 2, TENANT_1);
        this.formCreatedApplier.applyState(formV1.getFormKey(), formV1);
        this.formCreatedApplier.applyState(formV2.getFormKey(), formV2);
        Optional latestFormOpt = this.formState.findLatestFormById(formV2.getFormIdBuffer(), formV2.getTenantId());
        Assertions.assertThat((Optional)latestFormOpt).isNotEmpty();
        Assertions.assertThat((int)((PersistedForm)latestFormOpt.get()).getVersion()).isEqualTo(2);
        this.formDeletedApplier.applyState(formV2.getFormKey(), formV2);
        Optional latestFormV1Opt = this.formState.findLatestFormById(formV2.getFormIdBuffer(), formV2.getTenantId());
        Assertions.assertThat((Optional)latestFormV1Opt).isNotEmpty();
        Assertions.assertThat((int)((PersistedForm)latestFormV1Opt.get()).getVersion()).isEqualTo(1);
    }

    @Test
    void shouldFindVersion2AsLatestFormAfterDeletion() {
        FormRecord formV1 = this.sampleFormRecord();
        FormRecord formV2 = this.sampleFormRecord(2L, "form-id", 2, TENANT_1);
        this.formCreatedApplier.applyState(formV1.getFormKey(), formV1);
        this.formCreatedApplier.applyState(formV2.getFormKey(), formV2);
        Optional latestFormOpt = this.formState.findLatestFormById(formV2.getFormIdBuffer(), formV2.getTenantId());
        Assertions.assertThat((Optional)latestFormOpt).isNotEmpty();
        Assertions.assertThat((int)((PersistedForm)latestFormOpt.get()).getVersion()).isEqualTo(2);
        this.formDeletedApplier.applyState(formV1.getFormKey(), formV1);
        Optional latestFormV2Opt = this.formState.findLatestFormById(formV2.getFormIdBuffer(), formV2.getTenantId());
        Assertions.assertThat((Optional)latestFormV2Opt).isNotEmpty();
        Assertions.assertThat((int)((PersistedForm)latestFormV2Opt.get()).getVersion()).isEqualTo(2);
    }

    @Test
    void shouldNotReuseADeletedVersionNumber() {
        FormRecord form = this.sampleFormRecord();
        this.formCreatedApplier.applyState(form.getFormKey(), form);
        FormRecord formV2 = this.sampleFormRecord(2L, "form-id", 2, TENANT_1);
        this.formCreatedApplier.applyState(formV2.getFormKey(), formV2);
        this.formDeletedApplier.applyState(form.getFormKey(), form);
        this.formDeletedApplier.applyState(formV2.getFormKey(), formV2);
        int nextAvailableVersion = this.formState.getNextFormVersion(form.getFormId(), form.getTenantId());
        Assertions.assertThat((int)nextAvailableVersion).isEqualTo(3);
    }

    @Test
    public void shouldDeleteFormForSpecificTenant() {
        long formKey = this.keyGenerator.nextKey();
        String formId = Strings.newRandomValidBpmnId();
        boolean version = true;
        FormRecord tenant1Form = this.sampleFormRecord(formKey, formId, 1, TENANT_1);
        FormRecord tenant2Form = this.sampleFormRecord(formKey, formId, 1, TENANT_2);
        this.formCreatedApplier.applyState(tenant1Form.getFormKey(), tenant1Form);
        this.formCreatedApplier.applyState(tenant2Form.getFormKey(), tenant2Form);
        this.formDeletedApplier.applyState(tenant1Form.getFormKey(), tenant1Form);
        Assertions.assertThat((Optional)this.formState.findLatestFormById(tenant1Form.getFormIdBuffer(), TENANT_1)).isEmpty();
        Assertions.assertThat((Optional)this.formState.findLatestFormById(tenant2Form.getFormIdBuffer(), TENANT_2)).isNotEmpty();
    }

    private FormRecord sampleFormRecord() {
        return this.sampleFormRecord(1L, "form-id", 1, TENANT_1);
    }

    private FormRecord sampleFormRecord(long key, String id, int version, String tenant) {
        return new FormRecord().setFormKey(key).setFormId(id).setVersion(version).setResourceName("resourceName").setResource(BufferUtil.wrapString((String)"resource")).setChecksum(BufferUtil.wrapString((String)"checksum")).setTenantId(tenant);
    }
}

