/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.state.appliers;

import io.camunda.zeebe.engine.state.appliers.ProcessInstanceElementMigratedApplier;
import io.camunda.zeebe.engine.state.instance.ElementInstance;
import io.camunda.zeebe.engine.state.mutable.MutableElementInstanceState;
import io.camunda.zeebe.engine.state.mutable.MutableProcessingState;
import io.camunda.zeebe.engine.util.ProcessingStateExtension;
import io.camunda.zeebe.protocol.impl.record.value.processinstance.ProcessInstanceRecord;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceIntent;
import io.camunda.zeebe.protocol.record.value.BpmnElementType;
import io.camunda.zeebe.protocol.record.value.ProcessInstanceRecordValue;
import io.camunda.zeebe.protocol.record.value.ProcessInstanceRecordValueAssert;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ProcessingStateExtension.class})
public class ProcessInstanceElementMigratedApplierTest {
    private MutableProcessingState processingState;
    private MutableElementInstanceState elementInstanceState;
    private ProcessInstanceElementMigratedApplier processInstanceElementMigratedApplier;

    @BeforeEach
    public void setup() {
        this.elementInstanceState = this.processingState.getElementInstanceState();
        this.processInstanceElementMigratedApplier = new ProcessInstanceElementMigratedApplier(this.elementInstanceState);
    }

    @Test
    void shouldUpdateProcessDefinitionData() {
        ProcessInstanceRecord processInstance = new ProcessInstanceRecord().setProcessDefinitionKey(1L).setBpmnProcessId("process").setVersion(1).setElementId("process").setBpmnElementType(BpmnElementType.PROCESS).setProcessInstanceKey(2L);
        this.elementInstanceState.createInstance(new ElementInstance(processInstance.getProcessInstanceKey(), ProcessInstanceIntent.ELEMENT_ACTIVATED, processInstance));
        ProcessInstanceRecord migratedProcessInstance = new ProcessInstanceRecord();
        migratedProcessInstance.wrap(processInstance);
        migratedProcessInstance.setProcessDefinitionKey(3L).setVersion(2).setBpmnProcessId("another_process").setElementId("another_process");
        this.processInstanceElementMigratedApplier.applyState(processInstance.getProcessInstanceKey(), migratedProcessInstance);
        ((ProcessInstanceRecordValueAssert)((ProcessInstanceRecordValueAssert)io.camunda.zeebe.protocol.record.Assertions.assertThat((ProcessInstanceRecordValue)this.elementInstanceState.getInstance(processInstance.getProcessInstanceKey()).getValue()).describedAs("Expect that the process definition data is updated", new Object[0])).hasProcessDefinitionKey(migratedProcessInstance.getProcessDefinitionKey()).hasBpmnProcessId(migratedProcessInstance.getBpmnProcessId()).hasVersion(migratedProcessInstance.getVersion()).hasElementId(migratedProcessInstance.getElementId()).describedAs("Expect that the other data is left unchanged", new Object[0])).hasProcessInstanceKey(processInstance.getProcessInstanceKey()).hasParentElementInstanceKey(processInstance.getParentElementInstanceKey()).hasParentProcessInstanceKey(processInstance.getParentProcessInstanceKey()).hasTenantId(processInstance.getTenantId()).hasBpmnElementType(processInstance.getBpmnElementType()).hasBpmnEventType(processInstance.getBpmnEventType()).hasFlowScopeKey(processInstance.getFlowScopeKey());
        ((ListAssert)Assertions.assertThat((List)this.elementInstanceState.getProcessInstanceKeysByDefinitionKey(migratedProcessInstance.getProcessDefinitionKey())).describedAs("Expect that the instance is migrated to the target process definition", new Object[0])).containsExactly((Object[])new Long[]{migratedProcessInstance.getProcessInstanceKey()});
        ((ListAssert)Assertions.assertThat((List)this.elementInstanceState.getProcessInstanceKeysByDefinitionKey(processInstance.getProcessDefinitionKey())).describedAs("Expect that there are no instances of the old process definition", new Object[0])).isEmpty();
    }

    @Test
    void shouldUpdateFlowScopeKeyIfSetToDifferentValue() {
        long serviceTaskKey = 3L;
        ProcessInstanceRecord serviceTask = new ProcessInstanceRecord().setProcessDefinitionKey(1L).setBpmnProcessId("process").setVersion(1).setElementId("task").setBpmnElementType(BpmnElementType.SERVICE_TASK).setProcessInstanceKey(2L);
        this.elementInstanceState.createInstance(new ElementInstance(3L, ProcessInstanceIntent.ELEMENT_ACTIVATED, serviceTask));
        ProcessInstanceRecord migratedServiceTask = new ProcessInstanceRecord();
        migratedServiceTask.wrap(serviceTask);
        migratedServiceTask.setProcessDefinitionKey(4L).setVersion(2).setBpmnProcessId("another_process").setElementId("another_process").setFlowScopeKey(5L);
        this.processInstanceElementMigratedApplier.applyState(3L, migratedServiceTask);
        ((ProcessInstanceRecordValueAssert)io.camunda.zeebe.protocol.record.Assertions.assertThat((ProcessInstanceRecordValue)this.elementInstanceState.getInstance(3L).getValue()).describedAs("Expect that the flow scope key is updated", new Object[0])).hasFlowScopeKey(migratedServiceTask.getFlowScopeKey());
    }
}

