/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.state.instance;

import io.camunda.zeebe.engine.state.instance.ElementInstance;
import io.camunda.zeebe.engine.state.instance.TimerInstance;
import io.camunda.zeebe.engine.state.mutable.MutableProcessingState;
import io.camunda.zeebe.engine.state.mutable.MutableTimerInstanceState;
import io.camunda.zeebe.engine.util.ProcessingStateRule;
import io.camunda.zeebe.protocol.impl.record.value.processinstance.ProcessInstanceRecord;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceIntent;
import java.util.ArrayList;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public final class TimerInstanceStateTest {
    @Rule
    public final ProcessingStateRule stateRule = new ProcessingStateRule();
    private MutableTimerInstanceState state;

    @Before
    public void setUp() {
        MutableProcessingState processingState = this.stateRule.getProcessingState();
        this.state = processingState.getTimerState();
    }

    @Test
    public void shouldInsertTimer() {
        this.createTimerInstance(1L, 2L, 1000L);
        ArrayList timers = new ArrayList();
        this.state.processTimersWithDueDateBefore(1000L, timers::add);
        Assertions.assertThat(timers).hasSize(1);
        TimerInstance readTimer = (TimerInstance)timers.get(0);
        Assertions.assertThat((long)readTimer.getElementInstanceKey()).isEqualTo(1L);
        Assertions.assertThat((long)readTimer.getKey()).isEqualTo(2L);
        Assertions.assertThat((long)readTimer.getDueDate()).isEqualTo(1000L);
    }

    @Test
    public void shouldRemoveTimer() {
        this.createTimerInstance(1L, 0L, 1000L);
        this.createTimerInstance(2L, 0L, 2000L);
        TimerInstance timer = new TimerInstance();
        timer.setElementInstanceKey(1L);
        timer.setDueDate(1000L);
        this.state.remove(timer);
        ArrayList timers = new ArrayList();
        this.state.processTimersWithDueDateBefore(2000L, timers::add);
        Assertions.assertThat(timers).hasSize(1);
        Assertions.assertThat((long)((TimerInstance)timers.get(0)).getElementInstanceKey()).isEqualTo(2L);
    }

    @Test
    public void shouldGetTimerByElementInstanceKey() {
        this.createElementInstance(1L);
        TimerInstance timer = new TimerInstance();
        timer.setElementInstanceKey(1L);
        timer.setProcessInstanceKey(1L);
        timer.setKey(2L);
        timer.setDueDate(1000L);
        this.state.store(timer);
        TimerInstance readTimer = this.state.get(1L, 2L);
        Assertions.assertThat((Object)readTimer).isNotNull();
        Assertions.assertThat((long)readTimer.getElementInstanceKey()).isEqualTo(1L);
        Assertions.assertThat((long)readTimer.getKey()).isEqualTo(2L);
        Assertions.assertThat((long)readTimer.getProcessInstanceKey()).isEqualTo(1L);
        Assertions.assertThat((long)readTimer.getDueDate()).isEqualTo(1000L);
        Assertions.assertThat((Object)this.state.get(2L, 1L)).isNull();
    }

    @Test
    public void shouldFindTimersWithDueDate() {
        this.createTimerInstance(1L, 1L, 1000L);
        this.createTimerInstance(2L, 2L, 2000L);
        this.createTimerInstance(3L, 3L, 3000L);
        ArrayList keys = new ArrayList();
        this.state.processTimersWithDueDateBefore(2000L, t -> keys.add(t.getElementInstanceKey()));
        ((ListAssert)Assertions.assertThat(keys).hasSize(2)).containsExactly((Object[])new Long[]{1L, 2L});
    }

    @Test
    public void shouldReturnNextDueDate() {
        this.createTimerInstance(1L, 1L, 1000L);
        this.createTimerInstance(2L, 2L, 2000L);
        this.createTimerInstance(3L, 3L, 3000L);
        long nextDueDate = this.state.processTimersWithDueDateBefore(2000L, t -> true);
        Assertions.assertThat((long)nextDueDate).isEqualTo(3000L);
    }

    @Test
    public void shouldReturnNegativeDueDateIfEmpty() {
        long nextDueDate = this.state.processTimersWithDueDateBefore(2000L, t -> true);
        Assertions.assertThat((long)nextDueDate).isEqualTo(-1L);
    }

    @Test
    public void shouldReturnNegativeDueDateIfNoMoreTimers() {
        this.createTimerInstance(1L, 1L, 1000L);
        this.createTimerInstance(2L, 2L, 2000L);
        this.createTimerInstance(3L, 3L, 3000L);
        long nextDueDate = this.state.processTimersWithDueDateBefore(3000L, t -> true);
        Assertions.assertThat((long)nextDueDate).isEqualTo(-1L);
    }

    @Test
    public void shouldFindTimersWithDueDateUntilNotConsumed() {
        TimerInstance timer1 = this.createTimerInstance(1L, 1L, 1000L);
        this.createTimerInstance(2L, 2L, 2000L);
        ArrayList keys = new ArrayList();
        long nextDueDate = this.state.processTimersWithDueDateBefore(2000L, t -> {
            keys.add(t.getElementInstanceKey());
            return false;
        });
        Assertions.assertThat(keys).containsExactly((Object[])new Long[]{1L});
        Assertions.assertThat((long)nextDueDate).isEqualTo(timer1.getDueDate());
    }

    @Test
    public void shouldListAllTimersByElementInstanceKey() {
        this.createElementInstance(1L);
        this.createElementInstance(2L);
        TimerInstance timer1 = new TimerInstance();
        timer1.setElementInstanceKey(1L);
        timer1.setKey(1L);
        timer1.setDueDate(1000L);
        this.state.store(timer1);
        TimerInstance timer2 = new TimerInstance();
        timer2.setElementInstanceKey(1L);
        timer2.setKey(2L);
        timer2.setDueDate(2000L);
        this.state.store(timer2);
        TimerInstance timer3 = new TimerInstance();
        timer3.setElementInstanceKey(2L);
        timer3.setKey(3L);
        timer3.setDueDate(2000L);
        this.state.store(timer3);
        ArrayList keys = new ArrayList();
        this.state.forEachTimerForElementInstance(1L, t -> keys.add(t.getKey()));
        ((ListAssert)Assertions.assertThat(keys).hasSize(2)).containsExactly((Object[])new Long[]{1L, 2L});
    }

    private TimerInstance createTimerInstance(long elementInstanceKey, long timerKey, long dueDate) {
        this.createElementInstance(elementInstanceKey);
        TimerInstance timer = new TimerInstance();
        timer.setElementInstanceKey(elementInstanceKey);
        timer.setKey(timerKey);
        timer.setDueDate(dueDate);
        this.state.store(timer);
        return timer;
    }

    private void createElementInstance(long key) {
        this.stateRule.getProcessingState().getElementInstanceState().createInstance(new ElementInstance(key, ProcessInstanceIntent.ELEMENT_ACTIVATED, new ProcessInstanceRecord()));
    }
}

