/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.state.instance;

import io.camunda.zeebe.db.ZeebeDbInconsistentException;
import io.camunda.zeebe.engine.state.immutable.UserTaskState;
import io.camunda.zeebe.engine.state.mutable.MutableProcessingState;
import io.camunda.zeebe.engine.state.mutable.MutableUserTaskState;
import io.camunda.zeebe.engine.util.ProcessingStateRule;
import io.camunda.zeebe.msgpack.value.DocumentValue;
import io.camunda.zeebe.protocol.impl.record.value.usertask.UserTaskRecord;
import io.camunda.zeebe.protocol.record.value.UserTaskRecordValue;
import io.camunda.zeebe.test.util.BufferAssert;
import io.camunda.zeebe.test.util.MsgPackUtil;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import org.agrona.DirectBuffer;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class UserTaskStateTest {
    @Rule
    public final ProcessingStateRule stateRule = new ProcessingStateRule();
    private MutableUserTaskState userTaskState;

    @Before
    public void setUp() {
        MutableProcessingState processingState = this.stateRule.getProcessingState();
        this.userTaskState = processingState.getUserTaskState();
    }

    @Test
    public void shouldCreateUserTask() {
        UserTaskRecord expectedRecord = this.createUserTask(5000L);
        this.userTaskState.create(expectedRecord);
        UserTaskRecord storedRecord = this.userTaskState.getUserTask(5000L);
        this.assertUserTask(expectedRecord, storedRecord, UserTaskState.LifecycleState.CREATING);
    }

    @Test
    public void shouldCreateUserTaskWithCustomTenantId() {
        UserTaskRecord expectedRecord = this.createUserTask(5000L).setTenantId("customTenantId");
        this.userTaskState.create(expectedRecord);
        UserTaskRecord storedRecord = this.userTaskState.getUserTask(5000L);
        this.assertUserTask(expectedRecord, "customTenantId", storedRecord, UserTaskState.LifecycleState.CREATING);
    }

    @Test
    public void shouldUpdateUserTask() {
        UserTaskRecord expectedRecord = this.createUserTask(5000L);
        this.userTaskState.create(expectedRecord);
        expectedRecord.setAssignee("myNewAssignee");
        this.userTaskState.update(expectedRecord);
        UserTaskRecord storedRecord = this.userTaskState.getUserTask(5000L);
        io.camunda.zeebe.protocol.record.Assertions.assertThat((UserTaskRecordValue)storedRecord).hasAssignee("myNewAssignee");
    }

    @Test
    public void shouldUpdateUserTaskWithModifier() {
        UserTaskRecord expectedRecord = this.createUserTask(5000L);
        this.userTaskState.create(expectedRecord);
        this.userTaskState.update(5000L, record -> record.setAssignee("myNewAssignee"));
        UserTaskRecord storedRecord = this.userTaskState.getUserTask(5000L);
        io.camunda.zeebe.protocol.record.Assertions.assertThat((UserTaskRecordValue)storedRecord).hasAssignee("myNewAssignee");
    }

    @Test
    public void shouldUpdateUserTaskState() {
        UserTaskRecord expectedRecord = this.createUserTask(5000L);
        this.userTaskState.create(expectedRecord);
        this.userTaskState.updateUserTaskLifecycleState(5000L, UserTaskState.LifecycleState.CREATED);
        this.assertUserTaskState(5000L, UserTaskState.LifecycleState.CREATED);
    }

    @Test
    public void shouldFailOnUpdatingNonExistingUserTask() {
        UserTaskRecord expectedRecord = new UserTaskRecord();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.userTaskState.update(expectedRecord)).isInstanceOf(ZeebeDbInconsistentException.class)).hasMessageContaining("does not exist");
    }

    @Test
    public void shouldDeleteUserTask() {
        UserTaskRecord expectedRecord = this.createUserTask(5000L);
        this.userTaskState.create(expectedRecord);
        this.userTaskState.delete(5000L);
        io.camunda.zeebe.protocol.record.Assertions.assertThat((UserTaskRecordValue)this.userTaskState.getUserTask(5000L)).isNull();
    }

    @Test
    public void shouldNeverPersistUserTaskVariables() {
        long key = 1L;
        UserTaskRecord userTask = this.createUserTask(1L);
        Consumer[] consumerArray = new Consumer[2];
        consumerArray[0] = arg_0 -> ((MutableUserTaskState)this.userTaskState).create(arg_0);
        consumerArray[1] = arg_0 -> ((MutableUserTaskState)this.userTaskState).update(arg_0);
        List<Consumer> stateUpdates = Arrays.asList(consumerArray);
        for (Consumer stateUpdate : stateUpdates) {
            userTask.setVariables(MsgPackUtil.asMsgPack((String)"foo", (Object)"bar"));
            stateUpdate.accept(userTask);
            DirectBuffer variables = this.userTaskState.getUserTask(1L).getVariablesBuffer();
            BufferAssert.assertThatBuffer((DirectBuffer)variables).isEqualTo((Object)DocumentValue.EMPTY_DOCUMENT);
        }
    }

    @Test
    public void shouldNotOverwritePersistedRecord() {
        long key = 1L;
        UserTaskRecord writtenRecord = this.createUserTask(1L).setAssignee("test");
        this.userTaskState.create(writtenRecord);
        writtenRecord.setAssignee("foo");
        UserTaskRecord readRecord = this.userTaskState.getUserTask(1L);
        io.camunda.zeebe.protocol.record.Assertions.assertThat((UserTaskRecordValue)readRecord).hasAssignee("test");
        io.camunda.zeebe.protocol.record.Assertions.assertThat((UserTaskRecordValue)writtenRecord).hasAssignee("foo");
    }

    private UserTaskRecord createUserTask(long userTaskKey) {
        return new UserTaskRecord().setElementInstanceKey(1234L).setBpmnProcessId("process").setElementId("process").setProcessInstanceKey(4321L).setProcessDefinitionKey(8765L).setProcessDefinitionVersion(2).setAssignee("myAssignee").setCandidateGroups("myGroups").setCandidateUsers("myUsers").setDueDate("2023-11-11T11:11:00+01:00").setFollowUpDate("2023-11-12T11:11:00+01:00").setFormKey(5678L).setUserTaskKey(userTaskKey);
    }

    private void assertUserTask(UserTaskRecord expectedRecord, UserTaskRecord storedRecord, UserTaskState.LifecycleState expectedLifecycleState) {
        this.assertUserTask(expectedRecord, "<default>", storedRecord, expectedLifecycleState);
    }

    private void assertUserTask(UserTaskRecord expectedRecord, String expectedTenantId, UserTaskRecord storedRecord, UserTaskState.LifecycleState expectedLifecycleState) {
        io.camunda.zeebe.protocol.record.Assertions.assertThat((UserTaskRecordValue)storedRecord).hasElementInstanceKey(expectedRecord.getElementInstanceKey()).hasBpmnProcessId(expectedRecord.getBpmnProcessId()).hasElementId(expectedRecord.getElementId()).hasProcessInstanceKey(expectedRecord.getProcessInstanceKey()).hasProcessDefinitionKey(expectedRecord.getProcessDefinitionKey()).hasProcessDefinitionVersion(expectedRecord.getProcessDefinitionVersion()).hasAssignee(expectedRecord.getAssignee()).hasCandidateGroups(expectedRecord.getCandidateGroups()).hasCandidateUsers(expectedRecord.getCandidateUsers()).hasDueDate(expectedRecord.getDueDate()).hasFollowUpDate(expectedRecord.getFollowUpDate()).hasFormKey(expectedRecord.getFormKey()).hasUserTaskKey(expectedRecord.getUserTaskKey()).hasTenantId(expectedTenantId);
        this.assertUserTaskState(expectedRecord.getUserTaskKey(), expectedLifecycleState);
    }

    private void assertUserTaskState(long userTaskKey, UserTaskState.LifecycleState expectedLifecycleState) {
        Assertions.assertThat((Comparable)this.userTaskState.getLifecycleState(userTaskKey)).isEqualTo((Object)expectedLifecycleState);
    }
}

