/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.state.message;

import io.camunda.zeebe.engine.state.message.MessageSubscription;
import io.camunda.zeebe.engine.state.mutable.MutableMessageSubscriptionState;
import io.camunda.zeebe.engine.state.mutable.MutableProcessingState;
import io.camunda.zeebe.engine.util.ProcessingStateRule;
import io.camunda.zeebe.protocol.impl.record.value.message.MessageSubscriptionRecord;
import io.camunda.zeebe.util.buffer.BufferUtil;
import java.util.ArrayList;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public final class MessageSubscriptionStateTest {
    private static final String DEFAULT_TENANT = "<default>";
    @Rule
    public final ProcessingStateRule stateRule = new ProcessingStateRule();
    private MutableMessageSubscriptionState state;

    @Before
    public void setUp() {
        MutableProcessingState processingState = this.stateRule.getProcessingState();
        this.state = processingState.getMessageSubscriptionState();
    }

    @Test
    public void shouldNotExistWithDifferentElementKey() {
        MessageSubscriptionRecord subscription = this.subscriptionWithElementInstanceKey(1L);
        this.state.put(1L, subscription);
        boolean exist = this.state.existSubscriptionForElementInstance(2L, subscription.getMessageNameBuffer());
        Assertions.assertThat((boolean)exist).isFalse();
    }

    @Test
    public void shouldNotExistWithDifferentMessageName() {
        MessageSubscriptionRecord subscription = this.subscriptionWithElementInstanceKey(1L);
        this.state.put(1L, subscription);
        boolean exist = this.state.existSubscriptionForElementInstance(subscription.getElementInstanceKey(), BufferUtil.wrapString((String)"\u0000"));
        Assertions.assertThat((boolean)exist).isFalse();
    }

    @Test
    public void shouldExistSubscription() {
        MessageSubscriptionRecord subscription = this.subscriptionWithElementInstanceKey(1L);
        this.state.put(1L, subscription);
        boolean exist = this.state.existSubscriptionForElementInstance(subscription.getElementInstanceKey(), subscription.getMessageNameBuffer());
        Assertions.assertThat((boolean)exist).isTrue();
    }

    @Test
    public void shouldVisitSubscription() {
        MessageSubscriptionRecord subscription = this.subscription("messageName", "correlationKey", 1L);
        this.state.put(1L, subscription);
        ArrayList subscriptions = new ArrayList();
        this.state.visitSubscriptions(DEFAULT_TENANT, BufferUtil.wrapString((String)"messageName"), BufferUtil.wrapString((String)"correlationKey"), subscriptions::add);
        Assertions.assertThat(subscriptions).hasSize(1);
        Assertions.assertThat((long)((MessageSubscription)subscriptions.get(0)).getRecord().getProcessInstanceKey()).isEqualTo(subscription.getProcessInstanceKey());
        Assertions.assertThat((long)((MessageSubscription)subscriptions.get(0)).getRecord().getElementInstanceKey()).isEqualTo(subscription.getElementInstanceKey());
        Assertions.assertThat((String)((MessageSubscription)subscriptions.get(0)).getRecord().getMessageName()).isEqualTo(subscription.getMessageName());
        Assertions.assertThat((String)((MessageSubscription)subscriptions.get(0)).getRecord().getCorrelationKey()).isEqualTo(subscription.getCorrelationKey());
        Assertions.assertThat((Map)((MessageSubscription)subscriptions.get(0)).getRecord().getVariables()).isEqualTo((Object)subscription.getVariables());
        Assertions.assertThat((boolean)((MessageSubscription)subscriptions.get(0)).isCorrelating()).isFalse();
    }

    @Test
    public void shouldVisitSubscriptionsInOrder() {
        this.state.put(1L, this.subscription("messageName", "correlationKey", 1L));
        this.state.put(2L, this.subscription("messageName", "correlationKey", 2L));
        this.state.put(3L, this.subscription("otherMessageName", "correlationKey", 3L));
        this.state.put(4L, this.subscription("messageName", "otherCorrelationKey", 4L));
        ArrayList keys = new ArrayList();
        this.state.visitSubscriptions(DEFAULT_TENANT, BufferUtil.wrapString((String)"messageName"), BufferUtil.wrapString((String)"correlationKey"), s -> keys.add(s.getRecord().getElementInstanceKey()));
        ((ListAssert)Assertions.assertThat(keys).hasSize(2)).containsExactly((Object[])new Long[]{1L, 2L});
    }

    @Test
    public void shouldVisitSubsctionsUntilStop() {
        this.state.put(1L, this.subscription("messageName", "correlationKey", 1L));
        this.state.put(2L, this.subscription("messageName", "correlationKey", 2L));
        ArrayList keys = new ArrayList();
        this.state.visitSubscriptions(DEFAULT_TENANT, BufferUtil.wrapString((String)"messageName"), BufferUtil.wrapString((String)"correlationKey"), s -> {
            keys.add(s.getRecord().getElementInstanceKey());
            return false;
        });
        ((ListAssert)Assertions.assertThat(keys).hasSize(1)).contains((Object[])new Long[]{1L});
    }

    @Test
    public void shouldNotFailOnRemoveSubscriptionTwice() {
        MessageSubscriptionRecord subscription = this.subscriptionWithElementInstanceKey(1L);
        this.state.put(1L, subscription);
        this.state.remove(1L, subscription.getMessageNameBuffer());
        this.state.remove(1L, subscription.getMessageNameBuffer());
        Assertions.assertThat((boolean)this.state.existSubscriptionForElementInstance(1L, subscription.getMessageNameBuffer())).isFalse();
    }

    @Test
    public void shouldNotRemoveSubscriptionOnDifferentKey() {
        this.state.put(1L, this.subscription("messageName", "correlationKey", 1L));
        this.state.put(2L, this.subscription("messageName", "correlationKey", 2L));
        this.state.remove(2L, BufferUtil.wrapString((String)"messageName"));
        ArrayList keys = new ArrayList();
        this.state.visitSubscriptions(DEFAULT_TENANT, BufferUtil.wrapString((String)"messageName"), BufferUtil.wrapString((String)"correlationKey"), s -> keys.add(s.getRecord().getElementInstanceKey()));
        ((ListAssert)Assertions.assertThat(keys).hasSize(1)).contains((Object[])new Long[]{1L});
    }

    private MessageSubscriptionRecord subscriptionWithElementInstanceKey(long elementInstanceKey) {
        return this.subscription("messageName", "correlationKey", elementInstanceKey);
    }

    private MessageSubscriptionRecord subscription(String name, String correlationKey, long elementInstanceKey) {
        return new MessageSubscriptionRecord().setProcessInstanceKey(1L).setElementInstanceKey(elementInstanceKey).setBpmnProcessId(BufferUtil.wrapString((String)"process")).setMessageName(BufferUtil.wrapString((String)name)).setCorrelationKey(BufferUtil.wrapString((String)correlationKey)).setInterrupting(true);
    }
}

