/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.state.migration;

import io.camunda.zeebe.db.ColumnFamily;
import io.camunda.zeebe.db.DbKey;
import io.camunda.zeebe.db.DbValue;
import io.camunda.zeebe.db.TransactionContext;
import io.camunda.zeebe.db.ZeebeDb;
import io.camunda.zeebe.db.impl.DbCompositeKey;
import io.camunda.zeebe.db.impl.DbForeignKey;
import io.camunda.zeebe.db.impl.DbLong;
import io.camunda.zeebe.db.impl.DbNil;
import io.camunda.zeebe.engine.state.immutable.ProcessingState;
import io.camunda.zeebe.engine.state.instance.JobRecordValue;
import io.camunda.zeebe.engine.state.instance.JobStateValue;
import io.camunda.zeebe.engine.state.migration.JobBackoffRestoreMigration;
import io.camunda.zeebe.engine.state.mutable.MutableJobState;
import io.camunda.zeebe.engine.state.mutable.MutableProcessingState;
import io.camunda.zeebe.engine.util.ProcessingStateExtension;
import io.camunda.zeebe.protocol.ZbColumnFamilies;
import io.camunda.zeebe.protocol.impl.record.value.job.JobRecord;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ProcessingStateExtension.class})
public class JobBackoffRestoreMigrationTest {
    final JobBackoffRestoreMigration jobBackoffRestoreMigration = new JobBackoffRestoreMigration();
    private ZeebeDb<ZbColumnFamilies> zeebeDb;
    private MutableProcessingState processingState;
    private TransactionContext transactionContext;
    private final JobRecordValue jobRecordToRead = new JobRecordValue();
    private DbLong jobKey;
    private ColumnFamily<DbLong, JobRecordValue> jobsColumnFamily;
    private DbLong backoffKey;
    private DbCompositeKey<DbLong, DbForeignKey<DbLong>> backoffJobKey;
    private ColumnFamily<DbCompositeKey<DbLong, DbForeignKey<DbLong>>, DbNil> backoffColumnFamily;
    private final JobStateValue jobState = new JobStateValue();
    private ColumnFamily<DbForeignKey<DbLong>, JobStateValue> statesJobColumnFamily;

    @BeforeEach
    public void setup() {
        this.jobKey = new DbLong();
        DbForeignKey fkJob = new DbForeignKey((DbKey)this.jobKey, (Enum)ZbColumnFamilies.JOBS);
        this.jobsColumnFamily = this.zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.JOBS, this.transactionContext, (DbKey)this.jobKey, (DbValue)this.jobRecordToRead);
        this.statesJobColumnFamily = this.zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.JOB_STATES, this.transactionContext, (DbKey)fkJob, (DbValue)this.jobState);
        this.backoffKey = new DbLong();
        this.backoffJobKey = new DbCompositeKey((DbKey)this.backoffKey, (DbKey)fkJob);
        this.backoffColumnFamily = this.zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.JOB_BACKOFF, this.transactionContext, this.backoffJobKey, (DbValue)DbNil.INSTANCE);
        this.jobKey.wrapLong(1L);
    }

    @Test
    public void shouldRestoreIfBackoffColumnIsEmpty() {
        MutableJobState jobState = this.processingState.getJobState();
        JobRecord record = JobBackoffRestoreMigrationTest.createJobRecord(1000L);
        jobState.create(this.jobKey.getValue(), record);
        jobState.fail(this.jobKey.getValue(), record);
        this.backoffKey.wrapLong(record.getRecurringTime());
        this.backoffColumnFamily.deleteExisting(this.backoffJobKey);
        Assertions.assertThat((boolean)this.jobBackoffRestoreMigration.needsToRun((ProcessingState)this.processingState)).isTrue();
        this.jobBackoffRestoreMigration.runMigration(this.processingState);
        Assertions.assertThat((boolean)this.backoffColumnFamily.isEmpty()).isFalse();
    }

    @Test
    public void shouldRestoreIfFailedJobsAreMoreThanBackoffJob() {
        MutableJobState jobState = this.processingState.getJobState();
        JobRecord record = JobBackoffRestoreMigrationTest.createJobRecord(1000L);
        jobState.create(this.jobKey.getValue(), record);
        jobState.fail(this.jobKey.getValue(), record);
        this.backoffKey.wrapLong(record.getRecurringTime());
        this.backoffColumnFamily.deleteExisting(this.backoffJobKey);
        this.jobKey.wrapLong(2L);
        JobRecord backoffRecord = JobBackoffRestoreMigrationTest.createJobRecord(2000L);
        jobState.create(this.jobKey.getValue(), backoffRecord);
        jobState.fail(this.jobKey.getValue(), backoffRecord);
        this.backoffKey.wrapLong(backoffRecord.getRecurringTime());
        Assertions.assertThat((long)this.backoffColumnFamily.count()).isEqualTo(1L);
        Assertions.assertThat((boolean)this.jobBackoffRestoreMigration.needsToRun((ProcessingState)this.processingState)).isTrue();
        this.jobBackoffRestoreMigration.runMigration(this.processingState);
        Assertions.assertThat((boolean)this.backoffColumnFamily.isEmpty()).isFalse();
        Assertions.assertThat((long)this.backoffColumnFamily.count()).isEqualTo(2L);
    }

    @Test
    public void shouldDoNothingIfFailedJobsAreTheSameAsBackoff() {
        MutableJobState jobState = this.processingState.getJobState();
        JobRecord record = JobBackoffRestoreMigrationTest.createJobRecord(1000L);
        jobState.create(this.jobKey.getValue(), record);
        jobState.fail(this.jobKey.getValue(), record);
        this.jobKey.wrapLong(2L);
        JobRecord backoffRecord = JobBackoffRestoreMigrationTest.createJobRecord(2000L);
        jobState.create(this.jobKey.getValue(), backoffRecord);
        jobState.fail(this.jobKey.getValue(), backoffRecord);
        Assertions.assertThat((long)this.backoffColumnFamily.count()).isEqualTo(2L);
        Assertions.assertThat((boolean)this.jobBackoffRestoreMigration.needsToRun((ProcessingState)this.processingState)).isTrue();
        this.jobBackoffRestoreMigration.runMigration(this.processingState);
        Assertions.assertThat((boolean)this.backoffColumnFamily.isEmpty()).isFalse();
        Assertions.assertThat((long)this.backoffColumnFamily.count()).isEqualTo(2L);
    }

    @Test
    public void shouldNotRestoreJobWithoutRetries() {
        MutableJobState jobState = this.processingState.getJobState();
        JobRecord record = JobBackoffRestoreMigrationTest.createJobRecord(1000L);
        jobState.create(this.jobKey.getValue(), record);
        record = jobState.updateJobRetries(this.jobKey.getValue(), 0);
        jobState.fail(this.jobKey.getValue(), record);
        this.backoffKey.wrapLong(record.getRecurringTime());
        this.jobKey.wrapLong(2L);
        JobRecord backoffRecord = JobBackoffRestoreMigrationTest.createJobRecord(2000L);
        jobState.create(this.jobKey.getValue(), backoffRecord);
        jobState.fail(this.jobKey.getValue(), backoffRecord);
        Assertions.assertThat((long)this.backoffColumnFamily.count()).isEqualTo(1L);
        Assertions.assertThat((boolean)this.jobBackoffRestoreMigration.needsToRun((ProcessingState)this.processingState)).isTrue();
        this.jobBackoffRestoreMigration.runMigration(this.processingState);
        Assertions.assertThat((boolean)this.backoffColumnFamily.isEmpty()).isFalse();
        Assertions.assertThat((long)this.backoffColumnFamily.count()).isEqualTo(1L);
    }

    private static JobRecord createJobRecord(long retryBackoff) {
        return new JobRecord().setType("test").setRetries(3).setRetryBackoff(retryBackoff).setRecurringTime(System.currentTimeMillis() + retryBackoff);
    }
}

