/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.state.migration.to_8_2;

import io.camunda.zeebe.db.ColumnFamily;
import io.camunda.zeebe.db.DbKey;
import io.camunda.zeebe.db.TransactionContext;
import io.camunda.zeebe.db.ZeebeDb;
import io.camunda.zeebe.db.impl.DbCompositeKey;
import io.camunda.zeebe.db.impl.DbForeignKey;
import io.camunda.zeebe.db.impl.DbInt;
import io.camunda.zeebe.db.impl.DbLong;
import io.camunda.zeebe.db.impl.DbString;
import io.camunda.zeebe.engine.state.immutable.ProcessingState;
import io.camunda.zeebe.engine.state.migration.to_8_2.DecisionMigration;
import io.camunda.zeebe.engine.state.migration.to_8_2.LegacyDecisionState;
import io.camunda.zeebe.engine.state.mutable.MutableMigrationState;
import io.camunda.zeebe.engine.state.mutable.MutableProcessingState;
import io.camunda.zeebe.engine.util.ProcessingStateExtension;
import io.camunda.zeebe.protocol.ZbColumnFamilies;
import io.camunda.zeebe.protocol.impl.record.value.deployment.DecisionRecord;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;

public class DecisionMigrationTest {
    final DecisionMigration sutMigration = new DecisionMigration();

    @Nested
    @ExtendWith(value={ProcessingStateExtension.class})
    public class BlackboxTest {
        private ZeebeDb<ZbColumnFamilies> zeebeDb;
        private MutableProcessingState processingState;
        private TransactionContext transactionContext;
        private LegacyDecisionState legacyDecisionState;
        private DbString dbDecisionId;
        private DbLong dbDecisionKey;
        private DbForeignKey<DbLong> fkDecision;
        private DbInt dbDecisionVersion;
        private DbCompositeKey<DbString, DbInt> decisionIdAndVersion;
        private ColumnFamily<DbCompositeKey<DbString, DbInt>, DbForeignKey<DbLong>> decisionKeyByDecisionIdAndVersion;

        @BeforeEach
        public void setup() {
            this.legacyDecisionState = new LegacyDecisionState(this.zeebeDb, this.transactionContext);
            this.dbDecisionKey = new DbLong();
            this.fkDecision = new DbForeignKey((DbKey)this.dbDecisionKey, (Enum)ZbColumnFamilies.DEPRECATED_DMN_DECISIONS);
            this.dbDecisionId = new DbString();
            this.dbDecisionVersion = new DbInt();
            this.decisionIdAndVersion = new DbCompositeKey((DbKey)this.dbDecisionId, (DbKey)this.dbDecisionVersion);
            this.decisionKeyByDecisionIdAndVersion = this.zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.DEPRECATED_DMN_DECISION_KEY_BY_DECISION_ID_AND_VERSION, this.transactionContext, this.decisionIdAndVersion, this.fkDecision);
        }

        @Test
        public void afterMigrationRunNoFurtherMigrationIsNeeded() {
            long key = 123L;
            this.legacyDecisionState.putDecision(123L, this.sampleDecisionRecord().setDecisionKey(123L));
            DecisionMigrationTest.this.sutMigration.runMigration(this.processingState);
            boolean shouldRun = DecisionMigrationTest.this.sutMigration.needsToRun((ProcessingState)this.processingState);
            Assertions.assertThat((boolean)shouldRun).isFalse();
        }

        @Test
        public void shouldFindCorrectDecisionKeyAfterMigration() {
            DecisionRecord decision1 = this.sampleDecisionRecord().setVersion(1).setDecisionKey(111L);
            DecisionRecord decision2 = this.sampleDecisionRecord().setVersion(2).setDecisionKey(222L);
            this.legacyDecisionState.putDecision(decision1.getDecisionKey(), decision1);
            this.legacyDecisionState.putDecision(decision2.getDecisionKey(), decision2);
            DecisionMigrationTest.this.sutMigration.runMigration(this.processingState);
            this.assertContainsDecision(decision1);
            this.assertContainsDecision(decision2);
        }

        private DecisionRecord sampleDecisionRecord() {
            return new DecisionRecord().setDecisionId("decision-id").setDecisionName("decision-name").setVersion(1).setDecisionKey(1L).setDecisionRequirementsId("drg-id").setDecisionRequirementsKey(1L);
        }

        private void assertContainsDecision(DecisionRecord decisionRecord) {
            this.dbDecisionId.wrapString(decisionRecord.getDecisionId());
            this.dbDecisionKey.wrapLong(decisionRecord.getDecisionKey());
            this.dbDecisionVersion.wrapInt(decisionRecord.getVersion());
            Assertions.assertThat((boolean)this.decisionKeyByDecisionIdAndVersion.exists(this.decisionIdAndVersion)).isTrue();
            Assertions.assertThat((long)((DbLong)((DbForeignKey)this.decisionKeyByDecisionIdAndVersion.get(this.decisionIdAndVersion)).inner()).getValue()).isEqualTo(decisionRecord.getDecisionKey());
        }
    }

    @Nested
    public class MockBasedTests {
        @Test
        public void noMigrationNeededWhenDecisionsColumnFamilyIsEmpty() {
            ProcessingState mockProcessingState = (ProcessingState)Mockito.mock(ProcessingState.class);
            Mockito.when((Object)mockProcessingState.isEmpty(ZbColumnFamilies.DEPRECATED_DMN_DECISIONS)).thenReturn((Object)true);
            Mockito.when((Object)mockProcessingState.isEmpty(ZbColumnFamilies.DEPRECATED_DMN_DECISION_KEY_BY_DECISION_ID_AND_VERSION)).thenReturn((Object)true);
            boolean actual = DecisionMigrationTest.this.sutMigration.needsToRun(mockProcessingState);
            Assertions.assertThat((boolean)actual).isFalse();
        }

        @Test
        public void noMigrationNeededWhenVersionColumnFamilyIsPopulated() {
            ProcessingState mockProcessingState = (ProcessingState)Mockito.mock(ProcessingState.class);
            Mockito.when((Object)mockProcessingState.isEmpty(ZbColumnFamilies.DEPRECATED_DMN_DECISIONS)).thenReturn((Object)false);
            Mockito.when((Object)mockProcessingState.isEmpty(ZbColumnFamilies.DEPRECATED_DMN_DECISION_KEY_BY_DECISION_ID_AND_VERSION)).thenReturn((Object)false);
            boolean actual = DecisionMigrationTest.this.sutMigration.needsToRun(mockProcessingState);
            Assertions.assertThat((boolean)actual).isFalse();
        }

        @Test
        public void migrationNeededWhenDecisionHaveNotBeenMigratedYet() {
            ProcessingState mockProcessingState = (ProcessingState)Mockito.mock(ProcessingState.class);
            Mockito.when((Object)mockProcessingState.isEmpty(ZbColumnFamilies.DEPRECATED_DMN_DECISIONS)).thenReturn((Object)false);
            Mockito.when((Object)mockProcessingState.isEmpty(ZbColumnFamilies.DEPRECATED_DMN_DECISION_KEY_BY_DECISION_ID_AND_VERSION)).thenReturn((Object)true);
            boolean actual = DecisionMigrationTest.this.sutMigration.needsToRun(mockProcessingState);
            Assertions.assertThat((boolean)actual).isTrue();
        }

        @Test
        public void migrationCallsMethodInMigrationState() {
            MutableProcessingState mockProcessingState = (MutableProcessingState)Mockito.mock(MutableProcessingState.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
            DecisionMigrationTest.this.sutMigration.runMigration(mockProcessingState);
            ((MutableMigrationState)Mockito.verify((Object)mockProcessingState.getMigrationState())).migrateDecisionsPopulateDecisionVersionByDecisionIdAndDecisionKey();
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{mockProcessingState.getMigrationState()});
        }
    }
}

