/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.state.migration.to_8_3.legacy;

import io.camunda.zeebe.db.ColumnFamily;
import io.camunda.zeebe.db.DbKey;
import io.camunda.zeebe.db.DbValue;
import io.camunda.zeebe.db.TransactionContext;
import io.camunda.zeebe.db.ZeebeDb;
import io.camunda.zeebe.db.impl.DbCompositeKey;
import io.camunda.zeebe.db.impl.DbForeignKey;
import io.camunda.zeebe.db.impl.DbLong;
import io.camunda.zeebe.db.impl.DbString;
import io.camunda.zeebe.engine.processing.deployment.model.BpmnFactory;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableFlowElement;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableProcess;
import io.camunda.zeebe.engine.processing.deployment.model.transformation.BpmnTransformer;
import io.camunda.zeebe.engine.state.deployment.DeployedProcess;
import io.camunda.zeebe.engine.state.deployment.Digest;
import io.camunda.zeebe.engine.state.deployment.PersistedProcess;
import io.camunda.zeebe.model.bpmn.Bpmn;
import io.camunda.zeebe.model.bpmn.BpmnModelInstance;
import io.camunda.zeebe.protocol.ZbColumnFamilies;
import io.camunda.zeebe.protocol.impl.record.value.deployment.DeploymentRecord;
import io.camunda.zeebe.protocol.impl.record.value.deployment.ProcessMetadata;
import io.camunda.zeebe.protocol.impl.record.value.deployment.ProcessRecord;
import io.camunda.zeebe.protocol.record.value.deployment.DeploymentResource;
import io.camunda.zeebe.stream.impl.state.NextValue;
import io.camunda.zeebe.util.buffer.BufferUtil;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.collections.Long2ObjectHashMap;
import org.agrona.collections.Object2LongHashMap;
import org.agrona.concurrent.UnsafeBuffer;
import org.agrona.io.DirectBufferInputStream;

public final class LegacyProcessState {
    private static final int DEFAULT_VERSION_VALUE = 0;
    private final BpmnTransformer transformer = BpmnFactory.createTransformer();
    private final ProcessRecord processRecordForDeployments = new ProcessRecord();
    private final Map<DirectBuffer, Long2ObjectHashMap<DeployedProcess>> processesByProcessIdAndVersion = new HashMap<DirectBuffer, Long2ObjectHashMap<DeployedProcess>>();
    private final Long2ObjectHashMap<DeployedProcess> processesByKey;
    private final ColumnFamily<DbLong, PersistedProcess> processColumnFamily;
    private final DbLong processDefinitionKey;
    private final PersistedProcess persistedProcess;
    private final ColumnFamily<DbCompositeKey<DbString, DbLong>, PersistedProcess> processByIdAndVersionColumnFamily;
    private final DbLong processVersion;
    private final DbCompositeKey<DbString, DbLong> idAndVersionKey;
    private final DbString processId;
    private final DbForeignKey<DbString> fkProcessId;
    private final ColumnFamily<DbForeignKey<DbString>, Digest> digestByIdColumnFamily;
    private final Digest digest = new Digest();
    private final LegacyProcessVersionManager versionManager;

    public LegacyProcessState(ZeebeDb<ZbColumnFamilies> zeebeDb, TransactionContext transactionContext) {
        this.processDefinitionKey = new DbLong();
        this.persistedProcess = new PersistedProcess();
        this.processColumnFamily = zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.DEPRECATED_PROCESS_CACHE, transactionContext, (DbKey)this.processDefinitionKey, (DbValue)this.persistedProcess);
        this.processId = new DbString();
        this.processVersion = new DbLong();
        this.idAndVersionKey = new DbCompositeKey((DbKey)this.processId, (DbKey)this.processVersion);
        this.processByIdAndVersionColumnFamily = zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.DEPRECATED_PROCESS_CACHE_BY_ID_AND_VERSION, transactionContext, this.idAndVersionKey, (DbValue)this.persistedProcess);
        this.fkProcessId = new DbForeignKey((DbKey)this.processId, (Enum)ZbColumnFamilies.DEPRECATED_PROCESS_CACHE_BY_ID_AND_VERSION, DbForeignKey.MatchType.Prefix);
        this.digestByIdColumnFamily = zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.DEPRECATED_PROCESS_CACHE_DIGEST_BY_ID, transactionContext, this.fkProcessId, (DbValue)this.digest);
        this.processesByKey = new Long2ObjectHashMap();
        this.versionManager = new LegacyProcessVersionManager(0L, zeebeDb, transactionContext);
    }

    public void putDeployment(DeploymentRecord deploymentRecord) {
        for (ProcessMetadata metadata : deploymentRecord.processesMetadata()) {
            for (DeploymentResource resource : deploymentRecord.getResources()) {
                if (!resource.getResourceName().equals(metadata.getResourceName())) continue;
                this.processRecordForDeployments.reset();
                this.processRecordForDeployments.wrap(metadata, resource.getResource());
                this.putProcess(metadata.getKey(), this.processRecordForDeployments);
            }
        }
    }

    public void putLatestVersionDigest(DirectBuffer processIdBuffer, DirectBuffer digest) {
        this.processId.wrapBuffer(processIdBuffer);
        this.digest.set(digest);
        this.digestByIdColumnFamily.upsert(this.fkProcessId, (DbValue)this.digest);
    }

    public void putProcess(long key, ProcessRecord processRecord) {
        this.persistProcess(key, processRecord);
        this.updateLatestVersion(processRecord);
        this.putLatestVersionDigest(processRecord.getBpmnProcessIdBuffer(), processRecord.getChecksumBuffer());
    }

    private void persistProcess(long processDefinitionKey, ProcessRecord processRecord) {
        this.persistedProcess.wrap(processRecord, processDefinitionKey);
        this.processDefinitionKey.wrapLong(processDefinitionKey);
        this.processColumnFamily.upsert((DbKey)this.processDefinitionKey, (DbValue)this.persistedProcess);
        this.processId.wrapBuffer(processRecord.getBpmnProcessIdBuffer());
        this.processVersion.wrapLong((long)processRecord.getVersion());
        this.processByIdAndVersionColumnFamily.upsert(this.idAndVersionKey, (DbValue)this.persistedProcess);
    }

    private void updateLatestVersion(ProcessRecord processRecord) {
        this.processId.wrapBuffer(processRecord.getBpmnProcessIdBuffer());
        String bpmnProcessId = processRecord.getBpmnProcessId();
        long currentVersion = this.versionManager.getCurrentProcessVersion(bpmnProcessId);
        int nextVersion = processRecord.getVersion();
        if ((long)nextVersion > currentVersion) {
            this.versionManager.setProcessVersion(bpmnProcessId, nextVersion);
        }
    }

    private DeployedProcess updateInMemoryState(PersistedProcess persistedProcess) {
        byte[] bytes = new byte[persistedProcess.getLength()];
        UnsafeBuffer buffer = new UnsafeBuffer(bytes);
        persistedProcess.write((MutableDirectBuffer)buffer, 0);
        PersistedProcess copiedProcess = new PersistedProcess();
        copiedProcess.wrap((DirectBuffer)buffer, 0, persistedProcess.getLength());
        BpmnModelInstance modelInstance = this.readModelInstanceFromBuffer(copiedProcess.getResource());
        List definitions = this.transformer.transformDefinitions(modelInstance);
        ExecutableProcess executableProcess = definitions.stream().filter(w -> BufferUtil.equals((DirectBuffer)persistedProcess.getBpmnProcessId(), (DirectBuffer)w.getId())).findFirst().orElseThrow();
        DeployedProcess deployedProcess = new DeployedProcess(executableProcess, copiedProcess);
        this.addProcessToInMemoryState(deployedProcess);
        return deployedProcess;
    }

    private BpmnModelInstance readModelInstanceFromBuffer(DirectBuffer buffer) {
        try (DirectBufferInputStream stream = new DirectBufferInputStream(buffer);){
            BpmnModelInstance bpmnModelInstance = Bpmn.readModelFromStream((InputStream)stream);
            return bpmnModelInstance;
        }
    }

    private void addProcessToInMemoryState(DeployedProcess deployedProcess) {
        DirectBuffer bpmnProcessId = deployedProcess.getBpmnProcessId();
        this.processesByKey.put(deployedProcess.getKey(), (Object)deployedProcess);
        Long2ObjectHashMap versionMap = this.processesByProcessIdAndVersion.computeIfAbsent(bpmnProcessId, id -> new Long2ObjectHashMap());
        int version = deployedProcess.getVersion();
        versionMap.put((long)version, (Object)deployedProcess);
    }

    public DeployedProcess getLatestProcessVersionByProcessId(DirectBuffer processIdBuffer) {
        DeployedProcess deployedProcess;
        Long2ObjectHashMap<DeployedProcess> versionMap = this.processesByProcessIdAndVersion.get(processIdBuffer);
        this.processId.wrapBuffer(processIdBuffer);
        long latestVersion = this.versionManager.getCurrentProcessVersion(processIdBuffer);
        if (versionMap == null) {
            deployedProcess = this.lookupProcessByIdAndPersistedVersion(latestVersion);
        } else {
            deployedProcess = (DeployedProcess)versionMap.get(latestVersion);
            if (deployedProcess == null) {
                deployedProcess = this.lookupProcessByIdAndPersistedVersion(latestVersion);
            }
        }
        return deployedProcess;
    }

    public DeployedProcess getProcessByProcessIdAndVersion(DirectBuffer processId, int version) {
        Long2ObjectHashMap<DeployedProcess> versionMap = this.processesByProcessIdAndVersion.get(processId);
        if (versionMap != null) {
            DeployedProcess deployedProcess = (DeployedProcess)versionMap.get((long)version);
            return deployedProcess != null ? deployedProcess : this.lookupPersistenceState(processId, version);
        }
        return this.lookupPersistenceState(processId, version);
    }

    public DeployedProcess getProcessByKey(long key) {
        DeployedProcess deployedProcess = (DeployedProcess)this.processesByKey.get(key);
        if (deployedProcess != null) {
            return deployedProcess;
        }
        return this.lookupPersistenceStateForProcessByKey(key);
    }

    public Collection<DeployedProcess> getProcesses() {
        this.updateCompleteInMemoryState();
        return this.processesByKey.values();
    }

    public Collection<DeployedProcess> getProcessesByBpmnProcessId(DirectBuffer bpmnProcessId) {
        this.updateCompleteInMemoryState();
        Long2ObjectHashMap<DeployedProcess> processesByVersions = this.processesByProcessIdAndVersion.get(bpmnProcessId);
        if (processesByVersions != null) {
            return processesByVersions.values();
        }
        return Collections.emptyList();
    }

    public DirectBuffer getLatestVersionDigest(DirectBuffer processIdBuffer) {
        this.processId.wrapBuffer(processIdBuffer);
        Digest latestDigest = (Digest)this.digestByIdColumnFamily.get(this.fkProcessId);
        return latestDigest == null || this.digest.get().byteArray() == null ? null : latestDigest.get();
    }

    public int getProcessVersion(String bpmnProcessId) {
        return (int)this.versionManager.getCurrentProcessVersion(bpmnProcessId);
    }

    public <T extends ExecutableFlowElement> T getFlowElement(long processDefinitionKey, DirectBuffer elementId, Class<T> elementType) {
        DeployedProcess deployedProcess = this.getProcessByKey(processDefinitionKey);
        if (deployedProcess == null) {
            throw new IllegalStateException(String.format("Expected to find a process deployed with key '%d' but not found.", processDefinitionKey));
        }
        ExecutableProcess process = deployedProcess.getProcess();
        ExecutableFlowElement element = process.getElementById(elementId, elementType);
        if (element == null) {
            throw new IllegalStateException(String.format("Expected to find a flow element with id '%s' in process with key '%d' but not found.", BufferUtil.bufferAsString((DirectBuffer)elementId), processDefinitionKey));
        }
        return (T)element;
    }

    public void clearCache() {
        this.processesByKey.clear();
        this.processesByProcessIdAndVersion.clear();
        this.versionManager.clear();
    }

    private DeployedProcess lookupProcessByIdAndPersistedVersion(long latestVersion) {
        this.processVersion.wrapLong(latestVersion);
        PersistedProcess processWithVersionAndId = (PersistedProcess)this.processByIdAndVersionColumnFamily.get(this.idAndVersionKey);
        if (processWithVersionAndId != null) {
            return this.updateInMemoryState(processWithVersionAndId);
        }
        return null;
    }

    private DeployedProcess lookupPersistenceState(DirectBuffer processIdBuffer, int version) {
        this.processId.wrapBuffer(processIdBuffer);
        this.processVersion.wrapLong((long)version);
        PersistedProcess processWithVersionAndId = (PersistedProcess)this.processByIdAndVersionColumnFamily.get(this.idAndVersionKey);
        if (processWithVersionAndId != null) {
            this.updateInMemoryState(processWithVersionAndId);
            Long2ObjectHashMap<DeployedProcess> newVersionMap = this.processesByProcessIdAndVersion.get(processIdBuffer);
            if (newVersionMap != null) {
                return (DeployedProcess)newVersionMap.get((long)version);
            }
        }
        return null;
    }

    private DeployedProcess lookupPersistenceStateForProcessByKey(long processDefinitionKey) {
        this.processDefinitionKey.wrapLong(processDefinitionKey);
        PersistedProcess processWithKey = (PersistedProcess)this.processColumnFamily.get((DbKey)this.processDefinitionKey);
        if (processWithKey != null) {
            this.updateInMemoryState(processWithKey);
            return (DeployedProcess)this.processesByKey.get(processDefinitionKey);
        }
        return null;
    }

    private void updateCompleteInMemoryState() {
        this.processColumnFamily.forEach(this::updateInMemoryState);
    }

    public static final class LegacyProcessVersionManager {
        private final long initialValue;
        private final ColumnFamily<DbString, NextValue> nextValueColumnFamily;
        private final DbString processIdKey;
        private final NextValue nextVersion = new NextValue();
        private final Object2LongHashMap<String> versionCache;

        public LegacyProcessVersionManager(long initialValue, ZeebeDb<ZbColumnFamilies> zeebeDb, TransactionContext transactionContext) {
            this.initialValue = initialValue;
            this.processIdKey = new DbString();
            this.nextValueColumnFamily = zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.DEPRECATED_PROCESS_VERSION, transactionContext, (DbKey)this.processIdKey, (DbValue)this.nextVersion);
            this.versionCache = new Object2LongHashMap(initialValue);
        }

        public void setProcessVersion(String processId, long value) {
            this.processIdKey.wrapString(processId);
            this.nextVersion.set(value);
            this.nextValueColumnFamily.upsert((DbKey)this.processIdKey, (DbValue)this.nextVersion);
            this.versionCache.put((Object)processId, value);
        }

        public long getCurrentProcessVersion(String processId) {
            this.processIdKey.wrapString(processId);
            return this.getCurrentProcessVersion();
        }

        public long getCurrentProcessVersion(DirectBuffer processId) {
            this.processIdKey.wrapBuffer(processId);
            return this.getCurrentProcessVersion();
        }

        private long getCurrentProcessVersion() {
            return this.versionCache.computeIfAbsent((Object)this.processIdKey.toString(), key -> this.getProcessVersionFromDB());
        }

        private long getProcessVersionFromDB() {
            NextValue readValue = (NextValue)this.nextValueColumnFamily.get((DbKey)this.processIdKey);
            long currentValue = this.initialValue;
            if (readValue != null) {
                currentValue = readValue.get();
            }
            return currentValue;
        }

        public void clear() {
            this.versionCache.clear();
        }

        public void insertProcessVersion(String processId, int version) {
            this.processIdKey.wrapString(processId);
            NextValue value = new NextValue();
            value.set((long)version);
            this.nextValueColumnFamily.insert((DbKey)this.processIdKey, (DbValue)value);
        }
    }
}

