/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.util.client;

import io.camunda.zeebe.engine.util.client.CommandWriter;
import io.camunda.zeebe.protocol.impl.encoding.MsgPackConverter;
import io.camunda.zeebe.protocol.impl.record.UnifiedRecordValue;
import io.camunda.zeebe.protocol.impl.record.value.variable.VariableDocumentRecord;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.VariableDocumentIntent;
import io.camunda.zeebe.protocol.record.value.VariableDocumentRecordValue;
import io.camunda.zeebe.protocol.record.value.VariableDocumentUpdateSemantic;
import io.camunda.zeebe.test.util.MsgPackUtil;
import io.camunda.zeebe.test.util.record.RecordingExporter;
import io.camunda.zeebe.test.util.record.VariableDocumentRecordStream;
import java.util.Map;
import java.util.function.LongFunction;
import org.agrona.DirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

public final class VariableClient {
    private static final LongFunction<Record<VariableDocumentRecordValue>> SUCCESSFUL_EXPECTATION_SUPPLIER = sourceRecordPosition -> (Record)((VariableDocumentRecordStream)RecordingExporter.variableDocumentRecords((VariableDocumentIntent)VariableDocumentIntent.UPDATED).withSourceRecordPosition(sourceRecordPosition)).getFirst();
    private static final LongFunction<Record<VariableDocumentRecordValue>> REJECTION_EXPECTATION_SUPPLIER = sourceRecordPosition -> (Record)((VariableDocumentRecordStream)((VariableDocumentRecordStream)RecordingExporter.variableDocumentRecords().onlyCommandRejections()).withSourceRecordPosition(sourceRecordPosition)).getFirst();
    private final VariableDocumentRecord variableDocumentRecord;
    private final CommandWriter writer;
    private LongFunction<Record<VariableDocumentRecordValue>> expectation = SUCCESSFUL_EXPECTATION_SUPPLIER;
    private String[] authorizedTenants = new String[]{"<default>"};

    public VariableClient(CommandWriter writer) {
        this.writer = writer;
        this.variableDocumentRecord = new VariableDocumentRecord();
    }

    public VariableClient ofScope(long scopeKey) {
        this.variableDocumentRecord.setScopeKey(scopeKey);
        return this;
    }

    public VariableClient withDocument(Map<String, Object> variables) {
        UnsafeBuffer serializedVariables = new UnsafeBuffer(MsgPackUtil.asMsgPack(variables).byteArray());
        return this.withDocument((DirectBuffer)serializedVariables);
    }

    public VariableClient withDocument(DirectBuffer variables) {
        this.variableDocumentRecord.setVariables(variables);
        return this;
    }

    public VariableClient withDocument(String variables) {
        return this.withDocument((DirectBuffer)new UnsafeBuffer(MsgPackConverter.convertToMsgPack((String)variables)));
    }

    public VariableClient withUpdateSemantic(VariableDocumentUpdateSemantic semantic) {
        this.variableDocumentRecord.setUpdateSemantics(semantic);
        return this;
    }

    public VariableClient forAuthorizedTenants(String ... authorizedTenants) {
        this.authorizedTenants = authorizedTenants;
        return this;
    }

    public VariableClient expectRejection() {
        this.expectation = REJECTION_EXPECTATION_SUPPLIER;
        return this;
    }

    public Record<VariableDocumentRecordValue> update() {
        long position = this.writer.writeCommand((Intent)VariableDocumentIntent.UPDATE, (UnifiedRecordValue)this.variableDocumentRecord, this.authorizedTenants);
        return this.expectation.apply(position);
    }
}

