/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.metrics;

import io.camunda.zeebe.engine.metrics.JobMetrics;
import io.camunda.zeebe.engine.metrics.MetricsTestHelper;
import io.camunda.zeebe.engine.util.EngineRule;
import io.camunda.zeebe.model.bpmn.Bpmn;
import io.camunda.zeebe.protocol.record.intent.JobIntent;
import io.camunda.zeebe.protocol.record.value.JobBatchRecordValue;
import io.camunda.zeebe.protocol.record.value.JobRecordValue;
import io.camunda.zeebe.test.util.record.RecordingExporter;
import io.camunda.zeebe.test.util.record.RecordingExporterTestWatcher;
import java.time.Duration;
import java.util.Map;
import org.assertj.core.api.AbstractDoubleAssert;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestWatcher;

public class JobMetricsTest {
    @ClassRule
    public static final EngineRule ENGINE = EngineRule.singlePartition();
    private static final String PROCESS_ID = "process";
    private static final String TASK_ID = "task";
    private static final String JOB_TYPE = "job";
    @Rule
    public final TestWatcher watcher = new RecordingExporterTestWatcher();

    @BeforeClass
    public static void deployProcess() {
        ENGINE.deployment().withXmlResource(Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().serviceTask(TASK_ID, t -> t.zeebeJobTypeExpression("jobType")).endEvent().done()).deploy();
    }

    @Before
    public void resetMetrics() {
        JobMetrics.clear();
    }

    @Test
    public void allCountsStartAtNull() {
        Assertions.assertThat((Double)JobMetricsTest.jobMetric("created", JOB_TYPE)).isNull();
        Assertions.assertThat((Double)JobMetricsTest.jobMetric("activated", JOB_TYPE)).isNull();
        Assertions.assertThat((Double)JobMetricsTest.jobMetric("timed out", JOB_TYPE)).isNull();
        Assertions.assertThat((Double)JobMetricsTest.jobMetric("completed", JOB_TYPE)).isNull();
        Assertions.assertThat((Double)JobMetricsTest.jobMetric("failed", JOB_TYPE)).isNull();
        Assertions.assertThat((Double)JobMetricsTest.jobMetric("canceled", JOB_TYPE)).isNull();
        Assertions.assertThat((Double)JobMetricsTest.jobMetric("error thrown", JOB_TYPE)).isNull();
    }

    @Test
    public void shouldCountCreated() {
        JobMetricsTest.createProcessInstanceWithJob(JOB_TYPE);
        ((AbstractDoubleAssert)Assertions.assertThat((Double)JobMetricsTest.jobMetric("created", JOB_TYPE)).isNotNull()).isEqualTo(1.0);
    }

    @Test
    public void shouldCountActivated() {
        String jobType = "job_activated";
        JobMetricsTest.createProcessInstanceWithJob("job_activated");
        ENGINE.jobs().withType("job_activated").activate();
        ((AbstractDoubleAssert)Assertions.assertThat((Double)JobMetricsTest.jobMetric("activated", "job_activated")).isNotNull()).isEqualTo(1.0);
    }

    @Test
    public void shouldCountTimedOut() {
        long processInstanceKey = JobMetricsTest.createProcessInstanceWithJob(JOB_TYPE);
        Duration timeout = Duration.ofMinutes(10L);
        JobRecordValue jobRecord = (JobRecordValue)((JobBatchRecordValue)ENGINE.jobs().withType(JOB_TYPE).withTimeout(timeout.toMillis()).activate().getValue()).getJobs().get(0);
        ENGINE.getClock().addTime(Duration.ofMillis(jobRecord.getDeadline() - ENGINE.getClock().getCurrentTimeInMillis() + 1L));
        RecordingExporter.jobRecords((JobIntent)JobIntent.TIMED_OUT).withProcessInstanceKey(processInstanceKey).await();
        ((AbstractDoubleAssert)Assertions.assertThat((Double)JobMetricsTest.jobMetric("timed out", JOB_TYPE)).isNotNull()).isEqualTo(1.0);
    }

    @Test
    public void shouldCountCompleted() {
        long processInstanceKey = JobMetricsTest.createProcessInstanceWithJob(JOB_TYPE);
        ENGINE.job().ofInstance(processInstanceKey).withType(JOB_TYPE).complete();
        ((AbstractDoubleAssert)Assertions.assertThat((Double)JobMetricsTest.jobMetric("completed", JOB_TYPE)).isNotNull()).isEqualTo(1.0);
    }

    @Test
    public void shouldCountFailed() {
        long processInstanceKey = JobMetricsTest.createProcessInstanceWithJob(JOB_TYPE);
        ENGINE.job().ofInstance(processInstanceKey).withType(JOB_TYPE).fail();
        ((AbstractDoubleAssert)Assertions.assertThat((Double)JobMetricsTest.jobMetric("failed", JOB_TYPE)).isNotNull()).isEqualTo(1.0);
    }

    @Test
    public void shouldCountCanceled() {
        long processInstanceKey = JobMetricsTest.createProcessInstanceWithJob(JOB_TYPE);
        ENGINE.processInstance().withInstanceKey(processInstanceKey).cancel();
        RecordingExporter.jobRecords((JobIntent)JobIntent.CANCELED).withProcessInstanceKey(processInstanceKey).await();
        ((AbstractDoubleAssert)Assertions.assertThat((Double)JobMetricsTest.jobMetric("canceled", JOB_TYPE)).isNotNull()).isEqualTo(1.0);
    }

    @Test
    public void shouldCountErrorThrown() {
        long processInstanceKey = JobMetricsTest.createProcessInstanceWithJob(JOB_TYPE);
        ENGINE.job().ofInstance(processInstanceKey).withType(JOB_TYPE).throwError();
        ((AbstractDoubleAssert)Assertions.assertThat((Double)JobMetricsTest.jobMetric("error thrown", JOB_TYPE)).isNotNull()).isEqualTo(1.0);
    }

    private static long createProcessInstanceWithJob(String jobType) {
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).withVariable("jobType", jobType).create();
        RecordingExporter.jobRecords((JobIntent)JobIntent.CREATED).withProcessInstanceKey(processInstanceKey).await();
        return processInstanceKey;
    }

    private static Double jobMetric(String action, String type) {
        return MetricsTestHelper.readMetricValue("zeebe_job_events_total", Map.entry("action", action), Map.entry("partition", "1"), Map.entry("type", type));
    }
}

