/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.perf;

import io.camunda.zeebe.engine.perf.TestEngine;
import io.camunda.zeebe.engine.util.client.ProcessInstanceClient;
import io.camunda.zeebe.model.bpmn.Bpmn;
import io.camunda.zeebe.model.bpmn.builder.ServiceTaskBuilder;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.JobIntent;
import io.camunda.zeebe.scheduler.ActorScheduler;
import io.camunda.zeebe.scheduler.clock.ActorClock;
import io.camunda.zeebe.scheduler.clock.DefaultActorClock;
import io.camunda.zeebe.test.util.AutoCloseableRule;
import io.camunda.zeebe.test.util.jmh.JMHAssert;
import io.camunda.zeebe.test.util.jmh.JMHTestCase;
import io.camunda.zeebe.test.util.junit.JMHTest;
import io.camunda.zeebe.test.util.record.JobRecordStream;
import io.camunda.zeebe.test.util.record.RecordingExporter;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.junit.rules.TemporaryFolder;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;
import org.openjdk.jmh.annotations.Warmup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Warmup(iterations=100, time=1, timeUnit=TimeUnit.SECONDS)
@Measurement(iterations=50, time=1, timeUnit=TimeUnit.SECONDS)
@Fork(value=1, jvmArgs={"-Xmx4g", "-Xms4g"})
@BenchmarkMode(value={Mode.Throughput})
@OutputTimeUnit(value=TimeUnit.SECONDS)
@State(value=Scope.Benchmark)
public class EngineLargeStatePerformanceTest {
    public static final Logger LOG = LoggerFactory.getLogger((String)EngineLargeStatePerformanceTest.class.getName());
    private long count;
    private ProcessInstanceClient processInstanceClient;
    private TestEngine.TestContext testContext;
    private TestEngine singlePartitionEngine;

    @Setup
    public void setup() throws Throwable {
        this.testContext = this.createTestContext();
        this.singlePartitionEngine = TestEngine.createSinglePartitionEngine(this.testContext);
        this.setupState(this.singlePartitionEngine);
    }

    private void setupState(TestEngine singlePartitionEngine) {
        singlePartitionEngine.createDeploymentClient().withXmlResource(Bpmn.createExecutableProcess((String)"process").startEvent().serviceTask("task", t -> ((ServiceTaskBuilder)t.zeebeJobType("task")).done()).endEvent().done()).deploy();
        this.processInstanceClient = singlePartitionEngine.createProcessInstanceClient();
        int maxInstanceCount = 200000;
        LOG.info("Starting {} process instances, please hold the line...", (Object)200000);
        for (int i = 0; i < 200000; ++i) {
            this.processInstanceClient.ofBpmnProcessId("process").create();
            ++this.count;
            RecordingExporter.reset();
            if (i % 10000 != 0) continue;
            LOG.info("\t{} process instances already started.", (Object)i);
            singlePartitionEngine.reset();
        }
        LOG.info("Started {} process instances.", (Object)this.count);
    }

    private TestEngine.TestContext createTestContext() throws IOException {
        AutoCloseableRule autoCloseableRule = new AutoCloseableRule();
        TemporaryFolder temporaryFolder = new TemporaryFolder();
        temporaryFolder.create();
        ActorScheduler.ActorSchedulerBuilder builder = ActorScheduler.newActorScheduler().setCpuBoundActorThreadCount(1).setIoBoundActorThreadCount(1).setActorClock((ActorClock)new DefaultActorClock());
        ActorScheduler actorScheduler = builder.build();
        autoCloseableRule.manage((AutoCloseable)actorScheduler);
        actorScheduler.start();
        return new TestEngine.TestContext(actorScheduler, temporaryFolder, autoCloseableRule);
    }

    @TearDown
    public void tearDown() {
        LOG.info("Started {} process instances", (Object)this.count);
        this.testContext.autoCloseableRule().after();
    }

    @Benchmark
    public Record<?> measureProcessExecutionTime() {
        long piKey = this.processInstanceClient.ofBpmnProcessId("process").create();
        Record task = (Record)((JobRecordStream)RecordingExporter.jobRecords().withIntent((Intent)JobIntent.CREATED)).withType("task").withProcessInstanceKey(piKey).getFirst();
        ++this.count;
        this.singlePartitionEngine.reset();
        return task;
    }

    @JMHTest(value="measureProcessExecutionTime")
    void shouldProcessWithinExpectedDeviation(JMHTestCase testCase) {
        int referenceScore = 1000;
        JMHAssert assertResult = testCase.run();
        assertResult.isAtLeast(1000.0, 0.25);
    }
}

