/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.perf;

import io.camunda.zeebe.engine.processing.EngineProcessors;
import io.camunda.zeebe.engine.processing.message.command.SubscriptionCommandSender;
import io.camunda.zeebe.engine.processing.streamprocessor.JobStreamer;
import io.camunda.zeebe.engine.processing.streamprocessor.TypedRecordProcessorContext;
import io.camunda.zeebe.engine.state.DefaultZeebeDbFactory;
import io.camunda.zeebe.engine.util.ProcessingExporterTransistor;
import io.camunda.zeebe.engine.util.StreamProcessingComposite;
import io.camunda.zeebe.engine.util.TestInterPartitionCommandSender;
import io.camunda.zeebe.engine.util.TestStreams;
import io.camunda.zeebe.engine.util.client.DeploymentClient;
import io.camunda.zeebe.engine.util.client.ProcessInstanceClient;
import io.camunda.zeebe.scheduler.ActorScheduler;
import io.camunda.zeebe.stream.api.InterPartitionCommandSender;
import io.camunda.zeebe.stream.api.StreamProcessorLifecycleAware;
import io.camunda.zeebe.stream.impl.StreamProcessorMode;
import io.camunda.zeebe.test.util.AutoCloseableRule;
import io.camunda.zeebe.test.util.record.RecordingExporter;
import io.camunda.zeebe.util.FeatureFlags;
import java.util.ArrayList;
import java.util.Optional;
import org.junit.rules.TemporaryFolder;

public final class TestEngine {
    private final StreamProcessingComposite streamProcessingComposite;
    private final TestStreams testStreams;
    private final int partitionCount;

    private TestEngine(int partitionId, int partitionCount, TestContext testContext) {
        this.partitionCount = partitionCount;
        this.testStreams = new TestStreams(testContext.temporaryFolder(), testContext.autoCloseableRule(), testContext.actorScheduler());
        this.testStreams.withStreamProcessorMode(StreamProcessorMode.PROCESSING);
        this.testStreams.maxCommandsInBatch(100);
        testContext.autoCloseableRule().manage((AutoCloseable)this.testStreams.createLogStream(StreamProcessingComposite.getLogName(partitionId), partitionId));
        this.streamProcessingComposite = new StreamProcessingComposite(this.testStreams, partitionId, DefaultZeebeDbFactory.defaultFactory(), testContext.actorScheduler());
        ArrayList<TestInterPartitionCommandSender> interPartitionCommandSenders = new ArrayList<TestInterPartitionCommandSender>();
        FeatureFlags featureFlags = FeatureFlags.createDefaultForTests();
        TestInterPartitionCommandSender interPartitionCommandSender = new TestInterPartitionCommandSender(this.streamProcessingComposite::newLogStreamWriter);
        interPartitionCommandSenders.add(interPartitionCommandSender);
        testContext.autoCloseableRule().manage((AutoCloseable)this.streamProcessingComposite.startTypedStreamProcessor(partitionId, recordProcessorContext -> EngineProcessors.createEngineProcessors((TypedRecordProcessorContext)recordProcessorContext, (int)partitionCount, (SubscriptionCommandSender)new SubscriptionCommandSender(partitionId, (InterPartitionCommandSender)interPartitionCommandSender), (InterPartitionCommandSender)interPartitionCommandSender, (FeatureFlags)featureFlags, (JobStreamer)JobStreamer.noop()).withListener((StreamProcessorLifecycleAware)new ProcessingExporterTransistor(this.testStreams.getLogStream(StreamProcessingComposite.getLogName(partitionId)))), Optional.empty()));
        interPartitionCommandSenders.forEach(s -> s.initializeWriters(partitionCount));
    }

    public DeploymentClient createDeploymentClient() {
        return new DeploymentClient(this.streamProcessingComposite, p -> p.accept(1), this.partitionCount);
    }

    public ProcessInstanceClient createProcessInstanceClient() {
        return new ProcessInstanceClient(this.streamProcessingComposite);
    }

    public static TestEngine createSinglePartitionEngine(TestContext testContext) {
        return new TestEngine(1, 1, testContext);
    }

    public void reset() {
        RecordingExporter.reset();
        this.testStreams.resetLog();
    }

    public record TestContext(ActorScheduler actorScheduler, TemporaryFolder temporaryFolder, AutoCloseableRule autoCloseableRule) {
    }
}

