/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.bpmn;

import io.camunda.zeebe.engine.util.EngineRule;
import io.camunda.zeebe.model.bpmn.Bpmn;
import io.camunda.zeebe.model.bpmn.BpmnModelInstance;
import io.camunda.zeebe.model.bpmn.builder.BoundaryEventBuilder;
import io.camunda.zeebe.model.bpmn.builder.ExclusiveGatewayBuilder;
import io.camunda.zeebe.model.bpmn.builder.IntermediateCatchEventBuilder;
import io.camunda.zeebe.model.bpmn.builder.ReceiveTaskBuilder;
import io.camunda.zeebe.model.bpmn.builder.StartEventBuilder;
import io.camunda.zeebe.protocol.record.intent.MessageStartEventSubscriptionIntent;
import io.camunda.zeebe.protocol.record.value.BpmnElementType;
import io.camunda.zeebe.protocol.record.value.ProcessInstanceRecordValue;
import io.camunda.zeebe.test.util.Strings;
import io.camunda.zeebe.test.util.record.RecordingExporter;
import io.camunda.zeebe.test.util.record.RecordingExporterTestWatcher;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.assertj.core.api.AbstractListAssert;
import org.assertj.core.api.Assertions;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public final class BpmnElementTypeTest {
    @ClassRule
    public static final EngineRule ENGINE = EngineRule.singlePartition();
    private static final List<BpmnElementTypeScenario> SCENARIOS = Arrays.asList(new BpmnElementTypeScenario("Process", BpmnElementType.PROCESS){

        @Override
        BpmnModelInstance modelInstance() {
            return Bpmn.createExecutableProcess((String)this.processId()).startEvent().done();
        }

        @Override
        String elementId() {
            return this.processId();
        }
    }, new BpmnElementTypeScenario("Sub Process", BpmnElementType.SUB_PROCESS){

        @Override
        BpmnModelInstance modelInstance() {
            return Bpmn.createExecutableProcess((String)this.processId()).startEvent().subProcess(this.elementId()).embeddedSubProcess().startEvent().subProcessDone().done();
        }
    }, new BpmnElementTypeScenario("None Start Event", BpmnElementType.START_EVENT){

        @Override
        public BpmnModelInstance modelInstance() {
            return Bpmn.createExecutableProcess((String)this.processId()).startEvent(this.elementId()).done();
        }
    }, new BpmnElementTypeScenario("Message Start Event", BpmnElementType.START_EVENT){

        @Override
        public BpmnModelInstance modelInstance() {
            return ((StartEventBuilder)Bpmn.createExecutableProcess((String)this.processId()).startEvent(this.elementId()).message(this.messageName())).done();
        }

        @Override
        public void test() {
            RecordingExporter.messageStartEventSubscriptionRecords((MessageStartEventSubscriptionIntent)MessageStartEventSubscriptionIntent.CREATED).getFirst();
            ENGINE.message().withName(this.messageName()).withCorrelationKey("id").publish();
        }
    }, new BpmnElementTypeScenario("Timer Start Event", BpmnElementType.START_EVENT){

        @Override
        BpmnModelInstance modelInstance() {
            return ((StartEventBuilder)Bpmn.createExecutableProcess((String)this.processId()).startEvent(this.elementId()).timerWithCycle("R1/PT0.01S")).done();
        }

        @Override
        void test() {
            ENGINE.increaseTime(Duration.ofMinutes(1L));
        }
    }, new BpmnElementTypeScenario("Intermediate Message Catch Event", BpmnElementType.INTERMEDIATE_CATCH_EVENT){

        @Override
        BpmnModelInstance modelInstance() {
            return ((IntermediateCatchEventBuilder)Bpmn.createExecutableProcess((String)this.processId()).startEvent().intermediateCatchEvent(this.elementId()).message(b -> b.name(this.messageName()).zeebeCorrelationKeyExpression("id"))).done();
        }

        @Override
        void test() {
            super.executeInstance(Collections.singletonMap("id", "test"));
            ENGINE.message().withName(this.messageName()).withCorrelationKey("test").publish();
        }
    }, new BpmnElementTypeScenario("Intermediate Timer Catch Event", BpmnElementType.INTERMEDIATE_CATCH_EVENT){

        @Override
        BpmnModelInstance modelInstance() {
            return ((IntermediateCatchEventBuilder)Bpmn.createExecutableProcess((String)this.processId()).startEvent().intermediateCatchEvent(this.elementId()).timerWithDuration("PT0.01S")).done();
        }
    }, new BpmnElementTypeScenario("Intermediate Catch Event After Event Based Gateway", BpmnElementType.INTERMEDIATE_CATCH_EVENT){

        @Override
        BpmnModelInstance modelInstance() {
            return ((IntermediateCatchEventBuilder)((IntermediateCatchEventBuilder)Bpmn.createExecutableProcess((String)this.processId()).startEvent().eventBasedGateway().intermediateCatchEvent(this.elementId()).timerWithDuration("PT0.01S")).endEvent().moveToLastGateway().intermediateCatchEvent().timerWithDuration("PT1H")).endEvent().done();
        }
    }, new BpmnElementTypeScenario("Message Boundary Event", BpmnElementType.BOUNDARY_EVENT){

        @Override
        BpmnModelInstance modelInstance() {
            return ((BoundaryEventBuilder)Bpmn.createExecutableProcess((String)this.processId()).startEvent().serviceTask("task", b -> b.zeebeJobType(this.taskType())).boundaryEvent(this.elementId()).message(b -> b.name(this.messageName()).zeebeCorrelationKeyExpression("id"))).endEvent().done();
        }

        @Override
        void test() {
            super.executeInstance(Collections.singletonMap("id", "test"));
            ENGINE.message().withName(this.messageName()).withCorrelationKey("test").publish();
        }
    }, new BpmnElementTypeScenario("Timer Boundary Event", BpmnElementType.BOUNDARY_EVENT){

        @Override
        BpmnModelInstance modelInstance() {
            return ((BoundaryEventBuilder)Bpmn.createExecutableProcess((String)this.processId()).startEvent().serviceTask("task", b -> b.zeebeJobType(this.taskType())).boundaryEvent(this.elementId()).timerWithDuration("PT0.01S")).endEvent().done();
        }
    }, new BpmnElementTypeScenario("End Event", BpmnElementType.END_EVENT){

        @Override
        BpmnModelInstance modelInstance() {
            return Bpmn.createExecutableProcess((String)this.processId()).startEvent().endEvent(this.elementId()).done();
        }
    }, new BpmnElementTypeScenario("Service Task", BpmnElementType.SERVICE_TASK){

        @Override
        BpmnModelInstance modelInstance() {
            return Bpmn.createExecutableProcess((String)this.processId()).startEvent().serviceTask(this.elementId(), b -> b.zeebeJobType(this.taskType())).done();
        }

        @Override
        void test() {
            long processInstanceKey = super.executeInstance();
            ENGINE.job().ofInstance(processInstanceKey).withType(this.taskType()).complete();
        }
    }, new BpmnElementTypeScenario("Business Rule Task", BpmnElementType.BUSINESS_RULE_TASK){

        @Override
        BpmnModelInstance modelInstance() {
            return Bpmn.createExecutableProcess((String)this.processId()).startEvent().businessRuleTask(this.elementId(), b -> b.zeebeJobType(this.taskType())).done();
        }

        @Override
        void test() {
            long processInstanceKey = super.executeInstance();
            ENGINE.job().ofInstance(processInstanceKey).withType(this.taskType()).complete();
        }
    }, new BpmnElementTypeScenario("Script Task", BpmnElementType.SCRIPT_TASK){

        @Override
        BpmnModelInstance modelInstance() {
            return Bpmn.createExecutableProcess((String)this.processId()).startEvent().scriptTask(this.elementId(), b -> b.zeebeJobType(this.taskType())).done();
        }

        @Override
        void test() {
            long processInstanceKey = super.executeInstance();
            ENGINE.job().ofInstance(processInstanceKey).withType(this.taskType()).complete();
        }
    }, new BpmnElementTypeScenario("Send Task", BpmnElementType.SEND_TASK){

        @Override
        BpmnModelInstance modelInstance() {
            return Bpmn.createExecutableProcess((String)this.processId()).startEvent().sendTask(this.elementId(), b -> b.zeebeJobType(this.taskType())).done();
        }

        @Override
        void test() {
            long processInstanceKey = super.executeInstance();
            ENGINE.job().ofInstance(processInstanceKey).withType(this.taskType()).complete();
        }
    }, new BpmnElementTypeScenario("User Task", BpmnElementType.USER_TASK){

        @Override
        BpmnModelInstance modelInstance() {
            return Bpmn.createExecutableProcess((String)this.processId()).startEvent().userTask(this.elementId()).done();
        }

        @Override
        void test() {
            long processInstanceKey = super.executeInstance();
            ENGINE.job().ofInstance(processInstanceKey).withType("io.camunda.zeebe:userTask").complete();
        }
    }, new BpmnElementTypeScenario("Receive Task", BpmnElementType.RECEIVE_TASK){

        @Override
        BpmnModelInstance modelInstance() {
            return ((ReceiveTaskBuilder)Bpmn.createExecutableProcess((String)this.processId()).startEvent().receiveTask(this.elementId()).message(b -> b.name(this.messageName()).zeebeCorrelationKeyExpression("id"))).done();
        }

        @Override
        void test() {
            this.executeInstance(Collections.singletonMap("id", "test"));
            ENGINE.message().withName(this.messageName()).withCorrelationKey("test").publish();
        }
    }, new BpmnElementTypeScenario("Exclusive Gateway", BpmnElementType.EXCLUSIVE_GATEWAY){

        @Override
        BpmnModelInstance modelInstance() {
            return ((ExclusiveGatewayBuilder)Bpmn.createExecutableProcess((String)this.processId()).startEvent().exclusiveGateway(this.elementId()).defaultFlow()).endEvent().done();
        }
    }, new BpmnElementTypeScenario("Sequence Flow After Exclusive Gateway", BpmnElementType.SEQUENCE_FLOW){

        @Override
        BpmnModelInstance modelInstance() {
            return ((ExclusiveGatewayBuilder)((ExclusiveGatewayBuilder)Bpmn.createExecutableProcess((String)this.processId()).startEvent().exclusiveGateway().conditionExpression("5 > 1")).sequenceFlowId(this.elementId())).endEvent().moveToLastExclusiveGateway().defaultFlow().endEvent().done();
        }
    }, new BpmnElementTypeScenario("Event Based Gateway", BpmnElementType.EVENT_BASED_GATEWAY){

        @Override
        BpmnModelInstance modelInstance() {
            return ((IntermediateCatchEventBuilder)((IntermediateCatchEventBuilder)Bpmn.createExecutableProcess((String)this.processId()).startEvent().eventBasedGateway(this.elementId()).intermediateCatchEvent().message(b -> b.name(this.messageName()).zeebeCorrelationKeyExpression("id"))).moveToLastGateway().intermediateCatchEvent().timerWithDuration("PT0.01S")).done();
        }

        @Override
        void test() {
            this.executeInstance(Collections.singletonMap("id", "test"));
            ENGINE.message().withName(this.messageName()).withCorrelationKey("test").publish();
        }
    }, new BpmnElementTypeScenario("Parallel Gateway", BpmnElementType.PARALLEL_GATEWAY){

        @Override
        BpmnModelInstance modelInstance() {
            return Bpmn.createExecutableProcess((String)this.processId()).startEvent().parallelGateway(this.elementId()).endEvent().done();
        }
    }, new BpmnElementTypeScenario("Sequence Flow", BpmnElementType.SEQUENCE_FLOW){

        @Override
        BpmnModelInstance modelInstance() {
            return ((StartEventBuilder)Bpmn.createExecutableProcess((String)this.processId()).startEvent().sequenceFlowId(this.elementId())).endEvent().done();
        }
    }, new BpmnElementTypeScenario("Event Subprocess", BpmnElementType.EVENT_SUB_PROCESS){

        @Override
        BpmnModelInstance modelInstance() {
            return Bpmn.createExecutableProcess((String)this.processId()).eventSubProcess(this.elementId(), eventSubProcess -> ((StartEventBuilder)eventSubProcess.startEvent().timerWithDuration("PT0S")).endEvent()).startEvent().serviceTask("task", t -> t.zeebeJobType("test")).endEvent().done();
        }
    }, new BpmnElementTypeScenario("Intermediate throw event", BpmnElementType.INTERMEDIATE_THROW_EVENT){

        @Override
        BpmnModelInstance modelInstance() {
            return Bpmn.createExecutableProcess((String)this.processId()).startEvent().intermediateThrowEvent(this.elementId()).endEvent().done();
        }
    }, new BpmnElementTypeScenario("Manual Task", BpmnElementType.MANUAL_TASK){

        @Override
        BpmnModelInstance modelInstance() {
            return Bpmn.createExecutableProcess((String)this.processId()).startEvent().manualTask(this.elementId()).endEvent().done();
        }
    }, new BpmnElementTypeScenario("Undefined Task", BpmnElementType.TASK){

        @Override
        BpmnModelInstance modelInstance() {
            return Bpmn.createExecutableProcess((String)this.processId()).startEvent().task(this.elementId()).endEvent().done();
        }
    });
    @Rule
    public final RecordingExporterTestWatcher recordingExporterTestWatcher = new RecordingExporterTestWatcher();
    private final BpmnElementTypeScenario scenario;

    public BpmnElementTypeTest(BpmnElementTypeScenario scenario) {
        this.scenario = scenario;
    }

    /*
     * Exception decompiling
     */
    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> scenarios() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredReturn.rewriteExpressions(StructuredReturn.java:99)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Test
    public void test() {
        ENGINE.deployment().withXmlResource(this.scenario.modelInstance()).deploy();
        this.scenario.test();
        List records = RecordingExporter.processInstanceRecords().withBpmnProcessId(this.scenario.processId()).limitToProcessInstanceCompleted().withElementId(this.scenario.elementId()).asList();
        ((AbstractListAssert)Assertions.assertThat((List)records).extracting(r -> ((ProcessInstanceRecordValue)r.getValue()).getBpmnElementType()).isNotEmpty()).containsOnly((Object[])new BpmnElementType[]{this.scenario.elementType()});
    }

    static abstract class BpmnElementTypeScenario {
        private final String name;
        private final BpmnElementType elementType;
        private final String processId = Strings.newRandomValidBpmnId();
        private final String elementId = Strings.newRandomValidBpmnId();
        private final String taskType = Strings.newRandomValidBpmnId();
        private final String messageName = Strings.newRandomValidBpmnId();

        BpmnElementTypeScenario(String name, BpmnElementType elementType) {
            this.name = name;
            this.elementType = elementType;
        }

        String name() {
            return this.name;
        }

        abstract BpmnModelInstance modelInstance();

        String processId() {
            return this.processId;
        }

        String elementId() {
            return this.elementId;
        }

        String taskType() {
            return this.taskType;
        }

        String messageName() {
            return this.messageName;
        }

        BpmnElementType elementType() {
            return this.elementType;
        }

        void test() {
            this.executeInstance();
        }

        long executeInstance() {
            return ENGINE.processInstance().ofBpmnProcessId(this.processId()).create();
        }

        long executeInstance(Map<String, String> variables) {
            String json = "{ " + variables.entrySet().stream().map(e -> String.format("\"%s\":\"%s\"", e.getKey(), e.getValue())).collect(Collectors.joining(",")) + " }";
            return ENGINE.processInstance().ofBpmnProcessId(this.processId()).withVariables(json).create();
        }

        public String toString() {
            return this.name();
        }
    }
}

