/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.bpmn.activity;

import io.camunda.zeebe.engine.util.EngineRule;
import io.camunda.zeebe.model.bpmn.Bpmn;
import io.camunda.zeebe.model.bpmn.BpmnModelInstance;
import io.camunda.zeebe.model.bpmn.builder.BusinessRuleTaskBuilder;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.RecordType;
import io.camunda.zeebe.protocol.record.ValueType;
import io.camunda.zeebe.protocol.record.intent.DecisionEvaluationIntent;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceIntent;
import io.camunda.zeebe.protocol.record.intent.VariableIntent;
import io.camunda.zeebe.protocol.record.value.BpmnElementType;
import io.camunda.zeebe.protocol.record.value.DecisionEvaluationRecordValue;
import io.camunda.zeebe.protocol.record.value.DeploymentRecordValue;
import io.camunda.zeebe.protocol.record.value.EvaluatedDecisionValue;
import io.camunda.zeebe.protocol.record.value.EvaluatedInputValue;
import io.camunda.zeebe.protocol.record.value.EvaluatedOutputValue;
import io.camunda.zeebe.protocol.record.value.MatchedRuleValue;
import io.camunda.zeebe.protocol.record.value.ProcessInstanceRecordValue;
import io.camunda.zeebe.protocol.record.value.VariableRecordValue;
import io.camunda.zeebe.protocol.record.value.deployment.DecisionRecordValue;
import io.camunda.zeebe.protocol.record.value.deployment.DecisionRequirementsMetadataValue;
import io.camunda.zeebe.test.util.record.ProcessInstanceRecordStream;
import io.camunda.zeebe.test.util.record.RecordingExporter;
import io.camunda.zeebe.test.util.record.RecordingExporterTestWatcher;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractListAssert;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.ThrowingConsumer;
import org.assertj.core.groups.Tuple;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

public final class BusinessRuleTaskTest {
    @ClassRule
    public static final EngineRule ENGINE = EngineRule.singlePartition();
    private static final String DMN_RESOURCE = "/dmn/drg-force-user.dmn";
    private static final String DMN_WITH_ASSERTION = "/dmn/drg-force-user-with-assertions.dmn";
    private static final String DMN_RESOURCE_WITH_NAMELESS_OUTPUTS = "/dmn/drg-force-user-nameless-input-outputs.dmn";
    private static final String DMN_DECISION_TABLE = "/dmn/decision-table.dmn";
    private static final String DMN_DECISION_TABLE_RENAMED_DRG = "/dmn/decision-table-with-renamed-drg.dmn";
    private static final String PROCESS_ID = "process";
    private static final String TASK_ID = "task";
    private static final String RESULT_VARIABLE = "result";
    private static final String OUTPUT_TARGET = "output";
    @Rule
    public final RecordingExporterTestWatcher watcher = new RecordingExporterTestWatcher();

    private static BpmnModelInstance processWithBusinessRuleTask(Consumer<BusinessRuleTaskBuilder> modifier) {
        return Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().businessRuleTask(TASK_ID, modifier).done();
    }

    @Test
    public void shouldActivateTask() {
        ENGINE.deployment().withXmlClasspathResource(DMN_RESOURCE).withXmlResource(BusinessRuleTaskTest.processWithBusinessRuleTask(t -> ((BusinessRuleTaskBuilder)t.zeebeCalledDecisionId("jedi_or_sith")).zeebeResultVariable(RESULT_VARIABLE))).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).withVariable("lightsaberColor", "blue").create();
        Assertions.assertThat((Stream)RecordingExporter.processInstanceRecords().withProcessInstanceKey(processInstanceKey).withElementType(BpmnElementType.BUSINESS_RULE_TASK).limit(3L)).extracting(new Function[]{Record::getRecordType, Record::getIntent}).containsSequence((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{RecordType.COMMAND, ProcessInstanceIntent.ACTIVATE_ELEMENT}), Assertions.tuple((Object[])new Object[]{RecordType.EVENT, ProcessInstanceIntent.ELEMENT_ACTIVATING}), Assertions.tuple((Object[])new Object[]{RecordType.EVENT, ProcessInstanceIntent.ELEMENT_ACTIVATED})});
        Record taskActivating = (Record)((ProcessInstanceRecordStream)RecordingExporter.processInstanceRecords().withProcessInstanceKey(processInstanceKey).withIntent((Intent)ProcessInstanceIntent.ELEMENT_ACTIVATING)).withElementType(BpmnElementType.BUSINESS_RULE_TASK).getFirst();
        io.camunda.zeebe.protocol.record.Assertions.assertThat((ProcessInstanceRecordValue)((ProcessInstanceRecordValue)taskActivating.getValue())).hasElementId(TASK_ID).hasBpmnElementType(BpmnElementType.BUSINESS_RULE_TASK).hasFlowScopeKey(processInstanceKey).hasBpmnProcessId(PROCESS_ID).hasProcessInstanceKey(processInstanceKey).hasTenantId("<default>");
    }

    @Test
    public void shouldActivateTaskWithCustomTenant() {
        String tenantId = "foo";
        ENGINE.deployment().withXmlClasspathResource(DMN_RESOURCE).withXmlResource(BusinessRuleTaskTest.processWithBusinessRuleTask(t -> ((BusinessRuleTaskBuilder)t.zeebeCalledDecisionId("jedi_or_sith")).zeebeResultVariable(RESULT_VARIABLE))).withTenantId("foo").deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).withVariable("lightsaberColor", "blue").withTenantId("foo").create();
        Record taskActivating = (Record)((ProcessInstanceRecordStream)RecordingExporter.processInstanceRecords().withProcessInstanceKey(processInstanceKey).withIntent((Intent)ProcessInstanceIntent.ELEMENT_ACTIVATING)).withElementType(BpmnElementType.BUSINESS_RULE_TASK).getFirst();
        io.camunda.zeebe.protocol.record.Assertions.assertThat((ProcessInstanceRecordValue)((ProcessInstanceRecordValue)taskActivating.getValue())).hasElementId(TASK_ID).hasBpmnElementType(BpmnElementType.BUSINESS_RULE_TASK).hasFlowScopeKey(processInstanceKey).hasBpmnProcessId(PROCESS_ID).hasProcessInstanceKey(processInstanceKey).hasTenantId("foo");
    }

    @Test
    public void shouldCompleteTask() {
        ENGINE.deployment().withXmlClasspathResource(DMN_RESOURCE).withXmlResource(BusinessRuleTaskTest.processWithBusinessRuleTask(t -> ((BusinessRuleTaskBuilder)t.zeebeCalledDecisionId("jedi_or_sith")).zeebeResultVariable(RESULT_VARIABLE))).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).withVariable("lightsaberColor", "blue").create();
        Assertions.assertThat((Stream)RecordingExporter.processInstanceRecords().withProcessInstanceKey(processInstanceKey).limitToProcessInstanceCompleted()).extracting(new Function[]{r -> ((ProcessInstanceRecordValue)r.getValue()).getBpmnElementType(), Record::getIntent}).containsSubsequence((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{BpmnElementType.BUSINESS_RULE_TASK, ProcessInstanceIntent.ELEMENT_COMPLETING}), Assertions.tuple((Object[])new Object[]{BpmnElementType.BUSINESS_RULE_TASK, ProcessInstanceIntent.ELEMENT_COMPLETED}), Assertions.tuple((Object[])new Object[]{BpmnElementType.PROCESS, ProcessInstanceIntent.ELEMENT_COMPLETED})});
    }

    @Test
    public void shouldWriteResultAsProcessInstanceVariable() {
        ENGINE.deployment().withXmlClasspathResource(DMN_RESOURCE).withXmlResource(BusinessRuleTaskTest.processWithBusinessRuleTask(t -> ((BusinessRuleTaskBuilder)t.zeebeCalledDecisionId("jedi_or_sith")).zeebeResultVariable(RESULT_VARIABLE))).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).withVariable("lightsaberColor", "blue").create();
        Assertions.assertThat((Object)((Record)RecordingExporter.variableRecords((VariableIntent)VariableIntent.CREATED).withProcessInstanceKey(processInstanceKey).withName(RESULT_VARIABLE).getFirst())).extracting(Record::getValue).extracting(new Function[]{VariableRecordValue::getScopeKey, VariableRecordValue::getValue}).containsExactly(new Object[]{processInstanceKey, "\"Jedi\""});
    }

    @Test
    public void shouldUseResultInOutputMappings() {
        ENGINE.deployment().withXmlClasspathResource(DMN_RESOURCE).withXmlResource(BusinessRuleTaskTest.processWithBusinessRuleTask(t -> ((BusinessRuleTaskBuilder)((BusinessRuleTaskBuilder)t.zeebeCalledDecisionId("jedi_or_sith")).zeebeResultVariable(RESULT_VARIABLE)).zeebeOutputExpression(RESULT_VARIABLE, OUTPUT_TARGET))).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).withVariable("lightsaberColor", "blue").create();
        long taskInstanceKey = ((Record)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATED).withProcessInstanceKey(processInstanceKey).withElementType(BpmnElementType.BUSINESS_RULE_TASK).getFirst()).getKey();
        Assertions.assertThat((Object)((Record)RecordingExporter.variableRecords((VariableIntent)VariableIntent.CREATED).withProcessInstanceKey(processInstanceKey).withName(RESULT_VARIABLE).getFirst())).extracting(Record::getValue).extracting(new Function[]{VariableRecordValue::getScopeKey, VariableRecordValue::getValue}).containsExactly(new Object[]{taskInstanceKey, "\"Jedi\""});
        Assertions.assertThat((Object)((Record)RecordingExporter.variableRecords((VariableIntent)VariableIntent.CREATED).withProcessInstanceKey(processInstanceKey).withName(OUTPUT_TARGET).getFirst())).extracting(Record::getValue).extracting(new Function[]{VariableRecordValue::getScopeKey, VariableRecordValue::getValue}).containsExactly(new Object[]{processInstanceKey, "\"Jedi\""});
    }

    @Test
    public void shouldWriteDecisionEvaluationEvent() {
        Record<DeploymentRecordValue> deployment = ENGINE.deployment().withXmlClasspathResource(DMN_RESOURCE).withXmlResource(BusinessRuleTaskTest.processWithBusinessRuleTask(t -> ((BusinessRuleTaskBuilder)t.zeebeCalledDecisionId("force_user")).zeebeResultVariable(RESULT_VARIABLE))).deploy();
        Map deployedDecisionsById = ((DeploymentRecordValue)deployment.getValue()).getDecisionsMetadata().stream().collect(Collectors.toMap(DecisionRecordValue::getDecisionId, Function.identity()));
        DecisionRecordValue calledDecision = (DecisionRecordValue)deployedDecisionsById.get("force_user");
        DecisionRecordValue requiredDecision = (DecisionRecordValue)deployedDecisionsById.get("jedi_or_sith");
        Map<String, Object> variables = Map.ofEntries(Map.entry("lightsaberColor", "blue"), Map.entry("height", 182));
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).withVariables(variables).create();
        Record businessRuleTaskActivated = (Record)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATED).withProcessInstanceKey(processInstanceKey).withElementType(BpmnElementType.BUSINESS_RULE_TASK).getFirst();
        Record decisionEvaluationRecord = (Record)RecordingExporter.decisionEvaluationRecords().withProcessInstanceKey(processInstanceKey).getFirst();
        io.camunda.zeebe.protocol.record.Assertions.assertThat((Record)decisionEvaluationRecord).hasRecordType(RecordType.EVENT).hasValueType(ValueType.DECISION_EVALUATION).hasIntent((Intent)DecisionEvaluationIntent.EVALUATED).hasSourceRecordPosition(businessRuleTaskActivated.getSourceRecordPosition());
        ((AbstractLongAssert)Assertions.assertThat((long)decisionEvaluationRecord.getKey()).describedAs("Expect that the decision evaluation event has a key", new Object[0])).isPositive();
        DecisionEvaluationRecordValue decisionEvaluationValue = (DecisionEvaluationRecordValue)decisionEvaluationRecord.getValue();
        io.camunda.zeebe.protocol.record.Assertions.assertThat((DecisionEvaluationRecordValue)decisionEvaluationValue).hasDecisionKey(calledDecision.getDecisionKey()).hasDecisionId(calledDecision.getDecisionId()).hasDecisionName(calledDecision.getDecisionName()).hasDecisionVersion(calledDecision.getVersion()).hasDecisionRequirementsKey(calledDecision.getDecisionRequirementsKey()).hasDecisionRequirementsId(calledDecision.getDecisionRequirementsId()).hasDecisionOutput("\"Obi-Wan Kenobi\"").hasFailedDecisionId("").hasEvaluationFailureMessage("").hasTenantId("<default>");
        io.camunda.zeebe.protocol.record.Assertions.assertThat((DecisionEvaluationRecordValue)decisionEvaluationValue).hasProcessDefinitionKey(((ProcessInstanceRecordValue)businessRuleTaskActivated.getValue()).getProcessDefinitionKey()).hasBpmnProcessId(((ProcessInstanceRecordValue)businessRuleTaskActivated.getValue()).getBpmnProcessId()).hasProcessInstanceKey(((ProcessInstanceRecordValue)businessRuleTaskActivated.getValue()).getProcessInstanceKey()).hasElementInstanceKey(businessRuleTaskActivated.getKey()).hasElementId(((ProcessInstanceRecordValue)businessRuleTaskActivated.getValue()).getElementId());
        List evaluatedDecisions = decisionEvaluationValue.getEvaluatedDecisions();
        Assertions.assertThat((List)evaluatedDecisions).hasSize(2);
        io.camunda.zeebe.protocol.record.Assertions.assertThat((EvaluatedDecisionValue)((EvaluatedDecisionValue)evaluatedDecisions.get(0))).hasDecisionId("jedi_or_sith").hasDecisionName("Jedi or Sith").hasDecisionKey(requiredDecision.getDecisionKey()).hasDecisionVersion(requiredDecision.getVersion()).hasDecisionType("DECISION_TABLE").hasDecisionOutput("\"Jedi\"").hasTenantId("<default>").satisfies(new ThrowingConsumer[]{evaluatedDecision -> {
            Assertions.assertThat((List)evaluatedDecision.getEvaluatedInputs()).hasSize(1);
            io.camunda.zeebe.protocol.record.Assertions.assertThat((EvaluatedInputValue)((EvaluatedInputValue)evaluatedDecision.getEvaluatedInputs().get(0))).hasInputId("Input_1").hasInputName("Lightsaber color").hasInputValue("\"blue\"");
            Assertions.assertThat((List)evaluatedDecision.getMatchedRules()).hasSize(1);
            io.camunda.zeebe.protocol.record.Assertions.assertThat((MatchedRuleValue)((MatchedRuleValue)evaluatedDecision.getMatchedRules().get(0))).hasRuleId("DecisionRule_0zumznl").hasRuleIndex(1).satisfies(new ThrowingConsumer[]{matchedRule -> {
                Assertions.assertThat((List)matchedRule.getEvaluatedOutputs()).hasSize(1);
                io.camunda.zeebe.protocol.record.Assertions.assertThat((EvaluatedOutputValue)((EvaluatedOutputValue)matchedRule.getEvaluatedOutputs().get(0))).hasOutputId("Output_1").hasOutputName("Jedi or Sith").hasOutputValue("\"Jedi\"");
            }});
        }});
        io.camunda.zeebe.protocol.record.Assertions.assertThat((EvaluatedDecisionValue)((EvaluatedDecisionValue)evaluatedDecisions.get(1))).hasDecisionId("force_user").hasDecisionName("Which force user?").hasDecisionKey(calledDecision.getDecisionKey()).hasDecisionVersion(calledDecision.getVersion()).hasDecisionType("DECISION_TABLE").hasDecisionOutput("\"Obi-Wan Kenobi\"").hasTenantId("<default>").satisfies(new ThrowingConsumer[]{evaluatedDecision -> {
            Assertions.assertThat((List)evaluatedDecision.getEvaluatedInputs()).hasSize(2);
            io.camunda.zeebe.protocol.record.Assertions.assertThat((EvaluatedInputValue)((EvaluatedInputValue)evaluatedDecision.getEvaluatedInputs().get(0))).hasInputId("InputClause_0qnqj25").hasInputName("Jedi or Sith").hasInputValue("\"Jedi\"");
            io.camunda.zeebe.protocol.record.Assertions.assertThat((EvaluatedInputValue)((EvaluatedInputValue)evaluatedDecision.getEvaluatedInputs().get(1))).hasInputId("InputClause_0k64hys").hasInputName("Body height").hasInputValue("182");
            Assertions.assertThat((List)evaluatedDecision.getMatchedRules()).hasSize(1);
            io.camunda.zeebe.protocol.record.Assertions.assertThat((MatchedRuleValue)((MatchedRuleValue)evaluatedDecision.getMatchedRules().get(0))).hasRuleId("DecisionRule_0uin2hk").hasRuleIndex(2).satisfies(new ThrowingConsumer[]{matchedRule -> {
                Assertions.assertThat((List)matchedRule.getEvaluatedOutputs()).hasSize(1);
                io.camunda.zeebe.protocol.record.Assertions.assertThat((EvaluatedOutputValue)((EvaluatedOutputValue)matchedRule.getEvaluatedOutputs().get(0))).hasOutputId("OutputClause_0hhe1yo").hasOutputName("Force user").hasOutputValue("\"Obi-Wan Kenobi\"");
            }});
        }});
    }

    @Test
    public void shouldCallDecisionWithDecisionIdExpression() {
        ENGINE.deployment().withXmlClasspathResource(DMN_RESOURCE).withXmlResource(BusinessRuleTaskTest.processWithBusinessRuleTask(t -> ((BusinessRuleTaskBuilder)t.zeebeCalledDecisionIdExpression("decisionIdVariable")).zeebeResultVariable(RESULT_VARIABLE))).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).withVariables(Map.ofEntries(Map.entry("decisionIdVariable", "jedi_or_sith"), Map.entry("lightsaberColor", "blue"))).create();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)RecordingExporter.variableRecords((VariableIntent)VariableIntent.CREATED).withProcessInstanceKey(processInstanceKey).withName(RESULT_VARIABLE).exists()).as("Decision is evaluated successfully", new Object[0])).isTrue();
    }

    @Test
    public void shouldWriteDecisionEvaluationEventIfEvaluationFailed() {
        Record<DeploymentRecordValue> deployment = ENGINE.deployment().withXmlClasspathResource(DMN_WITH_ASSERTION).withXmlResource(BusinessRuleTaskTest.processWithBusinessRuleTask(t -> ((BusinessRuleTaskBuilder)t.zeebeCalledDecisionId("force_user")).zeebeResultVariable(RESULT_VARIABLE))).deploy();
        Map deployedDecisionsById = ((DeploymentRecordValue)deployment.getValue()).getDecisionsMetadata().stream().collect(Collectors.toMap(DecisionRecordValue::getDecisionId, Function.identity()));
        DecisionRecordValue calledDecision = (DecisionRecordValue)deployedDecisionsById.get("force_user");
        DecisionRecordValue requiredDecision = (DecisionRecordValue)deployedDecisionsById.get("jedi_or_sith");
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        Record businessRuleTaskActivating = (Record)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATING).withProcessInstanceKey(processInstanceKey).withElementType(BpmnElementType.BUSINESS_RULE_TASK).getFirst();
        Record decisionEvaluationRecord = (Record)RecordingExporter.decisionEvaluationRecords().withProcessInstanceKey(processInstanceKey).getFirst();
        io.camunda.zeebe.protocol.record.Assertions.assertThat((Record)decisionEvaluationRecord).hasRecordType(RecordType.EVENT).hasValueType(ValueType.DECISION_EVALUATION).hasIntent((Intent)DecisionEvaluationIntent.FAILED).hasSourceRecordPosition(businessRuleTaskActivating.getSourceRecordPosition());
        ((AbstractLongAssert)Assertions.assertThat((long)decisionEvaluationRecord.getKey()).describedAs("Expect that the decision evaluation event has a key", new Object[0])).isPositive();
        DecisionEvaluationRecordValue decisionEvaluationValue = (DecisionEvaluationRecordValue)decisionEvaluationRecord.getValue();
        io.camunda.zeebe.protocol.record.Assertions.assertThat((DecisionEvaluationRecordValue)decisionEvaluationValue).hasDecisionKey(calledDecision.getDecisionKey()).hasDecisionId(calledDecision.getDecisionId()).hasDecisionName(calledDecision.getDecisionName()).hasDecisionVersion(calledDecision.getVersion()).hasDecisionRequirementsKey(calledDecision.getDecisionRequirementsKey()).hasDecisionRequirementsId(calledDecision.getDecisionRequirementsId()).hasTenantId("<default>").hasDecisionOutput("null").hasFailedDecisionId("jedi_or_sith").hasEvaluationFailureMessage("Expected to evaluate decision 'force_user', but Assertion failure on evaluate the expression 'assert(lightsaberColor, lightsaberColor != null)': The condition is not fulfilled");
        io.camunda.zeebe.protocol.record.Assertions.assertThat((DecisionEvaluationRecordValue)decisionEvaluationValue).hasProcessDefinitionKey(((ProcessInstanceRecordValue)businessRuleTaskActivating.getValue()).getProcessDefinitionKey()).hasBpmnProcessId(((ProcessInstanceRecordValue)businessRuleTaskActivating.getValue()).getBpmnProcessId()).hasProcessInstanceKey(((ProcessInstanceRecordValue)businessRuleTaskActivating.getValue()).getProcessInstanceKey()).hasElementInstanceKey(businessRuleTaskActivating.getKey()).hasElementId(((ProcessInstanceRecordValue)businessRuleTaskActivating.getValue()).getElementId());
        List evaluatedDecisions = decisionEvaluationValue.getEvaluatedDecisions();
        Assertions.assertThat((List)evaluatedDecisions).hasSize(1);
        io.camunda.zeebe.protocol.record.Assertions.assertThat((EvaluatedDecisionValue)((EvaluatedDecisionValue)evaluatedDecisions.get(0))).hasDecisionId("jedi_or_sith").hasDecisionName("Jedi or Sith").hasDecisionKey(requiredDecision.getDecisionKey()).hasDecisionVersion(requiredDecision.getVersion()).hasDecisionType("DECISION_TABLE").hasDecisionOutput("null").hasTenantId("<default>").satisfies(new ThrowingConsumer[]{evaluatedDecision -> {
            Assertions.assertThat((List)evaluatedDecision.getEvaluatedInputs()).isEmpty();
            Assertions.assertThat((List)evaluatedDecision.getMatchedRules()).isEmpty();
        }});
    }

    @Test
    public void shouldWriteDecisionEvaluationEventIfInputOutputNamesAreNull() {
        ENGINE.deployment().withXmlClasspathResource(DMN_RESOURCE_WITH_NAMELESS_OUTPUTS).withXmlResource(BusinessRuleTaskTest.processWithBusinessRuleTask(t -> ((BusinessRuleTaskBuilder)t.zeebeCalledDecisionId("force_user")).zeebeResultVariable(RESULT_VARIABLE))).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).withVariables(Map.ofEntries(Map.entry("lightsaberColor", "blue"), Map.entry("height", 182))).create();
        Record decisionEvaluationRecord = (Record)RecordingExporter.decisionEvaluationRecords().withProcessInstanceKey(processInstanceKey).getFirst();
        ((AbstractListAssert)((AbstractListAssert)((ListAssert)Assertions.assertThat((List)((DecisionEvaluationRecordValue)decisionEvaluationRecord.getValue()).getEvaluatedDecisions()).isNotEmpty()).flatMap(EvaluatedDecisionValue::getMatchedRules).isNotEmpty()).flatMap(MatchedRuleValue::getEvaluatedOutputs).isNotEmpty()).extracting(EvaluatedOutputValue::getOutputName).describedAs("Expect that evaluated output's name is empty string", new Object[0]).containsOnly((Object[])new String[]{""});
    }

    @Test
    public void shouldEvaluateDecisionIfMultipleDrgsWithSameDecisionId() {
        ENGINE.deployment().withXmlClasspathResource(DMN_DECISION_TABLE).deploy();
        ENGINE.deployment().withXmlClasspathResource(DMN_DECISION_TABLE_RENAMED_DRG).deploy();
        Record<DeploymentRecordValue> deploymentCreated = ENGINE.deployment().withXmlClasspathResource(DMN_DECISION_TABLE).withXmlResource(BusinessRuleTaskTest.processWithBusinessRuleTask(t -> ((BusinessRuleTaskBuilder)t.zeebeCalledDecisionId("jedi_or_sith")).zeebeResultVariable(RESULT_VARIABLE))).deploy();
        DeploymentRecordValue lastDeployment = (DeploymentRecordValue)deploymentCreated.getValue();
        DecisionRequirementsMetadataValue lastDeployedDecisionRequirements = (DecisionRequirementsMetadataValue)lastDeployment.getDecisionRequirementsMetadata().get(0);
        DecisionRecordValue lastDeployedDecision = (DecisionRecordValue)lastDeployment.getDecisionsMetadata().get(0);
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).withVariables(Map.ofEntries(Map.entry("lightsaberColor", "blue"))).create();
        ((ListAssert)Assertions.assertThat((Stream)RecordingExporter.processInstanceRecords().withProcessInstanceKey(processInstanceKey).limitToProcessInstanceCompleted().withElementType(BpmnElementType.BUSINESS_RULE_TASK)).describedAs("expected the business rule task to be completed", new Object[0])).extracting(Record::getIntent).contains((Object[])new Intent[]{ProcessInstanceIntent.ELEMENT_COMPLETED});
        Record decisionEvaluationRecord = (Record)RecordingExporter.decisionEvaluationRecords().withProcessInstanceKey(processInstanceKey).getFirst();
        io.camunda.zeebe.protocol.record.Assertions.assertThat((DecisionEvaluationRecordValue)((DecisionEvaluationRecordValue)decisionEvaluationRecord.getValue())).hasDecisionKey(lastDeployedDecision.getDecisionKey()).hasDecisionRequirementsKey(lastDeployedDecisionRequirements.getDecisionRequirementsKey()).hasTenantId("<default>");
    }
}

