/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.bpmn.activity;

import io.camunda.zeebe.engine.util.EngineRule;
import io.camunda.zeebe.model.bpmn.Bpmn;
import io.camunda.zeebe.model.bpmn.BpmnModelInstance;
import io.camunda.zeebe.model.bpmn.builder.AbstractBpmnModelElementBuilder;
import io.camunda.zeebe.model.bpmn.builder.BoundaryEventBuilder;
import io.camunda.zeebe.model.bpmn.builder.CallActivityBuilder;
import io.camunda.zeebe.model.bpmn.builder.ProcessBuilder;
import io.camunda.zeebe.model.bpmn.builder.StartEventBuilder;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.RejectionType;
import io.camunda.zeebe.protocol.record.intent.IncidentIntent;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.JobIntent;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceIntent;
import io.camunda.zeebe.protocol.record.intent.VariableIntent;
import io.camunda.zeebe.protocol.record.value.BpmnElementType;
import io.camunda.zeebe.protocol.record.value.DeploymentRecordValue;
import io.camunda.zeebe.protocol.record.value.IncidentRecordValue;
import io.camunda.zeebe.protocol.record.value.JobBatchRecordValue;
import io.camunda.zeebe.protocol.record.value.ProcessInstanceRecordValue;
import io.camunda.zeebe.protocol.record.value.deployment.ProcessMetadataValue;
import io.camunda.zeebe.test.util.BrokerClassRuleHelper;
import io.camunda.zeebe.test.util.record.ProcessInstanceRecordStream;
import io.camunda.zeebe.test.util.record.RecordStream;
import io.camunda.zeebe.test.util.record.RecordingExporter;
import io.camunda.zeebe.test.util.record.VariableRecordStream;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractListAssert;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.groups.Tuple;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

public final class CallActivityTest {
    @ClassRule
    public static final EngineRule ENGINE = EngineRule.singlePartition();
    private static final String PROCESS_ID_PARENT = "wf-parent";
    private static final String PROCESS_ID_CHILD = "wf-child";
    @Rule
    public final BrokerClassRuleHelper helper = new BrokerClassRuleHelper();
    private String jobType;

    private static BpmnModelInstance parentProcess(Consumer<CallActivityBuilder> consumer) {
        CallActivityBuilder builder = Bpmn.createExecutableProcess((String)PROCESS_ID_PARENT).startEvent().callActivity("call", c -> c.zeebeProcessId(PROCESS_ID_CHILD));
        consumer.accept(builder);
        return builder.endEvent().done();
    }

    @Before
    public void init() {
        this.jobType = this.helper.getJobType();
        BpmnModelInstance parentProcess = CallActivityTest.parentProcess(AbstractBpmnModelElementBuilder::done);
        BpmnModelInstance childProcess = Bpmn.createExecutableProcess((String)PROCESS_ID_CHILD).startEvent().serviceTask("child-task", t -> t.zeebeJobType(this.jobType)).endEvent().done();
        ENGINE.deployment().withXmlResource("wf-parent.bpmn", parentProcess).withXmlResource("wf-child.bpmn", childProcess).deploy();
    }

    @Test
    public void shouldActivateCallActivity() {
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID_PARENT).create();
        Assertions.assertThat((Stream)((ProcessInstanceRecordStream)RecordingExporter.processInstanceRecords().onlyEvents()).withProcessInstanceKey(processInstanceKey).withTenantId("<default>").withElementId("call").limit(2L)).extracting(r -> Assertions.tuple((Object[])new Object[]{((ProcessInstanceRecordValue)r.getValue()).getBpmnElementType(), r.getIntent()})).containsExactly((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{BpmnElementType.CALL_ACTIVITY, ProcessInstanceIntent.ELEMENT_ACTIVATING}), Assertions.tuple((Object[])new Object[]{BpmnElementType.CALL_ACTIVITY, ProcessInstanceIntent.ELEMENT_ACTIVATED})});
    }

    @Test
    public void shouldCreateInstanceOfCalledElement() {
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID_PARENT).create();
        Assertions.assertThat((Stream)RecordingExporter.processInstanceRecords().withParentProcessInstanceKey(processInstanceKey).limit(6L)).extracting(r -> Assertions.tuple((Object[])new Object[]{((ProcessInstanceRecordValue)r.getValue()).getBpmnElementType(), r.getIntent()})).containsExactly((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{BpmnElementType.PROCESS, ProcessInstanceIntent.ACTIVATE_ELEMENT}), Assertions.tuple((Object[])new Object[]{BpmnElementType.PROCESS, ProcessInstanceIntent.ELEMENT_ACTIVATING}), Assertions.tuple((Object[])new Object[]{BpmnElementType.PROCESS, ProcessInstanceIntent.ELEMENT_ACTIVATED}), Assertions.tuple((Object[])new Object[]{BpmnElementType.START_EVENT, ProcessInstanceIntent.ACTIVATE_ELEMENT}), Assertions.tuple((Object[])new Object[]{BpmnElementType.START_EVENT, ProcessInstanceIntent.ELEMENT_ACTIVATING}), Assertions.tuple((Object[])new Object[]{BpmnElementType.START_EVENT, ProcessInstanceIntent.ELEMENT_ACTIVATED})});
    }

    @Test
    public void shouldCreateInstanceOfLatestVersionOfCalledElement() {
        BpmnModelInstance processChildV2 = Bpmn.createExecutableProcess((String)PROCESS_ID_CHILD).startEvent("v2").endEvent().done();
        Record<DeploymentRecordValue> secondDeployment = ENGINE.deployment().withXmlResource("wf-child.bpmn", processChildV2).deploy();
        ProcessMetadataValue secondVersion = (ProcessMetadataValue)((DeploymentRecordValue)secondDeployment.getValue()).getProcessesMetadata().get(0);
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID_PARENT).create();
        io.camunda.zeebe.protocol.record.Assertions.assertThat((ProcessInstanceRecordValue)this.getChildInstanceOf(processInstanceKey)).hasVersion(secondVersion.getVersion()).hasProcessDefinitionKey(secondVersion.getProcessDefinitionKey());
    }

    @Test
    public void shouldHaveReferenceToParentInstance() {
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID_PARENT).create();
        this.completeJobWith(Map.of());
        long callActivityInstanceKey = this.getCallActivityInstanceKey(processInstanceKey);
        Assertions.assertThat((Stream)RecordingExporter.records().betweenProcessInstance(processInstanceKey).processInstanceRecords().withParentProcessInstanceKey(processInstanceKey)).extracting(Record::getValue).extracting(v -> Assertions.tuple((Object[])new Object[]{v.getParentProcessInstanceKey(), v.getParentElementInstanceKey()})).containsOnly((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{processInstanceKey, callActivityInstanceKey})});
    }

    @Test
    public void shouldCompleteCallActivity() {
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID_PARENT).create();
        this.completeJobWith(Map.of());
        Assertions.assertThat((Stream)RecordingExporter.records().betweenProcessInstance(processInstanceKey).processInstanceRecords()).extracting(r -> Assertions.tuple((Object[])new Object[]{((ProcessInstanceRecordValue)r.getValue()).getBpmnElementType(), r.getIntent()})).containsSubsequence((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{BpmnElementType.END_EVENT, ProcessInstanceIntent.ELEMENT_COMPLETED}), Assertions.tuple((Object[])new Object[]{BpmnElementType.PROCESS, ProcessInstanceIntent.COMPLETE_ELEMENT}), Assertions.tuple((Object[])new Object[]{BpmnElementType.PROCESS, ProcessInstanceIntent.ELEMENT_COMPLETING}), Assertions.tuple((Object[])new Object[]{BpmnElementType.PROCESS, ProcessInstanceIntent.ELEMENT_COMPLETED}), Assertions.tuple((Object[])new Object[]{BpmnElementType.CALL_ACTIVITY, ProcessInstanceIntent.ELEMENT_COMPLETING}), Assertions.tuple((Object[])new Object[]{BpmnElementType.CALL_ACTIVITY, ProcessInstanceIntent.ELEMENT_COMPLETED}), Assertions.tuple((Object[])new Object[]{BpmnElementType.SEQUENCE_FLOW, ProcessInstanceIntent.SEQUENCE_FLOW_TAKEN}), Assertions.tuple((Object[])new Object[]{BpmnElementType.PROCESS, ProcessInstanceIntent.ELEMENT_COMPLETED})});
    }

    @Test
    public void shouldCopyVariablesToChild() {
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID_PARENT).withVariables(Map.of("x", 1, "y", 2)).create();
        ProcessInstanceRecordValue childInstance = this.getChildInstanceOf(processInstanceKey);
        ((AbstractListAssert)((AbstractListAssert)((AbstractListAssert)Assertions.assertThat((Stream)RecordingExporter.variableRecords().withProcessInstanceKey(childInstance.getProcessInstanceKey()).limit(2L)).extracting(Record::getValue).allMatch(v -> v.getProcessDefinitionKey() == childInstance.getProcessDefinitionKey())).allMatch(v -> v.getProcessInstanceKey() == childInstance.getProcessInstanceKey())).allMatch(v -> v.getScopeKey() == childInstance.getProcessInstanceKey())).extracting(v -> Assertions.tuple((Object[])new Object[]{v.getName(), v.getValue()})).contains((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{"x", "1"}), Assertions.tuple((Object[])new Object[]{"y", "2"})});
    }

    @Test
    public void shouldPropagateVariablesToParent() {
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID_PARENT).create();
        this.completeJobWith(Map.of("y", 2));
        Assertions.assertThat((Stream)RecordingExporter.records().betweenProcessInstance(processInstanceKey).variableRecords().withProcessInstanceKey(processInstanceKey)).extracting(Record::getValue).extracting(v -> Assertions.tuple((Object[])new Object[]{v.getScopeKey(), v.getName(), v.getValue()})).containsExactly((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{processInstanceKey, "y", "2"})});
    }

    @Test
    public void shouldNotPropagateVariablesToParentIfDisabled() {
        ENGINE.deployment().withXmlResource("wf-parent.bpmn", CallActivityTest.parentProcess(c -> c.zeebePropagateAllChildVariables(false))).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID_PARENT).create();
        long childInstanceKey = this.getChildInstanceOf(processInstanceKey).getProcessInstanceKey();
        this.completeJobWith(Map.of("y", 2));
        ((AbstractListAssert)Assertions.assertThat((Stream)RecordingExporter.records().betweenProcessInstance(processInstanceKey).variableRecords()).extracting(Record::getValue).extracting(v -> Assertions.tuple((Object[])new Object[]{v.getScopeKey(), v.getName()})).contains((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{childInstanceKey, "y"})})).doesNotContain((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{processInstanceKey, "y"})});
    }

    @Test
    public void shouldApplyInputMappings() {
        ENGINE.deployment().withXmlResource("wf-parent.bpmn", CallActivityTest.parentProcess(c -> c.zeebeInputExpression("x", "y"))).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID_PARENT).withVariable("x", 1).create();
        ProcessInstanceRecordValue childInstance = this.getChildInstanceOf(processInstanceKey);
        Assertions.assertThat((Stream)RecordingExporter.variableRecords().withProcessInstanceKey(childInstance.getProcessInstanceKey()).limit(2L)).extracting(Record::getValue).extracting(v -> Assertions.tuple((Object[])new Object[]{v.getName(), v.getValue()})).contains((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{"x", "1"}), Assertions.tuple((Object[])new Object[]{"y", "1"})});
    }

    @Test
    public void shouldPropagateAllVariablesWhenEnablingPropagateAllParentVariablesExplicitly() {
        ENGINE.deployment().withXmlResource("wf-parent.bpmn", CallActivityTest.parentProcess(c -> ((CallActivityBuilder)c.zeebeInputExpression("x", "y")).zeebePropagateAllParentVariables(true))).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID_PARENT).withVariables(Map.of("x", 1)).create();
        ProcessInstanceRecordValue childInstance = this.getChildInstanceOf(processInstanceKey);
        Assertions.assertThat((Stream)RecordingExporter.variableRecords().withProcessInstanceKey(childInstance.getProcessInstanceKey()).limit(2L)).extracting(Record::getValue).extracting(v -> Assertions.tuple((Object[])new Object[]{v.getName(), v.getValue()})).contains((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{"x", "1"}), Assertions.tuple((Object[])new Object[]{"y", "1"})});
    }

    @Test
    public void shouldOnlyPropagateVariablesDefinedViaInputMappings() {
        ENGINE.deployment().withXmlResource("wf-parent.bpmn", CallActivityTest.parentProcess(c -> ((CallActivityBuilder)c.zeebeInputExpression("x", "y")).zeebePropagateAllParentVariables(false))).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID_PARENT).withVariables(Map.of("x", 1)).create();
        ProcessInstanceRecordValue childInstance = this.getChildInstanceOf(processInstanceKey);
        Assertions.assertThat((Stream)((VariableRecordStream)((RecordStream)RecordingExporter.records().limit(r -> r.getIntent() == JobIntent.CREATED)).variableRecords().withIntent((Intent)VariableIntent.CREATED)).withProcessInstanceKey(childInstance.getProcessInstanceKey())).extracting(Record::getValue).extracting(v -> Assertions.tuple((Object[])new Object[]{v.getName(), v.getValue()})).containsExactly((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{"y", "1"})});
    }

    @Test
    public void shouldNotPropagateAnyVariable() {
        ENGINE.deployment().withXmlResource("wf-parent.bpmn", CallActivityTest.parentProcess(c -> c.zeebePropagateAllParentVariables(false))).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID_PARENT).withVariables(Map.of("x", 1)).create();
        ProcessInstanceRecordValue childInstance = this.getChildInstanceOf(processInstanceKey);
        Assertions.assertThat((Stream)((VariableRecordStream)((RecordStream)RecordingExporter.records().limit(r -> r.getIntent() == JobIntent.CREATED)).variableRecords().withIntent((Intent)VariableIntent.CREATED)).withProcessInstanceKey(childInstance.getProcessInstanceKey())).isEmpty();
    }

    @Test
    public void shouldApplyOutputMappings() {
        ENGINE.deployment().withXmlResource("wf-parent.bpmn", CallActivityTest.parentProcess(c -> ((CallActivityBuilder)c.zeebePropagateAllChildVariables(false)).zeebeOutputExpression("x", "y"))).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID_PARENT).create();
        this.completeJobWith(Map.of("x", 2));
        long callActivityInstanceKey = this.getCallActivityInstanceKey(processInstanceKey);
        ((AbstractListAssert)Assertions.assertThat((Stream)RecordingExporter.records().betweenProcessInstance(processInstanceKey).variableRecords().withProcessInstanceKey(processInstanceKey)).extracting(Record::getValue).extracting(v -> Assertions.tuple((Object[])new Object[]{v.getScopeKey(), v.getName(), v.getValue()})).hasSize(2)).contains((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{callActivityInstanceKey, "x", "2"}), Assertions.tuple((Object[])new Object[]{processInstanceKey, "y", "2"})});
    }

    @Test
    public void shouldApplyOutputMappingsIgnoringThePropagateAllProperty() {
        ENGINE.deployment().withXmlResource("wf-parent.bpmn", CallActivityTest.parentProcess(c -> ((CallActivityBuilder)c.zeebePropagateAllChildVariables(true)).zeebeOutputExpression("x", "x"))).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID_PARENT).create();
        this.completeJobWith(Map.of("x", 1, "y", 2));
        long callActivityInstanceKey = this.getCallActivityInstanceKey(processInstanceKey);
        ((AbstractListAssert)Assertions.assertThat((Stream)RecordingExporter.records().betweenProcessInstance(processInstanceKey).variableRecords().withProcessInstanceKey(processInstanceKey)).extracting(Record::getValue).extracting(v -> Assertions.tuple((Object[])new Object[]{v.getScopeKey(), v.getName(), v.getValue()})).hasSize(3)).contains((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{callActivityInstanceKey, "x", "1"}), Assertions.tuple((Object[])new Object[]{callActivityInstanceKey, "y", "2"}), Assertions.tuple((Object[])new Object[]{processInstanceKey, "x", "1"})});
    }

    @Test
    public void shouldCreateInstanceOfCalledElementWithExpression() {
        ENGINE.deployment().withXmlResource("wf-parent.bpmn", CallActivityTest.parentProcess(callActivity -> callActivity.zeebeProcessIdExpression("processId"))).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID_PARENT).withVariable("processId", PROCESS_ID_CHILD).create();
        io.camunda.zeebe.protocol.record.Assertions.assertThat((ProcessInstanceRecordValue)this.getChildInstanceOf(processInstanceKey)).hasBpmnProcessId(PROCESS_ID_CHILD);
    }

    @Test
    public void shouldTriggerBoundaryEvent() {
        ENGINE.deployment().withXmlResource("parent-wf.bpmn", CallActivityTest.parentProcess(callActivity -> callActivity.boundaryEvent("timeout", b -> ((BoundaryEventBuilder)b.cancelActivity(Boolean.valueOf(true))).timerWithDuration("PT0.1S")).endEvent())).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID_PARENT).create();
        Assertions.assertThat((Stream)RecordingExporter.records().betweenProcessInstance(processInstanceKey).processInstanceRecords()).extracting(r -> Assertions.tuple((Object[])new Object[]{((ProcessInstanceRecordValue)r.getValue()).getBpmnElementType(), r.getIntent()})).containsSubsequence((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{BpmnElementType.CALL_ACTIVITY, ProcessInstanceIntent.TERMINATE_ELEMENT}), Assertions.tuple((Object[])new Object[]{BpmnElementType.CALL_ACTIVITY, ProcessInstanceIntent.ELEMENT_TERMINATING}), Assertions.tuple((Object[])new Object[]{BpmnElementType.PROCESS, ProcessInstanceIntent.TERMINATE_ELEMENT}), Assertions.tuple((Object[])new Object[]{BpmnElementType.PROCESS, ProcessInstanceIntent.ELEMENT_TERMINATING}), Assertions.tuple((Object[])new Object[]{BpmnElementType.PROCESS, ProcessInstanceIntent.ELEMENT_TERMINATED}), Assertions.tuple((Object[])new Object[]{BpmnElementType.CALL_ACTIVITY, ProcessInstanceIntent.ELEMENT_TERMINATED}), Assertions.tuple((Object[])new Object[]{BpmnElementType.BOUNDARY_EVENT, ProcessInstanceIntent.ELEMENT_ACTIVATED}), Assertions.tuple((Object[])new Object[]{BpmnElementType.SEQUENCE_FLOW, ProcessInstanceIntent.SEQUENCE_FLOW_TAKEN}), Assertions.tuple((Object[])new Object[]{BpmnElementType.PROCESS, ProcessInstanceIntent.ELEMENT_COMPLETED})});
    }

    @Test
    public void shouldTerminateChildInstance() {
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID_PARENT).create();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)RecordingExporter.jobRecords((JobIntent)JobIntent.CREATED).withType(this.jobType).exists()).describedAs("Expected job in child instance to be created", new Object[0])).isTrue();
        ENGINE.processInstance().withInstanceKey(processInstanceKey).cancel();
        Assertions.assertThat((Stream)RecordingExporter.records().betweenProcessInstance(processInstanceKey).processInstanceRecords()).extracting(r -> Assertions.tuple((Object[])new Object[]{((ProcessInstanceRecordValue)r.getValue()).getBpmnElementType(), r.getIntent()})).containsSubsequence((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{BpmnElementType.PROCESS, ProcessInstanceIntent.ELEMENT_TERMINATING}), Assertions.tuple((Object[])new Object[]{BpmnElementType.CALL_ACTIVITY, ProcessInstanceIntent.ELEMENT_TERMINATING}), Assertions.tuple((Object[])new Object[]{BpmnElementType.PROCESS, ProcessInstanceIntent.ELEMENT_TERMINATING}), Assertions.tuple((Object[])new Object[]{BpmnElementType.SERVICE_TASK, ProcessInstanceIntent.ELEMENT_TERMINATING}), Assertions.tuple((Object[])new Object[]{BpmnElementType.SERVICE_TASK, ProcessInstanceIntent.ELEMENT_TERMINATED}), Assertions.tuple((Object[])new Object[]{BpmnElementType.PROCESS, ProcessInstanceIntent.ELEMENT_TERMINATED}), Assertions.tuple((Object[])new Object[]{BpmnElementType.CALL_ACTIVITY, ProcessInstanceIntent.ELEMENT_TERMINATED}), Assertions.tuple((Object[])new Object[]{BpmnElementType.PROCESS, ProcessInstanceIntent.ELEMENT_TERMINATED})});
    }

    @Test
    public void shouldTerminateOnCompleting() {
        ENGINE.deployment().withXmlResource("wf-parent.bpmn", CallActivityTest.parentProcess(c -> c.zeebeOutputExpression("assert(x, x != null)", "y"))).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID_PARENT).create();
        this.completeJobWith(Map.of());
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)RecordingExporter.incidentRecords((IncidentIntent)IncidentIntent.CREATED).withProcessInstanceKey(processInstanceKey).exists()).describedAs("Expected incident to be created", new Object[0])).isTrue();
        ENGINE.processInstance().withInstanceKey(processInstanceKey).cancel();
        Assertions.assertThat((Stream)RecordingExporter.processInstanceRecords().withProcessInstanceKey(processInstanceKey).limitToProcessInstanceTerminated()).extracting(r -> Assertions.tuple((Object[])new Object[]{((ProcessInstanceRecordValue)r.getValue()).getBpmnElementType(), r.getIntent()})).containsSubsequence((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{BpmnElementType.CALL_ACTIVITY, ProcessInstanceIntent.ELEMENT_COMPLETING}), Assertions.tuple((Object[])new Object[]{BpmnElementType.PROCESS, ProcessInstanceIntent.ELEMENT_TERMINATING}), Assertions.tuple((Object[])new Object[]{BpmnElementType.CALL_ACTIVITY, ProcessInstanceIntent.ELEMENT_TERMINATING}), Assertions.tuple((Object[])new Object[]{BpmnElementType.CALL_ACTIVITY, ProcessInstanceIntent.ELEMENT_TERMINATED}), Assertions.tuple((Object[])new Object[]{BpmnElementType.PROCESS, ProcessInstanceIntent.ELEMENT_TERMINATED})});
    }

    @Test
    public void shouldNotPropagateVariablesOnTermination() {
        ENGINE.deployment().withXmlResource("wf-parent.bpmn", CallActivityTest.parentProcess(callActivity -> callActivity.zeebeInputExpression("x", "y"))).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID_PARENT).withVariable("x", 1).create();
        long childInstanceKey = this.getChildInstanceOf(processInstanceKey).getProcessInstanceKey();
        ENGINE.processInstance().withInstanceKey(processInstanceKey).cancel();
        ((AbstractListAssert)Assertions.assertThat((Stream)RecordingExporter.records().betweenProcessInstance(processInstanceKey).variableRecords()).extracting(Record::getValue).extracting(v -> Assertions.tuple((Object[])new Object[]{v.getScopeKey(), v.getName()})).contains((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{childInstanceKey, "y"})})).doesNotContain((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{processInstanceKey, "y"})});
    }

    @Test
    public void shouldRejectCancelChildInstanceCommand() {
        ENGINE.deployment().withXmlResource("wf-root.bpmn", Bpmn.createExecutableProcess((String)"root").startEvent().callActivity("call", c -> c.zeebeProcessId(PROCESS_ID_PARENT)).done()).deploy();
        long rootInstanceKey = ENGINE.processInstance().ofBpmnProcessId("root").create();
        ProcessInstanceRecordValue parentInstance = this.getChildInstanceOf(rootInstanceKey);
        ProcessInstanceRecordValue childInstance = this.getChildInstanceOf(parentInstance.getProcessInstanceKey());
        Record<ProcessInstanceRecordValue> rejection = ENGINE.processInstance().withInstanceKey(childInstance.getProcessInstanceKey()).expectRejection().cancel();
        io.camunda.zeebe.protocol.record.Assertions.assertThat(rejection).hasRejectionType(RejectionType.INVALID_STATE).hasRejectionReason(String.format("Expected to cancel a process instance with key '%d', but it is created by a parent process instance. Cancel the root process instance '%d' instead.", childInstance.getProcessInstanceKey(), rootInstanceKey));
    }

    @Test
    public void shouldNotActivateCallActivityIfIncidentIsCreated() {
        ENGINE.deployment().withXmlResource("wf-parent.bpmn", CallActivityTest.parentProcess(c -> c.zeebeInputExpression("assert(x, x != null)", "y"))).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID_PARENT).create();
        long incidentKey = ((Record)RecordingExporter.incidentRecords((IncidentIntent)IncidentIntent.CREATED).withProcessInstanceKey(processInstanceKey).getFirst()).getKey();
        ENGINE.variables().ofScope(processInstanceKey).withDocument(Map.of("x", 1)).update();
        Record<IncidentRecordValue> incidentResolved = ENGINE.incident().ofInstance(processInstanceKey).withKey(incidentKey).resolve();
        ((AbstractLongAssert)Assertions.assertThat((long)((Record)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATED).withProcessInstanceKey(processInstanceKey).withElementType(BpmnElementType.CALL_ACTIVITY).getFirst()).getPosition()).describedAs("Expected call activity to be ACTIVATED after incident is resolved", new Object[0])).isGreaterThan(incidentResolved.getPosition());
    }

    @Test
    public void shouldCreateInstanceOfCalledElementAtNoneStartEvent() {
        ProcessBuilder processBuilder = Bpmn.createExecutableProcess((String)PROCESS_ID_CHILD);
        processBuilder.startEvent("none-start").endEvent();
        ((StartEventBuilder)processBuilder.startEvent("timer-start").timerWithCycle("R/PT1H")).endEvent();
        ((StartEventBuilder)processBuilder.startEvent("message-start").message("start")).endEvent();
        ENGINE.deployment().withXmlResource("wf-child.bpmn", processBuilder.done()).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID_PARENT).create();
        Assertions.assertThat((Stream)RecordingExporter.processInstanceRecords().withParentProcessInstanceKey(processInstanceKey).limitToProcessInstanceCompleted().withElementType(BpmnElementType.START_EVENT)).extracting(r -> ((ProcessInstanceRecordValue)r.getValue()).getElementId()).containsOnly((Object[])new String[]{"none-start"});
    }

    @Test
    public void shouldTriggerBoundaryEventOnChildInstanceTermination() {
        BpmnModelInstance processLevel1 = ((BoundaryEventBuilder)Bpmn.createExecutableProcess((String)"level1").startEvent().callActivity("call-level2", c -> c.zeebeProcessId("level2")).boundaryEvent().message(m -> m.name("cancel").zeebeCorrelationKeyExpression("key"))).endEvent().done();
        BpmnModelInstance processLevel2 = ((BoundaryEventBuilder)Bpmn.createExecutableProcess((String)"level2").startEvent().callActivity("call-level3", c -> c.zeebeProcessId("level3")).boundaryEvent().message(m -> m.name("cancel").zeebeCorrelationKeyExpression("key"))).endEvent().done();
        BpmnModelInstance processLevel3 = Bpmn.createExecutableProcess((String)"level3").startEvent().serviceTask("task-level3", t -> t.zeebeJobType("task-level3")).endEvent().done();
        ENGINE.deployment().withXmlResource("level1.bpmn", processLevel1).withXmlResource("level2.bpmn", processLevel2).withXmlResource("level3.bpmn", processLevel3).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId("level1").withVariable("key", "key-1").create();
        RecordingExporter.jobRecords((JobIntent)JobIntent.CREATED).withType("task-level3").await();
        ENGINE.message().withName("cancel").withCorrelationKey("key-1").publish();
        Assertions.assertThat((Stream)RecordingExporter.processInstanceRecords().withProcessInstanceKey(processInstanceKey).limitToProcessInstanceCompleted()).extracting(new Function[]{r -> ((ProcessInstanceRecordValue)r.getValue()).getBpmnElementType(), Record::getIntent}).containsSubsequence((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{BpmnElementType.CALL_ACTIVITY, ProcessInstanceIntent.ELEMENT_ACTIVATED}), Assertions.tuple((Object[])new Object[]{BpmnElementType.CALL_ACTIVITY, ProcessInstanceIntent.ELEMENT_TERMINATED}), Assertions.tuple((Object[])new Object[]{BpmnElementType.BOUNDARY_EVENT, ProcessInstanceIntent.ELEMENT_ACTIVATED}), Assertions.tuple((Object[])new Object[]{BpmnElementType.BOUNDARY_EVENT, ProcessInstanceIntent.ELEMENT_COMPLETED}), Assertions.tuple((Object[])new Object[]{BpmnElementType.PROCESS, ProcessInstanceIntent.ELEMENT_COMPLETED})});
    }

    private void completeJobWith(Map<String, Object> variables) {
        ((Record)RecordingExporter.jobRecords((JobIntent)JobIntent.CREATED).withType(this.jobType).getFirst()).getValue();
        ((JobBatchRecordValue)ENGINE.jobs().withType(this.jobType).activate().getValue()).getJobKeys().forEach(jobKey -> ENGINE.job().withKey((long)jobKey).withVariables(variables).complete());
    }

    private ProcessInstanceRecordValue getChildInstanceOf(long processInstanceKey) {
        return (ProcessInstanceRecordValue)((Record)RecordingExporter.processInstanceRecords().withParentProcessInstanceKey(processInstanceKey).getFirst()).getValue();
    }

    private long getCallActivityInstanceKey(long processInstanceKey) {
        return ((Record)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATED).withProcessInstanceKey(processInstanceKey).withElementType(BpmnElementType.CALL_ACTIVITY).getFirst()).getKey();
    }
}

