/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.bpmn.activity;

import io.camunda.zeebe.engine.util.EngineRule;
import io.camunda.zeebe.model.bpmn.Bpmn;
import io.camunda.zeebe.model.bpmn.BpmnModelInstance;
import io.camunda.zeebe.model.bpmn.builder.UserTaskBuilder;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.RecordType;
import io.camunda.zeebe.protocol.record.ValueType;
import io.camunda.zeebe.protocol.record.intent.DeploymentIntent;
import io.camunda.zeebe.protocol.record.intent.IncidentIntent;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceIntent;
import io.camunda.zeebe.protocol.record.value.BpmnElementType;
import io.camunda.zeebe.protocol.record.value.DeploymentRecordValue;
import io.camunda.zeebe.protocol.record.value.ErrorType;
import io.camunda.zeebe.protocol.record.value.IncidentRecordValue;
import io.camunda.zeebe.protocol.record.value.JobRecordValue;
import io.camunda.zeebe.test.util.record.RecordingExporter;
import io.camunda.zeebe.test.util.record.RecordingExporterTestWatcher;
import java.util.function.Function;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.assertj.core.groups.Tuple;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

public class JobBasedUserTaskFormTest {
    @ClassRule
    public static final EngineRule ENGINE = EngineRule.singlePartition();
    private static final String PROCESS_ID = "process";
    private static final String TEST_FORM_1 = "/form/test-form-1.form";
    private static final String TEST_FORM_2 = "/form/test-form-2.form";
    private static final String FORM_ID_1 = "Form_0w7r08e";
    private static final String FORM_ID_2 = "Form_6s1b76p";
    @Rule
    public final RecordingExporterTestWatcher recordingExporterTestWatcher = new RecordingExporterTestWatcher();

    @Test
    public void shouldActivateUserTaskIfFormIsAlreadyDeployed() {
        this.deployForm(TEST_FORM_1);
        this.deployProcess(FORM_ID_1);
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        this.assertUserTaskActivation(processInstanceKey);
    }

    @Test
    public void shouldRaiseAnIncidentIfFormIsNotDeployed() {
        String formId = "non-existent-form-id";
        this.deployProcess("non-existent-form-id");
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        this.assertFormIncident(processInstanceKey, "non-existent-form-id");
    }

    @Test
    public void shouldResolveAnIncidentIfFormIsDeployed() {
        this.deployProcess(FORM_ID_2);
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        Record<IncidentRecordValue> incidentCreated = this.assertFormIncident(processInstanceKey, FORM_ID_2);
        this.deployForm(TEST_FORM_2);
        ENGINE.incident().ofInstance(processInstanceKey).withKey(incidentCreated.getKey()).resolve();
        Assertions.assertThat((Stream)RecordingExporter.incidentRecords().onlyEvents()).extracting(new Function[]{Record::getKey, Record::getIntent}).describedAs("form not found incident is resolved and no new incident is created", new Object[0]).containsExactly((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{incidentCreated.getKey(), IncidentIntent.CREATED}), Assertions.tuple((Object[])new Object[]{incidentCreated.getKey(), IncidentIntent.RESOLVED})});
        this.assertUserTaskActivation(processInstanceKey);
    }

    private void deployProcess(String formId) {
        BpmnModelInstance processWithFormId = ((UserTaskBuilder)Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().userTask("task").zeebeFormId(formId)).endEvent().done();
        ENGINE.deployment().withXmlResource(processWithFormId).deploy();
    }

    private void deployForm(String formPath) {
        Record<DeploymentRecordValue> deploymentEvent = ENGINE.deployment().withJsonClasspathResource(formPath).deploy();
        io.camunda.zeebe.protocol.record.Assertions.assertThat(deploymentEvent).hasIntent((Intent)DeploymentIntent.CREATED).hasValueType(ValueType.DEPLOYMENT).hasRecordType(RecordType.EVENT);
    }

    private Record<IncidentRecordValue> assertFormIncident(long processInstanceKey, String formId) {
        Record incidentCreated = (Record)RecordingExporter.incidentRecords((IncidentIntent)IncidentIntent.CREATED).withProcessInstanceKey(processInstanceKey).getFirst();
        Assertions.assertThat((Object)((IncidentRecordValue)incidentCreated.getValue())).extracting(r -> Assertions.tuple((Object[])new Object[]{r.getErrorType(), r.getErrorMessage()})).isEqualTo((Object)Assertions.tuple((Object[])new Object[]{ErrorType.FORM_NOT_FOUND, String.format("Expected to find a form with id '%s', but no form with this id is found, at least a form with this id should be available. To resolve the Incident please deploy a form with the same id", formId)}));
        return incidentCreated;
    }

    private void assertUserTaskActivation(long processInstanceKey) {
        Assertions.assertThat((Stream)RecordingExporter.jobRecords().withProcessInstanceKey(processInstanceKey).limit(1L)).extracting(jobRecord -> ((JobRecordValue)jobRecord.getValue()).getCustomHeaders()).isNotNull().anyMatch(headers -> headers.containsKey("io.camunda.zeebe:formKey"));
        Assertions.assertThat((Stream)RecordingExporter.processInstanceRecords().withProcessInstanceKey(processInstanceKey).withElementType(BpmnElementType.USER_TASK).limit(3L)).extracting(new Function[]{Record::getRecordType, Record::getIntent}).containsSequence((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{RecordType.COMMAND, ProcessInstanceIntent.ACTIVATE_ELEMENT}), Assertions.tuple((Object[])new Object[]{RecordType.EVENT, ProcessInstanceIntent.ELEMENT_ACTIVATING}), Assertions.tuple((Object[])new Object[]{RecordType.EVENT, ProcessInstanceIntent.ELEMENT_ACTIVATED})});
    }
}

