/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.bpmn.activity;

import io.camunda.zeebe.engine.util.EngineRule;
import io.camunda.zeebe.model.bpmn.Bpmn;
import io.camunda.zeebe.model.bpmn.BpmnModelInstance;
import io.camunda.zeebe.model.bpmn.builder.ScriptTaskBuilder;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.RecordType;
import io.camunda.zeebe.protocol.record.intent.IncidentIntent;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceIntent;
import io.camunda.zeebe.protocol.record.intent.VariableIntent;
import io.camunda.zeebe.protocol.record.value.BpmnElementType;
import io.camunda.zeebe.protocol.record.value.ErrorType;
import io.camunda.zeebe.protocol.record.value.IncidentRecordValue;
import io.camunda.zeebe.protocol.record.value.ProcessInstanceRecordValue;
import io.camunda.zeebe.protocol.record.value.VariableRecordValue;
import io.camunda.zeebe.test.util.record.ProcessInstanceRecordStream;
import io.camunda.zeebe.test.util.record.RecordingExporter;
import io.camunda.zeebe.test.util.record.RecordingExporterTestWatcher;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.assertj.core.groups.Tuple;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

public final class ScriptTaskExpressionTest {
    @ClassRule
    public static final EngineRule ENGINE = EngineRule.singlePartition();
    private static final String PROCESS_ID = "process";
    private static final String TASK_ID = "task";
    private static final String RESULT_VARIABLE = "result";
    private static final String OUTPUT_TARGET = "output";
    private static final String A_STRING = "foobar";
    private static final String A_SUB_STRING = "\"bar\"";
    @Rule
    public final RecordingExporterTestWatcher recordingExporterTestWatcher = new RecordingExporterTestWatcher();

    private static BpmnModelInstance processWithScriptTask(Consumer<ScriptTaskBuilder> modifier) {
        return Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().scriptTask(TASK_ID, modifier).endEvent().done();
    }

    @Test
    public void shouldActivateTask() {
        ENGINE.deployment().withXmlResource(ScriptTaskExpressionTest.processWithScriptTask(t -> ((ScriptTaskBuilder)t.zeebeExpression("substring(x, 4)")).zeebeResultVariable(RESULT_VARIABLE))).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).withVariable("x", A_STRING).create();
        Assertions.assertThat((Stream)RecordingExporter.processInstanceRecords().withProcessInstanceKey(processInstanceKey).withElementType(BpmnElementType.SCRIPT_TASK).limit(3L)).extracting(new Function[]{Record::getRecordType, Record::getIntent}).containsSequence((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{RecordType.COMMAND, ProcessInstanceIntent.ACTIVATE_ELEMENT}), Assertions.tuple((Object[])new Object[]{RecordType.EVENT, ProcessInstanceIntent.ELEMENT_ACTIVATING}), Assertions.tuple((Object[])new Object[]{RecordType.EVENT, ProcessInstanceIntent.ELEMENT_ACTIVATED})});
        Record taskActivating = (Record)((ProcessInstanceRecordStream)RecordingExporter.processInstanceRecords().withProcessInstanceKey(processInstanceKey).withIntent((Intent)ProcessInstanceIntent.ELEMENT_ACTIVATING)).withElementType(BpmnElementType.SCRIPT_TASK).getFirst();
        io.camunda.zeebe.protocol.record.Assertions.assertThat((ProcessInstanceRecordValue)((ProcessInstanceRecordValue)taskActivating.getValue())).hasElementId(TASK_ID).hasBpmnElementType(BpmnElementType.SCRIPT_TASK).hasFlowScopeKey(processInstanceKey).hasBpmnProcessId(PROCESS_ID).hasProcessInstanceKey(processInstanceKey).hasTenantId("<default>");
    }

    @Test
    public void shouldActivateTaskWithCustomTenant() {
        String tenantId = "foo";
        ENGINE.deployment().withXmlResource(ScriptTaskExpressionTest.processWithScriptTask(t -> ((ScriptTaskBuilder)t.zeebeExpression("substring(x, 4)")).zeebeResultVariable(RESULT_VARIABLE))).withTenantId("foo").deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).withVariable("x", A_STRING).withTenantId("foo").create();
        Record taskActivating = (Record)((ProcessInstanceRecordStream)RecordingExporter.processInstanceRecords().withProcessInstanceKey(processInstanceKey).withIntent((Intent)ProcessInstanceIntent.ELEMENT_ACTIVATING)).withElementType(BpmnElementType.SCRIPT_TASK).withTenantId("foo").getFirst();
        io.camunda.zeebe.protocol.record.Assertions.assertThat((ProcessInstanceRecordValue)((ProcessInstanceRecordValue)taskActivating.getValue())).hasElementId(TASK_ID).hasBpmnElementType(BpmnElementType.SCRIPT_TASK).hasFlowScopeKey(processInstanceKey).hasBpmnProcessId(PROCESS_ID).hasProcessInstanceKey(processInstanceKey).hasTenantId("foo");
    }

    @Test
    public void shouldCompleteTask() {
        ENGINE.deployment().withXmlResource(ScriptTaskExpressionTest.processWithScriptTask(t -> ((ScriptTaskBuilder)t.zeebeExpression("substring(x, 4)")).zeebeResultVariable(RESULT_VARIABLE))).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).withVariable("x", A_STRING).create();
        Assertions.assertThat((Stream)RecordingExporter.processInstanceRecords().withProcessInstanceKey(processInstanceKey).limitToProcessInstanceCompleted()).extracting(new Function[]{r -> ((ProcessInstanceRecordValue)r.getValue()).getBpmnElementType(), Record::getIntent}).containsSubsequence((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{BpmnElementType.SCRIPT_TASK, ProcessInstanceIntent.ELEMENT_COMPLETING}), Assertions.tuple((Object[])new Object[]{BpmnElementType.SCRIPT_TASK, ProcessInstanceIntent.ELEMENT_COMPLETED}), Assertions.tuple((Object[])new Object[]{BpmnElementType.PROCESS, ProcessInstanceIntent.ELEMENT_COMPLETED})});
    }

    @Test
    public void shouldCompleteTaskWithCustomTenant() {
        String tenantId = "foo";
        ENGINE.deployment().withXmlResource(ScriptTaskExpressionTest.processWithScriptTask(t -> ((ScriptTaskBuilder)t.zeebeExpression("substring(x, 4)")).zeebeResultVariable(RESULT_VARIABLE))).withTenantId("foo").deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).withVariable("x", A_STRING).withTenantId("foo").create();
        Assertions.assertThat((Stream)RecordingExporter.processInstanceRecords().withProcessInstanceKey(processInstanceKey).withTenantId("foo").limitToProcessInstanceCompleted()).extracting(new Function[]{r -> ((ProcessInstanceRecordValue)r.getValue()).getBpmnElementType(), Record::getIntent}).containsSubsequence((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{BpmnElementType.SCRIPT_TASK, ProcessInstanceIntent.ELEMENT_COMPLETING}), Assertions.tuple((Object[])new Object[]{BpmnElementType.SCRIPT_TASK, ProcessInstanceIntent.ELEMENT_COMPLETED}), Assertions.tuple((Object[])new Object[]{BpmnElementType.PROCESS, ProcessInstanceIntent.ELEMENT_COMPLETED})});
    }

    @Test
    public void shouldWriteResultAsProcessInstanceVariable() {
        ENGINE.deployment().withXmlResource(ScriptTaskExpressionTest.processWithScriptTask(t -> ((ScriptTaskBuilder)t.zeebeExpression("substring(x, 4)")).zeebeResultVariable(RESULT_VARIABLE))).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).withVariable("x", A_STRING).create();
        Assertions.assertThat((Object)((Record)RecordingExporter.variableRecords((VariableIntent)VariableIntent.CREATED).withProcessInstanceKey(processInstanceKey).withName(RESULT_VARIABLE).getFirst())).extracting(Record::getValue).extracting(new Function[]{VariableRecordValue::getScopeKey, VariableRecordValue::getValue}).containsExactly(new Object[]{processInstanceKey, A_SUB_STRING});
    }

    @Test
    public void shouldUseResultInOutputMappings() {
        ENGINE.deployment().withXmlResource(ScriptTaskExpressionTest.processWithScriptTask(t -> ((ScriptTaskBuilder)((ScriptTaskBuilder)t.zeebeExpression("substring(x, 4)")).zeebeResultVariable(RESULT_VARIABLE)).zeebeOutputExpression(RESULT_VARIABLE, OUTPUT_TARGET))).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).withVariable("x", A_STRING).create();
        long taskInstanceKey = ((Record)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATED).withProcessInstanceKey(processInstanceKey).withElementType(BpmnElementType.SCRIPT_TASK).getFirst()).getKey();
        Assertions.assertThat((Object)((Record)RecordingExporter.variableRecords((VariableIntent)VariableIntent.CREATED).withProcessInstanceKey(processInstanceKey).withName(RESULT_VARIABLE).getFirst())).extracting(Record::getValue).extracting(new Function[]{VariableRecordValue::getScopeKey, VariableRecordValue::getValue}).containsExactly(new Object[]{taskInstanceKey, A_SUB_STRING});
        Assertions.assertThat((Object)((Record)RecordingExporter.variableRecords((VariableIntent)VariableIntent.CREATED).withProcessInstanceKey(processInstanceKey).withName(OUTPUT_TARGET).getFirst())).extracting(Record::getValue).extracting(new Function[]{VariableRecordValue::getScopeKey, VariableRecordValue::getValue}).containsExactly(new Object[]{processInstanceKey, A_SUB_STRING});
    }

    @Test
    public void shouldCreateIncidentIfScriptExpressionEvaluationFailed() {
        ENGINE.deployment().withXmlResource(ScriptTaskExpressionTest.processWithScriptTask(t -> ((ScriptTaskBuilder)((ScriptTaskBuilder)t.zeebeExpression("assert(x, x != null)")).zeebeResultVariable(RESULT_VARIABLE)).zeebeOutputExpression(RESULT_VARIABLE, OUTPUT_TARGET))).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        Record scriptTask = (Record)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATING).withProcessInstanceKey(processInstanceKey).withElementId(TASK_ID).withElementType(BpmnElementType.SCRIPT_TASK).getFirst();
        Record incidentRecord = (Record)RecordingExporter.incidentRecords((IncidentIntent)IncidentIntent.CREATED).withProcessInstanceKey(processInstanceKey).getFirst();
        io.camunda.zeebe.protocol.record.Assertions.assertThat((IncidentRecordValue)((IncidentRecordValue)incidentRecord.getValue())).hasErrorType(ErrorType.EXTRACT_VALUE_ERROR).hasErrorMessage("Assertion failure on evaluate the expression 'assert(x, x != null)': The condition is not fulfilled The evaluation reported the following warnings:\n[NO_VARIABLE_FOUND] No variable found with name 'x'\n[NO_VARIABLE_FOUND] No variable found with name 'x'\n[ASSERT_FAILURE] The condition is not fulfilled").hasBpmnProcessId(((ProcessInstanceRecordValue)scriptTask.getValue()).getBpmnProcessId()).hasProcessDefinitionKey(((ProcessInstanceRecordValue)scriptTask.getValue()).getProcessDefinitionKey()).hasProcessInstanceKey(((ProcessInstanceRecordValue)scriptTask.getValue()).getProcessInstanceKey()).hasElementId(((ProcessInstanceRecordValue)scriptTask.getValue()).getElementId()).hasElementInstanceKey(scriptTask.getKey()).hasVariableScopeKey(scriptTask.getKey()).hasJobKey(-1L);
    }

    @Test
    public void shouldResolveIncidentIfScriptExpressionEvaluationFailed() {
        ENGINE.deployment().withXmlResource(ScriptTaskExpressionTest.processWithScriptTask(t -> ((ScriptTaskBuilder)((ScriptTaskBuilder)t.zeebeExpression("assert(x, x != null)")).zeebeResultVariable(RESULT_VARIABLE)).zeebeOutputExpression(RESULT_VARIABLE, OUTPUT_TARGET))).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        Record incidentCreatedRecord = (Record)RecordingExporter.incidentRecords((IncidentIntent)IncidentIntent.CREATED).withProcessInstanceKey(processInstanceKey).getFirst();
        ENGINE.variables().ofScope(((IncidentRecordValue)incidentCreatedRecord.getValue()).getElementInstanceKey()).withDocument(Map.of("x", A_STRING)).update();
        Record<IncidentRecordValue> incidentResolvedEvent = ENGINE.incident().ofInstance(processInstanceKey).withKey(incidentCreatedRecord.getKey()).resolve();
        io.camunda.zeebe.protocol.record.Assertions.assertThat((VariableRecordValue)((VariableRecordValue)((Record)RecordingExporter.variableRecords((VariableIntent)VariableIntent.CREATED).withProcessInstanceKey(processInstanceKey).withName(OUTPUT_TARGET).getFirst()).getValue())).hasValue("\"foobar\"");
        Assertions.assertThat((long)incidentResolvedEvent.getKey()).isEqualTo(incidentCreatedRecord.getKey());
    }
}

