/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.bpmn.activity;

import io.camunda.zeebe.el.ExpressionLanguage;
import io.camunda.zeebe.el.ExpressionLanguageFactory;
import io.camunda.zeebe.engine.processing.bpmn.clock.ZeebeFeelEngineClock;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableJobWorkerTask;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableProcess;
import io.camunda.zeebe.engine.processing.deployment.model.transformation.BpmnTransformer;
import io.camunda.zeebe.model.bpmn.Bpmn;
import io.camunda.zeebe.model.bpmn.BpmnModelInstance;
import io.camunda.zeebe.model.bpmn.builder.UserTaskBuilder;
import io.camunda.zeebe.scheduler.clock.ActorClock;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.camunda.feel.FeelEngineClock;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

class UserTaskTransformerTest {
    private static final String TASK_ID = "user-task";
    private final ExpressionLanguage expressionLanguage = ExpressionLanguageFactory.createExpressionLanguage((FeelEngineClock)new ZeebeFeelEngineClock(ActorClock.current()));
    private final BpmnTransformer transformer = new BpmnTransformer(this.expressionLanguage);

    UserTaskTransformerTest() {
    }

    private BpmnModelInstance processWithUserTask(Consumer<UserTaskBuilder> userTaskModifier) {
        return Bpmn.createExecutableProcess().startEvent().userTask(TASK_ID, userTaskModifier).done();
    }

    private ExecutableJobWorkerTask transformUserTask(BpmnModelInstance userTask) {
        List processes = this.transformer.transformDefinitions(userTask);
        return (ExecutableJobWorkerTask)((ExecutableProcess)processes.get(0)).getElementById(TASK_ID, ExecutableJobWorkerTask.class);
    }

    @Nested
    @TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
    class FormIdTests {
        FormIdTests() {
        }

        Stream<Arguments> formIds() {
            return Stream.of(Arguments.of((Object[])new Object[]{null, null}), Arguments.of((Object[])new Object[]{"", null}), Arguments.of((Object[])new Object[]{"form-id", "form-id"}));
        }

        @DisplayName(value="Should transform user task with formId")
        @ParameterizedTest
        @MethodSource(value={"formIds"})
        void shouldTransform(String formId, String parsedExpression) {
            ExecutableJobWorkerTask userTask = UserTaskTransformerTest.this.transformUserTask(UserTaskTransformerTest.this.processWithUserTask(b -> b.zeebeFormId(formId)));
            if (parsedExpression == null) {
                Assertions.assertThat((Object)userTask.getJobWorkerProperties().getFormId()).isNull();
            } else {
                Assertions.assertThat((String)userTask.getJobWorkerProperties().getFormId().getExpression()).isEqualTo(parsedExpression);
            }
        }
    }

    @Nested
    @TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
    class FollowUpDateTests {
        FollowUpDateTests() {
        }

        Stream<Arguments> followUpDates() {
            return Stream.of(Arguments.of((Object[])new Object[]{null, null}), Arguments.of((Object[])new Object[]{"", null}), Arguments.of((Object[])new Object[]{" ", null}), Arguments.of((Object[])new Object[]{"2023-02-27T14:35:00Z", "2023-02-27T14:35:00Z"}), Arguments.of((Object[])new Object[]{"2023-02-27T14:35:00+02:00", "2023-02-27T14:35:00+02:00"}), Arguments.of((Object[])new Object[]{"2023-02-27T14:35:00+02:00[Europe/Berlin]", "2023-02-27T14:35:00+02:00[Europe/Berlin]"}), Arguments.of((Object[])new Object[]{"=followUpDateSchedule", "followUpDateSchedule"}), Arguments.of((Object[])new Object[]{"=schedule.followUpDate", "schedule.followUpDate"}));
        }

        @DisplayName(value="Should transform user task with followUpDate")
        @ParameterizedTest
        @MethodSource(value={"followUpDates"})
        void shouldTransform(String followUpDate, String parsedExpression) {
            ExecutableJobWorkerTask userTask = UserTaskTransformerTest.this.transformUserTask(UserTaskTransformerTest.this.processWithUserTask(b -> b.zeebeFollowUpDate(followUpDate)));
            if (parsedExpression == null) {
                Assertions.assertThat((Object)userTask.getJobWorkerProperties().getFollowUpDate()).isNull();
            } else {
                Assertions.assertThat((String)userTask.getJobWorkerProperties().getFollowUpDate().getExpression()).isEqualTo(parsedExpression);
            }
        }
    }

    @Nested
    class TaskScheduleTests {
        TaskScheduleTests() {
        }

        @Nested
        @TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
        class DueDateTests {
            DueDateTests() {
            }

            Stream<Arguments> dueDates() {
                return Stream.of(Arguments.of((Object[])new Object[]{null, null}), Arguments.of((Object[])new Object[]{"", null}), Arguments.of((Object[])new Object[]{" ", null}), Arguments.of((Object[])new Object[]{"2023-02-27T14:35:00Z", "2023-02-27T14:35:00Z"}), Arguments.of((Object[])new Object[]{"2023-02-27T14:35:00+02:00", "2023-02-27T14:35:00+02:00"}), Arguments.of((Object[])new Object[]{"2023-02-27T14:35:00+02:00[Europe/Berlin]", "2023-02-27T14:35:00+02:00[Europe/Berlin]"}), Arguments.of((Object[])new Object[]{"=dueDateSchedule", "dueDateSchedule"}), Arguments.of((Object[])new Object[]{"=schedule.dueDate", "schedule.dueDate"}));
            }

            @DisplayName(value="Should transform user task with dueDate")
            @ParameterizedTest
            @MethodSource(value={"dueDates"})
            void shouldTransform(String dueDate, String parsedExpression) {
                ExecutableJobWorkerTask userTask = UserTaskTransformerTest.this.transformUserTask(UserTaskTransformerTest.this.processWithUserTask(b -> b.zeebeDueDate(dueDate)));
                if (parsedExpression == null) {
                    Assertions.assertThat((Object)userTask.getJobWorkerProperties().getDueDate()).isNull();
                } else {
                    Assertions.assertThat((String)userTask.getJobWorkerProperties().getDueDate().getExpression()).isEqualTo(parsedExpression);
                }
            }
        }
    }

    @Nested
    class AssignmentDefinitionTests {
        AssignmentDefinitionTests() {
        }

        @Nested
        @TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
        class CandidateUsersTests {
            CandidateUsersTests() {
            }

            Stream<Arguments> candidateUsers() {
                return Stream.of(Arguments.of((Object[])new Object[]{null, null}), Arguments.of((Object[])new Object[]{"", null}), Arguments.of((Object[])new Object[]{" ", null}), Arguments.of((Object[])new Object[]{"rose", "[\"rose\"]"}), Arguments.of((Object[])new Object[]{"jack,rose", "[\"jack\",\"rose\"]"}), Arguments.of((Object[])new Object[]{" jack , rose ", "[\"jack\",\"rose\"]"}), Arguments.of((Object[])new Object[]{"=users", "users"}), Arguments.of((Object[])new Object[]{"=[\"jack\",\"rose\"]", "[\"jack\",\"rose\"]"}));
            }

            @DisplayName(value="Should transform user task with candidateUsers")
            @ParameterizedTest
            @MethodSource(value={"candidateUsers"})
            void shouldTransform(String candidateUsers, String parsedExpression) {
                ExecutableJobWorkerTask userTask = UserTaskTransformerTest.this.transformUserTask(UserTaskTransformerTest.this.processWithUserTask(b -> b.zeebeCandidateUsers(candidateUsers)));
                if (parsedExpression == null) {
                    Assertions.assertThat((Object)userTask.getJobWorkerProperties().getCandidateUsers()).isNull();
                } else {
                    Assertions.assertThat((String)userTask.getJobWorkerProperties().getCandidateUsers().getExpression()).isEqualTo(parsedExpression);
                }
            }
        }

        @Nested
        @TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
        class CandidateGroupsTests {
            CandidateGroupsTests() {
            }

            Stream<Arguments> candidateGroups() {
                return Stream.of(Arguments.of((Object[])new Object[]{null, null}), Arguments.of((Object[])new Object[]{"", null}), Arguments.of((Object[])new Object[]{" ", null}), Arguments.of((Object[])new Object[]{"humans", "[\"humans\"]"}), Arguments.of((Object[])new Object[]{"humans,elves", "[\"humans\",\"elves\"]"}), Arguments.of((Object[])new Object[]{" humans , elves ", "[\"humans\",\"elves\"]"}), Arguments.of((Object[])new Object[]{"=middle_earth.races", "middle_earth.races"}), Arguments.of((Object[])new Object[]{"=[\"elves\",\"orcs\"]", "[\"elves\",\"orcs\"]"}));
            }

            @DisplayName(value="Should transform user task with candidateGroups")
            @ParameterizedTest
            @MethodSource(value={"candidateGroups"})
            void shouldTransform(String candidateGroups, String parsedExpression) {
                ExecutableJobWorkerTask userTask = UserTaskTransformerTest.this.transformUserTask(UserTaskTransformerTest.this.processWithUserTask(b -> b.zeebeCandidateGroups(candidateGroups)));
                if (parsedExpression == null) {
                    Assertions.assertThat((Object)userTask.getJobWorkerProperties().getCandidateGroups()).isNull();
                } else {
                    Assertions.assertThat((String)userTask.getJobWorkerProperties().getCandidateGroups().getExpression()).isEqualTo(parsedExpression);
                }
            }
        }

        @Nested
        @TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
        class AssigneeTests {
            AssigneeTests() {
            }

            Stream<Arguments> assignees() {
                return Stream.of(Arguments.of((Object[])new Object[]{null, null}), Arguments.of((Object[])new Object[]{"", null}), Arguments.of((Object[])new Object[]{" ", null}), Arguments.of((Object[])new Object[]{"frodo", "\"frodo\""}), Arguments.of((Object[])new Object[]{"=ring.bearer", "ring.bearer"}), Arguments.of((Object[])new Object[]{"12345678", "\"12345678\""}));
            }

            @DisplayName(value="Should transform user task with assignee")
            @ParameterizedTest
            @MethodSource(value={"assignees"})
            void shouldTransform(String assignee, String parsedExpression) {
                ExecutableJobWorkerTask userTask = UserTaskTransformerTest.this.transformUserTask(UserTaskTransformerTest.this.processWithUserTask(b -> b.zeebeAssignee(assignee)));
                if (parsedExpression == null) {
                    Assertions.assertThat((Object)userTask.getJobWorkerProperties().getAssignee()).isNull();
                } else {
                    Assertions.assertThat((String)userTask.getJobWorkerProperties().getAssignee().getExpression()).isEqualTo(parsedExpression);
                }
            }
        }
    }
}

