/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.bpmn.gateway;

import io.camunda.zeebe.engine.util.EngineRule;
import io.camunda.zeebe.model.bpmn.Bpmn;
import io.camunda.zeebe.model.bpmn.BpmnModelInstance;
import io.camunda.zeebe.model.bpmn.builder.AbstractGatewayBuilder;
import io.camunda.zeebe.model.bpmn.builder.AbstractInclusiveGatewayBuilder;
import io.camunda.zeebe.model.bpmn.builder.InclusiveGatewayBuilder;
import io.camunda.zeebe.model.bpmn.builder.StartEventBuilder;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.ValueType;
import io.camunda.zeebe.protocol.record.intent.IncidentIntent;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceIntent;
import io.camunda.zeebe.protocol.record.value.BpmnElementType;
import io.camunda.zeebe.protocol.record.value.DeploymentRecordValue;
import io.camunda.zeebe.protocol.record.value.ErrorType;
import io.camunda.zeebe.protocol.record.value.IncidentRecordValue;
import io.camunda.zeebe.protocol.record.value.ProcessInstanceRecordValue;
import io.camunda.zeebe.test.util.Strings;
import io.camunda.zeebe.test.util.record.IncidentRecordStream;
import io.camunda.zeebe.test.util.record.ProcessInstanceRecordStream;
import io.camunda.zeebe.test.util.record.RecordingExporter;
import io.camunda.zeebe.test.util.record.RecordingExporterTestWatcher;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractListAssert;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.ThrowingConsumer;
import org.assertj.core.groups.Tuple;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

public final class InclusiveGatewayTest {
    @ClassRule
    public static final EngineRule ENGINE = EngineRule.singlePartition();
    private static final String PROCESS_ID = "process";
    private static final BpmnModelInstance INCLUSIVE_PROCESS = ((AbstractInclusiveGatewayBuilder)((AbstractInclusiveGatewayBuilder)((InclusiveGatewayBuilder)((InclusiveGatewayBuilder)Bpmn.createExecutableProcess((String)"process").startEvent("start").inclusiveGateway("inclusive").sequenceFlowId("s1")).conditionExpression("= contains(str,\"a\")")).manualTask("task1").endEvent("end1").moveToNode("inclusive").sequenceFlowId("s2").conditionExpression("= contains(str,\"b\")").manualTask("task2").endEvent("end2").moveToLastInclusiveGateway().defaultFlow().sequenceFlowId("s3")).conditionExpression("= contains(str,\"c\")")).manualTask("task3").endEvent("end3").done();
    @Rule
    public final RecordingExporterTestWatcher recordingExporterTestWatcher = new RecordingExporterTestWatcher();

    @Test
    public void shouldSplitOnInclusiveGateway() {
        String processId = Strings.newRandomValidBpmnId();
        BpmnModelInstance processDefinition = ((AbstractInclusiveGatewayBuilder)((AbstractInclusiveGatewayBuilder)((AbstractGatewayBuilder)((AbstractGatewayBuilder)((InclusiveGatewayBuilder)((InclusiveGatewayBuilder)Bpmn.createExecutableProcess((String)processId).startEvent().inclusiveGateway("inclusive").sequenceFlowId("s1")).conditionExpression("= contains(str,\"a\")")).endEvent("end1").moveToLastGateway().sequenceFlowId("s2")).conditionExpression("= contains(str,\"b\")")).endEvent("end2").moveToLastInclusiveGateway().defaultFlow().sequenceFlowId("s3")).conditionExpression("= true")).endEvent("end3").done();
        ENGINE.deployment().withXmlResource(processDefinition).deploy();
        long processInstance1 = ENGINE.processInstance().ofBpmnProcessId(processId).withVariable("str", "a").create();
        ((AbstractListAssert)((ListAssert)Assertions.assertThat((Stream)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_COMPLETED).withProcessInstanceKey(processInstance1).limitToProcessInstanceCompleted().withElementType(BpmnElementType.END_EVENT).withIntent((Intent)ProcessInstanceIntent.ELEMENT_COMPLETED)).describedAs("when s1's condition is true,then s1 sequence flow is taken", new Object[0])).extracting(Record::getValue).extracting(v -> Assertions.tuple((Object[])new Object[]{v.getProcessInstanceKey(), v.getElementId()})).contains((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{processInstance1, "end1"})})).doesNotContain((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{processInstance1, "end3"})});
        long processInstance2 = ENGINE.processInstance().ofBpmnProcessId(processId).withVariable("str", "b").create();
        ((AbstractListAssert)((ListAssert)Assertions.assertThat((Stream)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_COMPLETED).withProcessInstanceKey(processInstance2).limitToProcessInstanceCompleted().withElementType(BpmnElementType.END_EVENT).withIntent((Intent)ProcessInstanceIntent.ELEMENT_COMPLETED)).describedAs("when s2's condition is true,then s2 sequence flow is taken", new Object[0])).extracting(Record::getValue).extracting(v -> Assertions.tuple((Object[])new Object[]{v.getProcessInstanceKey(), v.getElementId()})).contains((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{processInstance2, "end2"})})).doesNotContain((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{processInstance1, "end3"})});
        long processInstance3 = ENGINE.processInstance().ofBpmnProcessId(processId).withVariable("str", "c").create();
        ((ListAssert)Assertions.assertThat((Stream)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_COMPLETED).withProcessInstanceKey(processInstance3).limitToProcessInstanceCompleted().withElementType(BpmnElementType.END_EVENT).withIntent((Intent)ProcessInstanceIntent.ELEMENT_COMPLETED)).describedAs("if no conditions are fulfilled, then the default flow is taken", new Object[0])).extracting(Record::getValue).extracting(v -> Assertions.tuple((Object[])new Object[]{v.getProcessInstanceKey(), v.getElementId()})).contains((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{processInstance3, "end3"})});
        long processInstance5 = ENGINE.processInstance().ofBpmnProcessId(processId).withVariable("str", "a,b").create();
        ((AbstractListAssert)Assertions.assertThat((Stream)RecordingExporter.processInstanceRecords().withProcessInstanceKey(processInstance5).limitToProcessInstanceCompleted().withElementType(BpmnElementType.END_EVENT).withIntent((Intent)ProcessInstanceIntent.ELEMENT_COMPLETED)).extracting(Record::getValue).describedAs("when s1 and s2's conditions are true,then s1 and s2's sequence flows are taken", new Object[0]).extracting(v -> Assertions.tuple((Object[])new Object[]{v.getProcessInstanceKey(), v.getElementId()})).contains((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{processInstance5, "end1"}), Assertions.tuple((Object[])new Object[]{processInstance5, "end2"})})).doesNotContain((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{processInstance1, "end3"})});
        long processInstance6 = ENGINE.processInstance().ofBpmnProcessId(processId).withVariable("str", "b,c").create();
        ((AbstractListAssert)((ListAssert)Assertions.assertThat((Stream)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_COMPLETED).withProcessInstanceKey(processInstance6).limitToProcessInstanceCompleted().withElementType(BpmnElementType.END_EVENT).withIntent((Intent)ProcessInstanceIntent.ELEMENT_COMPLETED)).describedAs("when s2's condition is true,then s2 sequence flow is taken, s3 is ignored", new Object[0])).extracting(Record::getValue).extracting(v -> Assertions.tuple((Object[])new Object[]{v.getProcessInstanceKey(), v.getElementId()})).contains((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{processInstance6, "end2"})})).doesNotContain((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{processInstance1, "end3"})});
        long processInstance7 = ENGINE.processInstance().ofBpmnProcessId(processId).withVariable("str", "a,c").create();
        ((AbstractListAssert)((ListAssert)Assertions.assertThat((Stream)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_COMPLETED).withProcessInstanceKey(processInstance7).limitToProcessInstanceCompleted().withElementType(BpmnElementType.END_EVENT).withIntent((Intent)ProcessInstanceIntent.ELEMENT_COMPLETED)).describedAs("when s1's condition is true,then s1 sequence flow is taken, s3 is ignored", new Object[0])).extracting(Record::getValue).extracting(v -> Assertions.tuple((Object[])new Object[]{v.getProcessInstanceKey(), v.getElementId()})).contains((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{processInstance7, "end1"})})).doesNotContain((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{processInstance1, "end3"})});
        long processInstance8 = ENGINE.processInstance().ofBpmnProcessId(processId).withVariable("str", "a,b,c").create();
        ((AbstractListAssert)((ListAssert)Assertions.assertThat((Stream)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_COMPLETED).withProcessInstanceKey(processInstance8).limitToProcessInstanceCompleted().withElementType(BpmnElementType.END_EVENT).withIntent((Intent)ProcessInstanceIntent.ELEMENT_COMPLETED)).describedAs("when all conditions are true,then all sequence flows are taken,the default sequence flow is ignored", new Object[0])).extracting(Record::getValue).extracting(v -> Assertions.tuple((Object[])new Object[]{v.getProcessInstanceKey(), v.getElementId()})).contains((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{processInstance8, "end1"}), Assertions.tuple((Object[])new Object[]{processInstance8, "end2"})})).doesNotContain((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{processInstance1, "end3"})});
    }

    @Test
    public void testProcessInstanceStatesWithInclusiveGateway() {
        String processId = Strings.newRandomValidBpmnId();
        BpmnModelInstance processDefinition = ((AbstractInclusiveGatewayBuilder)((AbstractInclusiveGatewayBuilder)((InclusiveGatewayBuilder)((InclusiveGatewayBuilder)Bpmn.createExecutableProcess((String)processId).startEvent().inclusiveGateway("inclusive").sequenceFlowId("s1")).conditionExpression("= contains(str,\"a\")")).endEvent("a").moveToLastInclusiveGateway().defaultFlow().sequenceFlowId("s2")).conditionExpression("= contains(str,\"b\")")).endEvent("b").done();
        ENGINE.deployment().withXmlResource(processDefinition).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(processId).withVariable("str", "a").create();
        List processEvents = ((ProcessInstanceRecordStream)((ProcessInstanceRecordStream)RecordingExporter.processInstanceRecords().onlyEvents()).withProcessInstanceKey(processInstanceKey).skipUntil(r -> ((ProcessInstanceRecordValue)r.getValue()).getElementId().equals("inclusive"))).limitToProcessInstanceCompleted().asList();
        Assertions.assertThat((List)processEvents).extracting(Record::getIntent).containsExactly((Object[])new Intent[]{ProcessInstanceIntent.ELEMENT_ACTIVATING, ProcessInstanceIntent.ELEMENT_ACTIVATED, ProcessInstanceIntent.ELEMENT_COMPLETING, ProcessInstanceIntent.ELEMENT_COMPLETED, ProcessInstanceIntent.SEQUENCE_FLOW_TAKEN, ProcessInstanceIntent.ELEMENT_ACTIVATING, ProcessInstanceIntent.ELEMENT_ACTIVATED, ProcessInstanceIntent.ELEMENT_COMPLETING, ProcessInstanceIntent.ELEMENT_COMPLETED, ProcessInstanceIntent.ELEMENT_COMPLETING, ProcessInstanceIntent.ELEMENT_COMPLETED});
        long processInstanceKey2 = ENGINE.processInstance().ofBpmnProcessId(processId).withVariable("str", "b").create();
        processEvents = ((ProcessInstanceRecordStream)((ProcessInstanceRecordStream)RecordingExporter.processInstanceRecords().onlyEvents()).withProcessInstanceKey(processInstanceKey2).skipUntil(r -> ((ProcessInstanceRecordValue)r.getValue()).getElementId().equals("inclusive"))).limitToProcessInstanceCompleted().asList();
        Assertions.assertThat((List)processEvents).extracting(Record::getIntent).containsExactly((Object[])new Intent[]{ProcessInstanceIntent.ELEMENT_ACTIVATING, ProcessInstanceIntent.ELEMENT_ACTIVATED, ProcessInstanceIntent.ELEMENT_COMPLETING, ProcessInstanceIntent.ELEMENT_COMPLETED, ProcessInstanceIntent.SEQUENCE_FLOW_TAKEN, ProcessInstanceIntent.ELEMENT_ACTIVATING, ProcessInstanceIntent.ELEMENT_ACTIVATED, ProcessInstanceIntent.ELEMENT_COMPLETING, ProcessInstanceIntent.ELEMENT_COMPLETED, ProcessInstanceIntent.ELEMENT_COMPLETING, ProcessInstanceIntent.ELEMENT_COMPLETED});
        long processInstanceKey3 = ENGINE.processInstance().ofBpmnProcessId(processId).withVariable("str", "c").create();
        processEvents = ((ProcessInstanceRecordStream)((ProcessInstanceRecordStream)RecordingExporter.processInstanceRecords().onlyEvents()).withProcessInstanceKey(processInstanceKey3).skipUntil(r -> ((ProcessInstanceRecordValue)r.getValue()).getElementId().equals("inclusive"))).limitToProcessInstanceCompleted().asList();
        Assertions.assertThat((List)processEvents).extracting(Record::getIntent).containsExactly((Object[])new Intent[]{ProcessInstanceIntent.ELEMENT_ACTIVATING, ProcessInstanceIntent.ELEMENT_ACTIVATED, ProcessInstanceIntent.ELEMENT_COMPLETING, ProcessInstanceIntent.ELEMENT_COMPLETED, ProcessInstanceIntent.SEQUENCE_FLOW_TAKEN, ProcessInstanceIntent.ELEMENT_ACTIVATING, ProcessInstanceIntent.ELEMENT_ACTIVATED, ProcessInstanceIntent.ELEMENT_COMPLETING, ProcessInstanceIntent.ELEMENT_COMPLETED, ProcessInstanceIntent.ELEMENT_COMPLETING, ProcessInstanceIntent.ELEMENT_COMPLETED});
        long processInstanceKey4 = ENGINE.processInstance().ofBpmnProcessId(processId).withVariable("str", "a,b").create();
        processEvents = ((ProcessInstanceRecordStream)((ProcessInstanceRecordStream)RecordingExporter.processInstanceRecords().onlyEvents()).withProcessInstanceKey(processInstanceKey4).skipUntil(r -> ((ProcessInstanceRecordValue)r.getValue()).getElementId().equals("inclusive"))).limitToProcessInstanceCompleted().asList();
        Assertions.assertThat((List)processEvents).extracting(Record::getIntent).containsExactly((Object[])new Intent[]{ProcessInstanceIntent.ELEMENT_ACTIVATING, ProcessInstanceIntent.ELEMENT_ACTIVATED, ProcessInstanceIntent.ELEMENT_COMPLETING, ProcessInstanceIntent.ELEMENT_COMPLETED, ProcessInstanceIntent.SEQUENCE_FLOW_TAKEN, ProcessInstanceIntent.ELEMENT_ACTIVATING, ProcessInstanceIntent.ELEMENT_ACTIVATED, ProcessInstanceIntent.ELEMENT_COMPLETING, ProcessInstanceIntent.ELEMENT_COMPLETED, ProcessInstanceIntent.ELEMENT_COMPLETING, ProcessInstanceIntent.ELEMENT_COMPLETED});
    }

    @Test
    public void shouldActivateTasksOnInclusiveBranches() {
        ENGINE.deployment().withXmlResource(INCLUSIVE_PROCESS).deploy();
        long processInstanceKey1 = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).withVariable("str", "a,b,c").create();
        Assertions.assertThat((Stream)((ProcessInstanceRecordStream)RecordingExporter.processInstanceRecords().withProcessInstanceKey(processInstanceKey1).limitToProcessInstanceCompleted().withIntent((Intent)ProcessInstanceIntent.ELEMENT_ACTIVATED)).withElementType(BpmnElementType.MANUAL_TASK)).extracting(record -> ((ProcessInstanceRecordValue)record.getValue()).getElementId()).containsExactlyInAnyOrder((Object[])new String[]{"task1", "task2"});
        long processInstanceKey2 = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).withVariable("str", "a,c").create();
        Assertions.assertThat((Stream)((ProcessInstanceRecordStream)RecordingExporter.processInstanceRecords().withProcessInstanceKey(processInstanceKey2).limitToProcessInstanceCompleted().withIntent((Intent)ProcessInstanceIntent.ELEMENT_ACTIVATED)).withElementType(BpmnElementType.MANUAL_TASK)).extracting(record -> ((ProcessInstanceRecordValue)record.getValue()).getElementId()).containsExactly((Object[])new String[]{"task1"});
        long processInstanceKey3 = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).withVariable("str", "d").create();
        Assertions.assertThat((Stream)((ProcessInstanceRecordStream)RecordingExporter.processInstanceRecords().withProcessInstanceKey(processInstanceKey3).limitToProcessInstanceCompleted().withIntent((Intent)ProcessInstanceIntent.ELEMENT_ACTIVATED)).withElementType(BpmnElementType.MANUAL_TASK)).extracting(record -> ((ProcessInstanceRecordValue)record.getValue()).getElementId()).containsExactly((Object[])new String[]{"task3"});
    }

    @Test
    public void shouldCompleteScopeWhenForkingPathsCompleted() {
        ENGINE.deployment().withXmlResource(INCLUSIVE_PROCESS).deploy();
        long processInstanceKey1 = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).withVariable("str", "a,b,c").create();
        Assertions.assertThat((Stream)((ProcessInstanceRecordStream)RecordingExporter.processInstanceRecords().withProcessInstanceKey(processInstanceKey1).limitToProcessInstanceCompleted().withIntent((Intent)ProcessInstanceIntent.ELEMENT_COMPLETED)).withElementType(BpmnElementType.END_EVENT)).extracting(record -> ((ProcessInstanceRecordValue)record.getValue()).getElementId()).containsExactlyInAnyOrder((Object[])new String[]{"end1", "end2"});
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_COMPLETED).withProcessInstanceKey(processInstanceKey1).withElementType(BpmnElementType.PROCESS).exists()).describedAs("Expect to complete the process instance", new Object[0])).isTrue();
        long processInstanceKey2 = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).withVariable("str", "a,b").create();
        Assertions.assertThat((Stream)((ProcessInstanceRecordStream)RecordingExporter.processInstanceRecords().withProcessInstanceKey(processInstanceKey2).limitToProcessInstanceCompleted().withIntent((Intent)ProcessInstanceIntent.ELEMENT_COMPLETED)).withElementType(BpmnElementType.END_EVENT)).extracting(record -> ((ProcessInstanceRecordValue)record.getValue()).getElementId()).containsExactlyInAnyOrder((Object[])new String[]{"end1", "end2"});
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_COMPLETED).withProcessInstanceKey(processInstanceKey2).withElementType(BpmnElementType.PROCESS).exists()).describedAs("Expect to complete the process instance", new Object[0])).isTrue();
        long processInstanceKey3 = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).withVariable("str", "d").create();
        Assertions.assertThat((Stream)((ProcessInstanceRecordStream)RecordingExporter.processInstanceRecords().withProcessInstanceKey(processInstanceKey3).limitToProcessInstanceCompleted().withIntent((Intent)ProcessInstanceIntent.ELEMENT_COMPLETED)).withElementType(BpmnElementType.END_EVENT)).extracting(record -> ((ProcessInstanceRecordValue)record.getValue()).getElementId()).containsExactly((Object[])new String[]{"end3"});
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_COMPLETED).withProcessInstanceKey(processInstanceKey3).withElementType(BpmnElementType.PROCESS).exists()).describedAs("Expect to complete the process instance", new Object[0])).isTrue();
    }

    @Test
    public void shouldPassThroughInclusiveGateway() {
        BpmnModelInstance process = ((InclusiveGatewayBuilder)((StartEventBuilder)Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent("start").sequenceFlowId("flow1")).inclusiveGateway("inclusive").sequenceFlowId("flow2")).endEvent("end").done();
        ENGINE.deployment().withXmlResource(process).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        List processInstanceEvents = (List)((ProcessInstanceRecordStream)RecordingExporter.processInstanceRecords().onlyEvents()).withProcessInstanceKey(processInstanceKey).limitToProcessInstanceCompleted().collect(Collectors.toList());
        Assertions.assertThat((List)processInstanceEvents).extracting(new Function[]{e -> ((ProcessInstanceRecordValue)e.getValue()).getElementId(), Record::getIntent}).containsSequence((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{"inclusive", ProcessInstanceIntent.ELEMENT_ACTIVATING}), Assertions.tuple((Object[])new Object[]{"inclusive", ProcessInstanceIntent.ELEMENT_ACTIVATED}), Assertions.tuple((Object[])new Object[]{"inclusive", ProcessInstanceIntent.ELEMENT_COMPLETING}), Assertions.tuple((Object[])new Object[]{"inclusive", ProcessInstanceIntent.ELEMENT_COMPLETED}), Assertions.tuple((Object[])new Object[]{"flow2", ProcessInstanceIntent.SEQUENCE_FLOW_TAKEN}), Assertions.tuple((Object[])new Object[]{"end", ProcessInstanceIntent.ELEMENT_ACTIVATING}), Assertions.tuple((Object[])new Object[]{"end", ProcessInstanceIntent.ELEMENT_ACTIVATED}), Assertions.tuple((Object[])new Object[]{"end", ProcessInstanceIntent.ELEMENT_COMPLETING}), Assertions.tuple((Object[])new Object[]{"end", ProcessInstanceIntent.ELEMENT_COMPLETED}), Assertions.tuple((Object[])new Object[]{PROCESS_ID, ProcessInstanceIntent.ELEMENT_COMPLETING}), Assertions.tuple((Object[])new Object[]{PROCESS_ID, ProcessInstanceIntent.ELEMENT_COMPLETED})});
    }

    @Test
    public void shouldCreateIncidentIfInclusiveGatewayWithSingleSequenceFlowHasNoMatchingCondition() {
        BpmnModelInstance process = ((InclusiveGatewayBuilder)Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().inclusiveGateway().condition("= false")).endEvent().done();
        ENGINE.deployment().withXmlResource(process).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        Record failingEvent = (Record)((ProcessInstanceRecordStream)RecordingExporter.processInstanceRecords().withElementType(BpmnElementType.INCLUSIVE_GATEWAY).withIntent((Intent)ProcessInstanceIntent.ELEMENT_ACTIVATING)).withProcessInstanceKey(processInstanceKey).getFirst();
        Record incidentEvent = (Record)((IncidentRecordStream)RecordingExporter.incidentRecords().withProcessInstanceKey(processInstanceKey).withIntent((Intent)IncidentIntent.CREATED)).getFirst();
        io.camunda.zeebe.protocol.record.Assertions.assertThat((IncidentRecordValue)((IncidentRecordValue)incidentEvent.getValue())).hasErrorType(ErrorType.CONDITION_ERROR).hasErrorMessage("Expected at least one condition to evaluate to true, or to have a default flow").hasBpmnProcessId(((ProcessInstanceRecordValue)failingEvent.getValue()).getBpmnProcessId()).hasProcessInstanceKey(((ProcessInstanceRecordValue)failingEvent.getValue()).getProcessInstanceKey()).hasElementId(((ProcessInstanceRecordValue)failingEvent.getValue()).getElementId()).hasElementInstanceKey(failingEvent.getKey()).hasVariableScopeKey(failingEvent.getKey());
    }

    @Test
    public void shouldCompleteScopeOnInclusiveGateway() {
        String processId = Strings.newRandomValidBpmnId();
        BpmnModelInstance process = ((StartEventBuilder)Bpmn.createExecutableProcess((String)processId).startEvent("start").sequenceFlowId("flow1")).inclusiveGateway("inclusive").done();
        ENGINE.deployment().withXmlResource(process).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(processId).create();
        List processInstanceEvents = RecordingExporter.processInstanceRecords().withProcessInstanceKey(processInstanceKey).limitToProcessInstanceCompleted().asList();
        Assertions.assertThat((List)processInstanceEvents).extracting(new Function[]{e -> ((ProcessInstanceRecordValue)e.getValue()).getElementId(), Record::getIntent}).containsSequence((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{"inclusive", ProcessInstanceIntent.ELEMENT_COMPLETED}), Assertions.tuple((Object[])new Object[]{processId, ProcessInstanceIntent.COMPLETE_ELEMENT})});
    }

    @Test
    public void shouldCreateDeploymentInclusiveGatewayWithDefaultFlow() {
        String processId = Strings.newRandomValidBpmnId();
        BpmnModelInstance processDefinition1 = ((AbstractInclusiveGatewayBuilder)((InclusiveGatewayBuilder)((InclusiveGatewayBuilder)Bpmn.createExecutableProcess((String)processId).startEvent().inclusiveGateway("inclusive").sequenceFlowId("s1")).conditionExpression("= contains(str,\"a\")")).endEvent("end1").moveToLastInclusiveGateway().defaultFlow().sequenceFlowId("s2")).endEvent("end2").done();
        Record<DeploymentRecordValue> deployment1 = ENGINE.deployment().withXmlResource(processDefinition1).deploy();
        ((AbstractLongAssert)Assertions.assertThat((long)deployment1.getKey()).describedAs("Inclusive gateway's default flow should be allowed to have no condition", new Object[0])).isNotNegative();
        BpmnModelInstance processDefinition2 = ((AbstractInclusiveGatewayBuilder)((AbstractInclusiveGatewayBuilder)((InclusiveGatewayBuilder)((InclusiveGatewayBuilder)Bpmn.createExecutableProcess((String)processId).startEvent().inclusiveGateway("inclusive").sequenceFlowId("s1")).conditionExpression("= contains(str,\"a\")")).endEvent("end1").moveToLastInclusiveGateway().defaultFlow().sequenceFlowId("s2")).conditionExpression("= contains(str,\"b\")")).endEvent("end2").done();
        Record<DeploymentRecordValue> deployment2 = ENGINE.deployment().withXmlResource(processDefinition2).deploy();
        ((AbstractLongAssert)Assertions.assertThat((long)deployment2.getKey()).describedAs("Inclusive gateway's default flow should be allowed to have a condition, but not be required", new Object[0])).isNotNegative();
    }

    @Test
    public void shouldNotEvaluateConditionOfDefaultFlow() {
        String processId = Strings.newRandomValidBpmnId();
        BpmnModelInstance processDefinition = ((AbstractInclusiveGatewayBuilder)((AbstractInclusiveGatewayBuilder)((AbstractGatewayBuilder)((AbstractGatewayBuilder)((InclusiveGatewayBuilder)((InclusiveGatewayBuilder)Bpmn.createExecutableProcess((String)processId).startEvent().inclusiveGateway("inclusive").sequenceFlowId("s1")).conditionExpression("= contains(str,\"a\")")).endEvent("end1").moveToLastGateway().sequenceFlowId("s2")).conditionExpression("= contains(str,\"b\")")).endEvent("end2").moveToLastInclusiveGateway().defaultFlow().sequenceFlowId("s3")).conditionExpression("= true")).endEvent("end3").done();
        ENGINE.deployment().withXmlResource(processDefinition).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(processId).withVariable("str", "d").create();
        ((ListAssert)((ListAssert)((ListAssert)Assertions.assertThat((Stream)RecordingExporter.records().limitToProcessInstance(processInstanceKey)).describedAs("Expect that the default flow is taken", new Object[0])).satisfies(new ThrowingConsumer[]{record -> Assertions.assertThat(record.stream().filter(r -> r.getValueType() == ValueType.PROCESS_INSTANCE)).extracting(new Function[]{r -> ((ProcessInstanceRecordValue)r.getValue()).getElementId(), Record::getIntent}).containsSubsequence((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{"inclusive", ProcessInstanceIntent.ELEMENT_COMPLETED}), Assertions.tuple((Object[])new Object[]{"s3", ProcessInstanceIntent.SEQUENCE_FLOW_TAKEN}), Assertions.tuple((Object[])new Object[]{"end3", ProcessInstanceIntent.ELEMENT_COMPLETED})})})).describedAs("Expect that the default flow's condition is not evaluated", new Object[0])).satisfies(new ThrowingConsumer[]{r -> Assertions.assertThat((List)r).extracting(Record::getIntent).doesNotContain((Object[])new Intent[]{IncidentIntent.CREATED})});
    }

    @Test
    public void shouldEvaluateConditionWithoutDefaultFlow() {
        String processId = Strings.newRandomValidBpmnId();
        BpmnModelInstance processDefinition = ((AbstractInclusiveGatewayBuilder)((AbstractInclusiveGatewayBuilder)((AbstractGatewayBuilder)((AbstractGatewayBuilder)((InclusiveGatewayBuilder)((InclusiveGatewayBuilder)Bpmn.createExecutableProcess((String)processId).startEvent().inclusiveGateway("inclusive").sequenceFlowId("s1")).conditionExpression("= contains(str,\"a\")")).endEvent("end1").moveToLastGateway().sequenceFlowId("s2")).conditionExpression("= contains(str,\"b\")")).endEvent("end2").moveToLastInclusiveGateway().sequenceFlowId("s3")).conditionExpression("= true")).endEvent("end3").done();
        ENGINE.deployment().withXmlResource(processDefinition).deploy();
        long processInstance = ENGINE.processInstance().ofBpmnProcessId(processId).withVariable("str", "a,b").create();
        Assertions.assertThat((Stream)RecordingExporter.processInstanceRecords().withProcessInstanceKey(processInstance).limitToProcessInstanceCompleted().withElementType(BpmnElementType.END_EVENT).withIntent((Intent)ProcessInstanceIntent.ELEMENT_COMPLETED)).extracting(Record::getValue).describedAs("when all conditions are true,then all sequence flows are taken", new Object[0]).extracting(v -> Assertions.tuple((Object[])new Object[]{v.getProcessInstanceKey(), v.getElementId()})).contains((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{processInstance, "end1"}), Assertions.tuple((Object[])new Object[]{processInstance, "end2"}), Assertions.tuple((Object[])new Object[]{processInstance, "end3"})});
    }
}

