/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.common;

import io.camunda.zeebe.el.EvaluationContext;
import io.camunda.zeebe.el.Expression;
import io.camunda.zeebe.el.ExpressionLanguage;
import io.camunda.zeebe.el.ExpressionLanguageFactory;
import io.camunda.zeebe.engine.processing.bpmn.clock.ZeebeFeelEngineClock;
import io.camunda.zeebe.engine.processing.common.ExpressionProcessor;
import io.camunda.zeebe.engine.processing.common.Failure;
import io.camunda.zeebe.scheduler.clock.ActorClock;
import io.camunda.zeebe.test.util.asserts.EitherAssert;
import io.camunda.zeebe.util.Either;
import java.util.List;
import java.util.stream.Stream;
import org.camunda.feel.FeelEngineClock;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

class ExpressionProcessorTest {
    private static final ExpressionLanguage EXPRESSION_LANGUAGE = ExpressionLanguageFactory.createExpressionLanguage((FeelEngineClock)new ZeebeFeelEngineClock(ActorClock.current()));
    private static final EvaluationContext EMPTY_LOOKUP = x -> null;
    private static final ExpressionProcessor.EvaluationContextLookup DEFAULT_CONTEXT_LOOKUP = scope -> EMPTY_LOOKUP;

    ExpressionProcessorTest() {
    }

    @Nested
    @TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
    class EvaluationWarningsTest {
        EvaluationWarningsTest(ExpressionProcessorTest this$0) {
        }

        @Test
        void testStringExpression() {
            ExpressionProcessor processor = new ExpressionProcessor(EXPRESSION_LANGUAGE, DEFAULT_CONTEXT_LOOKUP);
            Expression parsedExpression = EXPRESSION_LANGUAGE.parseExpression("=x");
            EitherAssert.assertThat((Either)processor.evaluateStringExpression(parsedExpression, -1L)).isLeft().extracting(r -> ((Failure)r.getLeft()).getMessage()).isEqualTo((Object)"Expected result of the expression 'x' to be 'STRING', but was 'NULL'. The evaluation reported the following warnings:\n[NO_VARIABLE_FOUND] No variable found with name 'x'");
        }

        @Test
        void testLongExpression() {
            ExpressionProcessor processor = new ExpressionProcessor(EXPRESSION_LANGUAGE, DEFAULT_CONTEXT_LOOKUP);
            Expression parsedExpression = EXPRESSION_LANGUAGE.parseExpression("=x");
            EitherAssert.assertThat((Either)processor.evaluateLongExpression(parsedExpression, -1L)).isLeft().extracting(r -> ((Failure)r.getLeft()).getMessage()).isEqualTo((Object)"Expected result of the expression 'x' to be 'NUMBER', but was 'NULL'. The evaluation reported the following warnings:\n[NO_VARIABLE_FOUND] No variable found with name 'x'");
        }

        @Test
        void testBooleanExpression() {
            ExpressionProcessor processor = new ExpressionProcessor(EXPRESSION_LANGUAGE, DEFAULT_CONTEXT_LOOKUP);
            Expression parsedExpression = EXPRESSION_LANGUAGE.parseExpression("=x");
            EitherAssert.assertThat((Either)processor.evaluateBooleanExpression(parsedExpression, -1L)).isLeft().extracting(r -> ((Failure)r.getLeft()).getMessage()).isEqualTo((Object)"Expected result of the expression 'x' to be 'BOOLEAN', but was 'NULL'. The evaluation reported the following warnings:\n[NO_VARIABLE_FOUND] No variable found with name 'x'");
        }

        @Test
        void testIntervalExpression() {
            ExpressionProcessor processor = new ExpressionProcessor(EXPRESSION_LANGUAGE, DEFAULT_CONTEXT_LOOKUP);
            Expression parsedExpression = EXPRESSION_LANGUAGE.parseExpression("=x");
            EitherAssert.assertThat((Either)processor.evaluateIntervalExpression(parsedExpression, -1L)).isLeft().extracting(r -> ((Failure)r.getLeft()).getMessage()).isEqualTo((Object)"Expected result of the expression 'x' to be one of '[DURATION, PERIOD, STRING]', but was 'NULL'. The evaluation reported the following warnings:\n[NO_VARIABLE_FOUND] No variable found with name 'x'");
        }

        @Test
        void testDateTimeExpression() {
            ExpressionProcessor processor = new ExpressionProcessor(EXPRESSION_LANGUAGE, DEFAULT_CONTEXT_LOOKUP);
            Expression parsedExpression = EXPRESSION_LANGUAGE.parseExpression("=x");
            EitherAssert.assertThat((Either)processor.evaluateDateTimeExpression(parsedExpression, Long.valueOf(-1L))).isLeft().extracting(r -> ((Failure)r.getLeft()).getMessage()).isEqualTo((Object)"Expected result of the expression 'x' to be one of '[DATE_TIME, STRING]', but was 'NULL'. The evaluation reported the following warnings:\n[NO_VARIABLE_FOUND] No variable found with name 'x'");
        }

        @Test
        void testArrayExpression() {
            ExpressionProcessor processor = new ExpressionProcessor(EXPRESSION_LANGUAGE, DEFAULT_CONTEXT_LOOKUP);
            Expression parsedExpression = EXPRESSION_LANGUAGE.parseExpression("=x");
            EitherAssert.assertThat((Either)processor.evaluateArrayExpression(parsedExpression, -1L)).isLeft().extracting(r -> ((Failure)r.getLeft()).getMessage()).isEqualTo((Object)"Expected result of the expression 'x' to be 'ARRAY', but was 'NULL'. The evaluation reported the following warnings:\n[NO_VARIABLE_FOUND] No variable found with name 'x'");
        }

        @Test
        void testStringArrayExpression() {
            ExpressionProcessor processor = new ExpressionProcessor(EXPRESSION_LANGUAGE, DEFAULT_CONTEXT_LOOKUP);
            Expression parsedExpression = EXPRESSION_LANGUAGE.parseExpression("=[x]");
            EitherAssert.assertThat((Either)processor.evaluateArrayOfStringsExpression(parsedExpression, -1L)).isLeft().extracting(r -> ((Failure)r.getLeft()).getMessage()).isEqualTo((Object)"Expected result of the expression '[x]' to be 'ARRAY' containing 'STRING' items, but was 'ARRAY' containing at least one non-'STRING' item. The evaluation reported the following warnings:\n[NO_VARIABLE_FOUND] No variable found with name 'x'");
        }

        @Test
        void testMessageCorrelationKeyExpression() {
            ExpressionProcessor processor = new ExpressionProcessor(EXPRESSION_LANGUAGE, DEFAULT_CONTEXT_LOOKUP);
            Expression parsedExpression = EXPRESSION_LANGUAGE.parseExpression("=x");
            EitherAssert.assertThat((Either)processor.evaluateMessageCorrelationKeyExpression(parsedExpression, -1L)).isLeft().extracting(r -> ((Failure)r.getLeft()).getMessage()).isEqualTo((Object)"Failed to extract the correlation key for 'x': The value must be either a string or a number, but was 'NULL'. The evaluation reported the following warnings:\n[NO_VARIABLE_FOUND] No variable found with name 'x'");
        }

        @Test
        void testVariableMappingExpression() {
            ExpressionProcessor processor = new ExpressionProcessor(EXPRESSION_LANGUAGE, DEFAULT_CONTEXT_LOOKUP);
            Expression parsedExpression = EXPRESSION_LANGUAGE.parseExpression("=x");
            EitherAssert.assertThat((Either)processor.evaluateVariableMappingExpression(parsedExpression, -1L)).isLeft().extracting(r -> ((Failure)r.getLeft()).getMessage()).isEqualTo((Object)"Expected result of the expression 'x' to be 'OBJECT', but was 'NULL'. The evaluation reported the following warnings:\n[NO_VARIABLE_FOUND] No variable found with name 'x'");
        }
    }

    @Nested
    @TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
    class EvaluateArrayOfStringsExpressionTest {
        EvaluateArrayOfStringsExpressionTest(ExpressionProcessorTest this$0) {
        }

        @ParameterizedTest
        @MethodSource(value={"arrayOfStringsExpressions"})
        void testSuccessfulEvaluations(String expression, List<String> expected) {
            ExpressionProcessor processor = new ExpressionProcessor(EXPRESSION_LANGUAGE, DEFAULT_CONTEXT_LOOKUP);
            Expression parsedExpression = EXPRESSION_LANGUAGE.parseExpression(expression);
            EitherAssert.assertThat((Either)processor.evaluateArrayOfStringsExpression(parsedExpression, -1L)).isRight().extracting(Either::get).isEqualTo(expected);
        }

        @ParameterizedTest
        @MethodSource(value={"notArrayOfStringsExpressions"})
        void testFailingEvaluations(String expression, String message) {
            ExpressionProcessor processor = new ExpressionProcessor(EXPRESSION_LANGUAGE, DEFAULT_CONTEXT_LOOKUP);
            Expression parsedExpression = EXPRESSION_LANGUAGE.parseExpression(expression);
            EitherAssert.assertThat((Either)processor.evaluateArrayOfStringsExpression(parsedExpression, -1L)).isLeft().extracting(Either::getLeft).extracting(Failure::getMessage).isEqualTo((Object)message);
        }

        Stream<Arguments> arrayOfStringsExpressions() {
            return Stream.of(Arguments.of((Object[])new Object[]{"= []", List.of()}), Arguments.of((Object[])new Object[]{"= [\"a\"]", List.of("a")}), Arguments.of((Object[])new Object[]{"= [\"a\",\"b\"]", List.of("a", "b")}));
        }

        Stream<Arguments> notArrayOfStringsExpressions() {
            return Stream.of(Arguments.of((Object[])new Object[]{"= \"a\"", "Expected result of the expression ' \"a\"' to be 'ARRAY', but was 'STRING'."}), Arguments.of((Object[])new Object[]{"= 1", "Expected result of the expression ' 1' to be 'ARRAY', but was 'NUMBER'."}), Arguments.of((Object[])new Object[]{"= {}", "Expected result of the expression ' {}' to be 'ARRAY', but was 'OBJECT'."}), Arguments.of((Object[])new Object[]{"[]", "Expected result of the expression '[]' to be 'ARRAY', but was 'STRING'."}), Arguments.of((Object[])new Object[]{"= [1,2,3]", "Expected result of the expression ' [1,2,3]' to be 'ARRAY' containing 'STRING' items, but was 'ARRAY' containing at least one non-'STRING' item."}), Arguments.of((Object[])new Object[]{"= [{},{}]", "Expected result of the expression ' [{},{}]' to be 'ARRAY' containing 'STRING' items, but was 'ARRAY' containing at least one non-'STRING' item."}), Arguments.of((Object[])new Object[]{"= [null]", "Expected result of the expression ' [null]' to be 'ARRAY' containing 'STRING' items, but was 'ARRAY' containing at least one non-'STRING' item."}));
        }
    }
}

