/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.deployment;

import io.camunda.zeebe.engine.util.EngineRule;
import io.camunda.zeebe.model.bpmn.Bpmn;
import io.camunda.zeebe.model.bpmn.BpmnModelInstance;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.RecordType;
import io.camunda.zeebe.protocol.record.intent.CommandDistributionIntent;
import io.camunda.zeebe.protocol.record.intent.DecisionIntent;
import io.camunda.zeebe.protocol.record.intent.DecisionRequirementsIntent;
import io.camunda.zeebe.protocol.record.intent.DeploymentIntent;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.ProcessIntent;
import io.camunda.zeebe.protocol.record.value.CommandDistributionRecordValue;
import io.camunda.zeebe.protocol.record.value.DeploymentRecordValue;
import io.camunda.zeebe.protocol.record.value.TenantOwned;
import io.camunda.zeebe.protocol.record.value.deployment.DecisionRecordValue;
import io.camunda.zeebe.protocol.record.value.deployment.DecisionRequirementsMetadataValue;
import io.camunda.zeebe.protocol.record.value.deployment.ProcessMetadataValue;
import io.camunda.zeebe.test.util.Strings;
import io.camunda.zeebe.test.util.record.CommandDistributionRecordStream;
import io.camunda.zeebe.test.util.record.DecisionRecordStream;
import io.camunda.zeebe.test.util.record.DecisionRequirementsRecordStream;
import io.camunda.zeebe.test.util.record.DeploymentRecordStream;
import io.camunda.zeebe.test.util.record.ProcessRecordStream;
import io.camunda.zeebe.test.util.record.RecordStream;
import io.camunda.zeebe.test.util.record.RecordingExporter;
import io.camunda.zeebe.test.util.record.RecordingExporterTestWatcher;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.iterable.ThrowingExtractor;
import org.assertj.core.groups.Tuple;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

public final class CreateDeploymentMultiplePartitionsTest {
    public static final String PROCESS_ID = "process";
    public static final int PARTITION_ID = 1;
    public static final int PARTITION_COUNT = 3;
    @ClassRule
    public static final EngineRule ENGINE = EngineRule.multiplePartition(3);
    private static final BpmnModelInstance PROCESS = Bpmn.createExecutableProcess((String)"process").startEvent().endEvent().done();
    private static final BpmnModelInstance PROCESS_2 = Bpmn.createExecutableProcess((String)"process2").startEvent().endEvent().done();
    private static final String DMN_DECISION_TABLE = "/dmn/decision-table.dmn";
    private static final String DMN_DECISION_TABLE_V2 = "/dmn/decision-table_v2.dmn";
    private static final String DMN_DECISION_TABLE_RENAMED = "/dmn/decision-table-with-renamed-drg-and-decision.dmn";
    @Rule
    public final RecordingExporterTestWatcher recordingExporterTestWatcher = new RecordingExporterTestWatcher();

    @Test
    public void shouldCreateDeploymentOnAllPartitions() {
        BpmnModelInstance modelInstance = Bpmn.createExecutableProcess((String)"shouldCreateDeploymentOnAllPartitions").startEvent().endEvent().done();
        BpmnModelInstance secondNoopModel = Bpmn.createExecutableProcess((String)"shouldCreateDeploymentOnAllPartitionsSecondNoopDeployment").startEvent().endEvent().done();
        Record<DeploymentRecordValue> deployment = ENGINE.deployment().withXmlResource("process.bpmn", modelInstance).deploy();
        Record<DeploymentRecordValue> secondDeployment = ENGINE.deployment().withXmlResource("secondNoopModel.bpmn", secondNoopModel).deploy();
        Assertions.assertThat((long)deployment.getKey()).isNotNegative();
        Assertions.assertThat((int)deployment.getPartitionId()).isEqualTo(1);
        Assertions.assertThat((Comparable)deployment.getRecordType()).isEqualTo((Object)RecordType.EVENT);
        Assertions.assertThat((Object)deployment.getIntent()).isEqualTo((Object)DeploymentIntent.CREATED);
        List deploymentRecords = ((RecordStream)((RecordStream)RecordingExporter.records().limit(r -> r.getIntent() == CommandDistributionIntent.FINISHED && r.getKey() == secondDeployment.getKey())).withRecordKey(deployment.getKey())).toList();
        List<Record> listOfFinishedDistributions = deploymentRecords.stream().filter(r -> r.getIntent() == CommandDistributionIntent.FINISHED).toList();
        Assertions.assertThat(listOfFinishedDistributions).hasSize(1);
        Record fullyDistributedDeployment = listOfFinishedDistributions.get(0);
        Assertions.assertThat((long)fullyDistributedDeployment.getKey()).isNotNegative();
        Assertions.assertThat((int)fullyDistributedDeployment.getPartitionId()).isEqualTo(1);
        Assertions.assertThat((Comparable)fullyDistributedDeployment.getRecordType()).isEqualTo((Object)RecordType.EVENT);
        Assertions.assertThat((Object)fullyDistributedDeployment.getIntent()).isEqualTo((Object)CommandDistributionIntent.FINISHED);
        Assertions.assertThat((long)deploymentRecords.stream().filter(r -> r.getIntent() == DeploymentIntent.CREATE).count()).isEqualTo(2L);
        Assertions.assertThat((long)deploymentRecords.stream().filter(r -> r.getIntent() == CommandDistributionIntent.DISTRIBUTING).count()).isEqualTo(2L);
        Assertions.assertThat((long)deploymentRecords.stream().filter(r -> r.getIntent() == CommandDistributionIntent.ACKNOWLEDGE).count()).isEqualTo(2L);
        ENGINE.getPartitionIds().forEach(partitionId -> this.assertDeploymentEventResources((int)partitionId, DeploymentIntent.CREATED, deployment.getKey(), createdDeployment -> this.assertDeploymentRecordWithoutResources(deployment, (Record<DeploymentRecordValue>)createdDeployment)));
    }

    @Test
    public void shouldOnlyDistributeFromDeploymentPartition() {
        long deploymentKey1 = ENGINE.deployment().withXmlResource(PROCESS).deploy().getKey();
        List distributionRecords = ((CommandDistributionRecordStream)((CommandDistributionRecordStream)((CommandDistributionRecordStream)RecordingExporter.commandDistributionRecords().withRecordKey(deploymentKey1)).withIntent((Intent)CommandDistributionIntent.DISTRIBUTING)).limit(2L)).asList();
        Assertions.assertThat((List)distributionRecords).hasSize(2);
        Assertions.assertThat((List)distributionRecords).extracting(Record::getValue).extracting(CommandDistributionRecordValue::getPartitionId).doesNotContain((Object[])new Integer[]{1});
    }

    @Test
    public void shouldWriteDistributingRecordsForOtherPartitions() {
        long deploymentKey = ENGINE.deployment().withXmlResource(PROCESS).deploy().getKey();
        List commandDistributionRecords = ((CommandDistributionRecordStream)((CommandDistributionRecordStream)RecordingExporter.commandDistributionRecords().withIntent((Intent)CommandDistributionIntent.DISTRIBUTING)).limit(2L)).asList();
        Assertions.assertThat((List)commandDistributionRecords).extracting(Record::getKey).containsOnly((Object[])new Long[]{deploymentKey});
        Assertions.assertThat((List)commandDistributionRecords).extracting(Record::getPartitionId).containsOnly((Object[])new Integer[]{1});
        Assertions.assertThat((List)commandDistributionRecords).extracting(Record::getValue).extracting(CommandDistributionRecordValue::getPartitionId).containsExactly((Object[])new Integer[]{2, 3});
    }

    @Test
    public void shouldCreateDeploymentResourceWithMultipleProcesses() {
        Record<DeploymentRecordValue> deployment = ENGINE.deployment().withXmlResource("process.bpmn", PROCESS).withXmlResource("process2.bpmn", PROCESS_2).deploy();
        Assertions.assertThat((Comparable)deployment.getRecordType()).isEqualTo((Object)RecordType.EVENT);
        Assertions.assertThat((Object)deployment.getIntent()).isEqualTo((Object)DeploymentIntent.CREATED);
        List deployments = ((DeploymentRecordStream)((DeploymentRecordStream)((DeploymentRecordStream)RecordingExporter.deploymentRecords().withIntent((Intent)DeploymentIntent.CREATED)).withRecordKey(deployment.getKey())).limit(3L)).asList();
        ((ListAssert)Assertions.assertThat((List)deployments).hasSize(3)).extracting(Record::getValue).flatExtracting(DeploymentRecordValue::getProcessesMetadata).extracting(ProcessMetadataValue::getBpmnProcessId).containsOnly((Object[])new String[]{PROCESS_ID, "process2"});
    }

    @Test
    public void shouldIncrementProcessVersions() {
        BpmnModelInstance modelInstance = Bpmn.createExecutableProcess((String)"shouldIncrementProcessVersions").startEvent().endEvent().done();
        Record<DeploymentRecordValue> firstDeployment = ENGINE.deployment().withXmlResource("process1.bpmn", modelInstance).deploy();
        Record<DeploymentRecordValue> secondDeployment = ENGINE.deployment().withXmlResource("process2.bpmn", modelInstance).deploy();
        Record firstCreatedDeployment = (Record)((DeploymentRecordStream)((DeploymentRecordStream)((DeploymentRecordStream)RecordingExporter.deploymentRecords().withIntent((Intent)DeploymentIntent.CREATED)).withPartitionId(1)).withRecordKey(firstDeployment.getKey())).getFirst();
        List deployedProcesses = ((DeploymentRecordValue)firstCreatedDeployment.getValue()).getProcessesMetadata();
        Assertions.assertThat((List)deployedProcesses).flatExtracting(new ThrowingExtractor[]{ProcessMetadataValue::getVersion}).containsOnly(new Object[]{1});
        Record secondCreatedDeployments = (Record)((DeploymentRecordStream)((DeploymentRecordStream)((DeploymentRecordStream)RecordingExporter.deploymentRecords().withIntent((Intent)DeploymentIntent.CREATED)).withPartitionId(1)).withRecordKey(secondDeployment.getKey())).getFirst();
        deployedProcesses = ((DeploymentRecordValue)secondCreatedDeployments.getValue()).getProcessesMetadata();
        Assertions.assertThat((List)deployedProcesses).flatExtracting(new ThrowingExtractor[]{ProcessMetadataValue::getVersion}).containsOnly(new Object[]{2});
    }

    @Test
    public void shouldFilterDuplicateProcess() {
        Record<DeploymentRecordValue> original = ENGINE.deployment().withXmlResource("process.bpmn", PROCESS).deploy();
        Record<DeploymentRecordValue> repeated = ENGINE.deployment().withXmlResource("process.bpmn", PROCESS).deploy();
        Assertions.assertThat((long)repeated.getKey()).isGreaterThan(original.getKey());
        List originalProcesses = ((DeploymentRecordValue)original.getValue()).getProcessesMetadata();
        List repeatedProcesses = ((DeploymentRecordValue)repeated.getValue()).getProcessesMetadata();
        Assertions.assertThat((int)repeatedProcesses.size()).isEqualTo(originalProcesses.size()).isOne();
        Assertions.assertThat((long)((DeploymentRecordStream)((DeploymentRecordStream)RecordingExporter.deploymentRecords((DeploymentIntent)DeploymentIntent.CREATE).withRecordKey(repeated.getKey())).limit(2L)).count()).isEqualTo(2L);
        List<ProcessMetadataValue> repeatedWfs = ((DeploymentRecordStream)((DeploymentRecordStream)RecordingExporter.deploymentRecords((DeploymentIntent)DeploymentIntent.CREATED).withRecordKey(repeated.getKey())).limit(2L)).map(r -> (ProcessMetadataValue)((DeploymentRecordValue)r.getValue()).getProcessesMetadata().get(0)).toList();
        Assertions.assertThat((int)repeatedWfs.size()).isEqualTo(2);
        repeatedWfs.forEach(repeatedWf -> this.assertSameProcess((ProcessMetadataValue)originalProcesses.get(0), (ProcessMetadataValue)repeatedWf));
    }

    @Test
    public void shouldNotFilterDifferentProcesses() {
        Record<DeploymentRecordValue> original = ENGINE.deployment().withXmlResource("process.bpmn", PROCESS).deploy();
        BpmnModelInstance sameBpmnIdModel = Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().endEvent().done();
        Record<DeploymentRecordValue> repeated = ENGINE.deployment().withXmlResource("process.bpmn", sameBpmnIdModel).deploy();
        List originalProcesses = ((DeploymentRecordValue)original.getValue()).getProcessesMetadata();
        List repeatedProcesses = ((DeploymentRecordValue)repeated.getValue()).getProcessesMetadata();
        Assertions.assertThat((int)repeatedProcesses.size()).isEqualTo(originalProcesses.size()).isOne();
        this.assertDifferentProcesses((ProcessMetadataValue)originalProcesses.get(0), (ProcessMetadataValue)repeatedProcesses.get(0));
        Assertions.assertThat((long)((DeploymentRecordStream)((DeploymentRecordStream)RecordingExporter.deploymentRecords((DeploymentIntent)DeploymentIntent.CREATE).withRecordKey(repeated.getKey())).limit(2L)).count()).isEqualTo(2L);
        List<ProcessMetadataValue> repeatedWfs = ((DeploymentRecordStream)((DeploymentRecordStream)RecordingExporter.deploymentRecords((DeploymentIntent)DeploymentIntent.CREATED).withRecordKey(repeated.getKey())).limit(2L)).map(r -> (ProcessMetadataValue)((DeploymentRecordValue)r.getValue()).getProcessesMetadata().get(0)).toList();
        Assertions.assertThat((int)repeatedWfs.size()).isEqualTo(2);
        repeatedWfs.forEach(repeatedWf -> this.assertDifferentProcesses((ProcessMetadataValue)originalProcesses.get(0), (ProcessMetadataValue)repeatedWf));
    }

    @Test
    public void shouldFilterDuplicateDmnResource() {
        Record<DeploymentRecordValue> original = ENGINE.deployment().withXmlClasspathResource(DMN_DECISION_TABLE).deploy();
        Record<DeploymentRecordValue> repeated = ENGINE.deployment().withXmlClasspathResource(DMN_DECISION_TABLE).deploy();
        Assertions.assertThat((long)repeated.getKey()).isGreaterThan(original.getKey());
        List originalDecision = ((DeploymentRecordValue)original.getValue()).getDecisionsMetadata();
        List originalDrg = ((DeploymentRecordValue)original.getValue()).getDecisionRequirementsMetadata();
        List repeatedDecision = ((DeploymentRecordValue)repeated.getValue()).getDecisionsMetadata();
        List repeatedDrg = ((DeploymentRecordValue)repeated.getValue()).getDecisionRequirementsMetadata();
        Assertions.assertThat((int)repeatedDecision.size()).isEqualTo(originalDecision.size()).isOne();
        Assertions.assertThat((int)repeatedDrg.size()).isEqualTo(originalDrg.size()).isOne();
        Assertions.assertThat((long)((DeploymentRecordStream)((DeploymentRecordStream)RecordingExporter.deploymentRecords((DeploymentIntent)DeploymentIntent.CREATE).withRecordKey(repeated.getKey())).limit(2L)).count()).isEqualTo(2L);
        List<DecisionRecordValue> repeatedDecisions = ((DeploymentRecordStream)((DeploymentRecordStream)RecordingExporter.deploymentRecords((DeploymentIntent)DeploymentIntent.CREATED).withRecordKey(repeated.getKey())).limit(2L)).map(r -> (DecisionRecordValue)((DeploymentRecordValue)r.getValue()).getDecisionsMetadata().get(0)).toList();
        Assertions.assertThat((int)repeatedDecisions.size()).isEqualTo(2);
        repeatedDecisions.forEach(r -> this.assertSameDecision((DecisionRecordValue)originalDecision.get(0), (DecisionRecordValue)r));
        List<DecisionRequirementsMetadataValue> repeatedDrgs = ((DeploymentRecordStream)((DeploymentRecordStream)RecordingExporter.deploymentRecords((DeploymentIntent)DeploymentIntent.CREATED).withRecordKey(repeated.getKey())).limit(2L)).map(r -> (DecisionRequirementsMetadataValue)((DeploymentRecordValue)r.getValue()).getDecisionRequirementsMetadata().get(0)).toList();
        Assertions.assertThat((int)repeatedDrgs.size()).isEqualTo(2);
        repeatedDrgs.forEach(r -> this.assertSameDrg((DecisionRequirementsMetadataValue)originalDrg.get(0), (DecisionRequirementsMetadataValue)r));
    }

    @Test
    public void shouldNotFilterDifferentDmnResource() {
        Record<DeploymentRecordValue> original = ENGINE.deployment().withXmlClasspathResource(DMN_DECISION_TABLE).deploy();
        Record<DeploymentRecordValue> repeated = ENGINE.deployment().withXmlClasspathResource(DMN_DECISION_TABLE_V2).deploy();
        Assertions.assertThat((long)repeated.getKey()).isGreaterThan(original.getKey());
        List originalDecision = ((DeploymentRecordValue)original.getValue()).getDecisionsMetadata();
        List originalDrg = ((DeploymentRecordValue)original.getValue()).getDecisionRequirementsMetadata();
        List repeatedDecision = ((DeploymentRecordValue)repeated.getValue()).getDecisionsMetadata();
        List repeatedDrg = ((DeploymentRecordValue)repeated.getValue()).getDecisionRequirementsMetadata();
        Assertions.assertThat((int)repeatedDecision.size()).isEqualTo(originalDecision.size()).isOne();
        Assertions.assertThat((int)repeatedDrg.size()).isEqualTo(originalDrg.size()).isOne();
        Assertions.assertThat((long)((DeploymentRecordStream)((DeploymentRecordStream)RecordingExporter.deploymentRecords((DeploymentIntent)DeploymentIntent.CREATE).withRecordKey(repeated.getKey())).limit(2L)).count()).isEqualTo(2L);
        List<DecisionRecordValue> repeatedDecisions = ((DeploymentRecordStream)((DeploymentRecordStream)RecordingExporter.deploymentRecords((DeploymentIntent)DeploymentIntent.CREATED).withRecordKey(repeated.getKey())).limit(2L)).map(r -> (DecisionRecordValue)((DeploymentRecordValue)r.getValue()).getDecisionsMetadata().get(0)).toList();
        Assertions.assertThat((int)repeatedDecisions.size()).isEqualTo(2);
        repeatedDecisions.forEach(r -> this.assertDifferentDecision((DecisionRecordValue)originalDecision.get(0), (DecisionRecordValue)r));
        List<DecisionRequirementsMetadataValue> repeatedDrgs = ((DeploymentRecordStream)((DeploymentRecordStream)RecordingExporter.deploymentRecords((DeploymentIntent)DeploymentIntent.CREATED).withRecordKey(repeated.getKey())).limit(2L)).map(r -> (DecisionRequirementsMetadataValue)((DeploymentRecordValue)r.getValue()).getDecisionRequirementsMetadata().get(0)).toList();
        Assertions.assertThat((int)repeatedDrgs.size()).isEqualTo(2);
        repeatedDrgs.forEach(r -> this.assertDifferentDrg((DecisionRequirementsMetadataValue)originalDrg.get(0), (DecisionRequirementsMetadataValue)r));
    }

    @Test
    public void shouldWriteProcessCreatedEventsWithSameKeys() {
        String processId = Strings.newRandomValidBpmnId();
        ENGINE.deployment().withXmlResource("process.bpmn", Bpmn.createExecutableProcess((String)processId).startEvent().endEvent().done()).deploy();
        ((ListAssert)Assertions.assertThat(((ProcessRecordStream)((ProcessRecordStream)RecordingExporter.processRecords().withIntents(new Intent[]{ProcessIntent.CREATED})).withBpmnProcessId(processId).limit(3L)).map(Record::getKey).distinct()).describedAs("All created events get the same key", new Object[0])).hasSize(1);
    }

    @Test
    public void shouldWriteDrgAndDecisionCreatedEventsWithSameKeys() {
        String drgId = "force_users";
        String decisionId = "jedi_or_sith";
        ENGINE.deployment().withXmlClasspathResource(DMN_DECISION_TABLE).deploy();
        ((ListAssert)Assertions.assertThat(((DecisionRequirementsRecordStream)((DecisionRequirementsRecordStream)RecordingExporter.decisionRequirementsRecords().withIntents(new Intent[]{DecisionRequirementsIntent.CREATED})).withDecisionRequirementsId("force_users").limit(3L)).map(Record::getKey).distinct()).describedAs("All created events get the same key", new Object[0])).hasSize(1);
        ((ListAssert)Assertions.assertThat(((DecisionRecordStream)((DecisionRecordStream)RecordingExporter.decisionRecords().withIntents(new Intent[]{DecisionIntent.CREATED})).withDecisionId("jedi_or_sith").limit(3L)).map(Record::getKey).distinct()).describedAs("All created events get the same key", new Object[0])).hasSize(1);
    }

    @Test
    public void shouldCreateProcessForTenant() {
        String tenant = "tenant";
        String processId = Strings.newRandomValidBpmnId();
        Record<DeploymentRecordValue> deployment = ENGINE.deployment().withXmlResource("process.xml", Bpmn.createExecutableProcess((String)processId).startEvent().endEvent().done()).withTenantId("tenant").deploy();
        Assertions.assertThat((String)((DeploymentRecordValue)deployment.getValue()).getTenantId()).isEqualTo("tenant");
        for (int partitionId = 1; partitionId <= 3; ++partitionId) {
            Assertions.assertThat((Stream)((ProcessRecordStream)((ProcessRecordStream)RecordingExporter.processRecords().withIntent((Intent)ProcessIntent.CREATED)).withPartitionId(partitionId)).limit(1L)).extracting(Record::getValue).extracting(new Function[]{ProcessMetadataValue::getBpmnProcessId, ProcessMetadataValue::getVersion, ProcessMetadataValue::getProcessDefinitionKey, TenantOwned::getTenantId}).describedAs("Processes are created for correct tenant", new Object[0]).containsExactly((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{processId, 1, ((ProcessMetadataValue)((DeploymentRecordValue)deployment.getValue()).getProcessesMetadata().get(0)).getProcessDefinitionKey(), "tenant"})});
        }
    }

    @Test
    public void shouldCreateDmnForTenant() {
        String tenant = "tenant";
        String drgId = "star-wars";
        String decisionId = "sith_or_jedi";
        Record<DeploymentRecordValue> deployment = ENGINE.deployment().withXmlClasspathResource(DMN_DECISION_TABLE_RENAMED).withTenantId("tenant").deploy();
        Assertions.assertThat((String)((DeploymentRecordValue)deployment.getValue()).getTenantId()).isEqualTo("tenant");
        for (int partitionId = 1; partitionId <= 3; ++partitionId) {
            Assertions.assertThat((Stream)((DecisionRequirementsRecordStream)((DecisionRequirementsRecordStream)RecordingExporter.decisionRequirementsRecords().withIntent((Intent)DecisionRequirementsIntent.CREATED)).withPartitionId(partitionId)).limit(1L)).extracting(Record::getValue).extracting(new Function[]{DecisionRequirementsMetadataValue::getDecisionRequirementsId, DecisionRequirementsMetadataValue::getDecisionRequirementsVersion, DecisionRequirementsMetadataValue::getDecisionRequirementsKey, TenantOwned::getTenantId}).describedAs("DRGs are created for correct tenant", new Object[0]).containsExactly((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{"star-wars", 1, ((DecisionRequirementsMetadataValue)((DeploymentRecordValue)deployment.getValue()).getDecisionRequirementsMetadata().get(0)).getDecisionRequirementsKey(), "tenant"})});
            Assertions.assertThat((Stream)((DecisionRecordStream)((DecisionRecordStream)RecordingExporter.decisionRecords().withIntent((Intent)DecisionIntent.CREATED)).withPartitionId(partitionId)).limit(1L)).extracting(Record::getValue).extracting(new Function[]{DecisionRecordValue::getDecisionId, DecisionRecordValue::getVersion, DecisionRecordValue::getDecisionKey, DecisionRecordValue::getDecisionRequirementsId, DecisionRecordValue::getDecisionRequirementsKey, TenantOwned::getTenantId}).describedAs("Decisions are created for correct tenant", new Object[0]).containsExactly((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{"sith_or_jedi", 1, ((DecisionRecordValue)((DeploymentRecordValue)deployment.getValue()).getDecisionsMetadata().get(0)).getDecisionKey(), "star-wars", ((DecisionRequirementsMetadataValue)((DeploymentRecordValue)deployment.getValue()).getDecisionRequirementsMetadata().get(0)).getDecisionRequirementsKey(), "tenant"})});
        }
    }

    private void assertDeploymentRecordWithoutResources(Record<DeploymentRecordValue> deployment, Record<DeploymentRecordValue> createdDeployment) {
        Assertions.assertThat((List)((DeploymentRecordValue)createdDeployment.getValue()).getResources()).isEmpty();
        List deployedProcesses = ((DeploymentRecordValue)createdDeployment.getValue()).getProcessesMetadata();
        Assertions.assertThat((List)deployedProcesses).hasSize(1);
        io.camunda.zeebe.protocol.record.Assertions.assertThat((ProcessMetadataValue)((ProcessMetadataValue)deployedProcesses.get(0))).hasBpmnProcessId("shouldCreateDeploymentOnAllPartitions").hasVersion(1).hasProcessDefinitionKey(this.getDeployedProcess(deployment, 0).getProcessDefinitionKey()).hasResourceName("process.bpmn");
    }

    private void assertSameProcess(ProcessMetadataValue original, ProcessMetadataValue repeated) {
        io.camunda.zeebe.protocol.record.Assertions.assertThat((ProcessMetadataValue)repeated).hasVersion(original.getVersion()).hasProcessDefinitionKey(original.getProcessDefinitionKey()).hasResourceName(original.getResourceName()).hasBpmnProcessId(original.getBpmnProcessId());
    }

    private void assertDifferentProcesses(ProcessMetadataValue original, ProcessMetadataValue repeated) {
        Assertions.assertThat((long)original.getProcessDefinitionKey()).isLessThan(repeated.getProcessDefinitionKey());
        Assertions.assertThat((int)original.getVersion()).isLessThan(repeated.getVersion());
    }

    private void assertSameDecision(DecisionRecordValue original, DecisionRecordValue repeated) {
        io.camunda.zeebe.protocol.record.Assertions.assertThat((DecisionRecordValue)repeated).hasDecisionId(original.getDecisionId()).hasDecisionName(original.getDecisionName()).hasVersion(original.getVersion()).hasDecisionKey(original.getDecisionKey()).hasDecisionRequirementsId(original.getDecisionRequirementsId()).hasDecisionRequirementsKey(original.getDecisionRequirementsKey());
    }

    private void assertDifferentDecision(DecisionRecordValue original, DecisionRecordValue repeated) {
        Assertions.assertThat((int)original.getVersion()).isLessThan(repeated.getVersion());
        Assertions.assertThat((long)original.getDecisionKey()).isLessThan(repeated.getDecisionKey());
        Assertions.assertThat((long)original.getDecisionRequirementsKey()).isLessThan(repeated.getDecisionRequirementsKey());
    }

    private void assertSameDrg(DecisionRequirementsMetadataValue original, DecisionRequirementsMetadataValue repeated) {
        io.camunda.zeebe.protocol.record.Assertions.assertThat((DecisionRequirementsMetadataValue)repeated).hasDecisionRequirementsId(original.getDecisionRequirementsId()).hasDecisionRequirementsName(original.getDecisionRequirementsName()).hasDecisionRequirementsVersion(original.getDecisionRequirementsVersion()).hasDecisionRequirementsKey(original.getDecisionRequirementsKey()).hasNamespace(original.getNamespace()).hasResourceName(original.getResourceName()).hasChecksum(original.getChecksum());
    }

    private void assertDifferentDrg(DecisionRequirementsMetadataValue original, DecisionRequirementsMetadataValue repeated) {
        Assertions.assertThat((int)original.getDecisionRequirementsVersion()).isLessThan(repeated.getDecisionRequirementsVersion());
        Assertions.assertThat((long)original.getDecisionRequirementsKey()).isLessThan(repeated.getDecisionRequirementsKey());
    }

    private byte[] bpmnXml(BpmnModelInstance definition) {
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        Bpmn.writeModelToStream((OutputStream)outStream, (BpmnModelInstance)definition);
        return outStream.toByteArray();
    }

    private ProcessMetadataValue getDeployedProcess(Record<DeploymentRecordValue> record, int offset) {
        return (ProcessMetadataValue)((DeploymentRecordValue)record.getValue()).getProcessesMetadata().get(offset);
    }

    private void assertDeploymentEventResources(int expectedPartition, DeploymentIntent deploymentIntent, long expectedKey, Consumer<Record<DeploymentRecordValue>> deploymentAssert) {
        Record deploymentCreatedEvent = (Record)((DeploymentRecordStream)((DeploymentRecordStream)((DeploymentRecordStream)RecordingExporter.deploymentRecords().withPartitionId(expectedPartition)).withIntent((Intent)deploymentIntent)).withRecordKey(expectedKey)).getFirst();
        Assertions.assertThat((long)deploymentCreatedEvent.getKey()).isEqualTo(expectedKey);
        Assertions.assertThat((int)deploymentCreatedEvent.getPartitionId()).isEqualTo(expectedPartition);
        deploymentAssert.accept((Record<DeploymentRecordValue>)deploymentCreatedEvent);
    }
}

