/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.deployment;

import io.camunda.zeebe.engine.util.EngineRule;
import io.camunda.zeebe.model.bpmn.Bpmn;
import io.camunda.zeebe.model.bpmn.BpmnModelInstance;
import io.camunda.zeebe.model.bpmn.builder.ServiceTaskBuilder;
import io.camunda.zeebe.model.bpmn.builder.StartEventBuilder;
import io.camunda.zeebe.protocol.record.ExecuteCommandResponseDecoder;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.RecordType;
import io.camunda.zeebe.protocol.record.RejectionType;
import io.camunda.zeebe.protocol.record.intent.CommandDistributionIntent;
import io.camunda.zeebe.protocol.record.intent.DeploymentIntent;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.ProcessIntent;
import io.camunda.zeebe.protocol.record.value.DeploymentRecordValue;
import io.camunda.zeebe.test.util.record.RecordStream;
import io.camunda.zeebe.test.util.record.RecordingExporter;
import io.camunda.zeebe.test.util.record.RecordingExporterTestWatcher;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.groups.Tuple;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

public class DeploymentRejectionTest {
    @ClassRule
    public static final EngineRule ENGINE = EngineRule.singlePartition();
    @Rule
    public final RecordingExporterTestWatcher recordingExporterTestWatcher = new RecordingExporterTestWatcher();

    @Test
    public void shouldRejectDeploymentIfUsedInvalidMessage() {
        BpmnModelInstance process = Bpmn.createExecutableProcess().startEvent().intermediateCatchEvent("invalidMessage").done();
        Record<DeploymentRecordValue> rejectedDeployment = ENGINE.deployment().withXmlResource(process).expectRejection().deploy();
        io.camunda.zeebe.protocol.record.Assertions.assertThat((RecordType)rejectedDeployment.getRecordType()).isEqualTo((Object)RecordType.COMMAND_REJECTION);
    }

    @Test
    public void shouldRejectDeploymentIfNotValidDesignTimeAspect() {
        String resource = "/processes/invalid_process.bpmn";
        Record<DeploymentRecordValue> rejectedDeployment = ENGINE.deployment().withXmlClasspathResource("/processes/invalid_process.bpmn").expectRejection().deploy();
        io.camunda.zeebe.protocol.record.Assertions.assertThat(rejectedDeployment).hasKey(ExecuteCommandResponseDecoder.keyNullValue()).hasRecordType(RecordType.COMMAND_REJECTION).hasIntent((Intent)DeploymentIntent.CREATE).hasRejectionType(RejectionType.INVALID_ARGUMENT);
        Assertions.assertThat((String)rejectedDeployment.getRejectionReason()).contains(new CharSequence[]{"ERROR: Must have at least one start event"});
    }

    @Test
    public void shouldRejectDeploymentIfNotValidRuntimeAspect() {
        String resource = "/processes/invalid_process_condition.bpmn";
        Record<DeploymentRecordValue> rejectedDeployment = ENGINE.deployment().withXmlClasspathResource("/processes/invalid_process_condition.bpmn").expectRejection().deploy();
        io.camunda.zeebe.protocol.record.Assertions.assertThat(rejectedDeployment).hasKey(ExecuteCommandResponseDecoder.keyNullValue()).hasRecordType(RecordType.COMMAND_REJECTION).hasIntent((Intent)DeploymentIntent.CREATE).hasRejectionType(RejectionType.INVALID_ARGUMENT);
        ((AbstractStringAssert)Assertions.assertThat((String)rejectedDeployment.getRejectionReason()).contains(new CharSequence[]{"Element: flow2 > conditionExpression"})).contains(new CharSequence[]{"ERROR: failed to parse expression"});
    }

    @Test
    public void shouldRejectDeploymentIfOneResourceIsNotValid() {
        String resource1 = "/processes/invalid_process.bpmn";
        String resource2 = "/processes/collaboration.bpmn";
        Record<DeploymentRecordValue> rejectedDeployment = ENGINE.deployment().withXmlClasspathResource("/processes/invalid_process.bpmn").withXmlClasspathResource("/processes/collaboration.bpmn").expectRejection().deploy();
        io.camunda.zeebe.protocol.record.Assertions.assertThat(rejectedDeployment).hasKey(ExecuteCommandResponseDecoder.keyNullValue()).hasRecordType(RecordType.COMMAND_REJECTION).hasIntent((Intent)DeploymentIntent.CREATE).hasRejectionType(RejectionType.INVALID_ARGUMENT);
    }

    @Test
    public void shouldRejectDeploymentIfNoResources() {
        Record<DeploymentRecordValue> rejectedDeployment = ENGINE.deployment().expectRejection().deploy();
        io.camunda.zeebe.protocol.record.Assertions.assertThat(rejectedDeployment).hasKey(ExecuteCommandResponseDecoder.keyNullValue()).hasRecordType(RecordType.COMMAND_REJECTION).hasIntent((Intent)DeploymentIntent.CREATE).hasRejectionType(RejectionType.INVALID_ARGUMENT);
    }

    @Test
    public void shouldRejectDeploymentIfNotParsable() {
        Record<DeploymentRecordValue> rejectedDeployment = ENGINE.deployment().withXmlResource("not a process".getBytes(StandardCharsets.UTF_8)).expectRejection().deploy();
        io.camunda.zeebe.protocol.record.Assertions.assertThat(rejectedDeployment).hasKey(ExecuteCommandResponseDecoder.keyNullValue()).hasRecordType(RecordType.COMMAND_REJECTION).hasIntent((Intent)DeploymentIntent.CREATE).hasRejectionType(RejectionType.INVALID_ARGUMENT);
    }

    @Test
    public void shouldRejectDeploymentWithDuplicateResources() {
        BpmnModelInstance definition1 = Bpmn.createExecutableProcess((String)"process1").startEvent().done();
        BpmnModelInstance definition2 = Bpmn.createExecutableProcess((String)"process2").startEvent().done();
        BpmnModelInstance definition3 = Bpmn.createExecutableProcess((String)"process2").startEvent().serviceTask("task", t -> ((ServiceTaskBuilder)t.zeebeJobType("j")).zeebeTaskHeader("k", "v")).done();
        Record<DeploymentRecordValue> deploymentRejection = ENGINE.deployment().withXmlResource("p1.bpmn", definition1).withXmlResource("p2.bpmn", definition2).withXmlResource("p3.bpmn", definition3).expectRejection().deploy();
        io.camunda.zeebe.protocol.record.Assertions.assertThat(deploymentRejection).hasRejectionType(RejectionType.INVALID_ARGUMENT).hasRejectionReason("Expected to deploy new resources, but encountered the following errors:\nDuplicated process id in resources 'p2.bpmn' and 'p3.bpmn'");
    }

    @Test
    public void shouldRejectDeploymentWithInvalidTimerStartEventExpression() {
        BpmnModelInstance definition = ((StartEventBuilder)Bpmn.createExecutableProcess((String)"process1").startEvent("start-event-1").timerWithCycleExpression("INVALID_CYCLE_EXPRESSION")).done();
        Record<DeploymentRecordValue> deploymentRejection = ENGINE.deployment().withXmlResource("p1.bpmn", definition).expectRejection().deploy();
        io.camunda.zeebe.protocol.record.Assertions.assertThat(deploymentRejection).hasRejectionType(RejectionType.INVALID_ARGUMENT).hasRejectionReason("Expected to deploy new resources, but encountered the following errors:\n'p1.bpmn': - Element: start-event-1\n    - ERROR: Invalid timer cycle expression (Expected result of the expression 'INVALID_CYCLE_EXPRESSION' to be 'STRING', but was 'NULL'. The evaluation reported the following warnings:\n[NO_VARIABLE_FOUND] No variable found with name 'INVALID_CYCLE_EXPRESSION')\n");
    }

    @Test
    public void shouldRejectDeploymentOfSAXException() {
        String resource = "/processes/saxexception-error-8026.bpmn";
        Record<DeploymentRecordValue> deploymentRejection = ENGINE.deployment().withXmlClasspathResource("/processes/saxexception-error-8026.bpmn").expectRejection().deploy();
        io.camunda.zeebe.protocol.record.Assertions.assertThat(deploymentRejection).hasKey(ExecuteCommandResponseDecoder.keyNullValue()).hasRecordType(RecordType.COMMAND_REJECTION).hasIntent((Intent)DeploymentIntent.CREATE).hasRejectionType(RejectionType.INVALID_ARGUMENT);
        ((AbstractStringAssert)((AbstractStringAssert)((AbstractStringAssert)((AbstractStringAssert)Assertions.assertThat((String)deploymentRejection.getRejectionReason()).describedAs("rejection should contain enough detail rejection reason", new Object[0])).contains(new CharSequence[]{"saxexception-error-8026.bpmn"})).contains(new CharSequence[]{"cvc-complex-type.3.2.2"})).contains(new CharSequence[]{"stroke"})).contains(new CharSequence[]{"bpmndi:BPMNPlane"});
    }

    @Test
    public void shouldRejectDeploymentIfNoExecutableProcess() {
        String resource = "/processes/non-executable-process-single.bpmn";
        Record<DeploymentRecordValue> deploymentRejection = ENGINE.deployment().withXmlClasspathResource("/processes/non-executable-process-single.bpmn").expectRejection().deploy();
        io.camunda.zeebe.protocol.record.Assertions.assertThat(deploymentRejection).hasRecordType(RecordType.COMMAND_REJECTION).hasIntent((Intent)DeploymentIntent.CREATE).hasRejectionType(RejectionType.INVALID_ARGUMENT);
        Assertions.assertThat((String)deploymentRejection.getRejectionReason()).contains(new CharSequence[]{"Must contain at least one executable process"});
    }

    @Test
    public void shouldDoAtomicDeployments() {
        BpmnModelInstance invalidProcess = Bpmn.createExecutableProcess((String)"invalid_process_without_start_event").done();
        BpmnModelInstance validProcess = Bpmn.createExecutableProcess((String)"valid_process").startEvent().task().endEvent().done();
        ENGINE.deployment().withXmlResource(invalidProcess).withXmlResource(validProcess).expectRejection().deploy();
        Assertions.assertThat((List)((List)((RecordStream)RecordingExporter.records().limit(r -> r.getRecordType() == RecordType.COMMAND_REJECTION)).collect(Collectors.toList()))).extracting(new Function[]{Record::getIntent, Record::getRecordType}).doesNotContain((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{ProcessIntent.CREATED, RecordType.EVENT}), Assertions.tuple((Object[])new Object[]{DeploymentIntent.CREATED, RecordType.EVENT}), Assertions.tuple((Object[])new Object[]{CommandDistributionIntent.STARTED, RecordType.EVENT})});
    }
}

