/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.deployment.model.validation;

import io.camunda.zeebe.engine.util.EngineRule;
import io.camunda.zeebe.engine.util.client.DeploymentClient;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.RecordType;
import io.camunda.zeebe.protocol.record.ValueType;
import io.camunda.zeebe.protocol.record.intent.DeploymentIntent;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.value.DeploymentRecordValue;
import io.camunda.zeebe.stream.api.CommandResponseWriter;
import io.camunda.zeebe.test.util.record.RecordingExporterTestWatcher;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import org.assertj.core.api.Assertions;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.mockito.verification.VerificationWithTimeout;

@RunWith(value=Parameterized.class)
public final class CollaborationDeploymentTest {
    private static final VerificationWithTimeout VERIFICATION_TIMEOUT = Mockito.timeout((long)Duration.ofSeconds(1L).toMillis());
    @Rule
    public final EngineRule engine = EngineRule.singlePartition();
    @Rule
    public final RecordingExporterTestWatcher recordingExporterTestWatcher = new RecordingExporterTestWatcher();
    @Parameterized.Parameter(value=0)
    public String description;
    @Parameterized.Parameter(value=1)
    public Function<DeploymentClient, Record<DeploymentRecordValue>> performDeployment;

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> data() {
        return Arrays.asList({"collaboration with NPE error", CollaborationDeploymentTest.deploy("/processes/issue-9400-NPE.bpmn")}, {"collaboration without NPE error", CollaborationDeploymentTest.deploy("/processes/issue-9400.bpmn")});
    }

    @Test
    public void shouldWriteDeploymentCreatedEvent() {
        Record<DeploymentRecordValue> deployment = this.performDeployment.apply(this.engine.deployment());
        Assertions.assertThat((Object)deployment.getIntent()).isEqualTo((Object)DeploymentIntent.CREATED);
        Assertions.assertThat((List)((DeploymentRecordValue)deployment.getValue()).getProcessesMetadata()).hasSize(2);
    }

    @Test
    public void shouldSendResponse() {
        Record<DeploymentRecordValue> deployment = this.performDeployment.apply(this.engine.deployment());
        ((CommandResponseWriter)Mockito.verify((Object)this.engine.getCommandResponseWriter(), (VerificationMode)VERIFICATION_TIMEOUT)).recordType(RecordType.EVENT);
        ((CommandResponseWriter)Mockito.verify((Object)this.engine.getCommandResponseWriter(), (VerificationMode)VERIFICATION_TIMEOUT)).valueType(ValueType.DEPLOYMENT);
        ((CommandResponseWriter)Mockito.verify((Object)this.engine.getCommandResponseWriter(), (VerificationMode)VERIFICATION_TIMEOUT)).intent((Intent)DeploymentIntent.CREATED);
        ((CommandResponseWriter)Mockito.verify((Object)this.engine.getCommandResponseWriter(), (VerificationMode)VERIFICATION_TIMEOUT)).key(deployment.getKey());
        ((CommandResponseWriter)Mockito.verify((Object)this.engine.getCommandResponseWriter(), (VerificationMode)VERIFICATION_TIMEOUT)).tryWriteResponse(ArgumentMatchers.anyInt(), ArgumentMatchers.anyLong());
    }

    private static Function<DeploymentClient, Record<DeploymentRecordValue>> deploy(String resource) {
        return deploymentClient -> deploymentClient.withXmlClasspathResource(resource).deploy();
    }
}

