/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.deployment.model.validation;

import io.camunda.zeebe.engine.util.EngineRule;
import io.camunda.zeebe.model.bpmn.Bpmn;
import io.camunda.zeebe.model.bpmn.BpmnModelInstance;
import io.camunda.zeebe.model.bpmn.builder.AbstractBoundaryEventBuilder;
import io.camunda.zeebe.model.bpmn.builder.AbstractThrowEventBuilder;
import io.camunda.zeebe.model.bpmn.builder.BoundaryEventBuilder;
import io.camunda.zeebe.model.bpmn.builder.EscalationEventDefinitionBuilder;
import io.camunda.zeebe.model.bpmn.builder.IntermediateThrowEventBuilder;
import io.camunda.zeebe.model.bpmn.builder.StartEventBuilder;
import io.camunda.zeebe.model.bpmn.builder.SubProcessBuilder;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.RecordType;
import io.camunda.zeebe.protocol.record.RejectionType;
import io.camunda.zeebe.protocol.record.value.DeploymentRecordValue;
import io.camunda.zeebe.protocol.record.value.deployment.ProcessMetadataValue;
import io.camunda.zeebe.test.util.record.RecordingExporterTestWatcher;
import java.util.List;
import java.util.function.Consumer;
import org.assertj.core.api.Assertions;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

public final class EscalationEventValidationTest {
    @ClassRule
    public static final EngineRule ENGINE = EngineRule.singlePartition();
    @Rule
    public final RecordingExporterTestWatcher recordingExporterTestWatcher = new RecordingExporterTestWatcher();

    private BpmnModelInstance process(Consumer<SubProcessBuilder> builder) {
        return Bpmn.createExecutableProcess().startEvent().subProcess("sp", builder).endEvent().done();
    }

    @Test
    public void shouldDeployProcessModelWithEscalationThrowEvent() {
        BpmnModelInstance processDefinition = ((IntermediateThrowEventBuilder)Bpmn.createExecutableProcess().startEvent().intermediateThrowEvent().escalation("escalationCode")).endEvent().done();
        Record<DeploymentRecordValue> result = ENGINE.deployment().withXmlResource(processDefinition).deploy();
        Assertions.assertThat((long)result.getKey()).isGreaterThan(0L);
        Assertions.assertThat((List)((DeploymentRecordValue)result.getValue()).getProcessesMetadata()).hasSize(1);
        ProcessMetadataValue deployedProcess = (ProcessMetadataValue)((DeploymentRecordValue)result.getValue()).getProcessesMetadata().get(0);
        Assertions.assertThat((int)deployedProcess.getVersion()).isEqualTo(1);
        Assertions.assertThat((long)deployedProcess.getProcessDefinitionKey()).isGreaterThan(0L);
    }

    @Test
    public void shouldDeployProcessModelWithEscalationStartEvent() {
        BpmnModelInstance processDefinition = Bpmn.createExecutableProcess().eventSubProcess("sub", s -> ((StartEventBuilder)s.startEvent("start-1").escalation("escalationCode")).endEvent()).startEvent().endEvent().done();
        Record<DeploymentRecordValue> result = ENGINE.deployment().withXmlResource(processDefinition).deploy();
        Assertions.assertThat((long)result.getKey()).isGreaterThan(0L);
        Assertions.assertThat((List)((DeploymentRecordValue)result.getValue()).getProcessesMetadata()).hasSize(1);
        ProcessMetadataValue deployedProcess = (ProcessMetadataValue)((DeploymentRecordValue)result.getValue()).getProcessesMetadata().get(0);
        Assertions.assertThat((int)deployedProcess.getVersion()).isEqualTo(1);
        Assertions.assertThat((long)deployedProcess.getProcessDefinitionKey()).isGreaterThan(0L);
    }

    @Test
    public void shouldDeployProcessModelWithEscalationEndEvent() {
        BpmnModelInstance processDefinition = Bpmn.createExecutableProcess().startEvent().endEvent("end", builder -> builder.escalation("escalationCode")).done();
        Record<DeploymentRecordValue> result = ENGINE.deployment().withXmlResource(processDefinition).deploy();
        Assertions.assertThat((long)result.getKey()).isGreaterThan(0L);
        Assertions.assertThat((List)((DeploymentRecordValue)result.getValue()).getProcessesMetadata()).hasSize(1);
        ProcessMetadataValue deployedProcess = (ProcessMetadataValue)((DeploymentRecordValue)result.getValue()).getProcessesMetadata().get(0);
        Assertions.assertThat((int)deployedProcess.getVersion()).isEqualTo(1);
        Assertions.assertThat((long)deployedProcess.getProcessDefinitionKey()).isGreaterThan(0L);
    }

    @Test
    public void shouldDeployProcessModelWithEscalationBoundaryEvent() {
        BpmnModelInstance processDefinition = Bpmn.createExecutableProcess().startEvent().callActivity("call", builder -> builder.zeebeProcessId("sub")).boundaryEvent("catch", builder -> builder.escalation("escalationCode")).endEvent().done();
        Record<DeploymentRecordValue> result = ENGINE.deployment().withXmlResource(processDefinition).deploy();
        Assertions.assertThat((long)result.getKey()).isGreaterThan(0L);
        Assertions.assertThat((List)((DeploymentRecordValue)result.getValue()).getProcessesMetadata()).hasSize(1);
        ProcessMetadataValue deployedProcess = (ProcessMetadataValue)((DeploymentRecordValue)result.getValue()).getProcessesMetadata().get(0);
        Assertions.assertThat((int)deployedProcess.getVersion()).isEqualTo(1);
        Assertions.assertThat((long)deployedProcess.getProcessDefinitionKey()).isGreaterThan(0L);
    }

    @Test
    public void shouldRejectDeploymentIfEscalationBoundaryEventIsNotAttachedToChildProcessOrCallActivity() {
        BpmnModelInstance processDefinition = Bpmn.createExecutableProcess().startEvent().serviceTask("task", builder -> builder.zeebeJobType("type")).boundaryEvent("catch", AbstractBoundaryEventBuilder::escalation).endEvent().done();
        Record<DeploymentRecordValue> rejectedDeployment = ENGINE.deployment().withXmlResource(processDefinition).expectRejection().deploy();
        io.camunda.zeebe.protocol.record.Assertions.assertThat(rejectedDeployment).hasRecordType(RecordType.COMMAND_REJECTION).hasRejectionType(RejectionType.INVALID_ARGUMENT);
        Assertions.assertThat((String)rejectedDeployment.getRejectionReason()).contains(new CharSequence[]{"An escalation boundary event should only be attached to a subprocess, or a call activity."});
    }

    @Test
    public void shouldRejectDeploymentIfMissingEscalationRefOnIntermediateThrowingEvent() {
        BpmnModelInstance processDefinition = Bpmn.createExecutableProcess().startEvent().intermediateThrowEvent().escalationEventDefinition("escalation").escalationEventDefinitionDone().endEvent().done();
        Record<DeploymentRecordValue> rejectedDeployment = ENGINE.deployment().withXmlResource(processDefinition).expectRejection().deploy();
        io.camunda.zeebe.protocol.record.Assertions.assertThat(rejectedDeployment).hasRecordType(RecordType.COMMAND_REJECTION).hasRejectionType(RejectionType.INVALID_ARGUMENT);
        Assertions.assertThat((String)rejectedDeployment.getRejectionReason()).contains(new CharSequence[]{"Must reference an escalation"});
    }

    @Test
    public void shouldRejectDeploymentIfEscalationThrowEventWithoutEscalationCode() {
        BpmnModelInstance processDefinition = ((EscalationEventDefinitionBuilder)Bpmn.createExecutableProcess().startEvent().intermediateThrowEvent().escalationEventDefinition("escalation").escalationCode("")).escalationEventDefinitionDone().endEvent().done();
        Record<DeploymentRecordValue> rejectedDeployment = ENGINE.deployment().withXmlResource(processDefinition).expectRejection().deploy();
        io.camunda.zeebe.protocol.record.Assertions.assertThat(rejectedDeployment).hasRecordType(RecordType.COMMAND_REJECTION).hasRejectionType(RejectionType.INVALID_ARGUMENT);
        Assertions.assertThat((String)rejectedDeployment.getRejectionReason()).contains(new CharSequence[]{"ERROR: EscalationCode must be present and not empty"});
    }

    @Test
    public void shouldRejectDeploymentIfMultipleEscalationBoundaryEventsWithoutEscalationCode() {
        BpmnModelInstance processDefinition = Bpmn.createExecutableProcess().startEvent().callActivity("call", c -> c.zeebeProcessId("child")).boundaryEvent("catch-1", b -> ((BoundaryEventBuilder)b.escalation()).endEvent()).moveToActivity("call").boundaryEvent("catch-2", b -> ((BoundaryEventBuilder)b.escalation()).endEvent()).endEvent().done();
        Record<DeploymentRecordValue> rejectedDeployment = ENGINE.deployment().withXmlResource(processDefinition).expectRejection().deploy();
        io.camunda.zeebe.protocol.record.Assertions.assertThat(rejectedDeployment).hasRecordType(RecordType.COMMAND_REJECTION).hasRejectionType(RejectionType.INVALID_ARGUMENT);
        Assertions.assertThat((String)rejectedDeployment.getRejectionReason()).contains(new CharSequence[]{"The same scope can not contain more than one escalation catch event without escalation code. An escalation catch event without escalation code catches all escalations."});
    }

    @Test
    public void shouldRejectDeploymentIfMultipleEscalationBoundaryEventsWithSameEscalationCode() {
        BpmnModelInstance processDefinition = Bpmn.createExecutableProcess().startEvent().callActivity("call", c -> c.zeebeProcessId("child")).boundaryEvent("catch-1", b -> ((BoundaryEventBuilder)b.escalation("escalationCode")).endEvent()).moveToActivity("call").boundaryEvent("catch-2", b -> ((BoundaryEventBuilder)b.escalation("escalationCode")).endEvent()).endEvent().done();
        Record<DeploymentRecordValue> rejectedDeployment = ENGINE.deployment().withXmlResource(processDefinition).expectRejection().deploy();
        io.camunda.zeebe.protocol.record.Assertions.assertThat(rejectedDeployment).hasRecordType(RecordType.COMMAND_REJECTION).hasRejectionType(RejectionType.INVALID_ARGUMENT);
        Assertions.assertThat((String)rejectedDeployment.getRejectionReason()).contains(new CharSequence[]{"Multiple escalation catch events with the same escalation code 'escalationCode' are not supported on the same scope."});
    }

    @Test
    public void shouldRejectDeploymentIfMissingEscalationRefOnEscalationEndEvent() {
        BpmnModelInstance processDefinition = Bpmn.createExecutableProcess().startEvent().endEvent("end", AbstractThrowEventBuilder::escalationEventDefinition).done();
        Record<DeploymentRecordValue> rejectedDeployment = ENGINE.deployment().withXmlResource(processDefinition).expectRejection().deploy();
        io.camunda.zeebe.protocol.record.Assertions.assertThat(rejectedDeployment).hasRecordType(RecordType.COMMAND_REJECTION).hasRejectionType(RejectionType.INVALID_ARGUMENT);
        Assertions.assertThat((String)rejectedDeployment.getRejectionReason()).contains(new CharSequence[]{"ERROR: Must reference an escalation"});
    }

    @Test
    public void shouldRejectDeploymentIfEscalationEndEventWithoutEscalationCode() {
        BpmnModelInstance processDefinition = Bpmn.createExecutableProcess().startEvent().endEvent("end", builder -> builder.escalation("")).done();
        Record<DeploymentRecordValue> rejectedDeployment = ENGINE.deployment().withXmlResource(processDefinition).expectRejection().deploy();
        io.camunda.zeebe.protocol.record.Assertions.assertThat(rejectedDeployment).hasRecordType(RecordType.COMMAND_REJECTION).hasRejectionType(RejectionType.INVALID_ARGUMENT);
        Assertions.assertThat((String)rejectedDeployment.getRejectionReason()).contains(new CharSequence[]{"ERROR: EscalationCode must be present and not empty"});
    }

    @Test
    public void shouldRejectDeploymentIfEscalationEndEventWithSameEscalationCode() {
        BpmnModelInstance processDefinition = Bpmn.createExecutableProcess().startEvent().callActivity("call", c -> c.zeebeProcessId("child")).boundaryEvent("catch-1", b -> ((BoundaryEventBuilder)b.escalation("escalationCode")).endEvent()).moveToActivity("call").boundaryEvent("catch-2", b -> ((BoundaryEventBuilder)b.escalation("escalationCode")).endEvent()).done();
        Record<DeploymentRecordValue> rejectedDeployment = ENGINE.deployment().withXmlResource(processDefinition).expectRejection().deploy();
        io.camunda.zeebe.protocol.record.Assertions.assertThat(rejectedDeployment).hasRecordType(RecordType.COMMAND_REJECTION).hasRejectionType(RejectionType.INVALID_ARGUMENT);
        Assertions.assertThat((String)rejectedDeployment.getRejectionReason()).contains(new CharSequence[]{"Multiple escalation catch events with the same escalation code 'escalationCode' are not supported on the same scope."});
    }

    @Test
    public void shouldRejectDeploymentIfMultipleEscalationEventSubprocessWithoutEscalationCode() {
        BpmnModelInstance processDefinition = this.process(sp -> {
            ((StartEventBuilder)((StartEventBuilder)sp.embeddedSubProcess().eventSubProcess().startEvent().interrupting(false)).escalation("")).endEvent();
            ((StartEventBuilder)((StartEventBuilder)sp.embeddedSubProcess().eventSubProcess().startEvent().interrupting(false)).escalation("")).endEvent();
            sp.embeddedSubProcess().startEvent().endEvent();
        });
        Record<DeploymentRecordValue> rejectedDeployment = ENGINE.deployment().withXmlResource(processDefinition).expectRejection().deploy();
        io.camunda.zeebe.protocol.record.Assertions.assertThat(rejectedDeployment).hasRecordType(RecordType.COMMAND_REJECTION).hasRejectionType(RejectionType.INVALID_ARGUMENT);
        Assertions.assertThat((String)rejectedDeployment.getRejectionReason()).contains(new CharSequence[]{"The same scope can not contain more than one escalation catch event without escalation code. An escalation catch event without escalation code catches all escalations."});
    }

    @Test
    public void shouldRejectDeploymentIfMultipleEscalationEventSubprocessWithSameEscalationCode() {
        BpmnModelInstance processDefinition = this.process(sp -> {
            ((StartEventBuilder)((StartEventBuilder)sp.embeddedSubProcess().eventSubProcess().startEvent().interrupting(false)).escalation("escalation")).endEvent();
            ((StartEventBuilder)((StartEventBuilder)sp.embeddedSubProcess().eventSubProcess().startEvent().interrupting(false)).escalation("escalation")).endEvent();
            sp.embeddedSubProcess().startEvent().endEvent();
        });
        Record<DeploymentRecordValue> rejectedDeployment = ENGINE.deployment().withXmlResource(processDefinition).expectRejection().deploy();
        io.camunda.zeebe.protocol.record.Assertions.assertThat(rejectedDeployment).hasRecordType(RecordType.COMMAND_REJECTION).hasRejectionType(RejectionType.INVALID_ARGUMENT);
        Assertions.assertThat((String)rejectedDeployment.getRejectionReason()).contains(new CharSequence[]{"Multiple escalation catch events with the same escalation code 'escalation' are not supported on the same scope."});
    }
}

