/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.deployment.model.validation;

import io.camunda.zeebe.el.EvaluationContext;
import io.camunda.zeebe.el.EvaluationResult;
import io.camunda.zeebe.el.Expression;
import io.camunda.zeebe.el.ExpressionLanguage;
import io.camunda.zeebe.el.ResultType;
import io.camunda.zeebe.el.impl.FeelExpressionLanguage;
import io.camunda.zeebe.engine.processing.bpmn.clock.ZeebeFeelEngineClock;
import io.camunda.zeebe.engine.processing.deployment.model.validation.ProcessMessageStartEventMessageNameValidator;
import io.camunda.zeebe.model.bpmn.Bpmn;
import io.camunda.zeebe.model.bpmn.BpmnModelInstance;
import io.camunda.zeebe.model.bpmn.builder.StartEventBuilder;
import io.camunda.zeebe.model.bpmn.instance.StartEvent;
import io.camunda.zeebe.scheduler.clock.ActorClock;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.model.xml.validation.ValidationResultCollector;
import org.camunda.feel.FeelEngineClock;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
public class ProcessMessageStartEventMessageNameValidatorTest {
    @Mock
    ValidationResultCollector mockResultCollector;

    @Test
    void shouldNotThrowNPEIfMessageNameIsNull() {
        BpmnModelInstance model = ((StartEventBuilder)Bpmn.createProcess().startEvent().message((String)null)).endEvent().done();
        StartEvent startEvent = (StartEvent)model.getModelElementsByType(StartEvent.class).iterator().next();
        ProcessMessageStartEventMessageNameValidator sutValidator = new ProcessMessageStartEventMessageNameValidator((ExpressionLanguage)new FeelExpressionLanguage((FeelEngineClock)new ZeebeFeelEngineClock(ActorClock.current())));
        Assertions.assertThatNoException().isThrownBy(() -> sutValidator.validate(startEvent, this.mockResultCollector));
    }

    @Nested
    final class WithMockedExpressionLanguage {
        private static final String TEST_EXPRESSION = "expression";
        private static final BpmnModelInstance MODEL = ((StartEventBuilder)Bpmn.createProcess().startEvent().message("expression")).endEvent().done();
        private static final StartEvent START_EVENT = (StartEvent)MODEL.getModelElementsByType(StartEvent.class).iterator().next();
        @Mock
        ExpressionLanguage mockExpressionLanguage;
        @Mock
        Expression mockExpression;
        @Mock
        EvaluationResult mockResult;
        ProcessMessageStartEventMessageNameValidator sutValidator;

        WithMockedExpressionLanguage() {
        }

        @BeforeEach
        void setUp() {
            Mockito.when((Object)this.mockExpressionLanguage.parseExpression(TEST_EXPRESSION)).thenReturn((Object)this.mockExpression);
            Mockito.when((Object)this.mockExpressionLanguage.evaluateExpression((Expression)ArgumentMatchers.eq((Object)this.mockExpression), (EvaluationContext)Mockito.any())).thenReturn((Object)this.mockResult);
            this.sutValidator = new ProcessMessageStartEventMessageNameValidator(this.mockExpressionLanguage);
        }

        @Test
        void shouldLetValidMessageNameExpressionsPass() {
            Mockito.when((Object)this.mockResult.isFailure()).thenReturn((Object)false);
            Mockito.when((Object)this.mockResult.getType()).thenReturn((Object)ResultType.STRING);
            this.sutValidator.validate(START_EVENT, ProcessMessageStartEventMessageNameValidatorTest.this.mockResultCollector);
            Mockito.verifyNoInteractions((Object[])new Object[]{ProcessMessageStartEventMessageNameValidatorTest.this.mockResultCollector});
        }

        @Test
        void shouldAddErrorIfEvaluationFailed() {
            Mockito.when((Object)this.mockResult.isFailure()).thenReturn((Object)true);
            Mockito.when((Object)this.mockResult.getFailureMessage()).thenReturn((Object)"Test failure message");
            this.sutValidator.validate(START_EVENT, ProcessMessageStartEventMessageNameValidatorTest.this.mockResultCollector);
            ((ValidationResultCollector)Mockito.verify((Object)ProcessMessageStartEventMessageNameValidatorTest.this.mockResultCollector)).addError(0, "Expected constant expression but found 'expression', which could not be evaluated without context: Test failure message");
        }

        @Test
        void shouldAddErrorIfEvaluationDoesNotReturnString() {
            Mockito.when((Object)this.mockResult.isFailure()).thenReturn((Object)false);
            Mockito.when((Object)this.mockResult.getType()).thenReturn((Object)ResultType.NUMBER);
            this.sutValidator.validate(START_EVENT, ProcessMessageStartEventMessageNameValidatorTest.this.mockResultCollector);
            ((ValidationResultCollector)Mockito.verify((Object)ProcessMessageStartEventMessageNameValidatorTest.this.mockResultCollector)).addError(0, "Expected constant expression of type String for message name 'expression', but was NUMBER");
        }
    }
}

