/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.deployment.model.validation;

import io.camunda.zeebe.engine.processing.deployment.model.validation.ExpectedValidationResult;
import io.camunda.zeebe.engine.processing.deployment.model.validation.ProcessValidationUtil;
import io.camunda.zeebe.model.bpmn.Bpmn;
import io.camunda.zeebe.model.bpmn.BpmnModelInstance;
import io.camunda.zeebe.model.bpmn.builder.ScriptTaskBuilder;
import io.camunda.zeebe.model.bpmn.instance.ScriptTask;
import io.camunda.zeebe.model.bpmn.instance.zeebe.ZeebeScript;
import java.util.function.Consumer;
import org.junit.jupiter.api.Test;

public class ScriptTaskValidatorTest {
    @Test
    void emptyExpression() {
        BpmnModelInstance process = this.process(task -> ((ScriptTaskBuilder)task.zeebeExpression("")).zeebeResultVariable("result"));
        ProcessValidationUtil.validateProcess(process, ExpectedValidationResult.expect(ZeebeScript.class, "Attribute 'expression' must be present and not empty"));
    }

    @Test
    void emptyResultVariable() {
        BpmnModelInstance process = this.process(task -> ((ScriptTaskBuilder)task.zeebeExpression("expression")).zeebeResultVariable(""));
        ProcessValidationUtil.validateProcess(process, ExpectedValidationResult.expect(ZeebeScript.class, "Attribute 'resultVariable' must be present and not empty"));
    }

    @Test
    void noExpressionAndTaskDefinition() {
        BpmnModelInstance process = this.process(task -> {});
        ProcessValidationUtil.validateProcess(process, ExpectedValidationResult.expect(ScriptTask.class, "Must have either one 'zeebe:script' or one 'zeebe:taskDefinition' extension element"));
    }

    @Test
    void bothExpressionAndTaskDefinitionExtension() {
        BpmnModelInstance process = this.process(task -> ((ScriptTaskBuilder)((ScriptTaskBuilder)task.zeebeExpression("true")).zeebeResultVariable("result")).zeebeJobType("jobType"));
        ProcessValidationUtil.validateProcess(process, ExpectedValidationResult.expect(ScriptTask.class, "Must have either one 'zeebe:script' or one 'zeebe:taskDefinition' extension element"));
    }

    private BpmnModelInstance process(Consumer<ScriptTaskBuilder> taskBuilder) {
        return Bpmn.createExecutableProcess((String)"process").startEvent().scriptTask("task", taskBuilder).done();
    }
}

