/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.deployment.model.validation;

import io.camunda.zeebe.engine.util.EngineRule;
import io.camunda.zeebe.model.bpmn.Bpmn;
import io.camunda.zeebe.model.bpmn.builder.AbstractExclusiveGatewayBuilder;
import io.camunda.zeebe.model.bpmn.builder.ExclusiveGatewayBuilder;
import io.camunda.zeebe.model.bpmn.builder.MultiInstanceLoopCharacteristicsBuilder;
import io.camunda.zeebe.model.bpmn.builder.SubProcessBuilder;
import io.camunda.zeebe.protocol.record.ExecuteCommandResponseDecoder;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.RecordType;
import io.camunda.zeebe.protocol.record.RejectionType;
import io.camunda.zeebe.protocol.record.intent.DeploymentIntent;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.value.DeploymentRecordValue;
import io.camunda.zeebe.test.util.Strings;
import io.camunda.zeebe.test.util.record.RecordingExporterTestWatcher;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

public class StraightThroughProcessingLoopValidationTest {
    @ClassRule
    public static final EngineRule ENGINE = EngineRule.singlePartition();
    private static final String GENERIC_REJECTION_MESSAGE = "ERROR: Processes are not allowed to contain a straight-through processing loop: ";
    @Rule
    public final RecordingExporterTestWatcher recordingExporter = new RecordingExporterTestWatcher();

    @Test
    public void shouldRejectDeploymentWithSimpleUndefinedTaskLoop() {
        String processId = Strings.newRandomValidBpmnId();
        Record<DeploymentRecordValue> rejectedDeployment = ENGINE.deployment().withXmlResource(Bpmn.createExecutableProcess((String)processId).startEvent().task("task1").task("task2").connectTo("task1").done()).expectRejection().deploy();
        io.camunda.zeebe.protocol.record.Assertions.assertThat(rejectedDeployment).hasKey(ExecuteCommandResponseDecoder.keyNullValue()).hasRecordType(RecordType.COMMAND_REJECTION).hasIntent((Intent)DeploymentIntent.CREATE).hasRejectionType(RejectionType.INVALID_ARGUMENT);
        ((AbstractStringAssert)Assertions.assertThat((String)rejectedDeployment.getRejectionReason()).contains(new CharSequence[]{String.format("Process: %s", processId)})).contains(new CharSequence[]{"ERROR: Processes are not allowed to contain a straight-through processing loop: task1 > task2 > task1"});
    }

    @Test
    public void shouldRejectDeploymentWithSimpleManualTaskLoop() {
        String processId = Strings.newRandomValidBpmnId();
        Record<DeploymentRecordValue> rejectedDeployment = ENGINE.deployment().withXmlResource(Bpmn.createExecutableProcess((String)processId).startEvent().manualTask("task1").manualTask("task2").connectTo("task1").done()).expectRejection().deploy();
        io.camunda.zeebe.protocol.record.Assertions.assertThat(rejectedDeployment).hasKey(ExecuteCommandResponseDecoder.keyNullValue()).hasRecordType(RecordType.COMMAND_REJECTION).hasIntent((Intent)DeploymentIntent.CREATE).hasRejectionType(RejectionType.INVALID_ARGUMENT);
        ((AbstractStringAssert)Assertions.assertThat((String)rejectedDeployment.getRejectionReason()).contains(new CharSequence[]{String.format("Process: %s", processId)})).contains(new CharSequence[]{"ERROR: Processes are not allowed to contain a straight-through processing loop: task1 > task2 > task1"});
    }

    @Test
    public void shouldRejectDeploymentWithComplexStraightThroughProcessingLoop() {
        String processId = Strings.newRandomValidBpmnId();
        Record<DeploymentRecordValue> rejectedDeployment = ENGINE.deployment().withXmlResource(((ExclusiveGatewayBuilder)Bpmn.createExecutableProcess((String)processId).startEvent().userTask("userTask1").parallelGateway("parallel1").exclusiveGateway("exclusive1").task("task1").parallelGateway("parallel2").manualTask("manualTask1").exclusiveGateway("exclusive2").defaultFlow()).userTask("userTask2").connectTo("exclusive1").moveToNode("parallel2").userTask("userTask3").endEvent().moveToNode("exclusive2").sequenceFlowId("sequenceToLoop").conditionExpression("true").connectTo("task1").moveToNode("parallel1").task("task2").task("task3").endEvent().done()).expectRejection().deploy();
        io.camunda.zeebe.protocol.record.Assertions.assertThat(rejectedDeployment).hasKey(ExecuteCommandResponseDecoder.keyNullValue()).hasRecordType(RecordType.COMMAND_REJECTION).hasIntent((Intent)DeploymentIntent.CREATE).hasRejectionType(RejectionType.INVALID_ARGUMENT);
        ((AbstractStringAssert)Assertions.assertThat((String)rejectedDeployment.getRejectionReason()).contains(new CharSequence[]{String.format("Process: %s", processId)})).contains(new CharSequence[]{"ERROR: Processes are not allowed to contain a straight-through processing loop: manualTask1 > exclusive2 > task1 > parallel2 > manualTask1"});
    }

    @Test
    public void shouldRejectDeploymentWithStraightThroughProcessingLoopNotStartingAtFirstElement() {
        String processId = Strings.newRandomValidBpmnId();
        Record<DeploymentRecordValue> rejectedDeployment = ENGINE.deployment().withXmlResource(Bpmn.createExecutableProcess((String)processId).startEvent().task("task1").task("task2").task("task3").task("task4").task("task5").task("task6").task("task7").task("task8").task("task9").connectTo("task7").done()).expectRejection().deploy();
        io.camunda.zeebe.protocol.record.Assertions.assertThat(rejectedDeployment).hasKey(ExecuteCommandResponseDecoder.keyNullValue()).hasRecordType(RecordType.COMMAND_REJECTION).hasIntent((Intent)DeploymentIntent.CREATE).hasRejectionType(RejectionType.INVALID_ARGUMENT);
        ((AbstractStringAssert)Assertions.assertThat((String)rejectedDeployment.getRejectionReason()).contains(new CharSequence[]{String.format("Process: %s", processId)})).contains(new CharSequence[]{"ERROR: Processes are not allowed to contain a straight-through processing loop: task7 > task8 > task9 > task7"});
    }

    @Test
    public void shouldRejectDeploymentWithCollaborationContainingStraightThroughProcessingLoop() {
        String resource = "/processes/collaboration_straight_through_processing_loop.bpmn";
        Record<DeploymentRecordValue> rejectedDeployment = ENGINE.deployment().withXmlClasspathResource("/processes/collaboration_straight_through_processing_loop.bpmn").expectRejection().deploy();
        io.camunda.zeebe.protocol.record.Assertions.assertThat(rejectedDeployment).hasKey(ExecuteCommandResponseDecoder.keyNullValue()).hasRecordType(RecordType.COMMAND_REJECTION).hasIntent((Intent)DeploymentIntent.CREATE).hasRejectionType(RejectionType.INVALID_ARGUMENT);
        ((AbstractStringAssert)((AbstractStringAssert)((AbstractStringAssert)Assertions.assertThat((String)rejectedDeployment.getRejectionReason()).contains(new CharSequence[]{"Process: process1"})).contains(new CharSequence[]{"ERROR: Processes are not allowed to contain a straight-through processing loop: task1 > task2 > task1"})).contains(new CharSequence[]{"Process: process2"})).contains(new CharSequence[]{"ERROR: Processes are not allowed to contain a straight-through processing loop: manualTask1 > manualTask2 > manualTask1"});
    }

    @Test
    public void shouldRejectDeploymentWithSubProcessAsPartOfLoop() {
        String processId = Strings.newRandomValidBpmnId();
        Record<DeploymentRecordValue> rejectedDeployment = ENGINE.deployment().withXmlResource(Bpmn.createExecutableProcess((String)processId).startEvent().task("task1").subProcess("subProcess", subProcessBuilder -> ((AbstractExclusiveGatewayBuilder)((AbstractExclusiveGatewayBuilder)((ExclusiveGatewayBuilder)((SubProcessBuilder)subProcessBuilder).embeddedSubProcess().startEvent("startEvent").exclusiveGateway("forking").defaultFlow()).task("task2").exclusiveGateway("joining").moveToLastExclusiveGateway().sequenceFlowId("seq")).conditionExpression("true")).userTask("userTask1").connectTo("joining").endEvent("endEvent")).task("task3").connectTo("task1").done()).expectRejection().deploy();
        io.camunda.zeebe.protocol.record.Assertions.assertThat(rejectedDeployment).hasKey(ExecuteCommandResponseDecoder.keyNullValue()).hasRecordType(RecordType.COMMAND_REJECTION).hasIntent((Intent)DeploymentIntent.CREATE).hasRejectionType(RejectionType.INVALID_ARGUMENT);
        ((AbstractStringAssert)Assertions.assertThat((String)rejectedDeployment.getRejectionReason()).contains(new CharSequence[]{String.format("Process: %s", processId)})).contains(new CharSequence[]{"ERROR: Processes are not allowed to contain a straight-through processing loop: task1 > subProcess > startEvent > forking > task2 > joining > endEvent > task3 > task1"});
    }

    @Test
    public void shouldRejectDeploymentWithImplicitEndEventAsPartOfLoop() {
        String processId = Strings.newRandomValidBpmnId();
        Record<DeploymentRecordValue> rejectedDeployment = ENGINE.deployment().withXmlResource(Bpmn.createExecutableProcess((String)processId).startEvent().task("task1").subProcess("subProcess", subProcessBuilder -> ((SubProcessBuilder)subProcessBuilder).embeddedSubProcess().startEvent("startEvent").task("task2")).task("task3").connectTo("task1").done()).expectRejection().deploy();
        io.camunda.zeebe.protocol.record.Assertions.assertThat(rejectedDeployment).hasKey(ExecuteCommandResponseDecoder.keyNullValue()).hasRecordType(RecordType.COMMAND_REJECTION).hasIntent((Intent)DeploymentIntent.CREATE).hasRejectionType(RejectionType.INVALID_ARGUMENT);
        ((AbstractStringAssert)Assertions.assertThat((String)rejectedDeployment.getRejectionReason()).contains(new CharSequence[]{String.format("Process: %s", processId)})).contains(new CharSequence[]{"ERROR: Processes are not allowed to contain a straight-through processing loop: task1 > subProcess > startEvent > task2 > task3 > task1"});
    }

    @Test
    public void shouldDeployProcessWithRegularLoops() {
        String processId = Strings.newRandomValidBpmnId();
        Record<DeploymentRecordValue> deployment = ENGINE.deployment().withXmlResource(Bpmn.createExecutableProcess((String)processId).startEvent().userTask("task1").userTask("task2").connectTo("task1").done()).deploy();
        ((AbstractLongAssert)Assertions.assertThat((long)deployment.getKey()).describedAs("Allow deployments of loops that aren't straight-through processed", new Object[0])).isNotNegative();
    }

    @Test
    public void shouldRejectDeploymentWithMultiInstanceAsPartOfLoop() {
        String processId = Strings.newRandomValidBpmnId();
        Record<DeploymentRecordValue> rejectedDeployment = ENGINE.deployment().withXmlResource(((MultiInstanceLoopCharacteristicsBuilder)((MultiInstanceLoopCharacteristicsBuilder)Bpmn.createExecutableProcess((String)processId).startEvent().task("task1").task("task2").multiInstance().parallel()).zeebeInputCollectionExpression("[1,2,3]")).multiInstanceDone().connectTo("task1").done()).expectRejection().deploy();
        io.camunda.zeebe.protocol.record.Assertions.assertThat(rejectedDeployment).hasKey(ExecuteCommandResponseDecoder.keyNullValue()).hasRecordType(RecordType.COMMAND_REJECTION).hasIntent((Intent)DeploymentIntent.CREATE).hasRejectionType(RejectionType.INVALID_ARGUMENT);
        ((AbstractStringAssert)Assertions.assertThat((String)rejectedDeployment.getRejectionReason()).contains(new CharSequence[]{String.format("Process: %s", processId)})).contains(new CharSequence[]{"ERROR: Processes are not allowed to contain a straight-through processing loop: task1 > task2 > task1"});
    }

    @Test
    public void shouldRejectDeploymentWithCallActivityCallingItselfWithoutOtherElements() {
        String processId = Strings.newRandomValidBpmnId();
        Record<DeploymentRecordValue> rejectedDeployment = ENGINE.deployment().withXmlResource(Bpmn.createExecutableProcess((String)processId).startEvent("startEvent").callActivity("callActivity", c -> c.zeebeProcessId(processId)).userTask("userTask").endEvent().done()).expectRejection().deploy();
        io.camunda.zeebe.protocol.record.Assertions.assertThat(rejectedDeployment).hasKey(ExecuteCommandResponseDecoder.keyNullValue()).hasRecordType(RecordType.COMMAND_REJECTION).hasIntent((Intent)DeploymentIntent.CREATE).hasRejectionType(RejectionType.INVALID_ARGUMENT);
        ((AbstractStringAssert)Assertions.assertThat((String)rejectedDeployment.getRejectionReason()).contains(new CharSequence[]{String.format("Process: %s", processId)})).contains(new CharSequence[]{"ERROR: Processes are not allowed to contain a straight-through processing loop: callActivity > startEvent > callActivity"});
    }

    @Test
    public void shouldRejectDeploymentWithMultiInstanceCallActivityCallingItself() {
        String processId = Strings.newRandomValidBpmnId();
        Record<DeploymentRecordValue> rejectedDeployment = ENGINE.deployment().withXmlResource(((MultiInstanceLoopCharacteristicsBuilder)((MultiInstanceLoopCharacteristicsBuilder)Bpmn.createExecutableProcess((String)processId).startEvent("startEvent").callActivity("callActivity", c -> c.zeebeProcessId(processId)).multiInstance().parallel()).zeebeInputCollectionExpression("[1,2,3]")).multiInstanceDone().userTask("userTask").endEvent().done()).expectRejection().deploy();
        io.camunda.zeebe.protocol.record.Assertions.assertThat(rejectedDeployment).hasKey(ExecuteCommandResponseDecoder.keyNullValue()).hasRecordType(RecordType.COMMAND_REJECTION).hasIntent((Intent)DeploymentIntent.CREATE).hasRejectionType(RejectionType.INVALID_ARGUMENT);
        ((AbstractStringAssert)Assertions.assertThat((String)rejectedDeployment.getRejectionReason()).contains(new CharSequence[]{String.format("Process: %s", processId)})).contains(new CharSequence[]{"ERROR: Processes are not allowed to contain a straight-through processing loop: callActivity > startEvent > callActivity"});
    }

    @Test
    public void shouldDeployProcessWithRegularTaskBetweenStraightThroughTasks() {
        String processId = Strings.newRandomValidBpmnId();
        Record<DeploymentRecordValue> deployment = ENGINE.deployment().withXmlResource(Bpmn.createExecutableProcess((String)processId).startEvent().task("task1").userTask("test").task("task2").connectTo("task1").done()).deploy();
        ((AbstractLongAssert)Assertions.assertThat((long)deployment.getKey()).describedAs("Allow deployments of loops that aren't straight-through processed", new Object[0])).isNotNegative();
    }

    @Test
    public void shouldDeployProcessWithRegularTaskInsideOfSubprocess() {
        String processId = Strings.newRandomValidBpmnId();
        Record<DeploymentRecordValue> deployment = ENGINE.deployment().withXmlResource(Bpmn.createExecutableProcess((String)processId).startEvent().task("task1").subProcess("subProcess", subProcessBuilder -> ((SubProcessBuilder)subProcessBuilder).embeddedSubProcess().startEvent("startEvent").userTask("userTask").endEvent("endEvent")).task("task3").connectTo("task1").done()).deploy();
        ((AbstractLongAssert)Assertions.assertThat((long)deployment.getKey()).describedAs("Allow deployments of loops that aren't straight-through processed", new Object[0])).isNotNegative();
    }

    @Test
    public void shouldDeployProcessContainingCallActivityCallingItselfWithAWaitStateInBetween() {
        String processId = Strings.newRandomValidBpmnId();
        Record<DeploymentRecordValue> deployment = ENGINE.deployment().withXmlResource(Bpmn.createExecutableProcess((String)processId).startEvent("startEvent").userTask("userTask").callActivity("callActivity", c -> c.zeebeProcessId(processId)).endEvent().done()).deploy();
        ((AbstractLongAssert)Assertions.assertThat((long)deployment.getKey()).describedAs("Allow deployments of loops that aren't straight-through processed", new Object[0])).isNotNegative();
    }
}

