/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.dmn;

import io.camunda.zeebe.engine.util.EngineRule;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.RejectionType;
import io.camunda.zeebe.protocol.record.intent.DecisionEvaluationIntent;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.value.DecisionEvaluationRecordValue;
import io.camunda.zeebe.protocol.record.value.DeploymentRecordValue;
import io.camunda.zeebe.protocol.record.value.deployment.DecisionRecordValue;
import io.camunda.zeebe.test.util.record.RecordingExporterTestWatcher;
import org.assertj.core.api.Assertions;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

public class StandaloneDecisionEvaluationTest {
    @ClassRule
    public static final EngineRule ENGINE = EngineRule.singlePartition();
    private static final String DMN_RESOURCE = "/dmn/drg-force-user.dmn";
    private static final String DMN_WITH_ASSERTION = "/dmn/drg-force-user-with-assertions.dmn";
    private static final String DMN_DECISION_TABLE = "/dmn/decision-table.dmn";
    private static final String DMN_DECISION_TABLE_V2 = "/dmn/decision-table_v2.dmn";
    private static final String DECISION_ID = "jedi_or_sith";
    private static final String EXPECTED_DECISION_OUTPUT = "\"Jedi\"";
    private static final String EXPECTED_FAILURE_MSG = "Expected to evaluate decision 'jedi_or_sith', but Assertion failure on evaluate the expression 'assert(lightsaberColor, lightsaberColor != null)': The condition is not fulfilled";
    @Rule
    public final RecordingExporterTestWatcher recordingExporterTestWatcher = new RecordingExporterTestWatcher();

    @Test
    public void shouldEvaluateDecisionById() {
        ENGINE.deployment().withXmlClasspathResource(DMN_RESOURCE).deploy();
        Record<DecisionEvaluationRecordValue> record = ENGINE.decision().ofDecisionId(DECISION_ID).withVariable("lightsaberColor", "blue").evaluate();
        io.camunda.zeebe.protocol.record.Assertions.assertThat((Intent)record.getIntent()).isEqualTo((Object)DecisionEvaluationIntent.EVALUATED);
        io.camunda.zeebe.protocol.record.Assertions.assertThat((DecisionEvaluationRecordValue)((DecisionEvaluationRecordValue)record.getValue())).hasDecisionOutput(EXPECTED_DECISION_OUTPUT).hasTenantId("<default>");
    }

    @Test
    public void shouldFailEvaluationOfDecisionById() {
        ENGINE.deployment().withXmlClasspathResource(DMN_WITH_ASSERTION).deploy();
        Record<DecisionEvaluationRecordValue> record = ENGINE.decision().ofDecisionId(DECISION_ID).expectFailure().evaluate();
        io.camunda.zeebe.protocol.record.Assertions.assertThat((Intent)record.getIntent()).isEqualTo((Object)DecisionEvaluationIntent.FAILED);
        io.camunda.zeebe.protocol.record.Assertions.assertThat((DecisionEvaluationRecordValue)((DecisionEvaluationRecordValue)record.getValue())).hasFailedDecisionId(DECISION_ID).hasEvaluationFailureMessage(EXPECTED_FAILURE_MSG).hasTenantId("<default>");
    }

    @Test
    public void shouldEvaluateLatestDecisionById() {
        ENGINE.deployment().withXmlClasspathResource(DMN_DECISION_TABLE).deploy();
        Record<DeploymentRecordValue> deploymentEvent = ENGINE.deployment().withXmlClasspathResource(DMN_DECISION_TABLE_V2).deploy();
        Record<DecisionEvaluationRecordValue> record = ENGINE.decision().ofDecisionId(DECISION_ID).withVariable("lightsaberColor", "blue").evaluate();
        int deployedVersion = ((DeploymentRecordValue)deploymentEvent.getValue()).getDecisionsMetadata().stream().filter(decisionRecordValue -> decisionRecordValue.getDecisionId().equals(DECISION_ID)).findFirst().get().getVersion();
        io.camunda.zeebe.protocol.record.Assertions.assertThat((Intent)record.getIntent()).isEqualTo((Object)DecisionEvaluationIntent.EVALUATED);
        io.camunda.zeebe.protocol.record.Assertions.assertThat((DecisionEvaluationRecordValue)((DecisionEvaluationRecordValue)record.getValue())).hasDecisionOutput(EXPECTED_DECISION_OUTPUT).hasDecisionVersion(deployedVersion).hasTenantId("<default>");
    }

    @Test
    public void shouldEvaluateDecisionByKey() {
        Record<DeploymentRecordValue> deploymentRecord = ENGINE.deployment().withXmlClasspathResource(DMN_RESOURCE).deploy();
        DecisionRecordValue decisionRecord = ((DeploymentRecordValue)deploymentRecord.getValue()).getDecisionsMetadata().stream().filter(decisionRecordValue -> decisionRecordValue.getDecisionId().equals(DECISION_ID)).findAny().get();
        long decisionKey = decisionRecord.getDecisionKey();
        Record<DecisionEvaluationRecordValue> record = ENGINE.decision().ofDecisionKey(decisionKey).withVariable("lightsaberColor", "blue").evaluate();
        io.camunda.zeebe.protocol.record.Assertions.assertThat((Intent)record.getIntent()).isEqualTo((Object)DecisionEvaluationIntent.EVALUATED);
        io.camunda.zeebe.protocol.record.Assertions.assertThat((DecisionEvaluationRecordValue)((DecisionEvaluationRecordValue)record.getValue())).hasDecisionOutput(EXPECTED_DECISION_OUTPUT).hasTenantId("<default>");
    }

    @Test
    public void shouldRejectDecisionWithoutIdAndKey() {
        Record<DecisionEvaluationRecordValue> record = ENGINE.decision().ofDecisionId("").ofDecisionKey(-1L).expectRejection().evaluate();
        io.camunda.zeebe.protocol.record.Assertions.assertThat((RejectionType)record.getRejectionType()).isEqualTo((Object)RejectionType.INVALID_ARGUMENT);
        io.camunda.zeebe.protocol.record.Assertions.assertThat((Intent)record.getIntent()).isEqualTo((Object)DecisionEvaluationIntent.EVALUATE);
        Assertions.assertThat((String)record.getRejectionReason()).isEqualTo("Expected either a decision id or a valid decision key, but none provided");
        io.camunda.zeebe.protocol.record.Assertions.assertThat((DecisionEvaluationRecordValue)((DecisionEvaluationRecordValue)record.getValue())).hasTenantId("<default>");
    }

    @Test
    public void shouldRejectDecisionOnFalseId() {
        String falseDecisionId = "falseId";
        Record<DecisionEvaluationRecordValue> record = ENGINE.decision().ofDecisionId("falseId").expectRejection().evaluate();
        io.camunda.zeebe.protocol.record.Assertions.assertThat((RejectionType)record.getRejectionType()).isEqualTo((Object)RejectionType.INVALID_ARGUMENT);
        io.camunda.zeebe.protocol.record.Assertions.assertThat((Intent)record.getIntent()).isEqualTo((Object)DecisionEvaluationIntent.EVALUATE);
        Assertions.assertThat((String)record.getRejectionReason()).isEqualTo("Expected to evaluate decision 'falseId', but no decision found for id 'falseId'");
        io.camunda.zeebe.protocol.record.Assertions.assertThat((DecisionEvaluationRecordValue)((DecisionEvaluationRecordValue)record.getValue())).hasTenantId("<default>");
    }

    @Test
    public void shouldRejectDecisionOnFalseKey() {
        long falseDecisionKey = 123L;
        Record<DecisionEvaluationRecordValue> record = ENGINE.decision().ofDecisionKey(123L).expectRejection().evaluate();
        io.camunda.zeebe.protocol.record.Assertions.assertThat((RejectionType)record.getRejectionType()).isEqualTo((Object)RejectionType.INVALID_ARGUMENT);
        io.camunda.zeebe.protocol.record.Assertions.assertThat((Intent)record.getIntent()).isEqualTo((Object)DecisionEvaluationIntent.EVALUATE);
        Assertions.assertThat((String)record.getRejectionReason()).isEqualTo("Expected to evaluate decision '123', but no decision found for key '123'");
        io.camunda.zeebe.protocol.record.Assertions.assertThat((DecisionEvaluationRecordValue)((DecisionEvaluationRecordValue)record.getValue())).hasTenantId("<default>");
    }
}

