/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.incident;

import io.camunda.zeebe.engine.util.EngineRule;
import io.camunda.zeebe.model.bpmn.Bpmn;
import io.camunda.zeebe.model.bpmn.BpmnModelInstance;
import io.camunda.zeebe.model.bpmn.builder.ReceiveTaskBuilder;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.intent.IncidentIntent;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceIntent;
import io.camunda.zeebe.protocol.record.intent.ProcessMessageSubscriptionIntent;
import io.camunda.zeebe.protocol.record.value.ErrorType;
import io.camunda.zeebe.protocol.record.value.IncidentRecordValue;
import io.camunda.zeebe.protocol.record.value.ProcessInstanceRecordValue;
import io.camunda.zeebe.protocol.record.value.ProcessMessageSubscriptionRecordValue;
import io.camunda.zeebe.test.util.record.RecordingExporter;
import io.camunda.zeebe.test.util.record.RecordingExporterTestWatcher;
import java.util.Arrays;
import java.util.HashMap;
import java.util.UUID;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public final class EventSubscriptionIncidentTest {
    @ClassRule
    public static final EngineRule ENGINE = EngineRule.singlePartition();
    private static final String MESSAGE_NAME_1 = "msg-1";
    private static final String MESSAGE_NAME_2 = "msg-2";
    private static final String CORRELATION_VARIABLE_1 = "key1";
    private static final String CORRELATION_VARIABLE_2 = "key2";
    private static final String WF_RECEIVE_TASK_ID = "wf-receive-task";
    private static final BpmnModelInstance WF_RECEIVE_TASK = ((ReceiveTaskBuilder)Bpmn.createExecutableProcess((String)"wf-receive-task").startEvent().receiveTask("task").message(m -> m.name(MESSAGE_NAME_1).zeebeCorrelationKeyExpression(CORRELATION_VARIABLE_1))).boundaryEvent("msg-2", c -> c.message(m -> m.name(MESSAGE_NAME_2).zeebeCorrelationKeyExpression(CORRELATION_VARIABLE_2))).endEvent().done();
    private static final String WF_RECEIVE_TASK_2_ID = "wf-receive-task-2";
    private static final BpmnModelInstance WF_RECEIVE_TASK_2 = ((ReceiveTaskBuilder)Bpmn.createExecutableProcess((String)"wf-receive-task-2").startEvent().receiveTask("task").message(m -> m.name(MESSAGE_NAME_2).zeebeCorrelationKeyExpression(CORRELATION_VARIABLE_2))).boundaryEvent("msg-1", c -> c.message(m -> m.name(MESSAGE_NAME_1).zeebeCorrelationKeyExpression(CORRELATION_VARIABLE_1))).endEvent().done();
    private static final String WF_EVENT_BASED_GATEWAY_ID = "wf-event-based-gateway";
    private static final BpmnModelInstance WF_EVENT_BASED_GATEWAY = Bpmn.createExecutableProcess((String)"wf-event-based-gateway").startEvent().eventBasedGateway("gateway").intermediateCatchEvent("msg-1", i -> i.message(m -> m.name(MESSAGE_NAME_1).zeebeCorrelationKeyExpression(CORRELATION_VARIABLE_1))).endEvent().moveToLastGateway().intermediateCatchEvent("msg-2", i -> i.message(m -> m.name(MESSAGE_NAME_2).zeebeCorrelationKeyExpression(CORRELATION_VARIABLE_2))).endEvent().done();
    private static final String WF_EVENT_BASED_GATEWAY_2_ID = "wf-event-based-gateway-2";
    private static final BpmnModelInstance WF_EVENT_BASED_GATEWAY_2 = Bpmn.createExecutableProcess((String)"wf-event-based-gateway-2").startEvent().eventBasedGateway("gateway").intermediateCatchEvent("msg-2", i -> i.message(m -> m.name(MESSAGE_NAME_2).zeebeCorrelationKeyExpression(CORRELATION_VARIABLE_2))).endEvent().moveToLastGateway().intermediateCatchEvent("msg-1", i -> i.message(m -> m.name(MESSAGE_NAME_1).zeebeCorrelationKeyExpression(CORRELATION_VARIABLE_1))).endEvent().done();
    private static final String WF_BOUNDARY_EVENT_ID = "wf-boundary-event";
    private static final BpmnModelInstance WF_BOUNDARY_EVENT = Bpmn.createExecutableProcess((String)"wf-boundary-event").startEvent().serviceTask("task", t -> t.zeebeJobType("test")).boundaryEvent("msg-1", c -> c.message(m -> m.name(MESSAGE_NAME_1).zeebeCorrelationKeyExpression(CORRELATION_VARIABLE_1))).endEvent().moveToActivity("task").boundaryEvent("msg-2", c -> c.message(m -> m.name(MESSAGE_NAME_2).zeebeCorrelationKeyExpression(CORRELATION_VARIABLE_2))).endEvent().done();
    private static final String WF_BOUNDARY_EVENT_2_ID = "wf-boundary-event-2";
    private static final BpmnModelInstance WF_BOUNDARY_EVENT_2 = Bpmn.createExecutableProcess((String)"wf-boundary-event-2").startEvent().serviceTask("task", t -> t.zeebeJobType("test")).boundaryEvent("msg-2", c -> c.message(m -> m.name(MESSAGE_NAME_2).zeebeCorrelationKeyExpression(CORRELATION_VARIABLE_2))).endEvent().moveToActivity("task").boundaryEvent("msg-1", c -> c.message(m -> m.name(MESSAGE_NAME_1).zeebeCorrelationKeyExpression(CORRELATION_VARIABLE_1))).endEvent().done();
    @Rule
    public RecordingExporterTestWatcher recordingExporterTestWatcher = new RecordingExporterTestWatcher();
    @Parameterized.Parameter(value=0)
    public String elementType;
    @Parameterized.Parameter(value=1)
    public String processId;
    @Parameterized.Parameter(value=2)
    public String elementId;
    @Parameterized.Parameter(value=3)
    public ProcessInstanceIntent failureEventIntent;
    @Parameterized.Parameter(value=4)
    public ProcessInstanceIntent resolvedEventIntent;
    private String correlationKey1;
    private String correlationKey2;

    @Parameterized.Parameters(name="{0}")
    public static Object[][] parameters() {
        return new Object[][]{{"boundary catch event (first event)", WF_BOUNDARY_EVENT_ID, "task", ProcessInstanceIntent.ELEMENT_ACTIVATING, ProcessInstanceIntent.ELEMENT_ACTIVATED}, {"boundary catch event (second event)", WF_BOUNDARY_EVENT_2_ID, "task", ProcessInstanceIntent.ELEMENT_ACTIVATING, ProcessInstanceIntent.ELEMENT_ACTIVATED}, {"receive task (boundary event)", WF_RECEIVE_TASK_ID, "task", ProcessInstanceIntent.ELEMENT_ACTIVATING, ProcessInstanceIntent.ELEMENT_ACTIVATED}, {"receive task (task)", WF_RECEIVE_TASK_2_ID, "task", ProcessInstanceIntent.ELEMENT_ACTIVATING, ProcessInstanceIntent.ELEMENT_ACTIVATED}, {"event-based gateway (first event)", WF_EVENT_BASED_GATEWAY_ID, "gateway", ProcessInstanceIntent.ELEMENT_ACTIVATING, null}, {"event-based gateway (second event)", WF_EVENT_BASED_GATEWAY_2_ID, "gateway", ProcessInstanceIntent.ELEMENT_ACTIVATING, null}};
    }

    @BeforeClass
    public static void deployProcesses() {
        for (BpmnModelInstance modelInstance : Arrays.asList(WF_RECEIVE_TASK, WF_RECEIVE_TASK_2, WF_BOUNDARY_EVENT, WF_BOUNDARY_EVENT_2, WF_EVENT_BASED_GATEWAY, WF_EVENT_BASED_GATEWAY_2)) {
            ENGINE.deployment().withXmlResource(modelInstance).deploy();
        }
    }

    @Before
    public void init() {
        this.correlationKey1 = UUID.randomUUID().toString();
        this.correlationKey2 = UUID.randomUUID().toString();
    }

    @Test
    public void shouldCreateIncidentIfMessageCorrelationKeyNotFound() {
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(this.processId).withVariable(CORRELATION_VARIABLE_1, this.correlationKey1).create();
        Record failureEvent = (Record)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)this.failureEventIntent).withProcessInstanceKey(processInstanceKey).withElementId(this.elementId).getFirst();
        Record incidentRecord = (Record)RecordingExporter.incidentRecords((IncidentIntent)IncidentIntent.CREATED).withProcessInstanceKey(processInstanceKey).getFirst();
        io.camunda.zeebe.protocol.record.Assertions.assertThat((IncidentRecordValue)((IncidentRecordValue)incidentRecord.getValue())).hasErrorType(ErrorType.EXTRACT_VALUE_ERROR).hasErrorMessage("Failed to extract the correlation key for 'key2': The value must be either a string or a number, but was 'NULL'. The evaluation reported the following warnings:\n[NO_VARIABLE_FOUND] No variable found with name 'key2'").hasBpmnProcessId(this.processId).hasProcessInstanceKey(processInstanceKey).hasElementId(((ProcessInstanceRecordValue)failureEvent.getValue()).getElementId()).hasElementInstanceKey(failureEvent.getKey()).hasTenantId("<default>").hasJobKey(-1L);
    }

    @Test
    public void shouldCreateIncidentIfMessageCorrelationKeyHasInvalidType() {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put(CORRELATION_VARIABLE_1, this.correlationKey1);
        variables.put(CORRELATION_VARIABLE_2, Arrays.asList(1, 2, 3));
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(this.processId).withVariables(variables).create();
        Record failureEvent = (Record)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)this.failureEventIntent).withProcessInstanceKey(processInstanceKey).withElementId(this.elementId).getFirst();
        Record incidentRecord = (Record)RecordingExporter.incidentRecords((IncidentIntent)IncidentIntent.CREATED).withProcessInstanceKey(processInstanceKey).getFirst();
        io.camunda.zeebe.protocol.record.Assertions.assertThat((IncidentRecordValue)((IncidentRecordValue)incidentRecord.getValue())).hasErrorType(ErrorType.EXTRACT_VALUE_ERROR).hasErrorMessage("Failed to extract the correlation key for 'key2': The value must be either a string or a number, but was 'ARRAY'.").hasBpmnProcessId(this.processId).hasProcessInstanceKey(processInstanceKey).hasElementId(((ProcessInstanceRecordValue)failureEvent.getValue()).getElementId()).hasElementInstanceKey(failureEvent.getKey()).hasTenantId("<default>").hasJobKey(-1L);
    }

    @Test
    public void shouldOpenSubscriptionsWhenIncidentIsResolved() {
        String correlationKey1 = UUID.randomUUID().toString();
        String correlationKey2 = UUID.randomUUID().toString();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(this.processId).withVariable(CORRELATION_VARIABLE_1, correlationKey1).create();
        Record incidentCreatedRecord = (Record)RecordingExporter.incidentRecords((IncidentIntent)IncidentIntent.CREATED).withProcessInstanceKey(processInstanceKey).getFirst();
        HashMap<String, Object> document = new HashMap<String, Object>();
        document.put(CORRELATION_VARIABLE_1, correlationKey1);
        document.put(CORRELATION_VARIABLE_2, correlationKey2);
        ENGINE.variables().ofScope(((IncidentRecordValue)incidentCreatedRecord.getValue()).getElementInstanceKey()).withDocument(document).update();
        ENGINE.incident().ofInstance(processInstanceKey).withKey(incidentCreatedRecord.getKey()).resolve();
        Assertions.assertThat((Stream)RecordingExporter.processMessageSubscriptionRecords((ProcessMessageSubscriptionIntent)ProcessMessageSubscriptionIntent.CREATED).withProcessInstanceKey(processInstanceKey).limit(2L)).extracting(Record::getValue).extracting(ProcessMessageSubscriptionRecordValue::getMessageName).containsExactlyInAnyOrder((Object[])new String[]{MESSAGE_NAME_1, MESSAGE_NAME_2});
        ENGINE.message().withName(MESSAGE_NAME_2).withCorrelationKey(correlationKey2).publish();
        Assertions.assertThat((boolean)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_COMPLETED).withProcessInstanceKey(processInstanceKey).withElementId(this.processId).exists()).isTrue();
    }

    @Test
    public void shouldNotOpenSubscriptionsWhenIncidentIsCreated() {
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(this.processId).withVariable(CORRELATION_VARIABLE_1, this.correlationKey1).create();
        Record incidentCreatedRecord = (Record)RecordingExporter.incidentRecords((IncidentIntent)IncidentIntent.CREATED).withProcessInstanceKey(processInstanceKey).getFirst();
        HashMap<String, Object> document = new HashMap<String, Object>();
        document.put(CORRELATION_VARIABLE_1, this.correlationKey1);
        document.put(CORRELATION_VARIABLE_2, this.correlationKey2);
        ENGINE.variables().ofScope(((IncidentRecordValue)incidentCreatedRecord.getValue()).getElementInstanceKey()).withDocument(document).update();
        ENGINE.incident().ofInstance(processInstanceKey).withKey(incidentCreatedRecord.getKey()).resolve();
        Record incidentResolvedRecord = (Record)RecordingExporter.incidentRecords((IncidentIntent)IncidentIntent.RESOLVED).withProcessInstanceKey(processInstanceKey).getFirst();
        Assertions.assertThat((Stream)RecordingExporter.processMessageSubscriptionRecords((ProcessMessageSubscriptionIntent)ProcessMessageSubscriptionIntent.CREATED).withProcessInstanceKey(processInstanceKey).limit(2L)).allMatch(r -> r.getPosition() > incidentResolvedRecord.getPosition());
        if (this.resolvedEventIntent != null) {
            Assertions.assertThat((long)((Record)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)this.resolvedEventIntent).withProcessInstanceKey(processInstanceKey).withElementId(this.elementId).getFirst()).getPosition()).isGreaterThan(incidentResolvedRecord.getPosition());
        }
    }
}

