/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.incident;

import io.camunda.zeebe.engine.util.EngineRule;
import io.camunda.zeebe.engine.util.RecordToWrite;
import io.camunda.zeebe.engine.util.Records;
import io.camunda.zeebe.model.bpmn.Bpmn;
import io.camunda.zeebe.model.bpmn.BpmnModelInstance;
import io.camunda.zeebe.model.bpmn.builder.MultiInstanceLoopCharacteristicsBuilder;
import io.camunda.zeebe.model.bpmn.builder.ServiceTaskBuilder;
import io.camunda.zeebe.protocol.impl.record.value.processinstance.ProcessInstanceRecord;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.intent.IncidentIntent;
import io.camunda.zeebe.protocol.record.intent.JobIntent;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceIntent;
import io.camunda.zeebe.protocol.record.intent.VariableDocumentIntent;
import io.camunda.zeebe.protocol.record.value.BpmnElementType;
import io.camunda.zeebe.protocol.record.value.DeploymentRecordValue;
import io.camunda.zeebe.protocol.record.value.ErrorType;
import io.camunda.zeebe.protocol.record.value.IncidentRecordValue;
import io.camunda.zeebe.protocol.record.value.JobRecordValue;
import io.camunda.zeebe.protocol.record.value.ProcessInstanceRecordValue;
import io.camunda.zeebe.protocol.record.value.VariableDocumentRecordValue;
import io.camunda.zeebe.protocol.record.value.deployment.ProcessMetadataValue;
import io.camunda.zeebe.test.util.BrokerClassRuleHelper;
import io.camunda.zeebe.test.util.record.IncidentRecordStream;
import io.camunda.zeebe.test.util.record.JobRecordStream;
import io.camunda.zeebe.test.util.record.RecordingExporter;
import io.camunda.zeebe.test.util.record.RecordingExporterTestWatcher;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.assertj.core.groups.Tuple;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

public class MultiInstanceConcurrentModificationTest {
    @ClassRule
    public static final EngineRule ENGINE = EngineRule.singlePartition().maxCommandsInBatch(1);
    private static final String MULTI_TASK_PROCESS = "multi-task-process";
    private static final String ELEMENT_ID = "task";
    private static final String INPUT_COLLECTION = "items";
    private static final String INPUT_ELEMENT = "item";
    @Rule
    public final RecordingExporterTestWatcher recordingExporterTestWatcher = new RecordingExporterTestWatcher();
    @Rule
    public final BrokerClassRuleHelper helper = new BrokerClassRuleHelper();
    private String jobType;

    @Before
    public void init() {
        this.jobType = this.helper.getJobType();
        ENGINE.deployment().withXmlResource(Bpmn.createExecutableProcess((String)MULTI_TASK_PROCESS).startEvent().serviceTask(ELEMENT_ID, t -> ((ServiceTaskBuilder)t.zeebeJobType(this.jobType)).multiInstance(b -> ((MultiInstanceLoopCharacteristicsBuilder)((MultiInstanceLoopCharacteristicsBuilder)((MultiInstanceLoopCharacteristicsBuilder)b.zeebeInputCollectionExpression(INPUT_COLLECTION)).zeebeInputElement(INPUT_ELEMENT)).zeebeOutputElementExpression("{x: undefined_var}")).zeebeOutputCollection("results"))).endEvent().done()).deploy();
    }

    @Test
    public void shouldCreateIncidentWhenInputCollectionModifiedConcurrently() {
        BpmnModelInstance process = ((ServiceTaskBuilder)((ServiceTaskBuilder)Bpmn.createExecutableProcess((String)"multi-task").startEvent().serviceTask(ELEMENT_ID, t -> t.zeebeJobType(this.jobType)).sequenceFlowId("from-task-to-multi-instance")).serviceTask("multi-instance", t -> t.zeebeJobType(this.jobType)).multiInstance(b -> ((MultiInstanceLoopCharacteristicsBuilder)((MultiInstanceLoopCharacteristicsBuilder)b.parallel()).zeebeInputCollectionExpression(INPUT_COLLECTION)).zeebeInputElement(INPUT_ELEMENT))).endEvent().done();
        Record<DeploymentRecordValue> deployment = ENGINE.deployment().withXmlResource(process).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId("multi-task").withVariable(INPUT_COLLECTION, List.of(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3))).create();
        Record serviceTask = (Record)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATED).withProcessInstanceKey(processInstanceKey).withElementType(BpmnElementType.SERVICE_TASK).getFirst();
        Record<JobRecordValue> job = MultiInstanceConcurrentModificationTest.findNthJob(processInstanceKey, 1);
        ENGINE.stop();
        RecordingExporter.reset();
        ProcessInstanceRecord sequenceFlow = Records.processInstance(processInstanceKey, "multi-task").setBpmnElementType(BpmnElementType.SEQUENCE_FLOW).setElementId("from-task-to-multi-instance").setFlowScopeKey(processInstanceKey).setProcessDefinitionKey(((ProcessMetadataValue)((DeploymentRecordValue)deployment.getValue()).getProcessesMetadata().get(0)).getProcessDefinitionKey());
        ProcessInstanceRecord multiInstanceBody = Records.processInstance(processInstanceKey, "multi-task").setBpmnElementType(BpmnElementType.MULTI_INSTANCE_BODY).setElementId("multi-instance").setFlowScopeKey(processInstanceKey).setProcessDefinitionKey(((ProcessMetadataValue)((DeploymentRecordValue)deployment.getValue()).getProcessesMetadata().get(0)).getProcessDefinitionKey());
        ENGINE.writeRecords(RecordToWrite.command().key(job.getKey()).job(JobIntent.COMPLETE, (JobRecordValue)job.getValue()), RecordToWrite.event().causedBy(0).key(job.getKey()).job(JobIntent.COMPLETED, (JobRecordValue)job.getValue()), RecordToWrite.command().causedBy(0).key(serviceTask.getKey()).processInstance(ProcessInstanceIntent.COMPLETE_ELEMENT, (ProcessInstanceRecordValue)serviceTask.getValue()), RecordToWrite.event().causedBy(2).key(serviceTask.getKey()).processInstance(ProcessInstanceIntent.ELEMENT_COMPLETING, (ProcessInstanceRecordValue)serviceTask.getValue()), RecordToWrite.event().causedBy(2).key(serviceTask.getKey()).processInstance(ProcessInstanceIntent.ELEMENT_COMPLETED, (ProcessInstanceRecordValue)serviceTask.getValue()), RecordToWrite.event().causedBy(2).key(-1L).processInstance(ProcessInstanceIntent.SEQUENCE_FLOW_TAKEN, (ProcessInstanceRecordValue)sequenceFlow), RecordToWrite.command().causedBy(2).processInstance(ProcessInstanceIntent.ACTIVATE_ELEMENT, (ProcessInstanceRecordValue)multiInstanceBody), RecordToWrite.command().variable(VariableDocumentIntent.UPDATE, (VariableDocumentRecordValue)Records.variableDocument(processInstanceKey, "{\"items\":0}")));
        ENGINE.start();
        List incidents = ((IncidentRecordStream)RecordingExporter.incidentRecords((IncidentIntent)IncidentIntent.CREATED).withProcessInstanceKey(processInstanceKey).limit(3L)).asList();
        ((ListAssert)Assertions.assertThat((List)incidents).describedAs("Should create incident for each child when input element cannot be retrieved from input collection", new Object[0])).extracting(Record::getValue).extracting(new Function[]{IncidentRecordValue::getElementId, IncidentRecordValue::getErrorType, IncidentRecordValue::getErrorMessage}).containsOnly((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{"multi-instance", ErrorType.EXTRACT_VALUE_ERROR, "Expected result of the expression 'items' to be 'ARRAY', but was 'NUMBER'."})});
        ENGINE.variables().ofScope(processInstanceKey).withDocument(Collections.singletonMap(INPUT_COLLECTION, List.of(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3)))).update();
        incidents.forEach(i -> ENGINE.incident().ofInstance(processInstanceKey).withKey(i.getKey()).resolve());
        MultiInstanceConcurrentModificationTest.completeNthJob(processInstanceKey, 2);
        MultiInstanceConcurrentModificationTest.completeNthJob(processInstanceKey, 3);
        MultiInstanceConcurrentModificationTest.completeNthJob(processInstanceKey, 4);
        RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_COMPLETED).withProcessInstanceKey(processInstanceKey).withElementType(BpmnElementType.PROCESS).await();
    }

    private static void completeNthJob(long processInstanceKey, int n) {
        Record<JobRecordValue> nthJob = MultiInstanceConcurrentModificationTest.findNthJob(processInstanceKey, n);
        ENGINE.job().withKey(nthJob.getKey()).complete();
    }

    private static Record<JobRecordValue> findNthJob(long processInstanceKey, int n) {
        return (Record)((JobRecordStream)RecordingExporter.jobRecords((JobIntent)JobIntent.CREATED).withProcessInstanceKey(processInstanceKey).skip((long)(n - 1))).getFirst();
    }
}

