/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.incident;

import io.camunda.zeebe.engine.processing.incident.IncidentHelper;
import io.camunda.zeebe.engine.util.EngineRule;
import io.camunda.zeebe.model.bpmn.Bpmn;
import io.camunda.zeebe.model.bpmn.BpmnModelInstance;
import io.camunda.zeebe.model.bpmn.builder.BoundaryEventBuilder;
import io.camunda.zeebe.model.bpmn.builder.ServiceTaskBuilder;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.intent.IncidentIntent;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceIntent;
import io.camunda.zeebe.protocol.record.value.ErrorType;
import io.camunda.zeebe.protocol.record.value.IncidentRecordValue;
import io.camunda.zeebe.protocol.record.value.ProcessInstanceRecordValue;
import io.camunda.zeebe.test.util.BrokerClassRuleHelper;
import io.camunda.zeebe.test.util.record.ProcessInstanceRecordStream;
import io.camunda.zeebe.test.util.record.RecordingExporter;
import io.camunda.zeebe.test.util.record.RecordingExporterTestWatcher;
import java.time.Duration;
import java.util.Collections;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.OptionalAssert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

public final class TimerIncidentTest {
    @ClassRule
    public static final EngineRule ENGINE = EngineRule.singlePartition();
    private static final String PROCESS_ID = "process";
    private static final String ELEMENT_ID = "timer-1";
    private static final String DURATION_VARIABLE = "timer_duration";
    private static final String DURATION_EXPRESSION = "duration(timer_duration)";
    private static final String CYCLE_EXPRESSION = "cycle(duration(timer_duration))";
    private static final String DATETIME_EXPRESSION = "date and time(date(timer_duration),time(\"T00:00:00@UTC\"))";
    @Rule
    public final RecordingExporterTestWatcher recordingExporterTestWatcher = new RecordingExporterTestWatcher();
    @Rule
    public final BrokerClassRuleHelper helper = new BrokerClassRuleHelper();

    private static BpmnModelInstance createProcess(String expression) {
        return Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().intermediateCatchEvent(ELEMENT_ID, b -> b.timerWithDurationExpression(expression)).endEvent().done();
    }

    private static BpmnModelInstance createProcessWithCycle(String expression) {
        return Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().serviceTask(ELEMENT_ID, serviceTaskBuilder -> ((ServiceTaskBuilder)serviceTaskBuilder.zeebeJobType("boundary_timer_test")).boundaryEvent("boundary-event-1", timerBoundaryEventBuilder -> ((BoundaryEventBuilder)((BoundaryEventBuilder)timerBoundaryEventBuilder.cancelActivity(Boolean.valueOf(false))).timerWithCycleExpression(expression)).endEvent("boundary-timer-end-event"))).endEvent().done();
    }

    private static BpmnModelInstance createProcessWithTimeDate(String expression) {
        return Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().serviceTask(ELEMENT_ID, serviceTaskBuilder -> ((ServiceTaskBuilder)serviceTaskBuilder.zeebeJobType("boundary_timer_test")).boundaryEvent("boundary-event-1", timerBoundaryEventBuilder -> ((BoundaryEventBuilder)((BoundaryEventBuilder)timerBoundaryEventBuilder.cancelActivity(Boolean.valueOf(false))).timerWithDateExpression(expression)).endEvent("boundary-timer-end-event"))).endEvent().done();
    }

    @Test
    public void shouldCreateIncidentIfTimeDateVariableNotFound() {
        ENGINE.deployment().withXmlResource(TimerIncidentTest.createProcessWithTimeDate(DATETIME_EXPRESSION)).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        Record incident = (Record)RecordingExporter.incidentRecords((IncidentIntent)IncidentIntent.CREATED).withProcessInstanceKey(processInstanceKey).getFirst();
        Record elementInstance = (Record)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATING).withElementId(ELEMENT_ID).getFirst();
        IncidentHelper.assertIncidentCreated((Record<IncidentRecordValue>)incident, (Record<ProcessInstanceRecordValue>)elementInstance).hasErrorType(ErrorType.EXTRACT_VALUE_ERROR).hasErrorMessage("Expected result of the expression 'date and time(date(timer_duration),time(\"T00:00:00@UTC\"))' to be one of '[DATE_TIME, STRING]', but was 'NULL'. The evaluation reported the following warnings:\n[NO_VARIABLE_FOUND] No variable found with name 'timer_duration'\n[FUNCTION_INVOCATION_FAILURE] Failed to invoke function 'date': Illegal arguments: 'null'\n[FUNCTION_INVOCATION_FAILURE] Failed to invoke function 'date and time': Illegal arguments: 'null', '00:00:00@UTC'");
    }

    @Test
    public void shouldCreateIncidentIfTimeDateVariableNotATimeDate() {
        ENGINE.deployment().withXmlResource(TimerIncidentTest.createProcessWithTimeDate(DURATION_VARIABLE)).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).withVariable(DURATION_VARIABLE, "not_a_duration_expression").create();
        Record incident = (Record)RecordingExporter.incidentRecords((IncidentIntent)IncidentIntent.CREATED).withProcessInstanceKey(processInstanceKey).getFirst();
        Record elementInstance = (Record)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATING).withElementId(ELEMENT_ID).getFirst();
        IncidentHelper.assertIncidentCreated((Record<IncidentRecordValue>)incident, (Record<ProcessInstanceRecordValue>)elementInstance).hasErrorType(ErrorType.EXTRACT_VALUE_ERROR).hasErrorMessage("Invalid date-time format 'not_a_duration_expression' for expression 'timer_duration'.");
    }

    @Test
    public void shouldCreateIncidentIfDurationVariableNotFound() {
        ENGINE.deployment().withXmlResource(TimerIncidentTest.createProcess(DURATION_EXPRESSION)).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        Record incident = (Record)RecordingExporter.incidentRecords((IncidentIntent)IncidentIntent.CREATED).withProcessInstanceKey(processInstanceKey).getFirst();
        Record elementInstance = (Record)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATING).withElementId(ELEMENT_ID).getFirst();
        IncidentHelper.assertIncidentCreated((Record<IncidentRecordValue>)incident, (Record<ProcessInstanceRecordValue>)elementInstance).hasErrorType(ErrorType.EXTRACT_VALUE_ERROR).hasErrorMessage("Expected result of the expression 'duration(timer_duration)' to be one of '[DURATION, PERIOD, STRING]', but was 'NULL'. The evaluation reported the following warnings:\n[NO_VARIABLE_FOUND] No variable found with name 'timer_duration'\n[FUNCTION_INVOCATION_FAILURE] Failed to invoke function 'duration': Illegal arguments: 'null'");
    }

    @Test
    public void shouldCreateIncidentIfDurationVariableNotADuration() {
        ENGINE.deployment().withXmlResource(TimerIncidentTest.createProcess(DURATION_VARIABLE)).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).withVariable(DURATION_VARIABLE, "not_a_duration_expression").create();
        Record incident = (Record)RecordingExporter.incidentRecords((IncidentIntent)IncidentIntent.CREATED).withProcessInstanceKey(processInstanceKey).getFirst();
        Record elementInstance = (Record)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATING).withElementId(ELEMENT_ID).getFirst();
        IncidentHelper.assertIncidentCreated((Record<IncidentRecordValue>)incident, (Record<ProcessInstanceRecordValue>)elementInstance).hasErrorType(ErrorType.EXTRACT_VALUE_ERROR).hasErrorMessage("Invalid duration format 'not_a_duration_expression' for expression 'timer_duration'.");
    }

    @Test
    public void shouldCreateIncidentIfCycleExpressionCannotBeEvaluated() {
        ENGINE.deployment().withXmlResource(TimerIncidentTest.createProcessWithCycle(CYCLE_EXPRESSION)).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).withVariable(DURATION_VARIABLE, "not_a_duration_expression").create();
        Record incident = (Record)RecordingExporter.incidentRecords((IncidentIntent)IncidentIntent.CREATED).withProcessInstanceKey(processInstanceKey).getFirst();
        Record elementInstance = (Record)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATING).withElementId(ELEMENT_ID).getFirst();
        IncidentHelper.assertIncidentCreated((Record<IncidentRecordValue>)incident, (Record<ProcessInstanceRecordValue>)elementInstance).hasErrorType(ErrorType.EXTRACT_VALUE_ERROR).hasErrorMessage("Expected result of the expression 'cycle(duration(timer_duration))' to be 'STRING', but was 'NULL'. The evaluation reported the following warnings:\n[FUNCTION_INVOCATION_FAILURE] Failed to invoke function 'duration': Failed to parse duration from 'not_a_duration_expression'\n[FUNCTION_INVOCATION_FAILURE] Failed to invoke function 'cycle': cycle function expected an interval (duration) parameter, but found 'null'");
    }

    @Test
    public void shouldCreateIncidentForCustomTenant() {
        String tenantId = "acme";
        ENGINE.deployment().withXmlResource(TimerIncidentTest.createProcessWithCycle(CYCLE_EXPRESSION)).withTenantId("acme").deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).withVariable(DURATION_VARIABLE, "not_a_duration_expression").withTenantId("acme").create();
        Record incident = (Record)RecordingExporter.incidentRecords((IncidentIntent)IncidentIntent.CREATED).withProcessInstanceKey(processInstanceKey).getFirst();
        Record elementInstance = (Record)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATING).withElementId(ELEMENT_ID).getFirst();
        IncidentHelper.assertIncidentCreated((Record<IncidentRecordValue>)incident, (Record<ProcessInstanceRecordValue>)elementInstance, "acme");
    }

    @Test
    public void shouldResolveIncident() {
        ENGINE.deployment().withXmlResource(TimerIncidentTest.createProcess(DURATION_EXPRESSION)).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        Record incident = (Record)RecordingExporter.incidentRecords((IncidentIntent)IncidentIntent.CREATED).withProcessInstanceKey(processInstanceKey).getFirst();
        ENGINE.variables().ofScope(((IncidentRecordValue)incident.getValue()).getVariableScopeKey()).withDocument(Collections.singletonMap(DURATION_VARIABLE, Duration.ofSeconds(1L).toString())).update();
        ENGINE.incident().ofInstance(processInstanceKey).withKey(incident.getKey()).resolve();
        ((OptionalAssert)Assertions.assertThat((Optional)((ProcessInstanceRecordStream)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATED).withProcessInstanceKey(processInstanceKey).withRecordKey(((IncidentRecordValue)incident.getValue()).getElementInstanceKey())).findAny()).describedAs("Expect that element was activated", new Object[0])).isPresent();
    }
}

