/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.job;

import io.camunda.zeebe.engine.util.EngineRule;
import io.camunda.zeebe.model.bpmn.Bpmn;
import io.camunda.zeebe.model.bpmn.BpmnModelInstance;
import io.camunda.zeebe.model.bpmn.builder.BoundaryEventBuilder;
import io.camunda.zeebe.model.bpmn.builder.StartEventBuilder;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.RecordType;
import io.camunda.zeebe.protocol.record.RejectionType;
import io.camunda.zeebe.protocol.record.intent.IncidentIntent;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.JobIntent;
import io.camunda.zeebe.protocol.record.intent.VariableIntent;
import io.camunda.zeebe.protocol.record.value.IncidentRecordValue;
import io.camunda.zeebe.protocol.record.value.JobRecordValue;
import io.camunda.zeebe.protocol.record.value.VariableRecordValue;
import io.camunda.zeebe.test.util.BrokerClassRuleHelper;
import io.camunda.zeebe.test.util.record.RecordingExporter;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.assertj.core.groups.Tuple;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

public final class JobThrowErrorTest {
    @ClassRule
    public static final EngineRule ENGINE = EngineRule.singlePartition();
    private static final String PROCESS_ID = "process";
    private static String jobType;
    private static final String ERROR_CODE = "ERROR";
    @Rule
    public final BrokerClassRuleHelper helper = new BrokerClassRuleHelper();

    @Before
    public void setup() {
        jobType = this.helper.getJobType();
    }

    @Test
    public void shouldThrowError() {
        Record<JobRecordValue> job = ENGINE.createJob(jobType, PROCESS_ID);
        Record<JobRecordValue> result = ENGINE.job().withKey(job.getKey()).withErrorCode("error").withErrorMessage("error-message").throwError();
        io.camunda.zeebe.protocol.record.Assertions.assertThat(result).hasRecordType(RecordType.EVENT).hasIntent((Intent)JobIntent.ERROR_THROWN);
        io.camunda.zeebe.protocol.record.Assertions.assertThat((JobRecordValue)((JobRecordValue)result.getValue())).hasErrorCode("error").hasErrorMessage("error-message");
    }

    @Test
    public void shouldRejectIfJobNotFound() {
        int key = 123;
        Record<JobRecordValue> result = ENGINE.job().withKey(123L).withErrorCode("error").throwError();
        io.camunda.zeebe.protocol.record.Assertions.assertThat(result).hasRejectionType(RejectionType.NOT_FOUND);
    }

    @Test
    public void shouldRejectIfJobIsFailed() {
        Record<JobRecordValue> job = ENGINE.createJob(jobType, PROCESS_ID);
        ENGINE.jobs().withType(jobType).activate();
        ENGINE.job().withKey(job.getKey()).withRetries(0).fail();
        Record<JobRecordValue> result = ENGINE.job().withKey(job.getKey()).withErrorCode("error").throwError();
        io.camunda.zeebe.protocol.record.Assertions.assertThat(result).hasRejectionType(RejectionType.INVALID_STATE);
        Assertions.assertThat((String)result.getRejectionReason()).contains(new CharSequence[]{"it is in state 'FAILED'"});
    }

    @Test
    public void shouldRejectIfErrorIsThrown() {
        Record<JobRecordValue> job = ENGINE.createJob(jobType, PROCESS_ID);
        ENGINE.job().withKey(job.getKey()).withErrorCode("error").throwError();
        Record<JobRecordValue> result = ENGINE.job().withKey(job.getKey()).withErrorCode("error").throwError();
        io.camunda.zeebe.protocol.record.Assertions.assertThat(result).hasRejectionType(RejectionType.INVALID_STATE);
        Assertions.assertThat((String)result.getRejectionReason()).contains(new CharSequence[]{"it is in state 'ERROR_THROWN'"});
    }

    @Test
    public void shouldThrowErrorWithVariables() {
        BpmnModelInstance process = Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().serviceTask("task", t -> t.zeebeJobType(jobType)).boundaryEvent("error-boundary-event", b -> b.error(ERROR_CODE)).endEvent().done();
        ENGINE.deployment().withXmlResource(process).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        Record<JobRecordValue> error = ENGINE.job().ofInstance(processInstanceKey).withType(jobType).withErrorCode(ERROR_CODE).withErrorMessage("error-message").withVariables("{'foo':'bar'}").throwError();
        io.camunda.zeebe.protocol.record.Assertions.assertThat(error).hasRecordType(RecordType.EVENT).hasIntent((Intent)JobIntent.ERROR_THROWN);
        io.camunda.zeebe.protocol.record.Assertions.assertThat((JobRecordValue)((JobRecordValue)error.getValue())).hasErrorCode(ERROR_CODE).hasErrorMessage("error-message").hasVariables(Map.of("foo", "bar"));
        Record errorEvent = (Record)RecordingExporter.processInstanceRecords().withProcessInstanceKey(processInstanceKey).withElementId("error-boundary-event").getFirst();
        Assertions.assertThat((List)((List)RecordingExporter.records().limitToProcessInstance(processInstanceKey).variableRecords().collect(Collectors.toList()))).extracting(new Function[]{r -> ((VariableRecordValue)r.getValue()).getName(), r -> ((VariableRecordValue)r.getValue()).getValue(), r -> ((VariableRecordValue)r.getValue()).getScopeKey(), Record::getIntent}).describedAs("The variables are created at the error catch event.", new Object[0]).containsExactly((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{"foo", "\"bar\"", errorEvent.getKey(), VariableIntent.CREATED})});
    }

    @Test
    public void shouldThrowErrorWithVariablesAndOutputMapping() {
        BpmnModelInstance process = Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().serviceTask("task", t -> t.zeebeJobType(jobType)).boundaryEvent("error-boundary-event", b -> ((BoundaryEventBuilder)b.error(ERROR_CODE)).zeebeOutputExpression("foo", "output")).endEvent().done();
        ENGINE.deployment().withXmlResource(process).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        Record<JobRecordValue> error = ENGINE.job().ofInstance(processInstanceKey).withType(jobType).withErrorCode(ERROR_CODE).withErrorMessage("error-message").withVariables("{'foo':'bar'}").throwError();
        io.camunda.zeebe.protocol.record.Assertions.assertThat(error).hasRecordType(RecordType.EVENT).hasIntent((Intent)JobIntent.ERROR_THROWN);
        io.camunda.zeebe.protocol.record.Assertions.assertThat((JobRecordValue)((JobRecordValue)error.getValue())).hasErrorCode(ERROR_CODE).hasErrorMessage("error-message").hasVariables(Map.of("foo", "bar"));
        Record errorEvent = (Record)RecordingExporter.processInstanceRecords().withProcessInstanceKey(processInstanceKey).withElementId("error-boundary-event").getFirst();
        Assertions.assertThat((List)((List)RecordingExporter.records().limitToProcessInstance(processInstanceKey).variableRecords().collect(Collectors.toList()))).extracting(new Function[]{r -> ((VariableRecordValue)r.getValue()).getName(), r -> ((VariableRecordValue)r.getValue()).getValue(), r -> ((VariableRecordValue)r.getValue()).getScopeKey(), Record::getIntent}).describedAs("The variables are created at the error catch event, and with an output mapping to created at the process instance.", new Object[0]).containsExactly((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{"foo", "\"bar\"", errorEvent.getKey(), VariableIntent.CREATED}), Assertions.tuple((Object[])new Object[]{"output", "\"bar\"", processInstanceKey, VariableIntent.CREATED})});
    }

    @Test
    public void shouldThrowErrorWithSubProcessVariables() {
        BpmnModelInstance process = Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().subProcess("subprocess", s -> s.embeddedSubProcess().startEvent().serviceTask("task", t -> t.zeebeJobType(jobType)).endEvent()).boundaryEvent("error-boundary-event", b -> b.error(ERROR_CODE)).endEvent().done();
        ENGINE.deployment().withXmlResource(process).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        Record<JobRecordValue> error = ENGINE.job().ofInstance(processInstanceKey).withType(jobType).withErrorCode(ERROR_CODE).withErrorMessage("error-message").withVariables("{'foo':'bar'}").throwError();
        io.camunda.zeebe.protocol.record.Assertions.assertThat(error).hasRecordType(RecordType.EVENT).hasIntent((Intent)JobIntent.ERROR_THROWN);
        io.camunda.zeebe.protocol.record.Assertions.assertThat((JobRecordValue)((JobRecordValue)error.getValue())).hasErrorCode(ERROR_CODE).hasErrorMessage("error-message").hasVariables(Map.of("foo", "bar"));
        Record errorEvent = (Record)RecordingExporter.processInstanceRecords().withBpmnProcessId(PROCESS_ID).withElementId("error-boundary-event").getFirst();
        Assertions.assertThat((List)((List)RecordingExporter.records().limitToProcessInstance(processInstanceKey).variableRecords().collect(Collectors.toList()))).extracting(new Function[]{r -> ((VariableRecordValue)r.getValue()).getName(), r -> ((VariableRecordValue)r.getValue()).getValue(), r -> ((VariableRecordValue)r.getValue()).getScopeKey(), Record::getIntent}).describedAs("The variables are created at the error catch event.", new Object[0]).containsExactly((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{"foo", "\"bar\"", errorEvent.getKey(), VariableIntent.CREATED})});
    }

    @Test
    public void shouldThrowErrorWithSubProcessVariablesWithOutputMapping() {
        BpmnModelInstance process = Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().subProcess("subprocess", s -> s.embeddedSubProcess().startEvent().serviceTask("task", t -> t.zeebeJobType(jobType)).endEvent()).boundaryEvent("error-boundary-event", b -> ((BoundaryEventBuilder)b.error(ERROR_CODE)).zeebeOutputExpression("foo", "output")).endEvent().done();
        ENGINE.deployment().withXmlResource(process).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        Record<JobRecordValue> error = ENGINE.job().ofInstance(processInstanceKey).withType(jobType).withErrorCode(ERROR_CODE).withErrorMessage("error-message").withVariables("{'foo':'bar'}").throwError();
        io.camunda.zeebe.protocol.record.Assertions.assertThat(error).hasRecordType(RecordType.EVENT).hasIntent((Intent)JobIntent.ERROR_THROWN);
        io.camunda.zeebe.protocol.record.Assertions.assertThat((JobRecordValue)((JobRecordValue)error.getValue())).hasErrorCode(ERROR_CODE).hasErrorMessage("error-message").hasVariables(Map.of("foo", "bar"));
        Record errorEvent = (Record)RecordingExporter.processInstanceRecords().withBpmnProcessId(PROCESS_ID).withElementId("error-boundary-event").getFirst();
        Assertions.assertThat((List)((List)RecordingExporter.records().limitToProcessInstance(processInstanceKey).variableRecords().collect(Collectors.toList()))).extracting(new Function[]{r -> ((VariableRecordValue)r.getValue()).getName(), r -> ((VariableRecordValue)r.getValue()).getValue(), r -> ((VariableRecordValue)r.getValue()).getScopeKey(), Record::getIntent}).describedAs("The variables are created at the error catch event, and with an output mapping to created at the process instance.", new Object[0]).containsExactly((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{"foo", "\"bar\"", errorEvent.getKey(), VariableIntent.CREATED}), Assertions.tuple((Object[])new Object[]{"output", "\"bar\"", processInstanceKey, VariableIntent.CREATED})});
    }

    @Test
    public void shouldThrowErrorWithVariablesWithEventSubProcess() {
        BpmnModelInstance process = Bpmn.createExecutableProcess((String)PROCESS_ID).eventSubProcess("error-event-subprocess", s -> ((StartEventBuilder)((StartEventBuilder)s.startEvent("error-start-event").error(ERROR_CODE)).interrupting(true)).endEvent()).startEvent().serviceTask("task", t -> t.zeebeJobType(jobType)).endEvent().done();
        ENGINE.deployment().withXmlResource(process).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        ENGINE.job().ofInstance(processInstanceKey).withType(jobType).withErrorCode(ERROR_CODE).withVariables("{'foo':'bar'}").throwError();
        ((ListAssert)Assertions.assertThat((List)((List)RecordingExporter.records().limitToProcessInstance(processInstanceKey).variableRecords().collect(Collectors.toList()))).filteredOn(r -> ((VariableRecordValue)r.getValue()).getName().equals("foo"))).extracting(new Function[]{r -> ((VariableRecordValue)r.getValue()).getName(), r -> ((VariableRecordValue)r.getValue()).getValue(), r -> ((VariableRecordValue)r.getValue()).getScopeKey(), Record::getIntent}).describedAs("With event sub process the variables are created at the process instance", new Object[0]).containsExactly((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{"foo", "\"bar\"", processInstanceKey, VariableIntent.CREATED})});
    }

    @Test
    public void shouldTruncateErrorMessage() {
        Record<JobRecordValue> job = ENGINE.createJob(jobType, PROCESS_ID);
        String exceedingErrorMessage = "*".repeat(10001);
        Record<JobRecordValue> failedRecord = ENGINE.job().withKey(job.getKey()).withErrorMessage(exceedingErrorMessage).throwError();
        Record incident = (Record)RecordingExporter.incidentRecords((IncidentIntent)IncidentIntent.CREATED).getFirst();
        io.camunda.zeebe.protocol.record.Assertions.assertThat(failedRecord).hasRecordType(RecordType.EVENT).hasIntent((Intent)JobIntent.ERROR_THROWN);
        String expectedJobMessage = "*".repeat(10000).concat("...");
        Assertions.assertThat((String)((JobRecordValue)failedRecord.getValue()).getErrorMessage()).isEqualTo(expectedJobMessage);
        String expectedIncidentMessage = "Expected to throw an error event with the code '' with message '" + expectedJobMessage + "', but it was not caught. No error events are available in the scope.";
        Assertions.assertThat((String)((IncidentRecordValue)incident.getValue()).getErrorMessage()).isEqualTo(expectedIncidentMessage);
    }

    @Test
    public void shouldNotTruncateErrorMessage() {
        Record<JobRecordValue> job = ENGINE.createJob(jobType, PROCESS_ID);
        String errorMessage = "*".repeat(10000);
        Record<JobRecordValue> failedRecord = ENGINE.job().withKey(job.getKey()).withErrorMessage(errorMessage).throwError();
        Record incident = (Record)RecordingExporter.incidentRecords((IncidentIntent)IncidentIntent.CREATED).getFirst();
        io.camunda.zeebe.protocol.record.Assertions.assertThat(failedRecord).hasRecordType(RecordType.EVENT).hasIntent((Intent)JobIntent.ERROR_THROWN);
        String expectedJobMessage = "*".repeat(10000);
        Assertions.assertThat((String)((JobRecordValue)failedRecord.getValue()).getErrorMessage()).isEqualTo(expectedJobMessage);
        String expectedIncidentMessage = "Expected to throw an error event with the code '' with message '" + expectedJobMessage + "', but it was not caught. No error events are available in the scope.";
        Assertions.assertThat((String)((IncidentRecordValue)incident.getValue()).getErrorMessage()).isEqualTo(expectedIncidentMessage);
    }

    @Test
    public void shouldThrowErrorForCustomTenant() {
        String tenantId = "acme";
        Record<JobRecordValue> job = ENGINE.createJob(jobType, PROCESS_ID, Collections.emptyMap(), "acme");
        Record<JobRecordValue> result = ENGINE.job().withKey(job.getKey()).withErrorCode("error").withErrorMessage("error-message").withAuthorizedTenantIds("acme").throwError();
        io.camunda.zeebe.protocol.record.Assertions.assertThat(result).hasRecordType(RecordType.EVENT).hasIntent((Intent)JobIntent.ERROR_THROWN);
        io.camunda.zeebe.protocol.record.Assertions.assertThat((JobRecordValue)((JobRecordValue)result.getValue())).hasErrorCode("error").hasErrorMessage("error-message");
        io.camunda.zeebe.protocol.record.Assertions.assertThat((JobRecordValue)((JobRecordValue)result.getValue())).hasTenantId("acme");
    }

    @Test
    public void shouldRejectIfTenantIsUnauthorized() {
        String tenantId = "acme";
        String falseTenantId = "foo";
        Record<JobRecordValue> job = ENGINE.createJob(jobType, PROCESS_ID, Collections.emptyMap(), "acme");
        ENGINE.jobs().withType(jobType).withTenantId("acme").activate();
        Record<JobRecordValue> result = ENGINE.job().withKey(job.getKey()).withErrorCode("error").withAuthorizedTenantIds("foo").throwError();
        io.camunda.zeebe.protocol.record.Assertions.assertThat(result).hasRejectionType(RejectionType.NOT_FOUND);
    }
}

