/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.job;

import io.camunda.zeebe.engine.EngineConfiguration;
import io.camunda.zeebe.engine.processing.job.JobTimeoutChecker;
import io.camunda.zeebe.engine.state.immutable.JobState;
import io.camunda.zeebe.engine.state.mutable.MutableJobState;
import io.camunda.zeebe.engine.state.mutable.MutableProcessingState;
import io.camunda.zeebe.engine.util.ProcessingStateRule;
import io.camunda.zeebe.protocol.impl.record.UnifiedRecordValue;
import io.camunda.zeebe.protocol.impl.record.value.job.JobRecord;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.JobIntent;
import io.camunda.zeebe.stream.api.ReadonlyStreamProcessorContext;
import io.camunda.zeebe.stream.api.scheduling.ProcessingScheduleService;
import io.camunda.zeebe.stream.api.scheduling.Task;
import io.camunda.zeebe.stream.api.scheduling.TaskResultBuilder;
import java.time.Duration;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.InOrder;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class JobTimeoutCheckerTest {
    public static final int NUMBER_OF_ACTIVE_JOBS = 10;
    @Rule
    public final ProcessingStateRule stateRule = new ProcessingStateRule();
    private MutableProcessingState processingState;
    private MutableJobState jobState;
    private ReadonlyStreamProcessorContext mockContext;
    private ProcessingScheduleService mockScheduleService;
    private TaskResultBuilder mockTaskResultBuilder;

    @Before
    public void setUp() {
        this.processingState = this.stateRule.getProcessingState();
        this.jobState = this.processingState.getJobState();
        for (int i = 1; i <= 10; ++i) {
            this.createAndActivateJobRecord(i, this.newJobRecord().setDeadline((long)i));
        }
        this.mockContext = (ReadonlyStreamProcessorContext)Mockito.mock(ReadonlyStreamProcessorContext.class);
        this.mockScheduleService = (ProcessingScheduleService)Mockito.mock(ProcessingScheduleService.class);
        Mockito.when((Object)this.mockContext.getScheduleService()).thenReturn((Object)this.mockScheduleService);
        this.mockTaskResultBuilder = (TaskResultBuilder)Mockito.mock(TaskResultBuilder.class);
    }

    private void createAndActivateJobRecord(long key, JobRecord record) {
        this.jobState.create(key, record);
        this.jobState.activate(key, record);
    }

    private JobRecord newJobRecord() {
        return this.newJobRecord("<default>");
    }

    private JobRecord newJobRecord(String tenantId) {
        JobRecord jobRecord = new JobRecord();
        jobRecord.setRetries(2).setDeadline(256L).setType("test").setTenantId(tenantId);
        return jobRecord;
    }

    @Test
    public void shouldRescheduleWithPollingIntervalAfterSuccessfulExecution() {
        Mockito.when((Object)this.mockTaskResultBuilder.appendCommandRecord(ArgumentMatchers.anyLong(), (Intent)ArgumentMatchers.any(), (UnifiedRecordValue)ArgumentMatchers.any())).thenReturn((Object)true);
        Duration pollingInterval = EngineConfiguration.DEFAULT_JOBS_TIMEOUT_POLLING_INTERVAL;
        int batchLimit = Integer.MAX_VALUE;
        JobTimeoutChecker task = new JobTimeoutChecker((JobState)this.jobState, pollingInterval, Integer.MAX_VALUE);
        task.setProcessingContext(this.mockContext);
        task.setShouldReschedule(true);
        task.execute(this.mockTaskResultBuilder);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockTaskResultBuilder});
        for (long i = 1L; i <= 10L; ++i) {
            ((TaskResultBuilder)inOrder.verify((Object)this.mockTaskResultBuilder)).appendCommandRecord(ArgumentMatchers.eq((long)i), (Intent)ArgumentMatchers.eq((Object)JobIntent.TIME_OUT), (UnifiedRecordValue)ArgumentMatchers.any());
        }
        ((TaskResultBuilder)inOrder.verify((Object)this.mockTaskResultBuilder)).build();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockTaskResultBuilder});
        ((ProcessingScheduleService)Mockito.verify((Object)this.mockScheduleService, (VerificationMode)Mockito.times((int)1))).runDelayed((Duration)ArgumentMatchers.eq((Object)pollingInterval), (Task)ArgumentMatchers.any(Task.class));
    }

    @Test
    public void shouldRescheduleImmediatelyIfYieldedDueToBatchLimit() {
        long i;
        Mockito.when((Object)this.mockTaskResultBuilder.appendCommandRecord(ArgumentMatchers.anyLong(), (Intent)ArgumentMatchers.any(), (UnifiedRecordValue)ArgumentMatchers.any())).thenReturn((Object)true);
        Duration pollingInterval = EngineConfiguration.DEFAULT_JOBS_TIMEOUT_POLLING_INTERVAL;
        int batchLimit = 3;
        JobTimeoutChecker task = new JobTimeoutChecker((JobState)this.jobState, pollingInterval, 3);
        task.setProcessingContext(this.mockContext);
        task.setShouldReschedule(true);
        task.execute(this.mockTaskResultBuilder);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockTaskResultBuilder});
        for (i = 1L; i <= 3L; ++i) {
            ((TaskResultBuilder)inOrder.verify((Object)this.mockTaskResultBuilder)).appendCommandRecord(ArgumentMatchers.eq((long)i), (Intent)ArgumentMatchers.eq((Object)JobIntent.TIME_OUT), (UnifiedRecordValue)ArgumentMatchers.any());
        }
        ((TaskResultBuilder)inOrder.verify((Object)this.mockTaskResultBuilder)).build();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockTaskResultBuilder});
        ((ProcessingScheduleService)Mockito.verify((Object)this.mockScheduleService, (VerificationMode)Mockito.times((int)1))).runDelayed((Duration)ArgumentMatchers.eq((Object)Duration.ZERO), (Task)ArgumentMatchers.any(Task.class));
        task.execute(this.mockTaskResultBuilder);
        for (i = 4L; i <= 6L; ++i) {
            ((TaskResultBuilder)inOrder.verify((Object)this.mockTaskResultBuilder)).appendCommandRecord(ArgumentMatchers.eq((long)i), (Intent)ArgumentMatchers.eq((Object)JobIntent.TIME_OUT), (UnifiedRecordValue)ArgumentMatchers.any());
        }
        ((TaskResultBuilder)inOrder.verify((Object)this.mockTaskResultBuilder)).build();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockTaskResultBuilder});
    }

    @Test
    public void shouldRescheduleImmediatelyIfFailedToAppendTimeoutCommand() {
        Mockito.when((Object)this.mockTaskResultBuilder.appendCommandRecord(ArgumentMatchers.anyLong(), (Intent)ArgumentMatchers.any(), (UnifiedRecordValue)ArgumentMatchers.any())).thenReturn((Object)true).thenReturn((Object)false);
        Duration pollingInterval = EngineConfiguration.DEFAULT_JOBS_TIMEOUT_POLLING_INTERVAL;
        int batchLimit = Integer.MAX_VALUE;
        JobTimeoutChecker task = new JobTimeoutChecker((JobState)this.jobState, pollingInterval, Integer.MAX_VALUE);
        task.setProcessingContext(this.mockContext);
        task.setShouldReschedule(true);
        task.execute(this.mockTaskResultBuilder);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockTaskResultBuilder});
        ((TaskResultBuilder)inOrder.verify((Object)this.mockTaskResultBuilder)).appendCommandRecord(ArgumentMatchers.eq((long)1L), (Intent)ArgumentMatchers.eq((Object)JobIntent.TIME_OUT), (UnifiedRecordValue)ArgumentMatchers.any());
        ((TaskResultBuilder)inOrder.verify((Object)this.mockTaskResultBuilder)).appendCommandRecord(ArgumentMatchers.eq((long)2L), (Intent)ArgumentMatchers.eq((Object)JobIntent.TIME_OUT), (UnifiedRecordValue)ArgumentMatchers.any());
        ((TaskResultBuilder)inOrder.verify((Object)this.mockTaskResultBuilder)).build();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockTaskResultBuilder});
        ((ProcessingScheduleService)Mockito.verify((Object)this.mockScheduleService, (VerificationMode)Mockito.times((int)1))).runDelayed((Duration)ArgumentMatchers.eq((Object)Duration.ZERO), (Task)ArgumentMatchers.any(Task.class));
    }
}

