/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.message;

import io.camunda.zeebe.engine.processing.message.MessageBatchExpireProcessor;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.StateWriter;
import io.camunda.zeebe.protocol.impl.record.RecordMetadata;
import io.camunda.zeebe.protocol.impl.record.UnifiedRecordValue;
import io.camunda.zeebe.protocol.impl.record.value.message.MessageBatchRecord;
import io.camunda.zeebe.protocol.record.RecordValue;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.stream.api.records.ExceededBatchRecordSizeException;
import io.camunda.zeebe.stream.api.records.TypedRecord;
import io.camunda.zeebe.stream.impl.records.RecordBatchEntry;
import io.camunda.zeebe.stream.impl.records.UnwrittenRecord;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public final class MessageBatchExpireProcessorTest {
    private final StateWriter stateWriter = (StateWriter)Mockito.mock(StateWriter.class);
    final MessageBatchExpireProcessor messageBatchExpireProcessor = new MessageBatchExpireProcessor(this.stateWriter);

    @Test
    public void shouldStopProcessingWhenExceedingBatchLimit() {
        MessageBatchRecord messageBatchRecord = new MessageBatchRecord().addMessageKey(1L).addMessageKey(2L).addMessageKey(3L).addMessageKey(4L);
        ((StateWriter)Mockito.doNothing().when((Object)this.stateWriter)).appendFollowUpEvent(ArgumentMatchers.eq((long)1L), (Intent)ArgumentMatchers.any(), (RecordValue)ArgumentMatchers.any());
        ((StateWriter)Mockito.doNothing().when((Object)this.stateWriter)).appendFollowUpEvent(ArgumentMatchers.eq((long)2L), (Intent)ArgumentMatchers.any(), (RecordValue)ArgumentMatchers.any());
        ExceededBatchRecordSizeException exceededBatchRecordSizeException = new ExceededBatchRecordSizeException((RecordBatchEntry)Mockito.mock(RecordBatchEntry.class), 10, 1, 1);
        ((StateWriter)Mockito.doThrow((Throwable[])new Throwable[]{exceededBatchRecordSizeException}).when((Object)this.stateWriter)).appendFollowUpEvent(ArgumentMatchers.eq((long)3L), (Intent)ArgumentMatchers.any(), (RecordValue)ArgumentMatchers.any());
        this.messageBatchExpireProcessor.processRecord((TypedRecord)new UnwrittenRecord(-1L, 1, (UnifiedRecordValue)messageBatchRecord, new RecordMetadata()));
        ((StateWriter)Mockito.verify((Object)this.stateWriter, (VerificationMode)Mockito.times((int)3))).appendFollowUpEvent(ArgumentMatchers.anyLong(), (Intent)ArgumentMatchers.any(), (RecordValue)ArgumentMatchers.any());
    }
}

