/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.message;

import io.camunda.zeebe.engine.util.EngineRule;
import io.camunda.zeebe.model.bpmn.Bpmn;
import io.camunda.zeebe.model.bpmn.BpmnModelInstance;
import io.camunda.zeebe.model.bpmn.builder.StartEventBuilder;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.intent.MessageStartEventSubscriptionIntent;
import io.camunda.zeebe.test.util.record.MessageStartEventSubscriptionRecordStream;
import io.camunda.zeebe.test.util.record.RecordingExporter;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.assertj.core.groups.Tuple;
import org.junit.Rule;
import org.junit.Test;

public final class MessageStartEventSubscriptionMultiplePartitionsTest {
    private static final String MESSAGE_NAME1 = "startMessage1";
    private static final String EVENT_ID1 = "startEventId1";
    @Rule
    public final EngineRule engine = EngineRule.multiplePartition(3);

    @Test
    public void shouldOpenMessageStartEventSubscriptionOnAllPartitions() {
        this.engine.deployment().withXmlResource(MessageStartEventSubscriptionMultiplePartitionsTest.createProcessWithOneMessageStartEvent()).deploy();
        List subscriptions = ((MessageStartEventSubscriptionRecordStream)RecordingExporter.messageStartEventSubscriptionRecords((MessageStartEventSubscriptionIntent)MessageStartEventSubscriptionIntent.CREATED).limit(3L)).asList();
        ((ListAssert)Assertions.assertThat((List)subscriptions).hasSize(3)).extracting(Record::getValue).extracting(v -> Assertions.tuple((Object[])new Object[]{v.getStartEventId(), v.getMessageName()})).containsOnly((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{EVENT_ID1, MESSAGE_NAME1})});
        List<Integer> partitionIds = this.engine.getPartitionIds();
        Assertions.assertThat((List)subscriptions).extracting(Record::getPartitionId).containsExactlyInAnyOrderElementsOf(partitionIds);
    }

    private static BpmnModelInstance createProcessWithOneMessageStartEvent() {
        return ((StartEventBuilder)Bpmn.createExecutableProcess((String)"processId").startEvent(EVENT_ID1).message(m -> m.name(MESSAGE_NAME1).id("startmsgId"))).endEvent().done();
    }
}

